/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Filters$;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.Idle$;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.Running;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchor$;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.models.Whitelist$;
import net.ripe.rpki.validator.models.validation.MyValidationProcess;
import net.ripe.rpki.validator.models.validation.TrackValidationProcess;
import net.ripe.rpki.validator.models.validation.ValidationProcess;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scalaz.Failure;
import scalaz.Validation;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001=\u0011!\u0004\u0016:bG.4\u0016\r\\5eCRLwN\u001c)s_\u000e,7o\u001d+fgRT!a\u0001\u0003\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u0006\r\u00051Qn\u001c3fYNT!a\u0002\u0005\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0005\u000b\u0003\u0011\u0011\bo[5\u000b\u0005-a\u0011\u0001\u0002:ja\u0016T\u0011!D\u0001\u0004]\u0016$8\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u001d\u0019X\u000f\u001d9peRL!!\u0006\n\u0003#Y\u000bG.\u001b3bi>\u0014H+Z:u\u0007\u0006\u001cX\r\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005I1oY1mCR,7\u000f\u001e\u0006\u00027\u0005\u0019qN]4\n\u0005uA\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003\t1A\u0001\n\u0001\u0001K\t\u0019S*\u001f+sC\u000e\\g+\u00197jI\u0006$\u0018n\u001c8Qe>\u001cWm]:UeV\u001cH/\u00118dQ>\u00148cA\u0012'SA\u0011!eJ\u0005\u0003Q\t\u00111#T=WC2LG-\u0019;j_:\u0004&o\\2fgN\u0004\"A\t\u0016\n\u0005-\u0012!A\u0006+sC\u000e\\g+\u00197jI\u0006$\u0018n\u001c8Qe>\u001cWm]:\t\u00115\u001a#\u0011!Q\u0001\n9\nA\u0002\u001e:vgR\fen\u00195peN\u00042aL\u001d=\u001d\t\u0001dG\u0004\u00022i5\t!G\u0003\u00024\u001d\u00051AH]8pizJ\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oa\nq\u0001]1dW\u0006<WMC\u00016\u0013\tQ4HA\u0002TKFT!a\u000e\u001d\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!a\u0003+skN$\u0018I\\2i_JDQaH\u0012\u0005\u0002\u0005#\"A\u0011#\u0011\u0005\r\u001bS\"\u0001\u0001\t\u000b5\u0002\u0005\u0019\u0001\u0018\t\u000f\u0019\u001b#\u0019!C!\u000f\u0006YQ.Z7pefLU.Y4f+\u0005A\u0005cA%O!6\t!J\u0003\u0002L\u0019\u0006\u00191\u000f^7\u000b\u00055C\u0014AC2p]\u000e,(O]3oi&\u0011qJ\u0013\u0002\u0004%\u00164\u0007CA)U\u001b\u0005\u0011&BA*\u0007\u0003\u0019\u0019wN\u001c4jO&\u0011QK\u0015\u0002\f\u001b\u0016lwN]=J[\u0006<W\r\u0003\u0004XG\u0001\u0006I\u0001S\u0001\r[\u0016lwN]=J[\u0006<W\r\t\u0005\u00063\u000e\"\tEW\u0001\u000beVt\u0007K]8dKN\u001cHCA.n!\u0011av,Y5\u000e\u0003uS\u0011AX\u0001\u0007g\u000e\fG.\u0019>\n\u0005\u0001l&A\u0003,bY&$\u0017\r^5p]B\u0011!M\u001a\b\u0003G\u0012l\u0011\u0001O\u0005\u0003Kb\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\r\u000f\t\u0004_eR\u0007CA\u001fl\u0013\taGAA\bWC2LG-\u0019;fI>\u0013'.Z2u\u0011\u0015q\u0007\f1\u0001p\u000351wN]2f\u001d\u0016<h)\u001a;dQB\u00111\r]\u0005\u0003cb\u0012qAQ8pY\u0016\fg\u000eC\u0004t\u0001\t\u0007I\u0011\u0001;\u0002\u0007Q\fG.F\u0001v!\t1\u00180D\u0001x\u0015\tAh!\u0001\u0003vi&d\u0017B\u0001>x\u0005I!&/^:u\u0003:\u001c\u0007n\u001c:M_\u000e\fGo\u001c:\t\rq\u0004\u0001\u0015!\u0003v\u0003\u0011!\u0018\r\u001c\u0011)\r\u0001q\u0018QBA\b!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u00051!/\u001e8oKJT1!a\u0002\u001b\u0003\u0015QWO\\5u\u0013\u0011\tY!!\u0001\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011\u0011\u0003\t\u0005\u0003'\t9\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0001\r\n\t\u0005e\u0011Q\u0003\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class TrackValidationProcessTest
extends ValidatorTestCase
implements BeforeAndAfter {
    private final TrustAnchorLocator tal;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public TrustAnchorLocator tal() {
        return this.tal;
    }

    public TrackValidationProcessTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.tal = new TrustAnchorLocator(new File(""), "caName", Collections.singletonList(URI.create("rsync://rpki.ripe.net/root.cer")), "publicKeyInfo", Collections.emptyList());
        this.test("should fail with no processable trust anchor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.empty()));
                Validation<String, Seq<ValidatedObject>> result = subject.runProcess(false);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not process disabled trust anchors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{new TrustAnchor(this.$outer.tal(), (ProcessingStatus)new Idle(new DateTime(), Idle$.MODULE$.apply$default$2()), false, TrustAnchor$.MODULE$.apply$default$4(), TrustAnchor$.MODULE$.apply$default$5(), TrustAnchor$.MODULE$.apply$default$6(), TrustAnchor$.MODULE$.apply$default$7())}))));
                Validation<String, Seq<ValidatedObject>> result = subject.runProcess(false);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not process already running trust anchors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{new TrustAnchor(this.$outer.tal(), (ProcessingStatus)new Running(""), true, TrustAnchor$.MODULE$.apply$default$4(), TrustAnchor$.MODULE$.apply$default$5(), TrustAnchor$.MODULE$.apply$default$6(), TrustAnchor$.MODULE$.apply$default$7())}))));
                Validation<String, Seq<ValidatedObject>> result = subject.runProcess(false);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public class MyTrackValidationProcessTrustAnchor
    extends MyValidationProcess
    implements TrackValidationProcess {
        private final Ref<MemoryImage> memoryImage;

        public Validation net$ripe$rpki$validator$models$validation$TrackValidationProcess$$super$runProcess(boolean forceNewFetch) {
            return ValidationProcess.class.runProcess((ValidationProcess)this, (boolean)forceNewFetch);
        }

        public Seq net$ripe$rpki$validator$models$validation$TrackValidationProcess$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant validationStart) {
            return super.validateObjects(certificate, forceNewFetch, validationStart);
        }

        @Override
        public Seq<ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant validationStart) {
            return TrackValidationProcess.class.validateObjects((TrackValidationProcess)this, (CertificateRepositoryObjectValidationContext)certificate, (boolean)forceNewFetch, (Instant)validationStart);
        }

        public Ref<MemoryImage> memoryImage() {
            return this.memoryImage;
        }

        @Override
        public Validation<String, Seq<ValidatedObject>> runProcess(boolean forceNewFetch) {
            return TrackValidationProcess.class.runProcess((TrackValidationProcess)this, (boolean)false);
        }

        public /* synthetic */ TrackValidationProcessTest net$ripe$rpki$validator$models$validation$TrackValidationProcessTest$MyTrackValidationProcessTrustAnchor$$$outer() {
            return TrackValidationProcessTest.this;
        }

        public MyTrackValidationProcessTrustAnchor(Seq<TrustAnchor> trustAnchors) {
            if (TrackValidationProcessTest.this == null) {
                throw new NullPointerException();
            }
            TrackValidationProcess.class.$init$((TrackValidationProcess)this);
            this.memoryImage = Ref$.MODULE$.apply((Object)new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist(Whitelist$.MODULE$.apply$default$1()), new TrustAnchors(trustAnchors), ValidatedObjects$.MODULE$.apply(new TrustAnchors(trustAnchors)), MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class));
        }
    }
}

