/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import java.net.URI;
import java.util.Map;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.validation.RepoFetcher;
import net.ripe.rpki.validator.store.RepoServiceStore$;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.Entry;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.enablers.Collecting;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.mock.MockitoSugar;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u001b\ty!+\u001a9p'\u0016\u0014h/[2f'B,7M\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0006\u000191\u0012\u0004\b\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003M\t1a\u001c:h\u0013\t)\u0002C\u0001\u0005Gk:\u001cV/\u001b;f!\tyq#\u0003\u0002\u0019!\tAQ*\u0019;dQ\u0016\u00148\u000f\u0005\u0002\u00105%\u00111\u0004\u0005\u0002\u0013\u0005\u00164wN]3B]\u0012\fe\r^3s\u000b\u0006\u001c\u0007\u000e\u0005\u0002\u001eA5\taD\u0003\u0002 !\u0005!Qn\\2l\u0013\t\tcD\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000fC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!9\u0001\u0006\u0001b\u0001\n\u0003I\u0013a\u00024fi\u000eDWM]\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011QFA\u0001\u000bm\u0006d\u0017\u000eZ1uS>t\u0017BA\u0018-\u0005-\u0011V\r]8GKR\u001c\u0007.\u001a:\t\rE\u0002\u0001\u0015!\u0003+\u0003!1W\r^2iKJ\u0004\u0003bB\u001a\u0001\u0005\u0004%\t\u0001N\u0001\fe\u0016\u0004xnU3sm&\u001cW-F\u00016!\t1c'\u0003\u00028\u0005\tY!+\u001a9p'\u0016\u0014h/[2f\u0011\u0019I\u0004\u0001)A\u0005k\u0005a!/\u001a9p'\u0016\u0014h/[2fA!)1\b\u0001C!y\u0005Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\"\u0001\u0001\u0012'N!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0004sk:tWM\u001d\u0006\u0003\u0013J\tQA[;oSRL!a\u0013$\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\na\n\u0005\u0002P#6\t\u0001K\u0003\u0002J!%\u0011!\u000b\u0015\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class RepoServiceSpec
extends FunSuite
implements Matchers,
BeforeAndAfterEach,
MockitoSugar {
    private final RepoFetcher fetcher;
    private final RepoService repoService;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        RepoServiceSpec repoServiceSpec = this;
        synchronized (repoServiceSpec) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    public RepoFetcher fetcher() {
        return this.fetcher;
    }

    public RepoService repoService() {
        return this.repoService;
    }

    public void beforeEach() {
        Mockito.reset((Object[])new RepoFetcher[]{this.fetcher()});
        RepoServiceStore$.MODULE$.reset();
    }

    public RepoServiceSpec() {
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.fetcher = (RepoFetcher)this.mock(ManifestFactory$.MODULE$.classType(RepoFetcher.class));
        this.repoService = new RepoService(this.fetcher());
        this.test("should fetch if URI was never visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                this.$outer.repoService().visitRepo(false, Instant.now(), uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher())).fetchRepo(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should NOT fetch if URI was just visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                Instant firstInstant = Instant.now();
                this.$outer.repoService().visitRepo(false, firstInstant, uri);
                Instant secondInstant = firstInstant.toDateTime().plusSeconds(1).toInstant();
                this.$outer.repoService().visitRepo(false, secondInstant, uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher(), (VerificationMode)VerificationModeFactory.times((int)1))).fetchRepo(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fetch if URI was just visited but forceFetch is true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                Instant firstInstant = Instant.now();
                this.$outer.repoService().visitRepo(false, firstInstant, uri);
                Instant secondInstant = firstInstant.toDateTime().plusSeconds(1).toInstant();
                this.$outer.repoService().visitRepo(true, secondInstant, uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher(), (VerificationMode)VerificationModeFactory.times((int)2))).fetchRepo(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fetch object if URI was never visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla.cer");
                this.$outer.repoService().visitTrustAnchorCertificate(uri, false, Instant.now());
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher())).fetchTrustAnchorCertificate(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch object if URI was already visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla.cer");
                this.$outer.repoService().visitTrustAnchorCertificate(uri, false, Instant.now());
                this.$outer.repoService().visitTrustAnchorCertificate(uri, false, Instant.now());
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher(), (VerificationMode)Mockito.times((int)1))).fetchTrustAnchorCertificate(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fetch time should be recent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Instant minuteAgo = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)1L));
                Duration twoMinutes = Duration.standardMinutes((long)2L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.repoService().timeIsRecent(minuteAgo, twoMinutes, Instant.now(), false))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fetch time should NOT be recent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Instant twoMinutesAgo = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)2L));
                Duration minute = Duration.standardMinutes((long)1L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.repoService().timeIsRecent(twoMinutesAgo, minute, Instant.now(), false))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should ignore duration when forceFetch is true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Instant twoMinutesAgo = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)1L));
                Duration minute = Duration.standardMinutes((long)2L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.repoService().timeIsRecent(twoMinutesAgo, minute, Instant.now(), true))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not update last fetch time in case of connection errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                Mockito.when((Object)this.$outer.fetcher().fetchRepo(uri)).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Fetcher.ParseError[]{new Fetcher.ParseError(uri, "Cannot parse stuff")})));
                Instant firstInstant = Instant.now();
                this.$outer.repoService().visitRepo(false, firstInstant, uri);
                this.$outer.convertToAnyShouldWrapper(this.$outer.repoService().lastFetchTime(uri)).should(this.$outer.be().apply((Object)firstInstant));
                Mockito.when((Object)this.$outer.fetcher().fetchRepo(uri)).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Fetcher.ConnectionError[]{new Fetcher.ConnectionError(uri, "Cannot parse stuff")})));
                Instant secondInstant = firstInstant.toDateTime().plusSeconds(1).toInstant();
                this.$outer.repoService().visitRepo(true, secondInstant, uri);
                this.$outer.convertToAnyShouldWrapper(this.$outer.repoService().lastFetchTime(uri)).should(this.$outer.be().apply((Object)firstInstant));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

