/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.controllers;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.authentication.AuthenticationSupport;
import net.ripe.rpki.validator.authentication.User;
import net.ripe.rpki.validator.controllers.ApplicationController;
import net.ripe.rpki.validator.controllers.ExportController;
import net.ripe.rpki.validator.controllers.ExportControllerTest$;
import net.ripe.rpki.validator.lib.Validation;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$;
import net.ripe.rpki.validator.support.ControllerTestCase;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatra.FlashMap;
import org.scalatra.FlashMapSupport;
import org.scalatra.MethodOverride;
import org.scalatra.Route;
import org.scalatra.ScalatraBase;
import org.scalatra.auth.Scentry;
import org.scalatra.auth.ScentryConfig;
import org.scalatra.auth.ScentrySupport;
import org.scalatra.auth.strategy.BasicAuthSupport;
import org.scalatra.package;
import org.scalatra.servlet.ServletBase;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalaz.NonEmptyList;
import scalaz.Validation;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u001b\t!R\t\u001f9peR\u001cuN\u001c;s_2dWM\u001d+fgRT!a\u0001\u0003\u0002\u0017\r|g\u000e\u001e:pY2,'o\u001d\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqa];qa>\u0014H/\u0003\u0002\u0014!\t\u00112i\u001c8ue>dG.\u001a:UKN$8)Y:f\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u0007Q\fG.F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005I!&/^:u\u0003:\u001c\u0007n\u001c:M_\u000e\fGo\u001c:\t\r\r\u0002\u0001\u0015!\u0003\u001d\u0003\u0011!\u0018\r\u001c\u0011\t\u000f\u0015\u0002!\u0019!C\u0001M\u00059\u0001KU#G\u0013b\u000bT#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)\"\u0011AB7pI\u0016d7/\u0003\u0002-S\tI!\u000b\u001e:Qe\u00164\u0017\u000e\u001f\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u0011A\u0013VIR%Yc\u0001Bq\u0001\r\u0001C\u0002\u0013\u0005a%A\u0004Q%\u00163\u0015\n\u0017\u001a\t\rI\u0002\u0001\u0015!\u0003(\u0003!\u0001&+\u0012$J1J\u0002\u0003b\u0002\u001b\u0001\u0005\u0004%\tAJ\u0001\b!J+e)\u0013-4\u0011\u00191\u0004\u0001)A\u0005O\u0005A\u0001KU#G\u0013b\u001b\u0004\u0005C\u00049\u0001\t\u0007I\u0011A\u001d\u0002\u001bQ+5\u000bV0Q%\u00163\u0015\nW#T+\u0005Q\u0004cA\u001eCO5\tAH\u0003\u0002>}\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007f\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"=\u0005\r\u0019V\r\u001e\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u001dQ+5\u000bV0Q%\u00163\u0015\nW#TA!)q\t\u0001C!\u0011\u0006Q1m\u001c8ue>dG.\u001a:\u0016\u0003%\u00132A\u0013'Q\r\u0011Ye\tA%\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u00055sU\"\u0001\u0001\n\u0005=\u0013\"\u0001E\"p]R\u0014x\u000e\u001c7fe\u001aKG\u000e^3s!\tA\u0012+\u0003\u0002S\u0005\t\u0001R\t\u001f9peR\u001cuN\u001c;s_2dWM\u001d\u0015\u0005\u0001Qsv\f\u0005\u0002V96\taK\u0003\u0002X1\u00061!/\u001e8oKJT!!\u0017.\u0002\u000b),h.\u001b;\u000b\u0003m\u000b1a\u001c:h\u0013\tifKA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0003\u0001\u0004\"!Y3\u000e\u0003\tT!!W2\u000b\u0005\u0011T\u0016!C:dC2\fG/Z:u\u0013\t1'MA\u0006K+:LGOU;o]\u0016\u0014\b")
public class ExportControllerTest
extends ControllerTestCase {
    private final TrustAnchorLocator tal = new TrustAnchorLocator(new File(""), "Ca Name", Collections.singletonList(URI.create("rsync://rpki.ripe.net/root.cer")), "publicKeyInfo", Collections.emptyList());
    private final RtrPrefix PREFIX1 = new RtrPrefix(Asn.parse((String)"AS6500"), IpRange.parse((String)"10/8"), (Option)None$.MODULE$, (Option)new Some((Object)this.tal()));
    private final RtrPrefix PREFIX2 = new RtrPrefix(Asn.parse((String)"AS6501"), IpRange.parse((String)"10/16"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), RtrPrefix$.MODULE$.apply$default$4());
    private final RtrPrefix PREFIX3 = new RtrPrefix(Asn.parse((String)"AS6502"), IpRange.parse((String)"2001:43e8::/32"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)32)), (Option)new Some((Object)this.tal()));
    private final Set<RtrPrefix> TEST_PREFIXES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.PREFIX1(), this.PREFIX2(), this.PREFIX3()}));

    public TrustAnchorLocator tal() {
        return this.tal;
    }

    public RtrPrefix PREFIX1() {
        return this.PREFIX1;
    }

    public RtrPrefix PREFIX2() {
        return this.PREFIX2;
    }

    public RtrPrefix PREFIX3() {
        return this.PREFIX3;
    }

    public Set<RtrPrefix> TEST_PREFIXES() {
        return this.TEST_PREFIXES;
    }

    @Override
    public ControllerTestCase.ControllerFilter controller() {
        return new ExportController(this){
            private final /* synthetic */ ExportControllerTest $outer;
            private final int net$ripe$rpki$validator$controllers$ExportController$$prefixDelta;
            private final String realm;
            private final ScentryConfig scentryConfig;
            private List org$scalatra$auth$ScentrySupport$$_strategiesFromConfig;

            public int net$ripe$rpki$validator$controllers$ExportController$$prefixDelta() {
                return this.net$ripe$rpki$validator$controllers$ExportController$$prefixDelta;
            }

            public void net$ripe$rpki$validator$controllers$ExportController$_setter_$net$ripe$rpki$validator$controllers$ExportController$$prefixDelta_$eq(int x$1) {
                this.net$ripe$rpki$validator$controllers$ExportController$$prefixDelta = x$1;
            }

            public Route net$ripe$rpki$validator$controllers$ApplicationController$$super$post(Seq transformers, Function0 action) {
                return ScalatraBase.class.post((ScalatraBase)this, (Seq)transformers, (Function0)action);
            }

            public Route net$ripe$rpki$validator$controllers$ApplicationController$$super$put(Seq transformers, Function0 action) {
                return ScalatraBase.class.put((ScalatraBase)this, (Seq)transformers, (Function0)action);
            }

            public Route net$ripe$rpki$validator$controllers$ApplicationController$$super$delete(Seq transformers, Function0 action) {
                return ScalatraBase.class.delete((ScalatraBase)this, (Seq)transformers, (Function0)action);
            }

            public Seq<Validation.FeedbackMessage> feedbackMessages() {
                return ApplicationController.class.feedbackMessages((ApplicationController)this);
            }

            public void redirectWithFeedbackMessages(String url, Seq<Validation.FeedbackMessage> messages) {
                ApplicationController.class.redirectWithFeedbackMessages((ApplicationController)this, (String)url, messages);
            }

            public <A> Validation<NonEmptyList<Validation.FeedbackMessage>, A> validateParameter(String name, Function1<Option<String>, Validation<String, A>> validator) {
                return ApplicationController.class.validateParameter((ApplicationController)this, (String)name, validator);
            }

            public Route post(Seq<package.RouteTransformer> transformers, Function0<Object> action) {
                return ApplicationController.class.post((ApplicationController)this, transformers, action);
            }

            public Route put(Seq<package.RouteTransformer> transformers, Function0<Object> action) {
                return ApplicationController.class.put((ApplicationController)this, transformers, action);
            }

            public Route delete(Seq<package.RouteTransformer> transformers, Function0<Object> action) {
                return ApplicationController.class.delete((ApplicationController)this, transformers, action);
            }

            public String realm() {
                return this.realm;
            }

            public ScentryConfig scentryConfig() {
                return this.scentryConfig;
            }

            public void net$ripe$rpki$validator$authentication$AuthenticationSupport$_setter_$realm_$eq(String x$1) {
                this.realm = x$1;
            }

            public void net$ripe$rpki$validator$authentication$AuthenticationSupport$_setter_$scentryConfig_$eq(ScentryConfig x$1) {
                this.scentryConfig = x$1;
            }

            public PartialFunction<String, User> fromSession() {
                return AuthenticationSupport.class.fromSession((AuthenticationSupport)this);
            }

            public PartialFunction<User, String> toSession() {
                return AuthenticationSupport.class.toSession((AuthenticationSupport)this);
            }

            public void registerAuthStrategies() {
                AuthenticationSupport.class.registerAuthStrategies((AuthenticationSupport)this);
            }

            public Object authenticatedAction(Function0<Object> action) {
                return AuthenticationSupport.class.authenticatedAction((AuthenticationSupport)this, action);
            }

            public Option<User> basicAuth(HttpServletRequest request, HttpServletResponse response) {
                return BasicAuthSupport.class.basicAuth((BasicAuthSupport)this, (HttpServletRequest)request, (HttpServletResponse)response);
            }

            public void org$scalatra$auth$ScentrySupport$$super$initialize(Object config) {
                ScalatraBase.class.initialize((ScalatraBase)this, (Object)config);
            }

            public List org$scalatra$auth$ScentrySupport$$_strategiesFromConfig() {
                return this.org$scalatra$auth$ScentrySupport$$_strategiesFromConfig;
            }

            public void org$scalatra$auth$ScentrySupport$$_strategiesFromConfig_$eq(List x$1) {
                this.org$scalatra$auth$ScentrySupport$$_strategiesFromConfig = x$1;
            }

            public void initialize(Object config) {
                ScentrySupport.class.initialize((ScentrySupport)this, (Object)config);
            }

            public void configureScentry() {
                ScentrySupport.class.configureScentry((ScentrySupport)this);
            }

            public Scentry<User> scentry(HttpServletRequest request) {
                return ScentrySupport.class.scentry((ScentrySupport)this, (HttpServletRequest)request);
            }

            public Option<Scentry<User>> scentryOption(HttpServletRequest request) {
                return ScentrySupport.class.scentryOption((ScentrySupport)this, (HttpServletRequest)request);
            }

            public Option<User> userOption(HttpServletRequest request) {
                return ScentrySupport.class.userOption((ScentrySupport)this, (HttpServletRequest)request);
            }

            public Object user(HttpServletRequest request) {
                return ScentrySupport.class.user((ScentrySupport)this, (HttpServletRequest)request);
            }

            public String user_$eq(Object user, HttpServletRequest request) {
                return ScentrySupport.class.user_$eq((ScentrySupport)this, (Object)user, (HttpServletRequest)request);
            }

            public boolean isAuthenticated(HttpServletRequest request) {
                return ScentrySupport.class.isAuthenticated((ScentrySupport)this, (HttpServletRequest)request);
            }

            public boolean isAnonymous(HttpServletRequest request) {
                return ScentrySupport.class.isAnonymous((ScentrySupport)this, (HttpServletRequest)request);
            }

            public Option<User> authenticate(HttpServletRequest request, HttpServletResponse response) {
                return ScentrySupport.class.authenticate((ScentrySupport)this, (HttpServletRequest)request, (HttpServletResponse)response);
            }

            public void logOut(HttpServletRequest request, HttpServletResponse response) {
                ScentrySupport.class.logOut((ScentrySupport)this, (HttpServletRequest)request, (HttpServletResponse)response);
            }

            public void org$scalatra$MethodOverride$$super$handle(HttpServletRequest request, HttpServletResponse res) {
                FlashMapSupport.class.handle((FlashMapSupport)this, (HttpServletRequest)request, (HttpServletResponse)res);
            }

            public void handle(HttpServletRequest req, HttpServletResponse res) {
                MethodOverride.class.handle((MethodOverride)this, (HttpServletRequest)req, (HttpServletResponse)res);
            }

            public void org$scalatra$FlashMapSupport$$super$handle(HttpServletRequest request, HttpServletResponse res) {
                ServletBase.class.handle((ServletBase)this, (HttpServletRequest)request, (HttpServletResponse)res);
            }

            public void flashMapSetSession(FlashMap f) {
                FlashMapSupport.class.flashMapSetSession((FlashMapSupport)this, (FlashMap)f);
            }

            public FlashMap flash(HttpServletRequest request) {
                return FlashMapSupport.class.flash((FlashMapSupport)this, (HttpServletRequest)request);
            }

            public Object flash(String key, HttpServletRequest request) {
                return FlashMapSupport.class.flash((FlashMapSupport)this, (String)key, (HttpServletRequest)request);
            }

            public boolean sweepUnusedFlashEntries(HttpServletRequest req) {
                return FlashMapSupport.class.sweepUnusedFlashEntries((FlashMapSupport)this, (HttpServletRequest)req);
            }

            public Seq<RtrPrefix> getRtrPrefixes() {
                return this.$outer.TEST_PREFIXES().toSeq();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                FlashMapSupport.class.$init$((FlashMapSupport)this);
                MethodOverride.class.$init$((MethodOverride)this);
                ScentrySupport.class.$init$((ScentrySupport)this);
                BasicAuthSupport.class.$init$((BasicAuthSupport)this);
                AuthenticationSupport.class.$init$((AuthenticationSupport)this);
                ApplicationController.class.$init$((ApplicationController)this);
                ExportController.class.$init$((ExportController)this);
            }
        };
    }

    public ExportControllerTest() {
        this.test("Should make CSV with max lengths filled out", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportControllerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.get("/export.csv", new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        String expectedResponse = new StringOps(Predef$.MODULE$.augmentString("ASN,IP Prefix,Max Length,Trust Anchor\n          |AS6500,10.0.0.0/8,8,Ca Name\n          |AS6501,10.0.0.0/16,18,unknown\n          |AS6502,2001:43e8::/32,32,Ca Name\n          |")).stripMargin();
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().status())).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal(BoxesRunTime.boxToInteger((int)200)), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().body()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal(expectedResponse), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().startWith().apply("text/csv"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().endWith().apply("charset=utf-8"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Pragma")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("public"), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Cache-Control")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("no-cache"), (Object)Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExportControllerTest net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should export JSON with max lengths filled out", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportControllerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.get("/export.json", new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().status())).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal(BoxesRunTime.boxToInteger((int)200)), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().body()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("{\"roas\":[{\"asn\":\"AS6500\",\"prefix\":\"10.0.0.0/8\",\"maxLength\":8,\"ta\":\"Ca Name\"},{\"asn\":\"AS6501\",\"prefix\":\"10.0.0.0/16\",\"maxLength\":18,\"ta\":\"unknown\"},{\"asn\":\"AS6502\",\"prefix\":\"2001:43e8::/32\",\"maxLength\":32,\"ta\":\"Ca Name\"}]}"), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().startWith().apply("text/json"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().endWith().apply("charset=utf-8"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Pragma")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("public"), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Cache-Control")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("no-cache"), (Object)Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExportControllerTest net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should make rpsl for every possible route", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExportControllerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTime dateTime = DateTime.now();
                DateTimeUtils.setCurrentMillisFixed((long)dateTime.getMillis());
                String formattedDateTime = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC().print((ReadableInstant)dateTime);
                this.$outer.get("/export.rpsl", new Serializable(this, formattedDateTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final String formattedDateTime$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        String expectedResponse = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |route: 10.0.0.0/8\n         |origin: AS6500\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-CA-NAME\n         |\n         |route: 10.0.0.0/16\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.0.0/17\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.0.0/18\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.64.0/18\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.128.0/17\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.128.0/18\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route: 10.0.192.0/18\n         |origin: AS6501\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-UNKNOWN\n         |\n         |route6: 2001:43e8::/32\n         |origin: AS6502\n         |descr: exported from ripe ncc validator\n         |mnt-by: NA\n         |created: ", "\n         |last-modified: ", "\n         |source: ROA-CA-NAME\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1, this.formattedDateTime$1})))).stripMargin();
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().status())).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal(BoxesRunTime.boxToInteger((int)200)), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().body()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal(expectedResponse), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().startWith().apply("text/plain"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper(((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Content-Type")).toLowerCase()).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().endWith().apply("charset=utf-8"));
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Pragma")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("public"), (Object)Equality$.MODULE$.default());
                        this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().convertToStringShouldWrapper((String)this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().header().apply((Object)"Cache-Control")).should(this.$outer.net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer().equal("no-cache"), (Object)Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.formattedDateTime$1 = formattedDateTime$1;
                    }
                });
            }

            public /* synthetic */ ExportControllerTest net$ripe$rpki$validator$controllers$ExportControllerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

