/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.config.health.Code$;
import net.ripe.rpki.validator.config.health.Health$;
import net.ripe.rpki.validator.config.health.Status;
import net.ripe.rpki.validator.config.health.Status$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.joda.time.DateTime;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001\u001b\tQ\u0001*Z1mi\"$Vm\u001d;\u000b\u0005\r!\u0011AB2p]\u001aLwM\u0003\u0002\u0006\r\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u000f!\tAA\u001d9lS*\u0011\u0011BC\u0001\u0005e&\u0004XMC\u0001\f\u0003\rqW\r^\u0002\u0001'\u0011\u0001a\u0002\u0006\u000f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011aB:vaB|'\u000f^\u0005\u0003'A\u0011\u0011CV1mS\u0012\fGo\u001c:UKN$8)Y:f!\t)\"$D\u0001\u0017\u0015\t9\u0002$A\u0005tG\u0006d\u0017\r^3ti*\t\u0011$A\u0002pe\u001eL!a\u0007\f\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000e\u0005\u0002\u0016;%\u0011aD\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\t!\u0001\u000b\u0003\u0001K5r\u0003C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0019\u0011XO\u001c8fe*\u0011!\u0006G\u0001\u0006UVt\u0017\u000e^\u0005\u0003Y\u001d\u0012qAU;o/&$\b.A\u0003wC2,XmI\u00010!\t\u0001$'D\u00012\u0015\tQc#\u0003\u00024c\tY!*\u00168jiJ+hN\\3s\u0001")
public class HealthTest
extends ValidatorTestCase
implements BeforeAndAfterAll,
BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public org.scalatest.Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public org.scalatest.Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public org.scalatest.Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public org.scalatest.Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public org.scalatest.Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public HealthTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.test("Should return OK for empty status list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(Health$.MODULE$.getValidationTimeStatus((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).should(this.$outer.equal(Status$.MODULE$.ok()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return WARNING for status list with one empty time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(Health$.MODULE$.getValidationTimeStatus((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new None$[]{None$.MODULE$})))).should(this.$outer.equal(Status$.MODULE$.warning("Not all TA's are validated.")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return OK for status list with one existing time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTime t = new DateTime();
                this.$outer.convertToAnyShouldWrapper(Health$.MODULE$.getValidationTimeStatus((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Some[]{new Some((Object)t)})))).should(this.$outer.equal(Status$.MODULE$.ok()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return ERROR for status list with one time in the past", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTime t = new DateTime().minus(ApplicationOptions$.MODULE$.validationInterval().length() * 5L);
                Status status = Health$.MODULE$.getValidationTimeStatus((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Some[]{new Some((Object)t)})));
                this.$outer.convertToAnyShouldWrapper(status.code()).should(this.$outer.equal(Code$.MODULE$.RECOVERABLE_ERROR()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((String)status.message().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).contains("No trust anchors have been validated since"))).should(this.$outer.be().apply(true));
                Predef$.MODULE$.println((Object)status);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return OK for status list with at least one good timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(Health$.MODULE$.getValidationTimeStatus((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{None$.MODULE$, new Some((Object)new DateTime().minus(ApplicationOptions$.MODULE$.validationInterval().length() * 5L)), new Some((Object)new DateTime())})))).should(this.$outer.equal(Status$.MODULE$.ok()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

