/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import java.util.Date;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementSet;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementSet$;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.joda.time.LocalDate;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001f\tA\"i\u001a9SSN$U/\u001c9E_^tGn\\1eKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00029sKZLWm\u001e\u0006\u0003\u000b\u0019\t1AY4q\u0015\t9\u0001\"A\u0005wC2LG-\u0019;pe*\u0011\u0011BC\u0001\u0005eB\\\u0017N\u0003\u0002\f\u0019\u0005!!/\u001b9f\u0015\u0005i\u0011a\u00018fi\u000e\u00011\u0003\u0002\u0001\u0011-y\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\u000fM,\b\u000f]8si&\u0011QC\u0005\u0002\u0012-\u0006d\u0017\u000eZ1u_J$Vm\u001d;DCN,\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u001c\u0003\ry'oZ\u0005\u0003;a\u0011!CQ3g_J,\u0017I\u001c3BMR,'/R1dQB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005G\u0001\u0005[>\u001c7.\u0003\u0002$A\taQj\\2lSR|7+^4be\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011A\u0001\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u00039iwnY6IiR\u00048\t\\5f]R,\u0012\u0001\f\t\u0003[Qj\u0011A\f\u0006\u0003_A\naa\u00197jK:$(BA\u00193\u0003\u0011AG\u000f\u001e9\u000b\u0005MR\u0012AB1qC\u000eDW-\u0003\u00026]\tQ\u0001\n\u001e;q\u00072LWM\u001c;\t\r]\u0002\u0001\u0015!\u0003-\u0003=iwnY6IiR\u00048\t\\5f]R\u0004\u0003bB\u001d\u0001\u0005\u0004%\tAO\u0001\u000fQR$\b/M\u0019Qe>$xnY8m+\u0005Y\u0004C\u0001\u001f>\u001b\u0005\u0001\u0014B\u0001 1\u0005=\u0001&o\u001c;pG>dg+\u001a:tS>t\u0007B\u0002!\u0001A\u0003%1(A\biiR\u0004\u0018'\r)s_R|7m\u001c7!\u0011\u001d\u0011\u0005A1A\u0005\u0002\r\u000bA\u0001Z;naV\tA\t\u0005\u0002)\u000b&\u0011aI\u0001\u0002\u0013\u0005\u001e\u0004\u0018I\u001c8pk:\u001cW-\\3oiN+G\u000f\u0003\u0004I\u0001\u0001\u0006I\u0001R\u0001\u0006IVl\u0007\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003Q\u0011u\r\u001d*jg\u0012+X\u000e\u001d#po:dw.\u00193feV\tA\n\u0005\u0002)\u001b&\u0011aJ\u0001\u0002\u0015\u0005\u001e\u0004(+[:Ek6\u0004Hi\\<oY>\fG-\u001a:\t\rA\u0003\u0001\u0015!\u0003M\u0003U\u0011u\r\u001d*jg\u0012+X\u000e\u001d#po:dw.\u00193fe\u0002BQA\u0015\u0001\u0005BM\u000b!BY3g_J,W)Y2i)\u0005!\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&\u0001B+oSRDC\u0001A.dIB\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0007eVtg.\u001a:\u000b\u0005\u0001T\u0012!\u00026v]&$\u0018B\u00012^\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013!\u001a\t\u0003M\"l\u0011a\u001a\u0006\u0003AbI!![4\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class BgpRisDumpDownloaderTest
extends ValidatorTestCase
implements BeforeAndAfterEach,
MockitoSugar {
    private final HttpClient mockHttpClient;
    private final ProtocolVersion http11Protocol;
    private final BgpAnnouncementSet dump;
    private final BgpRisDumpDownloader BgpRisDumpDownloader;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public HttpClient mockHttpClient() {
        return this.mockHttpClient;
    }

    public ProtocolVersion http11Protocol() {
        return this.http11Protocol;
    }

    public BgpAnnouncementSet dump() {
        return this.dump;
    }

    public BgpRisDumpDownloader BgpRisDumpDownloader() {
        return this.BgpRisDumpDownloader;
    }

    public void beforeEach() {
        Mockito.reset((Object[])new HttpClient[]{this.mockHttpClient()});
    }

    public BgpRisDumpDownloaderTest() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.mockHttpClient = (HttpClient)this.mock(ManifestFactory$.MODULE$.classType(HttpClient.class));
        this.http11Protocol = new ProtocolVersion("http", 1, 1);
        this.dump = new BgpAnnouncementSet("http://no.where/dump.4.gz", BgpAnnouncementSet$.MODULE$.apply$default$2(), BgpAnnouncementSet$.MODULE$.apply$default$3());
        this.BgpRisDumpDownloader = new BgpRisDumpDownloader(this.mockHttpClient());
        this.test("should stick to old dump, if new dump cannot be retrieved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 500, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpAnnouncementSet dumpFromResponse = (BgpAnnouncementSet)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should stick to old dump if it's not modified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 304, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpAnnouncementSet dumpFromResponse = (BgpAnnouncementSet)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should stick to old dump if new dump can't be parsed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 304, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpAnnouncementSet dumpFromResponse = (BgpAnnouncementSet)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should download and unzip new dump", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 200, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                StringEntity entity = new StringEntity("not gzip format");
                entity.setContentType("application/x-gzip");
                Date lastMidnight = LocalDate.now().toDate();
                response.setEntity((HttpEntity)entity);
                response.setHeader("Last-Modified", DateUtils.formatDate((Date)lastMidnight));
                BgpAnnouncementSet dumpFromResponse = (BgpAnnouncementSet)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

