/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementValidator;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement$;
import net.ripe.rpki.validator.models.RouteValidity$;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Size$;
import org.scalatest.junit.JUnitRunner;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001=\u0011ADQ4q\u0003:tw.\u001e8dK6,g\u000e\u001e,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0001O]3wS\u0016<(BA\u0003\u0007\u0003\r\u0011w\r\u001d\u0006\u0003\u000f!\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005%Q\u0011\u0001\u0002:qW&T!a\u0003\u0007\u0002\tIL\u0007/\u001a\u0006\u0002\u001b\u0005\u0019a.\u001a;\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011aB:vaB|'\u000f^\u0005\u0003+I\u0011\u0011CV1mS\u0012\fGo\u001c:UKN$8)Y:f!\t9B$D\u0001\u0019\u0015\tI\"$A\u0005tG\u0006d\u0017\r^3ti*\t1$A\u0002pe\u001eL!!\b\r\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000eC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u0005!)A\u0005\u0001C\u0002K\u0005A\u0011J\u001c;U_\u0006\u001bh\u000e\u0006\u0002'YA\u0011qEK\u0007\u0002Q)\u0011\u0011FC\u0001\u000bSB\u0014Xm]8ve\u000e,\u0017BA\u0016)\u0005\r\t5O\u001c\u0005\u0006[\r\u0002\rAL\u0001\u0004CNt\u0007CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$aA%oi\")Q\u0007\u0001C\u0002m\u0005Y1\u000b\u001e:j]\u001e$v.Q:o)\t1s\u0007C\u0003.i\u0001\u0007\u0001\b\u0005\u0002:y9\u0011qFO\u0005\u0003wA\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111\b\r\u0005\u0006\u0001\u0002!\u0019!Q\u0001\u0010'R\u0014\u0018N\\4U_&\u0003(+\u00198hKR\u0011!)\u0012\t\u0003O\rK!\u0001\u0012\u0015\u0003\u000f%\u0003(+\u00198hK\")ai\u0010a\u0001q\u00051\u0001O]3gSbDQ\u0001\u0013\u0001\u0005\u0004%\u000ba\u0003V;qY\u0016$vNQ4q\u0003:tw.\u001e8dK6,g\u000e\u001e\u000b\u0003\u00156\u0003\"AI&\n\u00051\u0013!a\u0004\"ha\u0006sgn\\;oG\u0016lWM\u001c;\t\u000b9;\u0005\u0019A(\u0002\u0003a\u0004Ba\f)/q%\u0011\u0011\u000b\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000bM\u0003A1\u0001+\u0002!Q+\b\u000f\\3U_J#(\u000f\u0015:fM&DHCA+\\!\t1\u0016,D\u0001X\u0015\tAf!\u0001\u0004n_\u0012,Gn]\u0005\u00035^\u0013\u0011B\u0015;s!J,g-\u001b=\t\u000b9\u0013\u0006\u0019A(\t\u000bM\u0003A1A/\u0015\u0005Us\u0006\"\u0002(]\u0001\u0004y\u0006#B\u0018a]ar\u0013BA11\u0005\u0019!V\u000f\u001d7fg!91\r\u0001b\u0001\n\u0007!\u0017aC1di>\u00148+_:uK6,\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fQ!Y2u_JT\u0011A[\u0001\u0005C.\\\u0017-\u0003\u0002mO\nY\u0011i\u0019;peNK8\u000f^3n\u0011\u0019q\u0007\u0001)A\u0005K\u0006a\u0011m\u0019;peNK8\u000f^3nA!9\u0001\u000f\u0001b\u0001\n\u0013\t\u0018aB:vE*,7\r^\u000b\u0002eB\u0011!e]\u0005\u0003i\n\u0011\u0001DQ4q\u0003:tw.\u001e8dK6,g\u000e\u001e,bY&$\u0017\r^8s\u0011\u00191\b\u0001)A\u0005e\u0006A1/\u001e2kK\u000e$\b\u0005\u000b\u0004\u0001q\u0006\u0005\u00111\u0001\t\u0003szl\u0011A\u001f\u0006\u0003wr\faA];o]\u0016\u0014(BA?\u001b\u0003\u0015QWO\\5u\u0013\ty(PA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u0017i!!!\u0003\u000b\u0005uD\u0012\u0002BA\u0007\u0003\u0013\u00111BS+oSR\u0014VO\u001c8fe\u0002")
public class BgpAnnouncementValidatorTest
extends ValidatorTestCase
implements BeforeAndAfterAll {
    private final ActorSystem actorSystem;
    private final BgpAnnouncementValidator net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Asn IntToAsn(int asn) {
        return new Asn((long)asn);
    }

    public Asn StringToAsn(String asn) {
        return Asn.parse((String)asn);
    }

    public IpRange StringToIpRange(String prefix) {
        return IpRange.parse((String)prefix);
    }

    public BgpAnnouncement TupleToBgpAnnouncement(Tuple2<Object, String> x) {
        return new BgpAnnouncement(this.IntToAsn(x._1$mcI$sp()), this.StringToIpRange((String)x._2()));
    }

    public RtrPrefix TupleToRtrPrefix(Tuple2<Object, String> x) {
        return new RtrPrefix(this.IntToAsn(x._1$mcI$sp()), this.StringToIpRange((String)x._2()), RtrPrefix$.MODULE$.apply$default$3(), RtrPrefix$.MODULE$.apply$default$4());
    }

    public RtrPrefix TupleToRtrPrefix(Tuple3<Object, String, Object> x) {
        return new RtrPrefix(this.IntToAsn(BoxesRunTime.unboxToInt((Object)x._1())), this.StringToIpRange((String)x._2()), (Option)new Some(x._3()), RtrPrefix$.MODULE$.apply$default$4());
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public BgpAnnouncementValidator net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject() {
        return this.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject;
    }

    public BgpAnnouncementValidatorTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.actorSystem = ActorSystem$.MODULE$.apply();
        this.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject = new BgpAnnouncementValidator(this.actorSystem());
        this.test("should validate prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.2.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24")), this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65004), (Object)"10.0.4.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.2.0/24")), this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements()).should(this.$outer.have()).size(4L, Size$.MODULE$.sizeOfGenTraversable());
                BgpValidatedAnnouncement[] bgpValidatedAnnouncementArray = new BgpValidatedAnnouncement[4];
                bgpValidatedAnnouncementArray[0] = BgpValidatedAnnouncement$.MODULE$.make(this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))})), BgpValidatedAnnouncement$.MODULE$.make$default$3(), BgpValidatedAnnouncement$.MODULE$.make$default$4());
                BgpAnnouncement x$1 = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.2.0/24"));
                Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.2.0/24"))}));
                Seq x$3 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                Seq x$4 = BgpValidatedAnnouncement$.MODULE$.make$default$4();
                bgpValidatedAnnouncementArray[1] = BgpValidatedAnnouncement$.MODULE$.make(x$1, x$3, x$2, x$4);
                BgpAnnouncement x$5 = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24"));
                Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65003), (Object)"10.0.3.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                Seq x$7 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                Seq x$8 = BgpValidatedAnnouncement$.MODULE$.make$default$3();
                bgpValidatedAnnouncementArray[2] = BgpValidatedAnnouncement$.MODULE$.make(x$5, x$7, x$8, x$6);
                bgpValidatedAnnouncementArray[3] = BgpValidatedAnnouncement$.MODULE$.make(this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65004), (Object)"10.0.4.0/24")), BgpValidatedAnnouncement$.MODULE$.make$default$2(), BgpValidatedAnnouncement$.MODULE$.make$default$3(), BgpValidatedAnnouncement$.MODULE$.make$default$4());
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements()).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])bgpValidatedAnnouncementArray))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Unknown if there are no RTR prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.empty();
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.IntToAsn(65001), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.Unknown())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Valid if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.IntToAsn(65001), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.Valid())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Invalid ASN if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.IntToAsn(65001), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.InvalidAsn())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be Invalid Length if there is an appropriate RTR prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq announcements = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncement[]{this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq prefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().startUpdate(announcements, prefixes);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidatorTest$$subject().validatedAnnouncements().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Asn, IpRange, Enumeration.Value> apply(BgpValidatedAnnouncement x) {
                        return new Tuple3((Object)x.asn(), (Object)x.prefix(), (Object)x.validity());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.$outer.IntToAsn(65001), (Object)this.$outer.StringToIpRange("10.0.1.0/24"), (Object)RouteValidity$.MODULE$.InvalidLength())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail to construct BgpValidatedAnnouncement if invalidsLength contains a VRP that refers to a different ASN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq invalidsAsn = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                IllegalArgumentException e = (IllegalArgumentException)this.$outer.the(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)).thrownBy((Function0)new Serializable(this, announcement, invalidsAsn){
                    public static final long serialVersionUID = 0L;
                    private final BgpAnnouncement announcement$1;
                    private final Seq invalidsAsn$1;

                    public final BgpValidatedAnnouncement apply() {
                        BgpAnnouncement x$9 = this.announcement$1;
                        Seq x$10 = this.invalidsAsn$1;
                        Seq x$11 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                        Seq x$12 = BgpValidatedAnnouncement$.MODULE$.make$default$3();
                        return BgpValidatedAnnouncement$.MODULE$.make(x$9, x$11, x$12, x$10);
                    }
                    {
                        this.announcement$1 = announcement$1;
                        this.invalidsAsn$1 = invalidsAsn$1;
                    }
                });
                this.$outer.convertToStringShouldWrapper(e.getMessage()).should(this.$outer.equal("requirement failed: invalidsLength must only contain VRPs that refer to the same ASN"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail to construct BgpValidatedAnnouncement if invalidsAsn contains a VRP with the announced ASN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq invalidsLength = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.0.0/16", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                IllegalArgumentException e = (IllegalArgumentException)this.$outer.the(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)).thrownBy((Function0)new Serializable(this, announcement, invalidsLength){
                    public static final long serialVersionUID = 0L;
                    private final BgpAnnouncement announcement$2;
                    private final Seq invalidsLength$1;

                    public final BgpValidatedAnnouncement apply() {
                        BgpAnnouncement x$13 = this.announcement$2;
                        Seq x$14 = this.invalidsLength$1;
                        Seq x$15 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                        Seq x$16 = BgpValidatedAnnouncement$.MODULE$.make$default$4();
                        return BgpValidatedAnnouncement$.MODULE$.make(x$13, x$15, x$14, x$16);
                    }
                    {
                        this.announcement$2 = announcement$2;
                        this.invalidsLength$1 = invalidsLength$1;
                    }
                });
                this.$outer.convertToStringShouldWrapper(e.getMessage()).should(this.$outer.equal("requirement failed: invalidsAsn must not contain the announced ASN"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validity should be determined by RTR prefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpAnnouncementValidatorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BgpAnnouncement announcement = this.$outer.TupleToBgpAnnouncement((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"));
                Seq valids = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.1.0/24"))}));
                Seq invalidsAsn = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple2<Object, String>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)65002), (Object)"10.0.1.0/24"))}));
                Seq invalidsLength = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.TupleToRtrPrefix((Tuple3<Object, String, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)65001), (Object)"10.0.0.0/16", (Object)BoxesRunTime.boxToInteger((int)20)))}));
                this.$outer.convertToAnyShouldWrapper(new BgpValidatedAnnouncement(announcement, BgpValidatedAnnouncement$.MODULE$.apply$default$2()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Unknown()));
                BgpAnnouncement x$17 = announcement;
                Seq x$18 = invalidsLength;
                Seq x$19 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                Seq x$20 = BgpValidatedAnnouncement$.MODULE$.make$default$3();
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(x$17, x$19, x$20, x$18).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidLength()));
                BgpAnnouncement x$21 = announcement;
                Seq x$22 = invalidsAsn;
                Seq x$23 = invalidsLength;
                Seq x$24 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(x$21, x$24, x$22, x$23).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidLength()));
                BgpAnnouncement x$25 = announcement;
                Seq x$26 = invalidsAsn;
                Seq x$27 = BgpValidatedAnnouncement$.MODULE$.make$default$2();
                Seq x$28 = BgpValidatedAnnouncement$.MODULE$.make$default$4();
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(x$25, x$27, x$26, x$28).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.InvalidAsn()));
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(announcement, valids, BgpValidatedAnnouncement$.MODULE$.make$default$3(), BgpValidatedAnnouncement$.MODULE$.make$default$4()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(announcement, valids, invalidsAsn, BgpValidatedAnnouncement$.MODULE$.make$default$4()).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                BgpAnnouncement x$29 = announcement;
                Seq x$30 = valids;
                Seq x$31 = invalidsLength;
                Seq x$32 = BgpValidatedAnnouncement$.MODULE$.make$default$3();
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(x$29, x$30, x$32, x$31).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
                this.$outer.convertToAnyShouldWrapper(BgpValidatedAnnouncement$.MODULE$.make(announcement, valids, invalidsAsn, invalidsLength).validity()).should(this.$outer.be().apply((Object)RouteValidity$.MODULE$.Valid()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

