/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.views;

import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.lib.DateAndTime$;
import net.ripe.rpki.validator.lib.DateAndTime$DateTimeOrdering$;
import net.ripe.rpki.validator.lib.Validation;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.Running;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.views.Tab;
import net.ripe.rpki.validator.views.Tabs$;
import net.ripe.rpki.validator.views.TrustAnchorsView$;
import net.ripe.rpki.validator.views.View;
import net.ripe.rpki.validator.views.ViewHelpers;
import net.ripe.rpki.validator.views.ViewHelpers$class;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u0016:vgR\fen\u00195peN4\u0016.Z<\u000b\u0005\r!\u0011!\u0002<jK^\u001c(BA\u0003\u0007\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\b\u0011\u0005!!\u000f]6j\u0015\tI!\"\u0001\u0003sSB,'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\t\u0001qA\u0003\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!\u0001\u0002,jK^\u0004\"!F\r\n\u0005i\u0011!a\u0003,jK^DU\r\u001c9feND\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\riJ,8\u000f^!oG\"|'o\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0011\ta!\\8eK2\u001c\u0018B\u0001\u0012 \u00051!&/^:u\u0003:\u001c\u0007n\u001c:t\u0011!!\u0003A!A!\u0002\u0013)\u0013A\u0006<bY&$\u0017\r^5p]N#\u0018\r^;t\u0007>,h\u000e^:\u0011\t\u0019JCF\r\b\u0003\u001f\u001dJ!\u0001\u000b\t\u0002\rA\u0013X\rZ3g\u0013\tQ3FA\u0002NCBT!\u0001\u000b\t\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011\u0001B;uS2L!!\r\u0018\u0003%Q\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\t\u0005M%\u001a4\b\u0005\u00025s5\tQG\u0003\u00027o\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005a2\u0011aB2p[6|gn]\u0005\u0003uU\u0012\u0001CV1mS\u0012\fG/[8o'R\fG/^:\u0011\u0005=a\u0014BA\u001f\u0011\u0005\rIe\u000e\u001e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006\u0019an\\<\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015\u0001\u0002;j[\u0016T!!\u0012$\u0002\t)|G-\u0019\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u0013%\u0001\u0003#bi\u0016$\u0016.\\3\t\u0011-\u0003!\u0011!Q\u0001\n1\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0004\u001bVCfB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011A\u000bE\u0001\ba\u0006\u001c7.Y4f\u0013\t1vKA\u0002TKFT!\u0001\u0016\t\u0011\u0005e\u000bgB\u0001._\u001d\tYF,D\u0001\u0005\u0013\tiF!A\u0002mS\nL!a\u00181\u0002\u0015Y\u000bG.\u001b3bi&|gN\u0003\u0002^\t%\u0011!m\u0019\u0002\u0010\r\u0016,GMY1dW6+7o]1hK*\u0011q\f\u0019\u0005\u0006K\u0002!\tAZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dD\u0017N[6\u0011\u0005U\u0001\u0001\"\u0002\u000fe\u0001\u0004i\u0002\"\u0002\u0013e\u0001\u0004)\u0003bB e!\u0003\u0005\r\u0001\u0011\u0005\b\u0017\u0012\u0004\n\u00111\u0001M\u0011\u0015i\u0007\u0001\"\u0001o\u0003\r!\u0018MY\u000b\u0002_B\u0011Q\u0003]\u0005\u0003c\n\u00111\u0001V1c\u0011\u0015\u0019\b\u0001\"\u0001u\u0003\u0015!\u0018\u000e\u001e7f+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=\u0011\u0003\rAX\u000e\\\u0005\u0003u^\u0014A\u0001V3yi\")A\u0010\u0001C\u0001{\u0006!!m\u001c3z+\u0005q\bC\u0001<\u0000\u0013\r\t\ta\u001e\u0002\b\u001d>$WmU3r\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\taB]3oI\u0016\u00148i\\;oi\u0016\u00148\u000f\u0006\u0004\u0002\n\u0005=\u0011\u0011\u0004\t\u0004m\u0006-\u0011bAA\u0007o\n!Q\t\\3n\u0011!\t\t\"a\u0001A\u0002\u0005M\u0011A\u0001;b!\rq\u0012QC\u0005\u0004\u0003/y\"a\u0003+skN$\u0018I\\2i_JDq!a\u0007\u0002\u0004\u0001\u0007!'\u0001\u0005d_VtG/\u001a:t\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\t\u0011\"\u001a=qSJ,7/\u00138\u0015\u0007y\f\u0019\u0003C\u0004\u0002&\u0005u\u0001\u0019\u0001!\u0002\u001b9|GOV1mS\u0012\fe\r^3s\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t!c]8si\u0016$GK];ti\u0006s7\r[8sgV\u0011\u0011Q\u0006\t\u0007\u0003_\tI$a\u0005\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005]\u0002#\u0001\u0006d_2dWm\u0019;j_:LA!a\u000f\u00022\t!A*[:u\u000f%\tyDAA\u0001\u0012\u0003\t\t%\u0001\tUeV\u001cH/\u00118dQ>\u00148OV5foB\u0019Q#a\u0011\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u000b\u001a2!a\u0011\u000f\u0011\u001d)\u00171\tC\u0001\u0003\u0013\"\"!!\u0011\t\u0015\u00055\u00131II\u0001\n\u0003\ty%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003#R3\u0001QA*W\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA0!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA4\u0003\u0007\n\n\u0011\"\u0001\u0002j\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a\u001b+\u00071\u000b\u0019\u0006")
public class TrustAnchorsView
implements View,
ViewHelpers {
    private final TrustAnchors trustAnchors;
    public final Map<TrustAnchorLocator, Map<ValidationStatus, Object>> net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts;
    public final DateTime net$ripe$rpki$validator$views$TrustAnchorsView$$now;
    private final Seq<Validation.FeedbackMessage> messages;
    private final Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes;
    private final Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers;

    public static Seq<Validation.FeedbackMessage> $lessinit$greater$default$4() {
        return TrustAnchorsView$.MODULE$.$lessinit$greater$default$4();
    }

    public static DateTime $lessinit$greater$default$3() {
        return TrustAnchorsView$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$classes;
    }

    @Override
    public Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$headers;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$classes_$eq(Map x$1) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$classes = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$headers_$eq(Map x$1) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$headers = x$1;
    }

    @Override
    public NodeSeq renderMessages(Seq<Validation.FeedbackMessage> messages2, Function1<String, String> fieldNameToText) {
        return ViewHelpers$class.renderMessages(this, messages2, fieldNameToText);
    }

    @Override
    public Tab tab() {
        return Tabs$.MODULE$.TrustAnchorsTab();
    }

    public Text title() {
        return Text$.MODULE$.apply("Configured Trust Anchors");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NodeSeq body() {
        Elem elem;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.renderMessages(this.messages, (Function1<String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        }));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var2_2));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("zebra-striped"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("trust-anchors"), (MetaData)$md);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Enabled"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Trust anchor"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, false, (Seq)$buf6));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Processed Items"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, false, (Seq)$buf7));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Expires in"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, false, (Seq)$buf8));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Last updated"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$8, false, (Seq)$buf9));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Next update in"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, false, (Seq)$buf10));
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md2);
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.tab().url()).append((Object)"/update").toString(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md3);
        TopScope$ topScope$11 = Predef$.MODULE$.$scope();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        if (this.trustAnchors.all().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrustAnchor x$1) {
                return x$1.status().isRunning();
            }
        }) || this.trustAnchors.all().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrustAnchor x$2) {
                return !x$2.enabled();
            }
        })) {
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("disabled", (Seq)new Text("disabled"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("value", (Seq)new Text("Update all"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("class", (Seq)new Text("btn primary span2"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md4);
            elem = new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        } else {
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("value", (Seq)new Text("Update all"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("class", (Seq)new Text("btn primary span2"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md5);
            elem = new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        }
        $buf12.$amp$plus((Object)elem);
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "form", (MetaData)$md3, (NamespaceBinding)topScope$11, false, (Seq)$buf12));
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)topScope$10, false, (Seq)$buf11));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus(this.sortedTrustAnchors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorsView $outer;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Elem apply(TrustAnchor ta) {
                void var2_2;
                NodeBuffer nodeBuffer;
                Elem elem;
                Elem elem2;
                Elem elem3;
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md);
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md2);
                $md2 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.$outer.tab().url()).append((Object)"/toggle").toString(), (MetaData)$md2);
                $md2 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md2);
                TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                  "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("value", ta.locator().getCaName(), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("name", (Seq)new Text("name"), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md3);
                $buf3.$amp$plus((Object)new Elem(null, "input", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf3.$amp$plus((Object)new Text("\n                "));
                if (ta.enabled()) {
                    Null$ $md4 = Null$.MODULE$;
                    $md4 = new UnprefixedAttribute("onclick", (Seq)new Text("this.form.submit();"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("name", (Seq)new Text("enable-ta"), (MetaData)$md4);
                    elem3 = new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                } else {
                    Null$ $md5 = Null$.MODULE$;
                    $md5 = new UnprefixedAttribute("onclick", (Seq)new Text("this.form.submit();"), (MetaData)$md5);
                    $md5 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md5);
                    $md5 = new UnprefixedAttribute("name", (Seq)new Text("enable-ta"), (MetaData)$md5);
                    elem3 = new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf3.$amp$plus((Object)elem3);
                $buf3.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus((Object)new Elem(null, "form", (MetaData)$md2, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n            "));
                TopScope$ topScope$4 = Predef$.MODULE$.$scope();
                NodeBuffer $buf4 = new NodeBuffer();
                Null$ $md6 = Null$.MODULE$;
                $md6 = new UnprefixedAttribute("data-original-title", (String)ta.certificate().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(X509ResourceCertificate x$3) {
                        return x$3.getSubject().toString();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }), (MetaData)$md6);
                $md6 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md6);
                TopScope$ topScope$5 = Predef$.MODULE$.$scope();
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)ta.name());
                $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)topScope$5, false, (Seq)$buf5));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, false, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md7 = Null$.MODULE$;
                $md7 = new UnprefixedAttribute("nowrap", (Seq)new Text("nowrap"), (MetaData)$md7);
                TopScope$ topScope$6 = Predef$.MODULE$.$scope();
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$renderCounters(ta, (Map<ValidationStatus, Object>)((Map)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts.getOrElse((Object)ta.locator(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<ValidationStatus, Nothing$> apply() {
                        return Predef$.MODULE$.Map().empty();
                    }
                }))));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)topScope$6, false, (Seq)$buf6));
                Option<X509ResourceCertificate> option = ta.certificate();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    X509ResourceCertificate certificate = (X509ResourceCertificate)some.x();
                    DateTime notValidAfter = certificate.getValidityPeriod().getNotValidAfter();
                    TopScope$ topScope$7 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf7 = new NodeBuffer();
                    Null$ $md8 = Null$.MODULE$;
                    $md8 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(notValidAfter), (MetaData)$md8);
                    $md8 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md8);
                    TopScope$ topScope$8 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf8 = new NodeBuffer();
                    $buf8.$amp$plus((Object)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$expiresIn(notValidAfter));
                    $buf7.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)topScope$8, false, (Seq)$buf8));
                    elem2 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, false, (Seq)$buf7);
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<X509ResourceCertificate> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                    elem2 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf.$amp$plus((Object)elem2);
                if (ta.enabled()) {
                    Elem elem4;
                    Option<DateTime> option3 = ta.lastUpdated();
                    if (option3 instanceof Some) {
                        NodeSeq nodeSeq;
                        Some some = (Some)option3;
                        DateTime lastUpdated = (DateTime)some.x();
                        Option manifestStale = ta.manifestNextUpdateTime().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$body$4 $outer;

                            public final Option<String> apply(DateTime dt) {
                                return dt.isBefore((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now) ? new Some((Object)new StringBuilder().append((Object)"Manifest has been stale for ").append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)dt, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now), DateAndTime$.MODULE$.periodInWords$default$2())).toString()) : None$.MODULE$;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Option crlStale = ta.crlNextUpdateTime().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$body$4 $outer;

                            public final Option<String> apply(DateTime dt) {
                                return dt.isBefore((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now) ? new Some((Object)new StringBuilder().append((Object)"CRL has been stale for ").append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)dt, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now), DateAndTime$.MODULE$.periodInWords$default$2())).toString()) : None$.MODULE$;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Seq warnings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{manifestStale, crlStale})).flatten((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<String> apply(Option<String> xo) {
                                return Option$.MODULE$.option2Iterable(xo);
                            }
                        });
                        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf9 = new NodeBuffer();
                        Null$ $md9 = Null$.MODULE$;
                        $md9 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(lastUpdated), (MetaData)$md9);
                        $md9 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md9);
                        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf10 = new NodeBuffer();
                        $buf10.$amp$plus((Object)new StringBuilder().append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)lastUpdated, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now).withMillis(0), 1)).append((Object)" ago").toString());
                        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)topScope$10, false, (Seq)$buf10));
                        if (warnings.isEmpty()) {
                            nodeSeq = NodeSeq$.MODULE$.Empty();
                        } else {
                            Null$ $md10 = Null$.MODULE$;
                            $md10 = new UnprefixedAttribute("data-original-title", warnings.mkString(", "), (MetaData)$md10);
                            $md10 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md10);
                            TopScope$ topScope$11 = Predef$.MODULE$.$scope();
                            NodeBuffer $buf11 = new NodeBuffer();
                            $buf11.$amp$plus((Object)new EntityRef("nbsp"));
                            Null$ $md11 = Null$.MODULE$;
                            $md11 = new UnprefixedAttribute("src", (Seq)new Text("/images/warningS.png"), (MetaData)$md11);
                            $md11 = new UnprefixedAttribute("align", (Seq)new Text("center"), (MetaData)$md11);
                            $buf11.$amp$plus((Object)new Elem(null, "img", (MetaData)$md11, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                            Elem elem5 = new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)topScope$11, false, (Seq)$buf11);
                            nodeSeq = elem5;
                        }
                        $buf9.$amp$plus((Object)nodeSeq);
                        $buf9.$amp$plus((Object)new Text(" "));
                        elem4 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, false, (Seq)$buf9);
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<DateTime> option4 = option3;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError(option3);
                        elem4 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                    }
                    elem = elem4;
                } else {
                    elem = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf.$amp$plus((Object)elem);
                if (ta.enabled()) {
                    NodeBuffer nodeBuffer2;
                    ProcessingStatus processingStatus = ta.status();
                    if (processingStatus instanceof Running) {
                        Running running = (Running)processingStatus;
                        String description = running.description();
                        NodeBuffer $buf12 = new NodeBuffer();
                        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf13 = new NodeBuffer();
                        $buf13.$amp$plus((Object)description);
                        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, false, (Seq)$buf13));
                        Null$ $md12 = Null$.MODULE$;
                        $md12 = new UnprefixedAttribute("style", (Seq)new Text("text-align: center;"), (MetaData)$md12);
                        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf14 = new NodeBuffer();
                        Null$ $md13 = Null$.MODULE$;
                        $md13 = new UnprefixedAttribute("src", (Seq)new Text("/images/spinner.gif"), (MetaData)$md13);
                        $buf14.$amp$plus((Object)new Elem(null, "img", (MetaData)$md13, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)topScope$13, false, (Seq)$buf14));
                        nodeBuffer2 = $buf12;
                    } else {
                        if (!(processingStatus instanceof Idle)) throw new MatchError((Object)processingStatus);
                        Idle idle = (Idle)processingStatus;
                        DateTime nextUpdate = idle.nextUpdate();
                        Option<String> errorMessage = idle.errorMessage();
                        NodeBuffer $buf15 = new NodeBuffer();
                        TopScope$ topScope$14 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf16 = new NodeBuffer();
                        Null$ $md14 = Null$.MODULE$;
                        $md14 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(nextUpdate), (MetaData)$md14);
                        $md14 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md14);
                        TopScope$ topScope$15 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf17 = new NodeBuffer();
                        $buf17.$amp$plus((Object)(ta.enabled() ? (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now, (Ordering)DateAndTime$DateTimeOrdering$.MODULE$).$less$eq((Object)nextUpdate) ? DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now, (ReadableInstant)nextUpdate), 1) : "any moment") : ""));
                        $buf16.$amp$plus((Object)new Elem(null, "span", (MetaData)$md14, (NamespaceBinding)topScope$15, false, (Seq)$buf17));
                        $buf16.$amp$plus(errorMessage.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            /*
                             * WARNING - void declaration
                             */
                            public final Elem apply(String text) {
                                void var3_3;
                                Null$ $md = Null$.MODULE$;
                                $md = new UnprefixedAttribute("data-original-title", text, (MetaData)$md);
                                $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
                                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                                NodeBuffer $buf = new NodeBuffer();
                                $buf.$amp$plus((Object)new EntityRef("nbsp"));
                                Null$ $md2 = Null$.MODULE$;
                                $md2 = new UnprefixedAttribute("src", (Seq)new Text("/images/warningS.png"), (MetaData)$md2);
                                $md2 = new UnprefixedAttribute("align", (Seq)new Text("center"), (MetaData)$md2);
                                $buf.$amp$plus((Object)new Elem(null, "img", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                                return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)var3_3);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final NodeSeq apply() {
                                return NodeSeq$.MODULE$.Empty();
                            }
                        }));
                        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$14, false, (Seq)$buf16));
                        Null$ $md15 = Null$.MODULE$;
                        $md15 = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md15);
                        TopScope$ topScope$16 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf18 = new NodeBuffer();
                        $buf18.$amp$plus((Object)new Text("\n                        "));
                        Null$ $md16 = Null$.MODULE$;
                        $md16 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md16);
                        $md16 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.$outer.tab().url()).append((Object)"/update").toString(), (MetaData)$md16);
                        $md16 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md16);
                        TopScope$ topScope$17 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf19 = new NodeBuffer();
                        $buf19.$amp$plus((Object)new Text("\n                            "));
                        Null$ $md17 = Null$.MODULE$;
                        $md17 = new UnprefixedAttribute("value", ta.locator().getCaName(), (MetaData)$md17);
                        $md17 = new UnprefixedAttribute("name", (Seq)new Text("name"), (MetaData)$md17);
                        $md17 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md17);
                        $buf19.$amp$plus((Object)new Elem(null, "input", (MetaData)$md17, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf19.$amp$plus((Object)new Text("\n                            "));
                        Null$ $md18 = Null$.MODULE$;
                        $md18 = new UnprefixedAttribute("value", (Seq)new Text("Update"), (MetaData)$md18);
                        $md18 = new UnprefixedAttribute("class", (Seq)new Text("btn span2"), (MetaData)$md18);
                        $md18 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md18);
                        $buf19.$amp$plus((Object)new Elem(null, "input", (MetaData)$md18, (NamespaceBinding)Predef$.MODULE$.$scope(), true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf19.$amp$plus((Object)new Text("\n                        "));
                        $buf18.$amp$plus((Object)new Elem(null, "form", (MetaData)$md16, (NamespaceBinding)topScope$17, false, (Seq)$buf19));
                        $buf18.$amp$plus((Object)new Text("\n                      "));
                        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)topScope$16, false, (Seq)$buf18));
                        nodeBuffer2 = $buf15;
                    }
                    nodeBuffer = nodeBuffer2;
                } else {
                    NodeBuffer $buf20 = new NodeBuffer();
                    $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                    $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                    nodeBuffer = $buf20;
                }
                $buf.$amp$plus((Object)nodeBuffer);
                $buf.$amp$plus((Object)new Text("\n          "));
                return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var2_2);
            }

            public /* synthetic */ TrustAnchorsView net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, false, (Seq)$buf13));
        $buf3.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md, (NamespaceBinding)topScope$2, false, (Seq)$buf3));
        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Comment("\n$(function () {\n  $('[rel=twipsy]').twipsy({\n    \"live\": true\n  });\n  var refresh = function() {\n    $.ajax({\n      url: \"/trust-anchors/refresh\",\n      dataType: \"html\",\n      success: function (data) {\n        var updatedTable = $(data).filter(\"#trust-anchors\");\n        $(\"#trust-anchors\").replaceWith(updatedTable);\n        $(\"div.twipsy\").fadeOut();\n      }\n    });\n  };\n  setInterval(refresh, 10000);\n});\n//"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$13, false, (Seq)$buf14));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public Elem net$ripe$rpki$validator$views$TrustAnchorsView$$renderCounters(TrustAnchor ta, Map<ValidationStatus, Object> counters) {
        void var3_3;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.badge$1("success", BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.PASSED, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        })), ta));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.badge$1("warning", BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.WARNING, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        })), ta));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.badge$1("important", BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.ERROR, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        })), ta));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public NodeSeq net$ripe$rpki$validator$views$TrustAnchorsView$$expiresIn(DateTime notValidAfter) {
        Elem elem;
        if (this.net$ripe$rpki$validator$views$TrustAnchorsView$$now.isBefore((ReadableInstant)notValidAfter)) {
            elem = Text$.MODULE$.apply(DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)this.net$ripe$rpki$validator$views$TrustAnchorsView$$now, (ReadableInstant)notValidAfter), DateAndTime$.MODULE$.periodInWords$default$2()));
        } else {
            void var2_2;
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("EXPIRED"));
            elem = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)var2_2);
        }
        return elem;
    }

    private List<TrustAnchor> sortedTrustAnchors() {
        return (List)this.trustAnchors.all().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TrustAnchor x$4) {
                return x$4.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    private final Elem badge$1(String level, int count, TrustAnchor ta$1) {
        String clazz = new StringBuilder().append((Object)"object-counter label ").append((Object)level).toString();
        String style = count > 0 ? "" : "opacity: 0.25;";
        String helpText = "Click to view monitor page";
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("data-original-title", helpText, (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("href", new StringBuilder().append((Object)Tabs$.MODULE$.TrustAnchorMonitorTab().url()).append((Object)"/").append((Object)ta$1.identifierHash()).toString(), (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", style, (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", clazz, (MetaData)$md3);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)count));
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)topScope$3, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)topScope$2, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, false, (Seq)$buf);
    }

    public TrustAnchorsView(TrustAnchors trustAnchors, Map<TrustAnchorLocator, Map<ValidationStatus, Object>> validationStatusCounts, DateTime now, Seq<Validation.FeedbackMessage> messages2) {
        this.trustAnchors = trustAnchors;
        this.net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts = validationStatusCounts;
        this.net$ripe$rpki$validator$views$TrustAnchorsView$$now = now;
        this.messages = messages2;
        ViewHelpers$class.$init$(this);
    }
}

