/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import akka.util.ByteString;
import akka.util.ByteString$;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;

public final class StoredRepositoryObject$
implements Serializable {
    public static final StoredRepositoryObject$ MODULE$;

    static {
        new StoredRepositoryObject$();
    }

    public StoredRepositoryObject apply(URI uri, byte[] binary) {
        DateTime dateTime;
        DateTime defaultTime = new DateTime(DateTimeZone.UTC).plusDays(1);
        ByteString binaryObject = ByteString$.MODULE$.apply(binary);
        ByteString hash = ByteString$.MODULE$.apply(ManifestCms.hashContents((byte[])binary));
        try {
            DateTime dateTime2;
            CertificateRepositoryObject certificateRepositoryObject = CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])binary, (ValidationResult)ValidationResult.withLocation((URI)uri));
            if (certificateRepositoryObject instanceof X509ResourceCertificate) {
                X509ResourceCertificate x509ResourceCertificate = (X509ResourceCertificate)certificateRepositoryObject;
                dateTime2 = x509ResourceCertificate.getValidityPeriod().getNotValidAfter();
            } else if (certificateRepositoryObject instanceof ManifestCms) {
                ManifestCms manifestCms = (ManifestCms)certificateRepositoryObject;
                dateTime2 = manifestCms.getNotValidAfter();
            } else if (certificateRepositoryObject instanceof RoaCms) {
                RoaCms roaCms = (RoaCms)certificateRepositoryObject;
                dateTime2 = roaCms.getValidityPeriod().getNotValidAfter();
            } else if (certificateRepositoryObject instanceof X509Crl) {
                X509Crl x509Crl = (X509Crl)certificateRepositoryObject;
                dateTime2 = x509Crl.getNextUpdateTime();
            } else {
                boolean bl = certificateRepositoryObject instanceof GhostbustersCms ? true : certificateRepositoryObject instanceof UnknownCertificateRepositoryObject;
                if (bl) {
                    dateTime2 = defaultTime;
                } else {
                    throw new MatchError((Object)certificateRepositoryObject);
                }
            }
            dateTime = dateTime2;
        }
        catch (RuntimeException runtimeException) {
            dateTime = defaultTime;
        }
        DateTime expires = dateTime;
        return new StoredRepositoryObject(hash, uri, binaryObject, expires);
    }

    public StoredRepositoryObject apply(ByteString hash, URI uri, ByteString binaryObject, DateTime expires) {
        return new StoredRepositoryObject(hash, uri, binaryObject, expires);
    }

    public Option<Tuple4<ByteString, URI, ByteString, DateTime>> unapply(StoredRepositoryObject x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.hash(), (Object)x$0.uri(), (Object)x$0.binaryObject(), (Object)x$0.expires()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StoredRepositoryObject$() {
        MODULE$ = this;
    }
}

