/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import net.ripe.ipresource.Asn;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.lib.NumberResources;
import net.ripe.rpki.validator.lib.NumberResources$NumberResourceIntervalTree$;
import net.ripe.rpki.validator.models.RouteValidity$;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$RtrPrefixReducer$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class BgpAnnouncementValidator$ {
    public static final BgpAnnouncementValidator$ MODULE$;
    private final int VISIBILITY_THRESHOLD;

    static {
        new BgpAnnouncementValidator$();
    }

    public int VISIBILITY_THRESHOLD() {
        return this.VISIBILITY_THRESHOLD;
    }

    public BgpValidatedAnnouncement validate(BgpAnnouncement announcement, Seq<RtrPrefix> prefixes) {
        return this.validate(announcement, NumberResources$NumberResourceIntervalTree$.MODULE$.apply(prefixes, RtrPrefix$RtrPrefixReducer$.MODULE$));
    }

    public BgpValidatedAnnouncement validate(BgpAnnouncement announcement, NumberResources.NumberResourceIntervalTree<RtrPrefix> prefixTree) {
        IndexedSeq<RtrPrefix> matchingPrefixes = prefixTree.findExactAndAllLessSpecific(announcement.interval());
        IndexedSeq groupedByValidity = (IndexedSeq)matchingPrefixes.map((Function1)new Serializable(announcement){
            public static final long serialVersionUID = 0L;
            private final BgpAnnouncement announcement$1;

            public final Tuple2<Enumeration.Value, RtrPrefix> apply(RtrPrefix prefix) {
                Enumeration.Value validity = BgpAnnouncementValidator$.MODULE$.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidator$$hasInvalidAsn(prefix, this.announcement$1) ? RouteValidity$.MODULE$.InvalidAsn() : (BgpAnnouncementValidator$.MODULE$.net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidator$$hasInvalidPrefixLength(prefix, this.announcement$1) ? RouteValidity$.MODULE$.InvalidLength() : RouteValidity$.MODULE$.Valid());
                return new Tuple2((Object)validity, (Object)prefix);
            }
            {
                this.announcement$1 = announcement$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new BgpValidatedAnnouncement(announcement, (Seq<Tuple2<Enumeration.Value, RtrPrefix>>)groupedByValidity);
    }

    public boolean net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidator$$hasInvalidAsn(RtrPrefix prefix, BgpAnnouncement announced) {
        Asn asn = prefix.asn();
        Asn asn2 = announced.asn();
        return asn != null ? !asn.equals(asn2) : asn2 != null;
    }

    public boolean net$ripe$rpki$validator$bgp$preview$BgpAnnouncementValidator$$hasInvalidPrefixLength(RtrPrefix prefix, BgpAnnouncement announced) {
        return BoxesRunTime.unboxToInt((Object)prefix.maxPrefixLength().getOrElse((Function0)new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final RtrPrefix prefix$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.prefix$1.prefix().getPrefixLength();
            }
            {
                this.prefix$1 = prefix$1;
            }
        })) < announced.prefix().getPrefixLength();
    }

    private BgpAnnouncementValidator$() {
        MODULE$ = this;
        this.VISIBILITY_THRESHOLD = 5;
    }
}

