/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.util.BouncyCastleUtil;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapperException;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.StoreException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class RpkiSignedObjectParser {
    private byte[] encoded;
    private X509ResourceCertificate certificate;
    protected ASN1ObjectIdentifier contentType;
    private DateTime signingTime;
    private ValidationResult validationResult;

    public final void parse(String location, byte[] encoded) {
        this.parse(ValidationResult.withLocation(location), encoded);
    }

    public void parse(ValidationResult result, byte[] encoded) {
        this.validationResult = result;
        this.encoded = encoded;
        this.parseCms();
    }

    protected byte[] getEncoded() {
        return this.encoded;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    protected X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    protected X509ResourceCertificate getResourceCertificate() {
        return this.certificate;
    }

    protected ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    protected DateTime getSigningTime() {
        return this.signingTime;
    }

    public abstract void decodeContent(ASN1Encodable var1);

    private void parseCms() {
        CMSSignedDataParser sp;
        try {
            sp = new CMSSignedDataParser(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER, this.encoded);
        }
        catch (CMSException e) {
            this.validationResult.rejectIfFalse(false, "cms.signed.data.parsing", new String[0]);
            return;
        }
        this.validationResult.rejectIfFalse(true, "cms.signed.data.parsing", new String[0]);
        if (!this.validationResult.hasFailures()) {
            this.parseContent(sp);
        }
        if (!this.validationResult.hasFailures()) {
            this.parseCmsCertificate(sp);
        }
        if (!this.validationResult.hasFailures()) {
            this.verifyCmsSigning(sp, this.certificate.getCertificate());
        }
    }

    protected void parseContent(CMSSignedDataParser sp) {
        CMSTypedStream signedContent = sp.getSignedContent();
        this.contentType = signedContent.getContentType();
        InputStream signedContentStream = signedContent.getContentStream();
        ASN1InputStream asn1InputStream = new ASN1InputStream(signedContentStream);
        try {
            this.decodeContent((ASN1Encodable)asn1InputStream.readObject());
        }
        catch (IOException e) {
            this.validationResult.rejectIfFalse(false, "cms.decode.content", new String[0]);
            return;
        }
        this.validationResult.rejectIfFalse(true, "cms.decode.content", new String[0]);
        try {
            this.validationResult.rejectIfFalse(asn1InputStream.readObject() == null, "cms.only.one.signed.object", new String[0]);
            asn1InputStream.close();
        }
        catch (IOException e) {
            this.validationResult.rejectIfFalse(false, "cms.content.parsing", new String[0]);
        }
        this.validationResult.rejectIfFalse(true, "cms.content.parsing", new String[0]);
    }

    private void parseCmsCertificate(CMSSignedDataParser sp) {
        Collection<? extends Certificate> certificates = this.extractCertificate(sp);
        if (!this.validationResult.rejectIfNull(certificates, "cms.get.certs.and.crls", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(certificates.size() == 1, "cms.only.one.ee.cert", new String[0])) {
            return;
        }
        if (!this.validationResult.rejectIfFalse(certificates.iterator().next() instanceof X509Certificate, "cms.cert.is.x509", new String[0])) {
            return;
        }
        this.certificate = this.parseCertificate(certificates.iterator().next());
        if (this.validationResult.hasFailureForCurrentLocation()) {
            return;
        }
        this.validationResult.rejectIfFalse(this.certificate.isEe(), "cms.cert.is.ee.cert", new String[0]);
        this.validationResult.rejectIfNull(this.certificate.getSubjectKeyIdentifier(), "cms.cert.has.ski", new String[0]);
    }

    private X509ResourceCertificate parseCertificate(Certificate certificate) {
        try {
            X509Certificate x509certificate = (X509Certificate)certificate;
            X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
            parser.parse(this.validationResult, x509certificate.getEncoded());
            return parser.isSuccess() ? parser.getCertificate() : null;
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException("cannot parse already decoded X509 certificate: " + e, e);
        }
    }

    private Collection<? extends Certificate> extractCertificate(CMSSignedDataParser sp) {
        try {
            return BouncyCastleUtil.extractCertificates(sp);
        }
        catch (CMSException e) {
            return null;
        }
        catch (StoreException e) {
            return null;
        }
        catch (CertificateException e) {
            return null;
        }
    }

    private void verifyCmsSigning(CMSSignedDataParser sp, X509Certificate certificate) {
        SignerInformation signer = this.extractSingleCmsSigner(sp);
        if (signer == null) {
            return;
        }
        if (!this.verifySigner(signer, certificate)) {
            return;
        }
        if (!this.verifyAndStoreSigningTime(signer)) {
            return;
        }
        this.verifySignature(certificate, signer);
    }

    private SignerInformation extractSingleCmsSigner(CMSSignedDataParser sp) {
        SignerInformationStore signerStore = this.getSignerStore(sp);
        if (!this.validationResult.rejectIfNull(signerStore, "cms.signature.signer.info", new String[0])) {
            return null;
        }
        Collection signers = signerStore.getSigners();
        if (this.validationResult.rejectIfFalse(signers.size() == 1, "cms.signature.has.one.signer", new String[0])) {
            return (SignerInformation)signers.iterator().next();
        }
        return null;
    }

    private SignerInformationStore getSignerStore(CMSSignedDataParser sp) {
        try {
            return sp.getSignerInfos();
        }
        catch (CMSException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private boolean isAllowedSignedAttribute(Attribute signedAttribute) {
        ASN1ObjectIdentifier binarySigningTimeOID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.46");
        ASN1ObjectIdentifier attributeOID = signedAttribute.getAttrType();
        return binarySigningTimeOID.equals((Object)attributeOID) || CMSAttributes.signingTime.equals((Object)attributeOID) || CMSAttributes.contentType.equals((Object)attributeOID) || CMSAttributes.messageDigest.equals((Object)attributeOID);
    }

    private boolean verifyOptionalSignedAttributes(SignerInformation signer) {
        ASN1EncodableVector signedAttributes = signer.getSignedAttributes().toASN1EncodableVector();
        boolean allAttributesCorrect = true;
        for (int i = 0; i < signedAttributes.size(); ++i) {
            ASN1Encodable signedAttribute = signedAttributes.get(i);
            if (this.isAllowedSignedAttribute((Attribute)signedAttribute)) continue;
            allAttributesCorrect = false;
            break;
        }
        if (allAttributesCorrect) {
            this.validationResult.pass("cms.signed.attrs.correct", new String[0]);
        } else {
            this.validationResult.warn("cms.signed.attrs.correct", new String[0]);
        }
        return allAttributesCorrect;
    }

    private boolean verifySigner(SignerInformation signer, X509Certificate certificate) {
        this.validationResult.rejectIfFalse(RpkiSignedObject.DIGEST_ALGORITHM_OID.equals(signer.getDigestAlgOID()), "cms.signer.info.digest.algorithm", new String[0]);
        this.validationResult.rejectIfFalse(RpkiSignedObject.RSA_ENCRYPTION_OID.equals(signer.getEncryptionAlgOID()) || RpkiSignedObject.SHA256WITHRSA_ENCRYPTION_OID.equals(signer.getEncryptionAlgOID()), "cms.encryption.algorithm", new String[0]);
        if (!this.validationResult.rejectIfNull(signer.getSignedAttributes(), "cms.signed.attrs.present", new String[0])) {
            return false;
        }
        this.validationResult.rejectIfNull(signer.getSignedAttributes().get(CMSAttributes.contentType), "cms.content.type.attr.present", new String[0]);
        this.validationResult.rejectIfNull(signer.getSignedAttributes().get(CMSAttributes.messageDigest), "cms.msg.digest.attr.present", new String[0]);
        this.verifyOptionalSignedAttributes(signer);
        SignerId signerId = signer.getSID();
        try {
            this.validationResult.rejectIfFalse(signerId.match((Object)new JcaX509CertificateHolder(certificate)), "cms.signer.id.match.cert", new String[0]);
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
        return true;
    }

    private boolean verifyAndStoreSigningTime(SignerInformation signer) {
        Attribute signingTimeAttibute = signer.getSignedAttributes().get(CMSAttributes.signingTime);
        if (!this.validationResult.rejectIfNull(signingTimeAttibute, "cms.signing.time.attr.present", new String[0])) {
            return false;
        }
        if (!this.validationResult.rejectIfFalse(signingTimeAttibute.getAttrValues().size() == 1, "cms.only.one.signing.time.attr", new String[0])) {
            return false;
        }
        Time signingTimeDate = Time.getInstance((Object)signingTimeAttibute.getAttrValues().getObjectAt(0));
        this.signingTime = new DateTime(signingTimeDate.getDate().getTime(), DateTimeZone.UTC);
        return true;
    }

    private void verifySignature(X509Certificate certificate, SignerInformation signer) {
        String errorMessage = null;
        try {
            this.validationResult.rejectIfFalse(signer.verify(new JcaSignerInfoVerifierBuilder(BouncyCastleUtil.DIGEST_CALCULATOR_PROVIDER).build(certificate.getPublicKey())), "cms.signature", new String[0]);
        }
        catch (OperatorCreationException e) {
            errorMessage = String.valueOf(e.getMessage());
        }
        catch (CMSException e) {
            errorMessage = String.valueOf(e.getMessage());
        }
        if (errorMessage != null) {
            this.validationResult.rejectIfFalse(false, "cms.signature", errorMessage);
        }
    }
}

