/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.cli.CommandLineOptions;
import net.ripe.rpki.validator.runtimeproblems.ValidatorIOException;
import net.ripe.rpki.validator.util.CertificateRepositoryObjectLocalFileHelper;
import net.ripe.rpki.validator.util.TrustAnchorExtractorException;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustAnchorExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustAnchorExtractor.class);
    private final Rsync rsync;

    public TrustAnchorExtractor() {
        this(new Rsync());
    }

    public TrustAnchorExtractor(Rsync rsync) {
        this.rsync = rsync;
    }

    public List<CertificateRepositoryObjectValidationContext> extractTAS(CommandLineOptions options) {
        return this.extractTAS(options.getTrustAnchorFiles(), options.getOutputDir().getAbsolutePath());
    }

    public List<CertificateRepositoryObjectValidationContext> extractTAS(List<TrustAnchorLocator> list, String rootCertificateOutputDir) {
        ArrayList<CertificateRepositoryObjectValidationContext> tas = new ArrayList<CertificateRepositoryObjectValidationContext>();
        for (TrustAnchorLocator tal : list) {
            tas.add(this.extractTA(tal, rootCertificateOutputDir));
        }
        return tas;
    }

    public CertificateRepositoryObjectValidationContext extractTA(TrustAnchorLocator tal, String rootCertificateOutputDir) {
        X509ResourceCertificate cert = this.getRemoteCertificate(tal, rootCertificateOutputDir);
        this.verifyTrustAnchor(tal, cert);
        return new CertificateRepositoryObjectValidationContext(tal.getFetchedCertificateUri(), cert);
    }

    private void verifyTrustAnchor(TrustAnchorLocator tal, X509ResourceCertificate resourceCertificate) {
        String encodedSubjectPublicKeyInfo;
        try {
            encodedSubjectPublicKeyInfo = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)resourceCertificate.getCertificate());
        }
        catch (Exception e) {
            throw new TrustAnchorExtractorException("Problem parsing remote Trust Anchor certificate", e);
        }
        if (!encodedSubjectPublicKeyInfo.equals(tal.getPublicKeyInfo())) {
            throw new TrustAnchorExtractorException("Remote Trust Anchor does not match public key mentioned in TAL");
        }
    }

    private X509ResourceCertificate getRemoteCertificate(TrustAnchorLocator tal, String rootCertificateOutputDir) {
        Preconditions.checkArgument((!tal.getCertificateLocations().isEmpty() ? 1 : 0) != 0, (Object)("TAL without a certificate location: " + tal.getCaName()));
        Path targetDirectory = Paths.get(rootCertificateOutputDir, new String[0]);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File dest = targetDirectory.resolve(tal.getFile().getName() + ".cer").toFile();
        URI uri = this.fetchRootCertificate(tal.getCertificateLocations(), dest);
        tal.setFetchedCertificateUri(uri);
        return CertificateRepositoryObjectLocalFileHelper.readCertificate(dest);
    }

    private URI fetchRootCertificate(Iterable<URI> certificateLocations, File dest) {
        URI certUri;
        int exitStatus = -1;
        Iterator<URI> certificateLocationsIterator = certificateLocations.iterator();
        do {
            if ("rsync".equalsIgnoreCase((certUri = certificateLocationsIterator.next()).getScheme())) {
                this.rsync.reset();
                this.rsync.setSource(certUri.toString());
                this.rsync.setDestination(dest.toString());
                exitStatus = this.rsync.execute();
                continue;
            }
            LOGGER.info("Only rsync protocol is supported for TA certificate fetch. Skipping " + certUri.toString());
        } while (exitStatus != 0 && certificateLocationsIterator.hasNext());
        if (exitStatus != 0) {
            throw new ValidatorIOException("Failed to retrieve TA certificate from all locations:" + Joiner.on((String)", ").join(certificateLocations));
        }
        return certUri;
    }
}

