/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.runtimeproblems.ValidatorIOException;

public final class CertificateRepositoryObjectLocalFileHelper {
    private CertificateRepositoryObjectLocalFileHelper() {
    }

    public static X509ResourceCertificate readCertificate(File certificate) {
        return (X509ResourceCertificate)CertificateRepositoryObjectLocalFileHelper.readCertificateRepositoryObject(certificate);
    }

    public static CertificateRepositoryObject readCertificateRepositoryObject(File file) {
        byte[] contents;
        try {
            contents = Files.toByteArray((File)file);
        }
        catch (IOException e) {
            throw new ValidatorIOException("Can't read file: " + file.getAbsolutePath(), e);
        }
        return CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])contents, (ValidationResult)ValidationResult.withLocation((String)file.getName()));
    }
}

