/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.output;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatedObjectWriter
implements NotifyingCertificateRepositoryObjectFetcher.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatedObjectWriter.class);
    private UriToFileMapper uriToFileMapper;

    public ValidatedObjectWriter(UriToFileMapper uriToFileMapper) {
        this.uriToFileMapper = uriToFileMapper;
    }

    @Override
    public void afterFetchFailure(URI uri, ValidationResult result) {
    }

    @Override
    public void afterFetchSuccess(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        File destinationFile = this.uriToFileMapper.map(uri, result);
        Validate.notNull((Object)destinationFile, (String)"uri could not be mapped to file");
        try {
            if (destinationFile.exists()) {
                LOG.error("destination file '" + destinationFile.getAbsolutePath() + "' already exists, validated object not stored");
            } else {
                FileUtils.writeByteArrayToFile((File)destinationFile, (byte[])object.getEncoded());
            }
        }
        catch (IOException e) {
            LOG.error("error writing validated object to file '" + destinationFile.getAbsolutePath() + "'");
        }
    }

    @Override
    public void afterPrefetchFailure(URI uri, ValidationResult result) {
    }

    @Override
    public void afterPrefetchSuccess(URI uri, ValidationResult result) {
    }
}

