/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.output;

import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationMessage;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFetcherResultLogger
implements NotifyingCertificateRepositoryObjectFetcher.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFetcherResultLogger.class);
    private boolean logValidObjects;

    public ObjectFetcherResultLogger() {
        this.logValidObjects = true;
    }

    public ObjectFetcherResultLogger(boolean logValidObjects) {
        this.logValidObjects = logValidObjects;
    }

    @Override
    public void afterFetchFailure(URI uri, ValidationResult result) {
        this.logResults(uri, result);
        LOG.info(uri + " is INVALID");
    }

    @Override
    public void afterFetchSuccess(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        this.logResults(uri, result);
        if (this.logValidObjects) {
            LOG.info(uri + " is VALID");
        }
    }

    @Override
    public void afterPrefetchFailure(URI uri, ValidationResult result) {
        this.logResults(uri, result);
        LOG.warn("failed to prefetch " + uri);
    }

    @Override
    public void afterPrefetchSuccess(URI uri, ValidationResult result) {
        this.logResults(uri, result);
    }

    protected void logResults(URI uri, ValidationResult result) {
        for (ValidationCheck check : result.getAllValidationChecksForLocation(new ValidationLocation(uri))) {
            String message = uri + ": " + ValidationMessage.getMessage((ValidationCheck)check);
            if (check.isOk()) {
                if (!this.logValidObjects) continue;
                LOG.debug(check.getStatus() + "->" + message);
                continue;
            }
            LOG.error(check.getStatus() + "->" + message);
        }
    }
}

