/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import org.apache.commons.lang.Validate;

public class NotifyingCertificateRepositoryObjectFetcher
implements CertificateRepositoryObjectFetcher {
    private final CertificateRepositoryObjectFetcher fetcher;
    private final List<Listener> callbacks;

    public NotifyingCertificateRepositoryObjectFetcher(CertificateRepositoryObjectFetcher fetcher) {
        Validate.notNull((Object)fetcher);
        this.fetcher = fetcher;
        this.callbacks = new ArrayList<Listener>();
    }

    public void addCallback(Listener callback) {
        Validate.notNull((Object)callback);
        this.callbacks.add(callback);
    }

    public X509Crl getCrl(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        X509Crl crl = this.fetcher.getCrl(uri, context, result);
        this.notifyAfterFetch(uri, (CertificateRepositoryObject)crl, result);
        return crl;
    }

    @Override
    public ManifestCms getManifest(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        ManifestCms manifest = this.fetcher.getManifest(uri, context, result);
        this.notifyAfterFetch(uri, (CertificateRepositoryObject)manifest, result);
        return manifest;
    }

    @Override
    public CertificateRepositoryObject getObject(URI uri, CertificateRepositoryObjectValidationContext context, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        CertificateRepositoryObject object = this.fetcher.getObject(uri, context, fileContentSpecification, result);
        this.notifyAfterFetch(uri, object, result);
        return object;
    }

    @Override
    public void prefetch(URI uri, ValidationResult result) {
        this.fetcher.prefetch(uri, result);
        if (result.hasFailureForCurrentLocation()) {
            for (Listener callback : this.callbacks) {
                callback.afterPrefetchFailure(uri, result);
            }
        } else {
            for (Listener callback : this.callbacks) {
                callback.afterPrefetchSuccess(uri, result);
            }
        }
    }

    private void notifyAfterFetch(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        if (result.hasFailureForCurrentLocation()) {
            for (Listener callback : this.callbacks) {
                callback.afterFetchFailure(uri, result);
            }
        } else {
            for (Listener callback : this.callbacks) {
                callback.afterFetchSuccess(uri, object, result);
            }
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void afterPrefetchFailure(URI uri, ValidationResult result) {
        }

        @Override
        public void afterPrefetchSuccess(URI uri, ValidationResult result) {
        }

        @Override
        public void afterFetchFailure(URI uri, ValidationResult result) {
        }

        @Override
        public void afterFetchSuccess(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        }
    }

    public static interface Listener {
        public void afterPrefetchFailure(URI var1, ValidationResult var2);

        public void afterPrefetchSuccess(URI var1, ValidationResult var2);

        public void afterFetchFailure(URI var1, ValidationResult var2);

        public void afterFetchSuccess(URI var1, CertificateRepositoryObject var2, ValidationResult var3);
    }
}

