/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.cli;

import ch.qos.logback.classic.Level;
import net.ripe.rpki.validator.cli.CommandLineOptions;
import net.ripe.rpki.validator.commands.BottomUpValidationCommand;
import net.ripe.rpki.validator.commands.PrintCertificateRepositoryObjectCommand;
import net.ripe.rpki.validator.commands.PrintVersionCommand;
import net.ripe.rpki.validator.commands.TopDownValidationCommand;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static Logger logger = LoggerFactory.getLogger(Main.class);
    private CommandLineOptions options;

    private Main() {
    }

    public static void main(String[] args) {
        try {
            new Main().run(args);
            System.exit(0);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private void run(String[] args) {
        this.parseOptions(args);
        this.execute();
    }

    private void execute() {
        if (this.options.isPrintVersionMode()) {
            new PrintVersionCommand().execute();
        } else if (this.options.isPrintHelpMode()) {
            this.options.printHelp();
        } else if (this.options.isPrintObjectMode()) {
            new PrintCertificateRepositoryObjectCommand(this.options).execute();
        } else if (this.options.isValidationMode()) {
            this.setVerbosity();
            if (this.options.isTopDownValidationEnabled()) {
                new TopDownValidationCommand(this.options).execute();
            } else {
                new BottomUpValidationCommand(this.options).execute();
            }
        }
    }

    private void parseOptions(String[] args) {
        this.options = new CommandLineOptions();
        try {
            this.options.parse(args);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            System.exit(1);
        }
    }

    private void setVerbosity() {
        Logger rootLogger;
        if (this.options.isVerboseEnabled() && (rootLogger = LoggerFactory.getLogger((String)"ROOT")) instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)rootLogger;
            logbackLogger.setLevel(Level.DEBUG);
        }
    }
}

