/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import com.google.common.collect.Lists;
import grizzled.slf4j.Logger;
import java.net.URI;
import java.security.cert.X509Certificate;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.lib.Structures$;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.TopDownWalker;
import net.ripe.rpki.validator.models.TopDownWalker$;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObject$;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.TrustAnchorValidationProcess$;
import net.ripe.rpki.validator.models.validation.ValidationProcess;
import net.ripe.rpki.validator.models.validation.ValidationProcess$class;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001=\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AB7pI\u0016d7O\u0003\u0002\b\u0011\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u0013)\tAA\u001d9lS*\u00111\u0002D\u0001\u0005e&\u0004XMC\u0001\u000e\u0003\rqW\r^\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!\u0005,bY&$\u0017\r^5p]B\u0013xnY3tg\"A1\u0004\u0001BC\u0002\u0013\u0005C$\u0001\nueV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014X#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011\u0001B;uS2L!AI\u0010\u0003%Q\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0005\tI\u0001\u0011\t\u0011)A\u0005;\u0005\u0019BO];ti\u0006s7\r[8s\u0019>\u001c\u0017\r^8sA!Aa\u0005\u0001B\u0001B\u0003%q%A\u0003ti>\u0014X\r\u0005\u0002)U5\t\u0011F\u0003\u0002'\r%\u00111&\u000b\u0002\u000b\u0007\u0006\u001c\u0007.Z*u_J,\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u0017I,\u0007o\\*feZL7-\u001a\t\u0003_Aj\u0011\u0001B\u0005\u0003c\u0011\u00111BU3q_N+'O^5dK\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0007nCb\u001cF/\u00197f\t\u0006L8\u000f\u0005\u0002\u0012k%\u0011aG\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\rQ\fg*Y7f!\tQTH\u0004\u0002\u0012w%\u0011AHE\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=%!A\u0011\t\u0001B\u0001B\u0003%!)A\u000bf]\u0006\u0014G.\u001a'p_N,g+\u00197jI\u0006$\u0018n\u001c8\u0011\u0005E\u0019\u0015B\u0001#\u0013\u0005\u001d\u0011un\u001c7fC:DQA\u0012\u0001\u0005\u0002\u001d\u000ba\u0001P5oSRtDc\u0002%J\u0015.cUJ\u0014\t\u0003/\u0001AQaG#A\u0002uAQAJ#A\u0002\u001dBQ!L#A\u00029BQaM#A\u0002QBQ\u0001O#A\u0002eBq!Q#\u0011\u0002\u0003\u0007!\tC\u0004Q\u0001\t\u0007I\u0011B)\u0002#Y\fG.\u001b3bi&|gn\u00149uS>t7/F\u0001S!\t\u0019v+D\u0001U\u0015\t\u0019QK\u0003\u0002W\u0011\u000591m\\7n_:\u001c\u0018B\u0001-U\u0005E1\u0016\r\\5eCRLwN\\(qi&|gn\u001d\u0005\u00075\u0002\u0001\u000b\u0011\u0002*\u0002%Y\fG.\u001b3bi&|gn\u00149uS>t7\u000f\t\u0005\u00069\u0002!\t%X\u0001\u001aKb$(/Y2u)J,8\u000f^!oG\"|'\u000fT8dCR|'\u000fF\u0002_C\u000e\u0004\"aL0\n\u0005\u0001$!a\u0004,bY&$\u0017\r^3e\u001f\nTWm\u0019;\t\u000b\t\\\u0006\u0019\u0001\"\u0002\u001b\u0019|'oY3OK^4U\r^2i\u0011\u0015!7\f1\u0001f\u0003=1\u0018\r\\5eCRLwN\\*uCJ$\bC\u00014n\u001b\u00059'B\u00015j\u0003\u0011!\u0018.\\3\u000b\u0005)\\\u0017\u0001\u00026pI\u0006T\u0011\u0001\\\u0001\u0004_J<\u0017B\u00018h\u0005\u001dIen\u001d;b]RDQ\u0001\u001d\u0001\u0005BE\fqB^1mS\u0012\fG/Z(cU\u0016\u001cGo\u001d\u000b\u0007ez\fi!a\u0004\u0011\u0007M\\hL\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011qOD\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\u001f\n\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\u0004'\u0016\f(B\u0001>\u0013\u0011\u0019yx\u000e1\u0001\u0002\u0002\u0005Y1-\u001a:uS\u001aL7-\u0019;f!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004)\u0006\u0001rN\u00196fGR4\u0018\r\\5eCR|'o]\u0005\u0005\u0003\u0017\t)A\u0001\u0017DKJ$\u0018NZ5dCR,'+\u001a9pg&$xN]=PE*,7\r\u001e,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\")!m\u001ca\u0001\u0005\"1\u0011\u0011C8A\u0002\u0015\f\u0011b\u001d;beR$\u0016.\\3\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u0005q1.Z=J]\u001a|W*\u0019;dQ\u0016\u001cHc\u0001\"\u0002\u001a!9q0a\u0005A\u0002\u0005m\u0001cA\f\u0002\u001e%\u0019\u0011q\u0004\u0002\u0003#\r+'\u000f^5gS\u000e\fG/Z(cU\u0016\u001cGoB\u0005\u0002$\t\t\t\u0011#\u0001\u0002&\u0005aBK];ti\u0006s7\r[8s-\u0006d\u0017\u000eZ1uS>t\u0007K]8dKN\u001c\bcA\f\u0002(\u0019A\u0011AAA\u0001\u0012\u0003\tIcE\u0002\u0002(AAqARA\u0014\t\u0003\ti\u0003\u0006\u0002\u0002&!Q\u0011\u0011GA\u0014#\u0003%\t!a\r\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t)DK\u0002C\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\u0012\u0012AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    public final CacheStore net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store;
    public final RepoService net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$repoService;
    private final ValidationOptions validationOptions;
    private final Logger logger;

    public static boolean $lessinit$greater$default$6() {
        return TrustAnchorValidationProcess$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$validation$ValidationProcess$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Validation<String, Seq<ValidatedObject>> runProcess(boolean forceNewFetch) {
        return ValidationProcess$class.runProcess(this, forceNewFetch);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions validationOptions() {
        return this.validationOptions;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator(boolean forceNewFetch, Instant validationStart) {
        Product product;
        ValidationResult validationResult;
        Buffer fetchErrors = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq certificateLocations = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getCertificateLocations()).asScala();
        URI taCertUri = (URI)certificateLocations.find((Function1)new Serializable(this, validationStart, fetchErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;
            private final Instant validationStart$1;
            private final Buffer fetchErrors$1;

            public final boolean apply(URI uri) {
                Seq<Fetcher.Error> errors = this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$repoService.visitTrustAnchorCertificate(uri, true, this.validationStart$1);
                this.fetchErrors$1.appendAll(errors);
                return errors.isEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.validationStart$1 = validationStart$1;
                this.fetchErrors$1 = fetchErrors$1;
            }
        }).getOrElse((Function0)new Serializable(this, certificateLocations){
            public static final long serialVersionUID = 0L;
            private final Seq certificateLocations$1;

            public final URI apply() {
                return (URI)this.certificateLocations$1.head();
            }
            {
                this.certificateLocations$1 = certificateLocations$1;
            }
        });
        this.trustAnchorLocator().setFetchedCertificateUri(taCertUri);
        ValidationResult validationResult2 = ValidationResult.withLocation((URI)taCertUri);
        Buffer fetchErrorChecks = (Buffer)fetchErrors.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidationCheck apply(Fetcher.Error e) {
                return new ValidationCheck(ValidationStatus.FETCH_ERROR, "validator.repository.object.not.found", new String[]{e.url().toString(), e.message()});
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<CertificateObject> certificates = this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store.getCertificates(taCertUri.toString());
        Object object = certificates.size() > 1 ? validationResult2.warnForLocation(new ValidationLocation(taCertUri), "validator.repository.trust.anchor.certificate.uri.not.unique", new String[]{taCertUri.toString()}) : BoxedUnit.UNIT;
        Seq matchingCertificates = (Seq)certificates.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;

            public final boolean apply(CertificateObject certificate) {
                return this.$outer.keyInfoMatches(certificate);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (matchingCertificates.size() == 1) {
            validationResult2.rejectIfFalse(this.keyInfoMatches((CertificateObject)matchingCertificates.head()), "trust.anchor.public.key.match", new String[0]);
            this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store.updateValidationTimestamp((Iterable<byte[]>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{((RepositoryObject)matchingCertificates.head()).hash()}))), validationStart);
            validationResult = BoxedUnit.UNIT;
        } else {
            validationResult = matchingCertificates.size() > 1 ? validationResult2.rejectForLocation(new ValidationLocation(taCertUri), "validator.repository.trust.anchor.certificate.not.unique", new String[]{taCertUri.toString()}) : validationResult2.rejectForLocation(new ValidationLocation(taCertUri), "validator.repository.object.not.in.cache", new String[]{taCertUri.toString(), "n/a"});
        }
        if (validationResult2.hasFailureForCurrentLocation()) {
            product = ValidatedObject$.MODULE$.invalid((Option<Tuple2<String, RepositoryObject<? extends CertificateRepositoryObject>>>)None$.MODULE$, Lists.newArrayList((Object[])new String[]{"No trust anchor certificate"}), taCertUri, (Option<byte[]>)None$.MODULE$, (Set<ValidationCheck>)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult2.getAllValidationChecksForCurrentLocation()).asScala()).$plus$plus((GenTraversableOnce)fetchErrorChecks).toSet());
        } else {
            CertificateObject taCertificate = (CertificateObject)matchingCertificates.head();
            product = ValidatedObject$.MODULE$.valid((Option<Tuple2<String, RepositoryObject<? extends CertificateRepositoryObject>>>)new Some((Object)new Tuple2((Object)"cert", (Object)taCertificate)), Lists.newArrayList((Object[])new String[]{taCertificate.decoded().getSubject().getName()}), taCertUri, (Option<byte[]>)new Some((Object)taCertificate.hash()), (Set<ValidationCheck>)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult2.getAllValidationChecksForCurrentLocation()).asScala()).$plus$plus((GenTraversableOnce)fetchErrorChecks).toSet(), (CertificateRepositoryObject)taCertificate.decoded());
        }
        return product;
    }

    @Override
    public Seq<ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant startTime) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this, forceNewFetch, startTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;
            private final boolean forceNewFetch$1;
            private final Instant startTime$1;

            public final Seq<Fetcher.Error> apply(URI uri) {
                return this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$repoService.visitRepo(this.forceNewFetch$1, this.startTime$1, uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.forceNewFetch$1 = forceNewFetch$1;
                this.startTime$1 = startTime$1;
            }
        });
        TopDownWalker walker = TopDownWalker$.MODULE$.create(certificate, this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store, this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$repoService, this.validationOptions(), startTime, ApplicationOptions$.MODULE$.preferRrdp());
        return (Seq)Structures$.MODULE$.block(new Serializable(this, forceNewFetch, walker){
            public static final long serialVersionUID = 0L;
            private final boolean forceNewFetch$1;
            private final TopDownWalker walker$1;

            public final Seq<ValidatedObject> apply() {
                return this.walker$1.execute(this.forceNewFetch$1);
            }
            {
                this.forceNewFetch$1 = forceNewFetch$1;
                this.walker$1 = walker$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(this, startTime){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;
            private final Instant startTime$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store.clearObjects(this.startTime$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startTime$1 = startTime$1;
            }
        });
    }

    public boolean keyInfoMatches(CertificateObject certificate) {
        String string = this.trustAnchorLocator().getPublicKeyInfo();
        String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.decoded().getCertificate());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, CacheStore store, RepoService repoService, int maxStaleDays, String taName, boolean enableLooseValidation2) {
        this.trustAnchorLocator = trustAnchorLocator;
        this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$store = store;
        this.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcess$$repoService = repoService;
        ValidationProcess$class.$init$(this);
        this.validationOptions = new ValidationOptions();
        this.validationOptions().setMaxStaleDays(maxStaleDays);
        this.validationOptions().setLooseValidationEnabled(enableLooseValidation2);
    }
}

