/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.net.URI;
import javax.sql.DataSource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.fetchers.FetcherListener;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CertificateObject$;
import net.ripe.rpki.validator.models.validation.Fetchers;
import net.ripe.rpki.validator.models.validation.Hashing;
import net.ripe.rpki.validator.models.validation.RepoFetcher;
import net.ripe.rpki.validator.models.validation.RepoFetcherTest$$anonfun$2$;
import net.ripe.rpki.validator.models.validation.RepoFetcherTest$$anonfun$3$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.HttpFetcherStore;
import net.ripe.rpki.validator.store.Storage;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001f\ty!+\u001a9p\r\u0016$8\r[3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AB7pI\u0016d7O\u0003\u0002\b\u0011\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u0013)\tAA\u001d9lS*\u00111\u0002D\u0001\u0005e&\u0004XMC\u0001\u000e\u0003\rqW\r^\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0019\tqa];qa>\u0014H/\u0003\u0002\u0016%\t\tb+\u00197jI\u0006$xN\u001d+fgR\u001c\u0015m]3\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012\u0001B7pG.T!a\u0007\u000f\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u000f\u0002\u0007=\u0014x-\u0003\u0002 1\taQj\\2lSR|7+^4be\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011A\u0001\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003\u001d\u0019Ho\u001c:bO\u0016,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0019\tQa\u001d;pe\u0016L!!\f\u0016\u0003\u0015\r\u000b7\r[3Ti>\u0014X\r\u0003\u00040\u0001\u0001\u0006I\u0001K\u0001\tgR|'/Y4fA!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0014\u0001\u0004:fg>,(oY3TKR\fT#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005YR\u0011AC5qe\u0016\u001cx.\u001e:dK&\u0011\u0001(\u000e\u0002\u000e\u0013B\u0014Vm]8ve\u000e,7+\u001a;\t\ri\u0002\u0001\u0015!\u00034\u00035\u0011Xm]8ve\u000e,7+\u001a;2A!9A\b\u0001b\u0001\n\u0003\u0011\u0014\u0001\u0004:fg>,(oY3TKR\u0014\u0004B\u0002 \u0001A\u0003%1'A\u0007sKN|WO]2f'\u0016$(\u0007\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0003A!Xm\u001d;DKJ$\u0018NZ5dCR,\u0017'F\u0001C!\t\u0019%*D\u0001E\u0015\t)e)\u0001\u0005ykAJ4-\u001a:u\u0015\t9\u0005*\u0001\u0004def\u0004Ho\u001c\u0006\u0003\u0013\"\tqaY8n[>t7/\u0003\u0002L\t\n9\u0002,\u000e\u0019:%\u0016\u001cx.\u001e:dK\u000e+'\u000f^5gS\u000e\fG/\u001a\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\"\u0002#Q,7\u000f^\"feRLg-[2bi\u0016\f\u0004\u0005C\u0004P\u0001\t\u0007I\u0011A!\u0002!Q,7\u000f^\"feRLg-[2bi\u0016\u0014\u0004BB)\u0001A\u0003%!)A\tuKN$8)\u001a:uS\u001aL7-\u0019;fe\u0001BQa\u0015\u0001\u0005\u0002Q\u000b1#\u001b8NK6|'/\u001f*fa>4U\r^2iKJ$\"!\u0016-\u0011\u0005\u00112\u0016BA,\u0003\u0005-\u0011V\r]8GKR\u001c\u0007.\u001a:\t\u000be\u0013\u0006\u0019\u0001.\u0002\r\r|gNZ5h!\tYf,D\u0001]\u0015\tif!\u0001\u0005gKR\u001c\u0007.\u001a:t\u0013\tyFLA\u0007GKR\u001c\u0007.\u001a:D_:4\u0017n\u001a\u0015\u0005\u0001\u0005L'\u000e\u0005\u0002cO6\t1M\u0003\u0002eK\u00061!/\u001e8oKJT!A\u001a\u000f\u0002\u000b),h.\u001b;\n\u0005!\u001c'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002WB\u0011AN\\\u0007\u0002[*\u0011aMG\u0005\u0003_6\u00141BS+oSR\u0014VO\u001c8fe\u0002")
public class RepoFetcherTest
extends ValidatorTestCase
implements MockitoSugar {
    private final CacheStore storage;
    private final IpResourceSet resourceSet1;
    private final IpResourceSet resourceSet2;
    private final X509ResourceCertificate testCertificate1;
    private final X509ResourceCertificate testCertificate2;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public CacheStore storage() {
        return this.storage;
    }

    public IpResourceSet resourceSet1() {
        return this.resourceSet1;
    }

    public IpResourceSet resourceSet2() {
        return this.resourceSet2;
    }

    public X509ResourceCertificate testCertificate1() {
        return this.testCertificate1;
    }

    public X509ResourceCertificate testCertificate2() {
        return this.testCertificate2;
    }

    public RepoFetcher inMemoryRepoFetcher(FetcherConfig config) {
        DriverManagerDataSource dataSource = DataSources$.MODULE$.InMemoryDataSource();
        return new RepoFetcher((Storage)new CacheStore((DataSource)dataSource), new Fetchers(new HttpFetcherStore(), config));
    }

    public RepoFetcherTest() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.storage = new CacheStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.resourceSet1 = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
        this.resourceSet2 = IpResourceSet.parse((String)"192.169.0.0/16");
        this.testCertificate1 = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate((IpResourceSet)this.resourceSet1());
        this.testCertificate2 = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate((IpResourceSet)this.resourceSet2());
        this.test("Should create different directories for different repo URLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RepoFetcher fetcher = this.$outer.inMemoryRepoFetcher(new FetcherConfig(ApplicationOptions$.MODULE$.rsyncDirLocation()));
                fetcher.fetchRepo(new URI("rsync://repo1/x/z"));
                fetcher.fetchRepo(new URI("rsync://repo2/y"));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new File(new StringBuilder().append((Object)ApplicationOptions$.MODULE$.rsyncDirLocation()).append((Object)"/repo1/x").toString()).exists())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new File(new StringBuilder().append((Object)ApplicationOptions$.MODULE$.rsyncDirLocation()).append((Object)"/repo2/y").toString()).exists())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should add a new trust anchor certificate in the repo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverManagerDataSource dataSource = DataSources$.MODULE$.InMemoryDataSource();
                Fetchers fetchersMock = (Fetchers)this.$outer.mock(ManifestFactory$.MODULE$.classType(Fetchers.class));
                RepoFetcher fetcher = new RepoFetcher((Storage)new CacheStore((DataSource)dataSource), fetchersMock);
                String oldUrl = "rsync://repo2/oldCert.cert";
                CertificateObject oldCertificate = new CertificateObject(oldUrl, this.$outer.testCertificate1(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.storage().storeCertificate(oldCertificate);
                String newUrl = "rsync://repo2/cert.cert";
                URI uri = new URI(newUrl);
                CertificateObject newCert = new CertificateObject(newUrl, this.$outer.testCertificate2(), CertificateObject$.MODULE$.$lessinit$greater$default$3());
                Fetcher mockFetcher = new Fetcher(this, newCert){
                    private final CertificateObject newCert$1;
                    private final Logger grizzled$slf4j$Logging$$_logger;
                    private volatile boolean bitmap$0;

                    public Either<Fetcher.Error, BoxedUnit> processObject(URI uri, byte[] bytes, FetcherListener fetcherListener) {
                        return Fetcher.class.processObject((Fetcher)this, (URI)uri, (byte[])bytes, (FetcherListener)fetcherListener);
                    }

                    public Function2<URI, String, Fetcher.ConnectionError> connectionE() {
                        return Fetcher.class.connectionE((Fetcher)this);
                    }

                    public Function2<URI, String, Fetcher.ProcessingError> processingE() {
                        return Fetcher.class.processingE((Fetcher)this);
                    }

                    public Function2<URI, String, Fetcher.ParseError> parseE() {
                        return Fetcher.class.parseE((Fetcher)this);
                    }

                    public <R> Product tryTo(URI uri, Function2<URI, String, Fetcher.Error> err, Function0<R> f) {
                        return Fetcher.class.tryTo((Fetcher)this, (URI)uri, err, f);
                    }

                    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
                        $anonfun$2$$anon$1 var1_1 = this;
                        synchronized (var1_1) {
                            if (!this.bitmap$0) {
                                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                                this.bitmap$0 = true;
                            }
                            return this.grizzled$slf4j$Logging$$_logger;
                        }
                    }

                    public Logger grizzled$slf4j$Logging$$_logger() {
                        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
                    }

                    public Logger logger() {
                        return Logging.class.logger((Logging)this);
                    }

                    public String loggerName() {
                        return Logging.class.loggerName((Logging)this);
                    }

                    public boolean isTraceEnabled() {
                        return Logging.class.isTraceEnabled((Logging)this);
                    }

                    public void trace(Function0<Object> msg) {
                        Logging.class.trace((Logging)this, msg);
                    }

                    public void trace(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.trace((Logging)this, msg, t);
                    }

                    public boolean isDebugEnabled() {
                        return Logging.class.isDebugEnabled((Logging)this);
                    }

                    public void debug(Function0<Object> msg) {
                        Logging.class.debug((Logging)this, msg);
                    }

                    public void debug(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.debug((Logging)this, msg, t);
                    }

                    public boolean isErrorEnabled() {
                        return Logging.class.isErrorEnabled((Logging)this);
                    }

                    public void error(Function0<Object> msg) {
                        Logging.class.error((Logging)this, msg);
                    }

                    public void error(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.error((Logging)this, msg, t);
                    }

                    public boolean isInfoEnabled() {
                        return Logging.class.isInfoEnabled((Logging)this);
                    }

                    public void info(Function0<Object> msg) {
                        Logging.class.info((Logging)this, msg);
                    }

                    public void info(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.info((Logging)this, msg, t);
                    }

                    public boolean isWarnEnabled() {
                        return Logging.class.isWarnEnabled((Logging)this);
                    }

                    public void warn(Function0<Object> msg) {
                        Logging.class.warn((Logging)this, msg);
                    }

                    public void warn(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.warn((Logging)this, msg, t);
                    }

                    public byte[] getHash(byte[] bytes) {
                        return Hashing.class.getHash((Hashing)this, (byte[])bytes);
                    }

                    public String stringify(byte[] bytes) {
                        return Hashing.class.stringify((Hashing)this, (byte[])bytes);
                    }

                    public Option<byte[]> parseBytes(String hex) {
                        return Hashing.class.parseBytes((Hashing)this, (String)hex);
                    }

                    public boolean equals(byte[] hashA, byte[] hashB) {
                        return Hashing.class.equals((Hashing)this, (byte[])hashA, (byte[])hashB);
                    }

                    public Seq<Fetcher.Error> fetch(URI url, FetcherListener process) {
                        process.processObject((RepositoryObject)this.newCert$1);
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    {
                        this.newCert$1 = newCert$1;
                        Hashing.class.$init$((Hashing)this);
                        Logging.class.$init$((Logging)this);
                        Fetcher.class.$init$((Fetcher)this);
                    }
                };
                Mockito.when((Object)fetchersMock.singleObjectFetcher(uri)).thenReturn((Object)mockFetcher);
                fetcher.fetchTrustAnchorCertificate(uri);
                Seq certs = this.$outer.storage().getCertificates(newUrl);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)certs.size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToAnyShouldWrapper(certs.head()).should(this.$outer.equal(newCert), (Object)Equality$.MODULE$.default());
                certs = this.$outer.storage().getCertificates(oldUrl);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)certs.size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToAnyShouldWrapper(certs.head()).should(this.$outer.equal(oldCertificate), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should update an existing trust anchor certificate in the repo by uri", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DriverManagerDataSource dataSource = DataSources$.MODULE$.InMemoryDataSource();
                Fetchers fetchersMock = (Fetchers)this.$outer.mock(ManifestFactory$.MODULE$.classType(Fetchers.class));
                RepoFetcher fetcher = new RepoFetcher((Storage)new CacheStore((DataSource)dataSource), fetchersMock);
                String url = "rsync://repo2/cert.cert";
                URI uri = new URI(url);
                CertificateObject certificate = new CertificateObject(url, this.$outer.testCertificate1(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.storage().storeCertificate(certificate);
                CertificateObject updatedCert = new CertificateObject(url, this.$outer.testCertificate2(), CertificateObject$.MODULE$.$lessinit$greater$default$3());
                Fetcher mockFetcher = new Fetcher(this, updatedCert){
                    private final CertificateObject updatedCert$1;
                    private final Logger grizzled$slf4j$Logging$$_logger;
                    private volatile boolean bitmap$0;

                    public Either<Fetcher.Error, BoxedUnit> processObject(URI uri, byte[] bytes, FetcherListener fetcherListener) {
                        return Fetcher.class.processObject((Fetcher)this, (URI)uri, (byte[])bytes, (FetcherListener)fetcherListener);
                    }

                    public Function2<URI, String, Fetcher.ConnectionError> connectionE() {
                        return Fetcher.class.connectionE((Fetcher)this);
                    }

                    public Function2<URI, String, Fetcher.ProcessingError> processingE() {
                        return Fetcher.class.processingE((Fetcher)this);
                    }

                    public Function2<URI, String, Fetcher.ParseError> parseE() {
                        return Fetcher.class.parseE((Fetcher)this);
                    }

                    public <R> Product tryTo(URI uri, Function2<URI, String, Fetcher.Error> err, Function0<R> f) {
                        return Fetcher.class.tryTo((Fetcher)this, (URI)uri, err, f);
                    }

                    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
                        $anonfun$3$$anon$2 var1_1 = this;
                        synchronized (var1_1) {
                            if (!this.bitmap$0) {
                                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                                this.bitmap$0 = true;
                            }
                            return this.grizzled$slf4j$Logging$$_logger;
                        }
                    }

                    public Logger grizzled$slf4j$Logging$$_logger() {
                        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
                    }

                    public Logger logger() {
                        return Logging.class.logger((Logging)this);
                    }

                    public String loggerName() {
                        return Logging.class.loggerName((Logging)this);
                    }

                    public boolean isTraceEnabled() {
                        return Logging.class.isTraceEnabled((Logging)this);
                    }

                    public void trace(Function0<Object> msg) {
                        Logging.class.trace((Logging)this, msg);
                    }

                    public void trace(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.trace((Logging)this, msg, t);
                    }

                    public boolean isDebugEnabled() {
                        return Logging.class.isDebugEnabled((Logging)this);
                    }

                    public void debug(Function0<Object> msg) {
                        Logging.class.debug((Logging)this, msg);
                    }

                    public void debug(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.debug((Logging)this, msg, t);
                    }

                    public boolean isErrorEnabled() {
                        return Logging.class.isErrorEnabled((Logging)this);
                    }

                    public void error(Function0<Object> msg) {
                        Logging.class.error((Logging)this, msg);
                    }

                    public void error(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.error((Logging)this, msg, t);
                    }

                    public boolean isInfoEnabled() {
                        return Logging.class.isInfoEnabled((Logging)this);
                    }

                    public void info(Function0<Object> msg) {
                        Logging.class.info((Logging)this, msg);
                    }

                    public void info(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.info((Logging)this, msg, t);
                    }

                    public boolean isWarnEnabled() {
                        return Logging.class.isWarnEnabled((Logging)this);
                    }

                    public void warn(Function0<Object> msg) {
                        Logging.class.warn((Logging)this, msg);
                    }

                    public void warn(Function0<Object> msg, Function0<Throwable> t) {
                        Logging.class.warn((Logging)this, msg, t);
                    }

                    public byte[] getHash(byte[] bytes) {
                        return Hashing.class.getHash((Hashing)this, (byte[])bytes);
                    }

                    public String stringify(byte[] bytes) {
                        return Hashing.class.stringify((Hashing)this, (byte[])bytes);
                    }

                    public Option<byte[]> parseBytes(String hex) {
                        return Hashing.class.parseBytes((Hashing)this, (String)hex);
                    }

                    public boolean equals(byte[] hashA, byte[] hashB) {
                        return Hashing.class.equals((Hashing)this, (byte[])hashA, (byte[])hashB);
                    }

                    public Seq<Fetcher.Error> fetch(URI url, FetcherListener process) {
                        process.processObject((RepositoryObject)this.updatedCert$1);
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    {
                        this.updatedCert$1 = updatedCert$1;
                        Hashing.class.$init$((Hashing)this);
                        Logging.class.$init$((Logging)this);
                        Fetcher.class.$init$((Fetcher)this);
                    }
                };
                Mockito.when((Object)fetchersMock.singleObjectFetcher(uri)).thenReturn((Object)mockFetcher);
                fetcher.fetchTrustAnchorCertificate(uri);
                Seq certs = this.$outer.storage().getCertificates(url);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)certs.size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToAnyShouldWrapper(certs.head()).should(this.$outer.equal(updatedCert), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

