/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.sqlserver;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerSchema;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerSqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class SQLServerDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(SQLServerDbSupport.class);

    public SQLServerDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/sqlserver/";
    }

    public String getCurrentUserFunction() {
        return "SUSER_SNAME()";
    }

    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SCHEMA_NAME()", new String[0]);
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        LOG.info("SQLServer does not support setting the schema for the current session. Default schema NOT changed to " + schema);
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SQLServerSqlStatementBuilder();
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, "]", "]]");
    }

    public String doQuote(String identifier) {
        return "[" + this.escapeIdentifier(identifier) + "]";
    }

    public Schema getSchema(String name) {
        return new SQLServerSchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

