/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import java.net.InetSocketAddress;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.rtr.BadData;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011\u0011C\u0015;s'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002siJT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\u000b\u0003\u001de\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0011!1\u0002A!A!\u0002\u00139\u0012!\u0004:f[>$X-\u00113ee\u0016\u001c8\u000f\u0005\u0002\u001931\u0001A!\u0002\u000e\u0001\u0005\u0004Y\"!\u0001+\u0012\u0005qy\u0002C\u0001\t\u001e\u0013\tq\u0012CA\u0004O_RD\u0017N\\4\u0011\u0005A\u0001\u0013BA\u0011\u0012\u0005\r\te.\u001f\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005)r-\u001a;DkJ\u0014XM\u001c;DC\u000eDWmU3sS\u0006d\u0007c\u0001\t&O%\u0011a%\u0005\u0002\n\rVt7\r^5p]B\u0002\"\u0001\u0005\u0015\n\u0005%\n\"aA%oi\"A1\u0006\u0001B\u0001B\u0003%A&A\u000bhKR\u001cUO\u001d:f]R\u0014FO\u001d)sK\u001aL\u00070Z:\u0011\u0007A)S\u0006E\u0002/mer!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005Ib\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t)\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005]B$aA*fc*\u0011Q'\u0005\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0011\ta!\\8eK2\u001c\u0018B\u0001 <\u0005%\u0011FO\u001d)sK\u001aL\u0007\u0010\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0003M9W\r^\"veJ,g\u000e^*fgNLwN\\%e!\r\u0001RE\u0011\t\u0003\u0007\u001es!\u0001R#\u000e\u0003\tI!A\u0012\u0002\u0002\u0007A#W/\u0003\u0002I\u0013\nI1+Z:tS>t\u0017\n\u001a\u0006\u0003\r\nA\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001T\u0001\u0017Q\u0006\u001cHK];ti\u0006s7\r[8sg\u0016s\u0017M\u00197fIB\u0019\u0001#J'\u0011\u0005Aq\u0015BA(\u0012\u0005\u001d\u0011un\u001c7fC:DQ!\u0015\u0001\u0005\u0002I\u000ba\u0001P5oSRtDCB*U+Z;\u0006\fE\u0002E\u0001]AQA\u0006)A\u0002]AQa\t)A\u0002\u0011BQa\u000b)A\u00021BQ\u0001\u0011)A\u0002\u0005CQa\u0013)A\u00021CqA\u0017\u0001C\u0002\u0013\u00051,A\u0006tKN\u001c\u0018n\u001c8ECR\fW#\u0001/\u0011\u0005\u0011k\u0016B\u00010\u0003\u00059\u0011FO]*fgNLwN\u001c#bi\u0006Da\u0001\u0019\u0001!\u0002\u0013a\u0016\u0001D:fgNLwN\u001c#bi\u0006\u0004\u0003\"\u00022\u0001\t\u0003\u0019\u0017aB2p]:,7\r\u001e\u000b\u0002IB\u0011\u0001#Z\u0005\u0003MF\u0011A!\u00168ji\")\u0001\u000e\u0001C\u0001G\u0006QA-[:d_:tWm\u0019;\t\u000b)\u0004A\u0011A6\u0002\u0019M,'/[1m\u001d>$\u0018NZ=\u0015\u0005\u0011d\u0007\"B7j\u0001\u0004q\u0017a\u00019ekB\u0011Ai\\\u0005\u0003a\n\u00111\u0001\u00153v\u0011\u0015\u0011\b\u0001\"\u0001t\u00039\u0001(o\\2fgN\u0014V-];fgR$\"\u0001^;\u0011\u000792d\u000eC\u0003wc\u0002\u0007q/A\u0004sKF,Xm\u001d;\u0011\t9B(P\\\u0005\u0003sb\u0012a!R5uQ\u0016\u0014\bC\u0001#|\u0013\ta(AA\u0004CC\u0012$\u0015\r^1\t\u000by\u0004A\u0011A@\u0002#\u0011,G/\u001a:nS:,WI\u001d:peB#W\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001#\u0002\u0004%\u0019\u0011Q\u0001\u0002\u0003\u0011\u0015\u0013(o\u001c:QIVDq!!\u0003~\u0001\u0004\tY!A\u0003dCV\u001cX\rE\u0002/\u0003\u001bI1!a\u00049\u0005%!\u0006N]8xC\ndW\rC\u0004\u0002\u0014\u0001!I!!\u0006\u0002\u001b!\fg\u000e\u001a7f\u0005\u0006$G)\u0019;b)\u0019\t9\"!\b\u0002\"A!a&!\u0007o\u0013\r\tY\u0002\u000f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002 \u0005E\u0001\u0019A\u0014\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,\u0007\u0002CA\u0012\u0003#\u0001\r!!\n\u0002\u000f\r|g\u000e^3oiB)\u0001#a\n\u0002,%\u0019\u0011\u0011F\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007A\ti#C\u0002\u00020E\u0011AAQ=uK\"9\u00111\u0007\u0001\u0005\n\u0005U\u0012!\u00059s_\u000e,7o\u001d*fcV,7\u000f\u001e)ekR\u0019A/a\u000e\t\r5\f\t\u00041\u0001o\u0011\u001d\tY\u0004\u0001C\u0005\u0003{\t\u0011\u0003\u001d:pG\u0016\u001c8OU3tKR\fV/\u001a:z+\u0005!\bbBA!\u0001\u0011%\u00111I\u0001\u0013aJ|7-Z:t'\u0016\u0014\u0018.\u00197Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002F\u0005\u0015\u0014q\u000e\t\u0007\u0003\u000f\n\t&a\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005=\u0013#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002JI9\u0011QKA-\u0003?rgABA,\u0001\u0001\t\u0019F\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002\u0011\u00037J1!!\u0018\u0012\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001EA1\u0013\r\t\u0019'\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0003O\ny\u00041\u0001\u0002j\u0005I1/Z:tS>t\u0017\n\u001a\t\u0004!\u0005-\u0014bAA7#\t)1\u000b[8si\"A\u0011\u0011OA \u0001\u0004\t\u0019(\u0001\u0004tKJL\u0017\r\u001c\t\u0004!\u0005U\u0014bAA<#\t!Aj\u001c8h\u0001")
public class RtrSessionHandler<T> {
    private final Function0<Object> getCurrentCacheSerial;
    private final Function0<Seq<RtrPrefix>> getCurrentRtrPrefixes;
    private final Function0<Object> getCurrentSessionId;
    private final Function0<Object> hasTrustAnchorsEnabled;
    private final RtrSessionData sessionData;

    public RtrSessionData sessionData() {
        return this.sessionData;
    }

    public void connect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)true));
    }

    public void disconnect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)false));
    }

    public void serialNotify(Pdu pdu) {
        this.sessionData().lastPduSent_$eq(pdu);
    }

    public Seq<Pdu> processRequest(Either<BadData, Pdu> request) {
        Either<BadData, Pdu> either;
        block4: {
            List<Pdu> list;
            block3: {
                block2: {
                    Left left;
                    BadData badData;
                    either = request;
                    if (!(either instanceof Left) || (badData = (BadData)(left = (Left)either).a()) == null) break block2;
                    int errorCode = badData.errorCode();
                    byte[] content = badData.content();
                    list = this.handleBadData(errorCode, content);
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Pdu pdu = (Pdu)right.b();
                Seq<Pdu> result = this.processRequestPdu(pdu);
                this.sessionData().lastPduSent_$eq((Pdu)result.last());
                list = result;
            }
            return list;
        }
        throw new MatchError(either);
    }

    /*
     * WARNING - void declaration
     */
    public ErrorPdu determineErrorPdu(Throwable cause) {
        void var2_6;
        ErrorPdu errorPdu;
        this.sessionData().lastPduReceived_$eq(cause.getMessage());
        Throwable throwable = cause;
        if (throwable instanceof CorruptedFrameException) {
            CorruptedFrameException corruptedFrameException = (CorruptedFrameException)throwable;
            errorPdu = new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), corruptedFrameException.toString());
        } else if (throwable instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)throwable;
            errorPdu = new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), tooLongFrameException.toString());
        } else {
            errorPdu = throwable instanceof ReadTimeoutException ? new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "Connection timed out") : new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), throwable.toString());
        }
        ErrorPdu result = errorPdu;
        this.sessionData().lastPduSent_$eq(result);
        return var2_6;
    }

    private List<Pdu> handleBadData(int errorCode, byte[] content) {
        this.sessionData().lastPduReceived_$eq(new StringOps(Predef$.MODULE$.augmentString("Bad data (error code: %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorCode)})));
        ErrorPdu pdu = new ErrorPdu(errorCode, content, "");
        this.sessionData().lastPduSent_$eq(pdu);
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{pdu}));
    }

    private Seq<Pdu> processRequestPdu(Pdu pdu) {
        List list;
        Pdu pdu2 = pdu;
        if (pdu2 instanceof ResetQueryPdu) {
            this.sessionData().lastPduReceived_$eq("ResetQuery");
            list = this.processResetQuery();
        } else if (pdu2 instanceof SerialQueryPdu) {
            SerialQueryPdu serialQueryPdu = (SerialQueryPdu)pdu2;
            short sessionId = serialQueryPdu.sessionId();
            long serial = serialQueryPdu.serial();
            this.sessionData().lastPduReceived_$eq("SerialQuery");
            list = this.processSerialQuery(sessionId, serial);
        } else {
            this.sessionData().lastPduReceived_$eq("Invalid Request");
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.InvalidRequest(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "")}));
        }
        return list;
    }

    private Seq<Pdu> processResetQuery() {
        Tuple2.mcIZ.sp sp2;
        block4: {
            List list;
            block3: {
                block2: {
                    sp2 = new Tuple2.mcIZ.sp(this.getCurrentCacheSerial.apply$mcI$sp(), this.hasTrustAnchorsEnabled.apply$mcZ$sp());
                    if (sp2 == null) break block2;
                    int n = sp2._1$mcI$sp();
                    boolean bl = sp2._2$mcZ$sp();
                    if (0 != n || !bl) break block2;
                    list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.NoDataAvailable(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), "")}));
                    break block3;
                }
                if (sp2 == null) break block4;
                int serialNumber = sp2._1$mcI$sp();
                ObjectRef responsePdus = new ObjectRef((Object)package$.MODULE$.Vector().empty());
                short currentSessionId = this.getCurrentSessionId.apply$mcS$sp();
                responsePdus.elem = (Vector)((Vector)responsePdus.elem).$colon$plus((Object)new CacheResponsePdu(currentSessionId), Vector$.MODULE$.canBuildFrom());
                ((IterableLike)this.getCurrentRtrPrefixes.apply()).foreach((Function1)new Serializable(this, responsePdus){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef responsePdus$1;

                    public final void apply(RtrPrefix rtrPrefix) {
                        IpRange prefix = rtrPrefix.prefix();
                        int prefixLength = prefix.getPrefixLength();
                        int maxLength = BoxesRunTime.unboxToInt((Object)rtrPrefix.maxPrefixLength().getOrElse((Function0)new Serializable(this, prefixLength){
                            public static final long serialVersionUID = 0L;
                            private final int prefixLength$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.prefixLength$1;
                            }
                            {
                                this.prefixLength$1 = prefixLength$1;
                            }
                        }));
                        Asn asn = rtrPrefix.asn();
                        UniqueIpResource uniqueIpResource = prefix.getStart();
                        if (uniqueIpResource instanceof Ipv4Address) {
                            Ipv4Address ipv4Address = (Ipv4Address)uniqueIpResource;
                            this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv4PrefixAnnouncePdu(ipv4Address, (byte)prefixLength, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (uniqueIpResource instanceof Ipv6Address) {
                            Ipv6Address ipv6Address = (Ipv6Address)uniqueIpResource;
                            this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv6PrefixAnnouncePdu(ipv6Address, (byte)prefixLength, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Predef$.MODULE$.assert(false);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.responsePdus$1 = responsePdus$1;
                    }
                });
                list = (Seq)((Vector)responsePdus.elem).$colon$plus((Object)new EndOfDataPdu(currentSessionId, serialNumber), Vector$.MODULE$.canBuildFrom());
            }
            return list;
        }
        throw new MatchError((Object)sp2);
    }

    private List<Product> processSerialQuery(short sessionId, long serial) {
        return sessionId == this.getCurrentSessionId.apply$mcS$sp() && serial == (long)this.getCurrentCacheSerial.apply$mcI$sp() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CacheResponsePdu(sessionId), new EndOfDataPdu(sessionId, serial)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CacheResetPdu[]{new CacheResetPdu()}));
    }

    public RtrSessionHandler(T remoteAddress, Function0<Object> getCurrentCacheSerial, Function0<Seq<RtrPrefix>> getCurrentRtrPrefixes, Function0<Object> getCurrentSessionId, Function0<Object> hasTrustAnchorsEnabled) {
        this.getCurrentCacheSerial = getCurrentCacheSerial;
        this.getCurrentRtrPrefixes = getCurrentRtrPrefixes;
        this.getCurrentSessionId = getCurrentSessionId;
        this.hasTrustAnchorsEnabled = hasTrustAnchorsEnabled;
        this.sessionData = new RtrSessionData((InetSocketAddress)remoteAddress);
    }
}

