/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import grizzled.slf4j.Logging;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.ripe.rpki.validator.config.Http;
import net.ripe.rpki.validator.config.Http$;
import net.ripe.rpki.validator.lib.DateAndTime$;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.joda.time.DateTime;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public abstract class Http$class {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Try[] loadCertificatesFromDir(Http $this, File dir) {
        Try[] tryArray;
        ObjectRef cf$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        if (!dir.isDirectory()) {
            tryArray = (Try[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Try.class));
            return tryArray;
        }
        try {
            tryArray = (Try[])Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File f) {
                    return f.isFile() && !f.getName().equals(".keep");
                }
            }).map((Function1)new Serializable($this, cf$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Http $outer;
                private final ObjectRef cf$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Try<X509Certificate> apply(File f) {
                    return Http$class.loadCertificateFromFile$1(this.$outer, f, this.cf$lzy$1, this.bitmap$0$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.cf$lzy$1 = cf$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Try.class)));
            return tryArray;
        }
        catch (Exception exception) {
            tryArray = (Try[])((Object[])new Try[]{new Failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading trusted certificates from ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir, exception.getMessage()})), exception))});
        }
        return tryArray;
    }

    public static void net$ripe$rpki$validator$config$Http$$putCertificateInKeyStore(Http $this, X509Certificate cert) {
        $this.net$ripe$rpki$validator$config$Http$$customKeyStore().setCertificateEntry(cert.getSubjectDN().getName(), cert);
    }

    public static CloseableHttpClient net$ripe$rpki$validator$config$Http$$wrongSslHttp(Http $this) {
        Http$.anon.1 acceptingTrustStrategy = new Http$.anon.1($this);
        KeyStore emptyKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        emptyKeyStore.load(null, "".toCharArray());
        SSLContext sslConext = SSLContexts.custom().useTLS().loadTrustMaterial(emptyKeyStore, (TrustStrategy)acceptingTrustStrategy).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslConext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
    }

    public static CloseableHttpClient http(Http $this) {
        return $this.net$ripe$rpki$validator$config$Http$$httpClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CloseableHttpResponse fallBackToInsecureSsl(Http $this, HttpGet get) {
        CloseableHttpResponse closeableHttpResponse;
        URI url = get.getURI();
        String string = url.getScheme();
        String string2 = "https";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if ($this.net$ripe$rpki$validator$config$Http$$invalidSslHosts().contains((Object)url.getHost())) {
                closeableHttpResponse = $this.net$ripe$rpki$validator$config$Http$$wrongSslHttp().execute((HttpUriRequest)get);
                return closeableHttpResponse;
            }
            closeableHttpResponse = $this.http().execute((HttpUriRequest)get);
            return closeableHttpResponse;
        }
        closeableHttpResponse = $this.http().execute((HttpUriRequest)get);
        return closeableHttpResponse;
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SSLException) {
                CloseableHttpResponse closeableHttpResponse2;
                SSLException sSLException = (SSLException)throwable2;
                ((Logging)$this).logger().error((Function0)new Serializable($this, url){
                    public static final long serialVersionUID = 0L;
                    private final URI url$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not establish SSL connection while retrieving ", ", trying to establish SSL connection without certificate check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1}));
                    }
                    {
                        this.url$1 = url$1;
                    }
                }, (Function0)new Serializable($this, sSLException){
                    public static final long serialVersionUID = 0L;
                    private final SSLException x7$1;

                    public final SSLException apply() {
                        return this.x7$1;
                    }
                    {
                        this.x7$1 = x7$1;
                    }
                });
                URI uRI = url;
                synchronized (uRI) {
                    $this.net$ripe$rpki$validator$config$Http$$invalidSslHosts_$eq((Set<String>)((Set)$this.net$ripe$rpki$validator$config$Http$$invalidSslHosts().$plus((Object)url.getHost())));
                }
                closeableHttpResponse = closeableHttpResponse2 = $this.net$ripe$rpki$validator$config$Http$$wrongSslHttp().execute((HttpUriRequest)get);
                return closeableHttpResponse;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            ((Logging)$this).logger().error((Function0)new Serializable($this, url){
                public static final long serialVersionUID = 0L;
                private final URI url$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Something bad happened while retrieving ").append((Object)this.url$1).toString();
                }
                {
                    this.url$1 = url$1;
                }
            });
            throw e;
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
    }

    public static CloseableHttpResponse httpGet(Http $this, String url) {
        return Http$class.fallBackToInsecureSsl($this, new HttpGet(url));
    }

    public static CloseableHttpResponse httpGetIfNotModified(Http $this, String url, Option ifModifiedSince) {
        HttpGet get = new HttpGet(url);
        ifModifiedSince.foreach((Function1)new Serializable($this, get){
            public static final long serialVersionUID = 0L;
            private final HttpGet get$1;

            public final void apply(DateTime t) {
                this.get$1.setHeader("If-Modified-Since", DateAndTime$.MODULE$.formatAsRFC2616(t));
            }
            {
                this.get$1 = get$1;
            }
        });
        return Http$class.fallBackToInsecureSsl($this, get);
    }

    private static final CertificateFactory cf$lzycompute$1(Http $this, ObjectRef cf$lzy$1, VolatileByteRef bitmap$0$1) {
        Http http = $this;
        synchronized (http) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                cf$lzy$1.elem = CertificateFactory.getInstance("X.509");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (CertificateFactory)cf$lzy$1.elem;
        }
    }

    public static final CertificateFactory cf$1(Http $this, ObjectRef cf$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Http$class.cf$lzycompute$1($this, cf$lzy$1, bitmap$0$1) : (CertificateFactory)cf$lzy$1.elem;
    }

    public static final Try loadCertificateFromFile$1(Http $this, File f, ObjectRef cf$lzy$1, VolatileByteRef bitmap$0$1) {
        return Try$.MODULE$.apply((Function0)new Serializable($this, cf$lzy$1, f, bitmap$0$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Http $outer;
            private final ObjectRef cf$lzy$1;
            private final File f$1;
            private final VolatileByteRef bitmap$0$1;

            public final X509Certificate apply() {
                return (X509Certificate)Http$class.cf$1(this.$outer, this.cf$lzy$1, this.bitmap$0$1).generateCertificate(new BufferedInputStream(new FileInputStream(this.f$1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cf$lzy$1 = cf$lzy$1;
                this.f$1 = f$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }).recoverWith((PartialFunction)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final File f$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    object = new Failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error loading certificate from file ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1, exception.getMessage()})), exception));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static void $init$(Http $this) {
        $this.net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customKeyStore_$eq(KeyStore.getInstance("jceks"));
        $this.net$ripe$rpki$validator$config$Http$$customKeyStore().load(null);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init((KeyStore)null);
        $this.net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$systemTrustedCertificates_$eq((X509Certificate[])Predef$.MODULE$.refArrayOps((Object[])tmf.getTrustManagers()).withFilter((Function1)new Http$.anonfun.1($this)).flatMap((Function1)new Http$.anonfun.2($this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(X509Certificate.class))));
        Predef$.MODULE$.refArrayOps((Object[])$this.net$ripe$rpki$validator$config$Http$$systemTrustedCertificates()).foreach((Function1)new Http$.anonfun.3($this));
        Predef$.MODULE$.refArrayOps((Object[])Http$class.loadCertificatesFromDir($this, $this.trustedCertsLocation())).foreach((Function1)new Http$.anonfun.4($this));
        $this.net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpRequestConfig_$eq(RequestConfig.custom().setConnectTimeout(11000).setSocketTimeout(29000).build());
        $this.net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customSslContext_$eq(SSLContexts.custom().useTLS().loadTrustMaterial($this.net$ripe$rpki$validator$config$Http$$customKeyStore()).build());
        $this.net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpClient_$eq(HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig($this.net$ripe$rpki$validator$config$Http$$httpRequestConfig()).setSslcontext($this.net$ripe$rpki$validator$config$Http$$customSslContext()).build());
        $this.net$ripe$rpki$validator$config$Http$$invalidSslHosts_$eq((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }
}

