/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.output;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.CsvFormatter;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatedRoaWriter
implements NotifyingCertificateRepositoryObjectFetcher.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatedRoaWriter.class);
    private List<RoaData> allRoaData = new ArrayList<RoaData>();

    @Override
    public void afterFetchFailure(URI uri, ValidationResult result) {
    }

    @Override
    public void afterFetchSuccess(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        if (object instanceof RoaCms) {
            List<RoaData> roaDataList = RoaData.getRoaDataListFromRoaCms(uri, (RoaCms)object);
            this.allRoaData.addAll(roaDataList);
        }
    }

    @Override
    public void afterPrefetchFailure(URI uri, ValidationResult result) {
    }

    @Override
    public void afterPrefetchSuccess(URI uri, ValidationResult result) {
    }

    public void writeCsvFile(File outputFile) {
        CsvFormatter formatter = new CsvFormatter();
        this.setHeaders(formatter);
        for (RoaData roaData : this.allRoaData) {
            this.addRow(formatter, roaData);
        }
        try {
            formatter.print(outputFile);
        }
        catch (IOException e) {
            LOG.error("Failed to write ROA data into csv file", (Throwable)e);
        }
    }

    private void setHeaders(CsvFormatter formatter) {
        formatter.addQuotedColumn("URI");
        formatter.addColumn("ASN");
        formatter.addColumn("IP Prefix");
        formatter.addColumn("Max Length");
        formatter.addColumn("Not Before");
        formatter.addColumn("Not After");
    }

    private void addRow(CsvFormatter formatter, RoaData roaData) {
        formatter.addLine(new String[]{roaData.getUri(), roaData.getAsn(), roaData.getIpRange(), roaData.getMaxLength(), roaData.getNotValidBefore(), roaData.getNotValidAfter()});
    }

    List<RoaData> getAllRoaData() {
        return this.allRoaData;
    }

    public static final class RoaData {
        private URI uri;
        private Asn asn;
        private IpRange ipRange;
        private Integer maxLength;
        private ValidityPeriod validityPeriod;
        private DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss").withZone(DateTimeZone.UTC);

        private RoaData(URI uri, Asn asn, IpRange ipRange, Integer maxLength, ValidityPeriod validityPeriod) {
            this.uri = uri;
            this.asn = asn;
            this.ipRange = ipRange;
            this.maxLength = maxLength;
            this.validityPeriod = validityPeriod;
        }

        public String getUri() {
            return this.uri.toString();
        }

        public static List<RoaData> getRoaDataListFromRoaCms(URI uri, RoaCms roaCms) {
            ArrayList<RoaData> roaDataList = new ArrayList<RoaData>();
            Asn asn = roaCms.getAsn();
            X509ResourceCertificate roaCertificate = roaCms.getCertificate();
            ValidityPeriod validityPeriod = roaCertificate.getValidityPeriod();
            for (RoaPrefix roaPrefix : roaCms.getPrefixes()) {
                IpRange ipRange = roaPrefix.getPrefix();
                Integer maxLength = roaPrefix.getMaximumLength();
                RoaData roaData = new RoaData(uri, asn, ipRange, maxLength, validityPeriod);
                roaDataList.add(roaData);
            }
            return roaDataList;
        }

        public String getAsn() {
            return this.asn.toString();
        }

        public String getIpRange() {
            return this.ipRange.toString();
        }

        public String getMaxLength() {
            if (this.maxLength == null) {
                return null;
            }
            return this.maxLength.toString();
        }

        public String getNotValidBefore() {
            return this.dateFormatter.print((ReadableInstant)this.validityPeriod.getNotValidBefore());
        }

        public String getNotValidAfter() {
            return this.dateFormatter.print((ReadableInstant)this.validityPeriod.getNotValidAfter());
        }
    }
}

