/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.io.File;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingCertificateRepositoryObjectFetcher
implements CertificateRepositoryObjectFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingCertificateRepositoryObjectFetcher.class);
    private final CertificateRepositoryObjectFetcher fetcher;
    private CertificateRepositoryObjectFetcher outerMostDecorator;
    private ValidationOptions options;

    public ValidatingCertificateRepositoryObjectFetcher(CertificateRepositoryObjectFetcher fetcher) {
        this(fetcher, new ValidationOptions());
    }

    public ValidatingCertificateRepositoryObjectFetcher(CertificateRepositoryObjectFetcher fetcher, ValidationOptions options) {
        this.fetcher = fetcher;
        this.options = options;
        this.outerMostDecorator = this;
    }

    public void setOuterMostDecorator(CertificateRepositoryObjectFetcher outerMostDecorator) {
        this.outerMostDecorator = outerMostDecorator;
    }

    public X509Crl getCrl(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)result);
        Validate.notNull((Object)uri);
        X509Crl crl = this.fetcher.getCrl(uri, context, result);
        if (crl == null) {
            return null;
        }
        ManifestCms manifest = this.getManifestValidatedForCrl(uri, context, result, crl = (X509Crl)this.processCertificateRepositoryObject(uri, context, result, (CertificateRepositoryObject)crl));
        result.rejectIfFalse(manifest != null, "crl.manifest.valid", new String[0]);
        if (manifest == null) {
            return null;
        }
        this.checkHashValueForCrl(uri, result, crl, manifest);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return crl;
    }

    @Override
    public ManifestCms getManifest(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)result);
        try {
            ManifestCms manifestCms = this.fetcher.getManifest(uri, context, result);
            return (ManifestCms)this.processCertificateRepositoryObject(uri, context, result, (CertificateRepositoryObject)manifestCms);
        }
        catch (Exception e) {
            LOG.error("There was an exception trying to get manifest: " + uri.toString(), (Throwable)e);
            result.rejectIfFalse(false, "objects.general.parsing", new String[]{uri.toString()});
            return null;
        }
    }

    @Override
    public CertificateRepositoryObject getObject(URI uri, CertificateRepositoryObjectValidationContext context, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)result);
        try {
            CertificateRepositoryObject certificateRepositoryObject = this.fetcher.getObject(uri, context, fileContentSpecification, result);
            return this.processCertificateRepositoryObject(uri, context, result, certificateRepositoryObject);
        }
        catch (Exception e) {
            LOG.error("There was an exception trying to get object for uri: " + uri.toString(), (Throwable)e);
            result.rejectIfFalse(false, "objects.general.parsing", new String[]{uri.toString()});
            return null;
        }
    }

    @Override
    public void prefetch(URI uri, ValidationResult result) {
        this.fetcher.prefetch(uri, result);
    }

    private CertificateRepositoryObject processCertificateRepositoryObject(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result, CertificateRepositoryObject certificateRepositoryObject) {
        if (certificateRepositoryObject == null) {
            return null;
        }
        certificateRepositoryObject.validate(uri.toString(), context, (CrlLocator)this.outerMostDecorator, this.options, result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return certificateRepositoryObject;
    }

    private void checkHashValueForCrl(URI uri, ValidationResult result, X509Crl crl, ManifestCms manifest) {
        String crlFileName = new File(uri.getRawPath()).getName();
        result.setLocation(new ValidationLocation(uri));
        result.rejectIfFalse(manifest.containsFile(crlFileName), "validator.manifest.does.not.contain.file", new String[]{crlFileName});
        if (result.hasFailureForCurrentLocation()) {
            return;
        }
        result.rejectIfFalse(manifest.verifyFileContents(crlFileName, crl.getEncoded()), "validator.file.content", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestCms getManifestValidatedForCrl(final URI crlUri, CertificateRepositoryObjectValidationContext context, ValidationResult result, final X509Crl crl) {
        ValidationLocation savedCurrentLocation = result.getCurrentLocation();
        result.setLocation(new ValidationLocation(context.getManifestURI()));
        try {
            ManifestCms manifest = this.fetcher.getManifest(context.getManifestURI(), context, result);
            if (manifest == null) {
                ManifestCms manifestCms = null;
                return manifestCms;
            }
            manifest.validate(context.getManifestURI().toString(), context, new CrlLocator(){

                public X509Crl getCrl(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
                    Validate.isTrue((boolean)uri.equals(crlUri));
                    return crl;
                }
            }, this.options, result);
            if (result.hasFailureForCurrentLocation()) {
                ManifestCms manifestCms = null;
                return manifestCms;
            }
            ManifestCms manifestCms = manifest;
            return manifestCms;
        }
        finally {
            result.setLocation(savedCurrentLocation);
        }
    }
}

