/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.util.HierarchicalUriCache;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsyncRpkiRepositoryObjectFetcher
implements RpkiRepositoryObjectFetcher {
    public static final String RSYNC_PREFETCH_VALIDATION_METRIC = "rsync.prefetch";
    public static final String RSYNC_FETCH_FILE_VALIDATION_METRIC = "rsync.fetch.file";
    private static final Logger LOG = LoggerFactory.getLogger(RsyncRpkiRepositoryObjectFetcher.class);
    private static final String[] STANDARD_OPTIONS = new String[]{"--update", "--times", "--copy-links"};
    private static final String[] PREFETCH_OPTIONS = new String[]{"--recursive", "--delete"};
    private static final String[] SINGLE_FILE_OPTIONS = new String[0];
    private final HierarchicalUriCache uriCache;
    private final Rsync rsync;
    private final UriToFileMapper uriToFileMapper;

    public RsyncRpkiRepositoryObjectFetcher(Rsync rsync, UriToFileMapper uriToFileMapper) {
        this.rsync = rsync;
        this.uriToFileMapper = uriToFileMapper;
        this.uriCache = new HierarchicalUriCache();
    }

    @Override
    public CertificateRepositoryObject fetch(URI uri, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        byte[] contents = this.fetchContent(uri, fileContentSpecification, result);
        if (result.hasFailureForCurrentLocation() || contents == null) {
            return null;
        }
        return CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])contents, (ValidationResult)result);
    }

    private byte[] fetchContent(URI uri, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        File destinationFile = this.uriToFileMapper.map(uri, result);
        if (destinationFile == null) {
            return null;
        }
        this.fetchFile(uri, destinationFile, result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        byte[] contents = this.readFile(destinationFile, result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        result.rejectIfFalse(fileContentSpecification.isSatisfiedBy((Object)contents), "validator.file.content", new String[]{uri.toString()});
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return contents;
    }

    @Override
    public void prefetch(URI uri, ValidationResult result) {
        if (this.uriCache.contains(uri)) {
            LOG.debug("rsync cache hit for URI " + uri);
            return;
        }
        File destinationDirectory = this.uriToFileMapper.map(uri, result);
        if (result.hasFailureForCurrentLocation()) {
            return;
        }
        this.rsync.reset();
        this.rsync.addOptions(STANDARD_OPTIONS);
        this.rsync.addOptions(PREFETCH_OPTIONS);
        this.rsync.setSource(uri.toString());
        this.rsync.setDestination(destinationDirectory.getAbsolutePath());
        destinationDirectory.mkdirs();
        int rc = this.rsync.execute();
        result.addMetric(RSYNC_PREFETCH_VALIDATION_METRIC, String.valueOf(this.rsync.elapsedTime()));
        result.rejectIfFalse(rc == 0, "validator.rsync.command", new String[]{uri.toString()});
        if (rc == 0) {
            this.uriCache.add(uri);
        }
    }

    private void fetchFile(URI uri, File destinationFile, ValidationResult result) {
        if (this.uriCache.contains(uri)) {
            LOG.debug("rsync cache hit for URI " + uri);
            return;
        }
        this.rsync.reset();
        this.rsync.addOptions(STANDARD_OPTIONS);
        this.rsync.addOptions(SINGLE_FILE_OPTIONS);
        this.rsync.setSource(uri.toString());
        this.rsync.setDestination(destinationFile.getAbsolutePath());
        destinationFile.getParentFile().mkdirs();
        int rc = this.rsync.execute();
        result.addMetric(RSYNC_FETCH_FILE_VALIDATION_METRIC, String.valueOf(this.rsync.elapsedTime()));
        result.rejectIfFalse(rc == 0, "validator.rsync.command", new String[]{uri.toString()});
        if (rc == 0) {
            this.uriCache.add(uri);
        }
    }

    private byte[] readFile(File destinationFile, ValidationResult validationResult) {
        byte[] result;
        try {
            result = FileUtils.readFileToByteArray((File)destinationFile);
        }
        catch (IOException e) {
            result = null;
        }
        validationResult.rejectIfNull((Object)result, "validator.read.file", new String[]{destinationFile.getAbsolutePath()});
        return result;
    }
}

