/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.net.URI;
import java.util.LinkedList;
import java.util.Queue;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalkerWorkQueue;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import org.apache.commons.lang.Validate;

public class TopDownWalker {
    private final CertificateRepositoryObjectFetcher certificateRepositoryObjectFetcher;
    private final TopDownWalkerWorkQueue workQueue;
    private final ValidationResult validationResult;

    public TopDownWalker(CertificateRepositoryObjectFetcher certificateRepositoryObjectFetcher) {
        this(new LinkedList<CertificateRepositoryObjectValidationContext>(), certificateRepositoryObjectFetcher, ValidationResult.withLocation((String)"n/a"));
    }

    public TopDownWalker(CertificateRepositoryObjectFetcher certificateRepositoryObjectFetcher, ValidationResult validationResult) {
        this(new LinkedList<CertificateRepositoryObjectValidationContext>(), certificateRepositoryObjectFetcher, validationResult);
    }

    TopDownWalker(Queue<CertificateRepositoryObjectValidationContext> workQueue, CertificateRepositoryObjectFetcher certificateRepositoryObjectFetcher, ValidationResult validationResult) {
        this.certificateRepositoryObjectFetcher = certificateRepositoryObjectFetcher;
        this.workQueue = new TopDownWalkerWorkQueue(workQueue);
        this.validationResult = validationResult;
    }

    public void addTrustAnchor(CertificateRepositoryObjectValidationContext trustAnchor) {
        Validate.isTrue((boolean)trustAnchor.getCertificate().isObjectIssuer(), (String)"trust anchor must be an object issuer");
        this.workQueue.add(trustAnchor);
    }

    public void execute() {
        while (!this.workQueue.isEmpty()) {
            CertificateRepositoryObjectValidationContext context = this.workQueue.remove();
            this.prefetch(context);
            this.processManifest(context);
        }
    }

    void prefetch(CertificateRepositoryObjectValidationContext context) {
        URI repositoryURI = context.getRepositoryURI();
        if (repositoryURI != null) {
            this.validationResult.setLocation(new ValidationLocation(repositoryURI));
            this.certificateRepositoryObjectFetcher.prefetch(repositoryURI, this.validationResult);
        }
    }

    void processManifest(CertificateRepositoryObjectValidationContext context) {
        URI manifestURI = context.getManifestURI();
        ManifestCms manifestCms = this.fetchManifest(manifestURI, context);
        if (manifestCms != null) {
            this.processManifestFiles(context, manifestCms);
        }
    }

    ManifestCms fetchManifest(URI manifestURI, CertificateRepositoryObjectValidationContext context) {
        this.validationResult.setLocation(new ValidationLocation(manifestURI));
        try {
            return this.certificateRepositoryObjectFetcher.getManifest(manifestURI, context, this.validationResult);
        }
        catch (RuntimeException e) {
            this.validationResult.error("validator.object.processing.exception", new String[]{manifestURI.toString()});
            return null;
        }
    }

    void processManifestFiles(CertificateRepositoryObjectValidationContext context, ManifestCms manifestCms) {
        URI repositoryURI = context.getRepositoryURI();
        for (String fileName : manifestCms.getFileNames()) {
            try {
                this.processManifestEntry(manifestCms, context, repositoryURI, fileName);
            }
            catch (RuntimeException e) {
                this.validationResult.error("validator.object.processing.exception", new String[]{repositoryURI.resolve(fileName).toString()});
            }
        }
    }

    void processManifestEntry(ManifestCms manifestCms, CertificateRepositoryObjectValidationContext context, URI repositoryURI, String fileName) {
        URI uri = repositoryURI.resolve(fileName);
        this.validationResult.setLocation(new ValidationLocation(uri));
        CertificateRepositoryObject object = this.certificateRepositoryObjectFetcher.getObject(uri, context, (Specification<byte[]>)manifestCms.getFileContentSpecification(fileName), this.validationResult);
        this.addToWorkQueueIfObjectIssuer(context, uri, object);
    }

    void addToWorkQueueIfObjectIssuer(CertificateRepositoryObjectValidationContext context, URI objectURI, CertificateRepositoryObject object) {
        X509ResourceCertificate childCertificate;
        if (object instanceof X509ResourceCertificate && (childCertificate = (X509ResourceCertificate)object).isObjectIssuer()) {
            this.workQueue.add(context.createChildContext(objectURI, childCertificate));
        }
    }
}

