/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.util.Specifications;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;

public class SingleObjectWalker {
    private static final int MAX_CHAIN_LENGTH = 30;
    private CertificateRepositoryObject startingPoint;
    private URI startingPointUri;
    private CertificateRepositoryObjectFetcher chainBuildFetcher;
    private NotifyingCertificateRepositoryObjectFetcher.Listener chainBuildLogger;
    private CertificateRepositoryObjectFetcher validationFetcher;
    private List<URI> parentCertificateChain = new ArrayList<URI>();
    private ValidationResult result = ValidationResult.withLocation((String)"n/a");

    public SingleObjectWalker(CertificateRepositoryObject startingPoint, URI startingPointUri, CertificateRepositoryObjectFetcher chainBuildFetcher, NotifyingCertificateRepositoryObjectFetcher.Listener chainBuildLogger, CertificateRepositoryObjectFetcher validationFetcher) {
        this.startingPoint = startingPoint;
        this.startingPointUri = startingPointUri;
        this.chainBuildFetcher = chainBuildFetcher;
        this.chainBuildLogger = chainBuildLogger;
        this.validationFetcher = validationFetcher;
    }

    void setParentCertificateChain(List<URI> certificateChain) {
        this.parentCertificateChain = certificateChain;
    }

    void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    public ValidationResult execute(List<CertificateRepositoryObjectValidationContext> trustAnchors) {
        this.buildUpChain();
        if (this.result.hasFailures()) {
            return this.result;
        }
        this.validateTrustAnchor(trustAnchors);
        if (this.result.hasFailures()) {
            return this.result;
        }
        this.validateChain();
        return this.result;
    }

    void buildUpChain() {
        URI parentURI = this.startingPoint.getParentCertificateUri();
        while (parentURI != null) {
            this.result.setLocation(new ValidationLocation(parentURI));
            CertificateRepositoryObject parent = this.chainBuildFetcher.getObject(parentURI, null, (Specification<byte[]>)Specifications.alwaysTrue(), this.result);
            if (parent instanceof X509ResourceCertificate) {
                this.parentCertificateChain.add(0, parentURI);
                if (!this.result.rejectIfFalse(this.parentCertificateChain.size() <= 30, "cert.chain.length", new String[]{Integer.valueOf(30).toString()})) {
                    this.chainBuildLogger.afterFetchFailure(parentURI, this.result);
                    return;
                }
                URI newParentURI = parent.getParentCertificateUri();
                if (this.parentCertificateChain.contains(newParentURI)) {
                    this.result.rejectIfFalse(false, "cert.chain.circular.reference", new String[0]);
                    this.chainBuildLogger.afterFetchFailure(parentURI, this.result);
                    return;
                }
                parentURI = newParentURI;
                continue;
            }
            if (parent == null) {
                parentURI = null;
                continue;
            }
            this.result.rejectIfFalse(false, "cert.aia.no.certificate", new String[0]);
            this.chainBuildLogger.afterFetchFailure(parentURI, this.result);
            return;
        }
    }

    void validateTrustAnchor(List<CertificateRepositoryObjectValidationContext> trustAnchors) {
        URI rootURI = this.parentCertificateChain.get(0);
        this.result.setLocation(new ValidationLocation(rootURI));
        X509ResourceCertificate rootCertificate = (X509ResourceCertificate)this.chainBuildFetcher.getObject(rootURI, null, (Specification<byte[]>)Specifications.alwaysTrue(), this.result);
        boolean rootCertIsTa = false;
        for (CertificateRepositoryObjectValidationContext context : trustAnchors) {
            if (!context.getCertificate().equals((Object)rootCertificate)) continue;
            rootCertIsTa = true;
            break;
        }
        if (!this.result.rejectIfFalse(rootCertIsTa, "cert.root.is.ta", new String[0])) {
            this.chainBuildLogger.afterFetchFailure(rootURI, this.result);
        }
    }

    void validateChain() {
        URI rootURI = this.parentCertificateChain.get(0);
        X509ResourceCertificate rootCertificate = (X509ResourceCertificate)this.chainBuildFetcher.getObject(rootURI, null, (Specification<byte[]>)Specifications.alwaysTrue(), this.result);
        CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(rootURI, rootCertificate);
        for (URI uri : this.parentCertificateChain) {
            X509ResourceCertificate cert = (X509ResourceCertificate)this.validationFetcher.getObject(uri, context, (Specification<byte[]>)Specifications.alwaysTrue(), this.result);
            if (cert == null) {
                return;
            }
            context = context.createChildContext(uri, cert);
        }
        this.validationFetcher.getObject(this.startingPointUri, context, (Specification<byte[]>)Specifications.alwaysTrue(), this.result);
    }
}

