/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CertificateRepositoryObjectValidationContext {
    private final List<String> subjectChain;
    private final URI location;
    private final X509ResourceCertificate certificate;
    private final IpResourceSet resources;
    private IpResourceSet overclaiming = new IpResourceSet();

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate) {
        this(location, certificate, certificate.getResources(), Lists.newArrayList((Object[])new String[]{certificate.getSubject().getName()}));
    }

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate, IpResourceSet resources, List<String> subjectChain) {
        this.location = location;
        this.certificate = certificate;
        this.resources = resources;
        this.subjectChain = subjectChain;
    }

    public URI getLocation() {
        return this.location;
    }

    public X509ResourceCertificate getCertificate() {
        return this.certificate;
    }

    public List<String> getSubjectChain() {
        return this.subjectChain;
    }

    public URI getManifestURI() {
        return this.certificate.getManifestUri();
    }

    public URI getRepositoryURI() {
        return this.certificate.getRepositoryUri();
    }

    public URI getRpkiNotifyURI() {
        return this.certificate.getRrdpNotifyUri();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.certificate.getSubjectKeyIdentifier();
    }

    public void addOverclaiming(IpResourceSet overclaiming) {
        this.overclaiming.addAll(overclaiming);
    }

    public CertificateRepositoryObjectValidationContext createChildContext(URI childLocation, X509ResourceCertificate childCertificate) {
        IpResourceSet effectiveResources = this.getEffectiveResources(childCertificate.deriveResources(this.resources));
        ArrayList childSubjects = Lists.newArrayList(this.subjectChain);
        childSubjects.add(childCertificate.getSubject().getName());
        return new CertificateRepositoryObjectValidationContext(childLocation, childCertificate, effectiveResources, childSubjects);
    }

    public IpResourceSet getResources() {
        return this.getEffectiveResources(this.resources);
    }

    private IpResourceSet getEffectiveResources(IpResourceSet r) {
        IpResourceSet effectiveResources = new IpResourceSet(r);
        effectiveResources.removeAll(this.overclaiming);
        return effectiveResources;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.location).append((Object)this.certificate).append((Object)this.resources).append((Object)this.overclaiming).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateRepositoryObjectValidationContext that = (CertificateRepositoryObjectValidationContext)obj;
        return new EqualsBuilder().append((Object)this.getLocation(), (Object)that.getLocation()).append((Object)this.getCertificate(), (Object)that.getCertificate()).append((Object)this.resources, (Object)that.resources).append((Object)this.overclaiming, (Object)that.overclaiming).isEquals();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

