/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;

public class GhostbustersCmsParser
extends RpkiSignedObjectParser {
    private String vCardPayload;

    @Override
    public void decodeContent(ASN1Encodable encoded) {
    }

    @Override
    protected void parseContent(CMSSignedDataParser sp) {
        ValidationResult validationResult = this.getValidationResult();
        final CMSTypedStream signedContent = sp.getSignedContent();
        this.contentType = signedContent.getContentType();
        try {
            InputSupplier<InputStream> supplier = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return signedContent.getContentStream();
                }
            };
            this.vCardPayload = CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)supplier, (Charset)Charsets.US_ASCII));
        }
        catch (IOException e) {
            validationResult.rejectIfFalse(false, "cms.decode.content", new String[0]);
            return;
        }
        validationResult.rejectIfFalse(true, "cms.decode.content", new String[0]);
    }

    public GhostbustersCms getGhostbustersCms() {
        if (!this.isSuccess()) {
            throw new IllegalArgumentException("Ghostbuster record validation failed: " + this.getValidationResult().getFailuresForCurrentLocation());
        }
        RpkiSignedObjectInfo cmsObjectData = new RpkiSignedObjectInfo(this.getEncoded(), this.getResourceCertificate(), this.getContentType(), this.getSigningTime());
        return new GhostbustersCms(cmsObjectData, this.vCardPayload);
    }

    public boolean isSuccess() {
        return !this.getValidationResult().hasFailureForCurrentLocation();
    }
}

