/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.ghostbuster;

import java.net.URI;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class GhostbustersCms
extends RpkiSignedObject {
    public static final ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.35");
    private String vCard;

    GhostbustersCms(RpkiSignedObjectInfo cmsObjectData, String vCard) {
        super(cmsObjectData);
        this.vCard = vCard;
    }

    @Override
    protected void validateWithCrl(String location, CertificateRepositoryObjectValidationContext context, ValidationOptions options, ValidationResult result, X509Crl crl) {
        if (result.rejectIfNull(this.vCard, "validator.repository.ghostbusters.record.empty", this.getParentCertificateUri().toString())) {
            return;
        }
        result.rejectIfTrue(this.vCard.isEmpty(), "validator.repository.ghostbusters.record.empty", new String[0]);
    }

    @Override
    public URI getParentCertificateUri() {
        return this.getCertificate().getParentCertificateUri();
    }

    public String getvCard() {
        return this.vCard;
    }
}

