/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.codahale.metrics.servlets.HealthCheckServlet;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumSet;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.api.RestApi;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementValidator;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump$;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.config.Http;
import net.ripe.rpki.validator.config.Http$class;
import net.ripe.rpki.validator.config.Main$;
import net.ripe.rpki.validator.config.Main$$anon$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.config.PersistentData;
import net.ripe.rpki.validator.config.PersistentData$;
import net.ripe.rpki.validator.config.PersistentDataSerialiser$;
import net.ripe.rpki.validator.config.ReleaseInfo$;
import net.ripe.rpki.validator.config.WebFilter;
import net.ripe.rpki.validator.config.health.HealthChecks$;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.lib.DateAndTime$DateTimeOrdering$;
import net.ripe.rpki.validator.lib.OnlineNewVersionDetailFetcher;
import net.ripe.rpki.validator.lib.UserPreferences;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.TrackValidationProcess;
import net.ripe.rpki.validator.models.TrackValidationProcess$class;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchorData;
import net.ripe.rpki.validator.models.TrustAnchorValidationProcess;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.TrustAnchors$;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.models.ValidationProcessLogger$ObjectFetcherLogger$;
import net.ripe.rpki.validator.models.ValidationProcessLogger$class;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.rtr.RTRServer;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.package$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalaz.Failure;
import scalaz.Success;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\tEr!B\u0001\u0003\u0011\u0003i\u0011\u0001B'bS:T!a\u0001\u0003\u0002\r\r|gNZ5h\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"\u0001B'bS:\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011B\u000f\u0002\u0013M,7o]5p]&#W#\u0001\u0010\u0011\u0005})cB\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\r\u0011HO]\u0005\u0003I\u0005\n1\u0001\u00153v\u0013\t1sEA\u0005TKN\u001c\u0018n\u001c8JI*\u0011A%\t\u0005\u0007S=\u0001\u000b\u0011\u0002\u0010\u0002\u0015M,7o]5p]&#\u0007\u0005C\u0003,\u001f\u0011\u0005A&\u0001\u0003nC&tGCA\u00171!\t\u0019b&\u0003\u00020)\t!QK\\5u\u0011\u0015\t$\u00061\u00013\u0003\u0011\t'oZ:\u0011\u0007M\u0019T'\u0003\u00025)\t)\u0011I\u001d:bsB\u0011aG\u0010\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\u001f\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\"b\u0001\u0002\t\u0003\u0001\t\u001bB!\u0011\nD\rB\u0011a\u0002R\u0005\u0003\u000b\n\u0011A\u0001\u0013;uaB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006g24GG\u001b\u0006\u0002\u0017\u0006AqM]5{u2,G-\u0003\u0002N\u0011\n9Aj\\4hS:<\u0007\"B\rB\t\u0003yE#\u0001)\u0011\u00059\t\u0005b\u0002*B\u0005\u0004%\u0019aU\u0001\fC\u000e$xN]*zgR,W.F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,A\u0003bGR|'OC\u0001Z\u0003\u0011\t7n[1\n\u0005m3&aC!di>\u00148+_:uK6Da!X!!\u0002\u0013!\u0016\u0001D1di>\u00148+_:uK6\u0004\u0003bB0B\u0005\u0004%\t\u0001Y\u0001\ngR\f'\u000f^3e\u0003R,\u0012!\u0019\t\u0003'\tL!a\u0019\u000b\u0003\t1{gn\u001a\u0005\u0007K\u0006\u0003\u000b\u0011B1\u0002\u0015M$\u0018M\u001d;fI\u0006#\b\u0005C\u0004h\u0003\n\u0007I\u0011\u00015\u0002\u0017\t<\u0007OU5t\tVl\u0007o]\u000b\u0002SB\u0019!n\\9\u000e\u0003-T!\u0001\\7\u0002\u0007M$XN\u0003\u0002o)\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005A\\'a\u0001*fMB\u0019!/^<\u000e\u0003MT!\u0001\u001e\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002wg\n\u00191+Z9\u0011\u0005alX\"A=\u000b\u0005i\\\u0018a\u00029sKZLWm\u001e\u0006\u0003y\u0012\t1AY4q\u0013\tq\u0018P\u0001\u0006COB\u0014\u0016n\u001d#v[BDq!!\u0001BA\u0003%\u0011.\u0001\u0007cOB\u0014\u0016n\u001d#v[B\u001c\b\u0005C\u0005\u0002\u0006\u0005\u0013\r\u0011\"\u0001\u0002\b\u0005A\"m\u001a9B]:|WO\\2f[\u0016tGOV1mS\u0012\fGo\u001c:\u0016\u0005\u0005%\u0001c\u0001=\u0002\f%\u0019\u0011QB=\u00031\t;\u0007/\u00118o_Vt7-Z7f]R4\u0016\r\\5eCR|'\u000f\u0003\u0005\u0002\u0012\u0005\u0003\u000b\u0011BA\u0005\u0003e\u0011w\r]!o]>,hnY3nK:$h+\u00197jI\u0006$xN\u001d\u0011\t\u0013\u0005U\u0011I1A\u0005\u0002\u0005]\u0011\u0001\u00033bi\u00064\u0015\u000e\\3\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0003S>T!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tiB\u0001\u0003GS2,\u0007\u0002CA\u0016\u0003\u0002\u0006I!!\u0007\u0002\u0013\u0011\fG/\u0019$jY\u0016\u0004\u0003\"CA\u0018\u0003\n\u0007I\u0011AA\u0019\u0003\u0011!\u0017\r^1\u0016\u0005\u0005M\u0002c\u0001\b\u00026%\u0019\u0011q\u0007\u0002\u0003\u001dA+'o]5ti\u0016tG\u000fR1uC\"A\u00111H!!\u0002\u0013\t\u0019$A\u0003eCR\f\u0007\u0005C\u0005\u0002@\u0005\u0013\r\u0011\"\u0001\u0002B\u0005aAO];ti\u0006s7\r[8sgV\u0011\u00111\t\t\u0007\u0003\u000b\nY%a\u0014\u000e\u0005\u0005\u001d#bAA%g\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u001b\n9E\u0001\u0003MSN$\b\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005UC!\u0001\u0004n_\u0012,Gn]\u0005\u0005\u00033\n\u0019FA\u0006UeV\u001cH/\u00118dQ>\u0014\b\u0002CA/\u0003\u0002\u0006I!a\u0011\u0002\u001bQ\u0014Xo\u001d;B]\u000eDwN]:!\u0011%\t\t'\u0011b\u0001\n\u0003\t\u0019'\u0001\u0003s_\u0006\u001cXCAA3!\u0011\t\t&a\u001a\n\t\u0005%\u00141\u000b\u0002\u0011-\u0006d\u0017\u000eZ1uK\u0012|%M[3diND\u0001\"!\u001cBA\u0003%\u0011QM\u0001\u0006e>\f7\u000f\t\u0005\b\u0003c\nE\u0011IA\f\u0003Q!(/^:uK\u0012\u001cUM\u001d;t\u0019>\u001c\u0017\r^5p]\"I\u0011QO!C\u0002\u0013\u0005\u0011qO\u0001\u0010kN,'\u000f\u0015:fM\u0016\u0014XM\\2fgV\u0011\u0011\u0011\u0010\t\u0005U>\fY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t\tB\u0001\u0004Y&\u0014\u0017\u0002BAC\u0003\u007f\u0012q\"V:feB\u0013XMZ3sK:\u001cWm\u001d\u0005\t\u0003\u0013\u000b\u0005\u0015!\u0003\u0002z\u0005\u0001Ro]3s!J,g-\u001a:f]\u000e,7\u000f\t\u0005\n\u0003\u001b\u000b%\u0019!C\u0001\u0003\u001f\u000bACY4q%&\u001cH)^7q\t><h\u000e\\8bI\u0016\u0014XCAAI!\rA\u00181S\u0005\u0004\u0003+K(\u0001\u0006\"haJK7\u000fR;na\u0012{wO\u001c7pC\u0012,'\u000f\u0003\u0005\u0002\u001a\u0006\u0003\u000b\u0011BAI\u0003U\u0011w\r\u001d*jg\u0012+X\u000e\u001d#po:dw.\u00193fe\u0002B\u0011\"!(B\u0005\u0004%\t!a(\u0002\u00175,Wn\u001c:z\u00136\fw-Z\u000b\u0003\u0003C\u0003BA[8\u0002$B\u0019a\"!*\n\u0007\u0005\u001d&AA\u0006NK6|'/_%nC\u001e,\u0007\u0002CAV\u0003\u0002\u0006I!!)\u0002\u00195,Wn\u001c:z\u00136\fw-\u001a\u0011\t\u000f\u0005=\u0016\t\"\u0001\u00022\u0006\tR\u000f\u001d3bi\u0016lU-\\8ss&k\u0017mZ3\u0015\t\u0005M\u0016q\u0018\u000b\u0004[\u0005U\u0006\u0002CA\\\u0003[\u0003\u001d!!/\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\t\u0004U\u0006m\u0016bAA_W\nAQ*Y=cKRCh\u000e\u0003\u0005\u0002B\u00065\u0006\u0019AAb\u0003\u00051\u0007cB\n\u0002F\u0006\r\u00161U\u0005\u0004\u0003\u000f$\"!\u0003$v]\u000e$\u0018n\u001c82\u0011%\tY-\u0011b\u0001\n\u0003\ti-A\u0005siJ\u001cVM\u001d<feV\u0011\u0011q\u001a\t\u0004A\u0005E\u0017bAAjC\tI!\u000b\u0016*TKJ4XM\u001d\u0005\t\u0003/\f\u0005\u0015!\u0003\u0002P\u0006Q!\u000f\u001e:TKJ4XM\u001d\u0011\t\u000f\u0005m\u0017\t\"\u0003\u0002^\u0006\u0001Bn\\1e)J,8\u000f^!oG\"|'o\u001d\u000b\u0003\u0003?\u0004B!!\u0015\u0002b&!\u00111]A*\u00051!&/^:u\u0003:\u001c\u0007n\u001c:t\u0011\u001d\t9/\u0011C\u0005\u0003S\fqB]3ge\u0016\u001c\bNU5t\tVl\u0007o\u001d\u000b\u0002[!9\u0011Q^!\u0005\n\u0005%\u0018\u0001\u0004:v]Z\u000bG.\u001b3bi>\u0014\bbBAw\u0003\u0012%\u0011\u0011\u001f\u000b\u0004[\u0005M\b\u0002CA{\u0003_\u0004\r!a>\u0002!Q\u0014Xo\u001d;B]\u000eDwN\u001d(b[\u0016\u001c\b#BA}\u0003\u007f,dbA\u001c\u0002|&\u0019\u0011Q \u000b\u0002\u000fA\f7m[1hK&\u0019aO!\u0001\u000b\u0007\u0005uH\u0003C\u0004\u0003\u0006\u0005#I!!;\u0002\u0019I,hnV3c'\u0016\u0014h/\u001a:\t\u000f\t%\u0011\t\"\u0003\u0003\f\u0005a!/\u001e8SiJ\u001cVM\u001d<feR\u0011\u0011q\u001a\u0005\b\u0005\u001f\tE\u0011\u0002B\t\u0003\u0015\u0019X\r^;q)\u0011\u0011\u0019Ba\u000b\u0011\t\tU!qE\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u000511/\u001a:wKJTAA!\b\u0003 \u0005)!.\u001a;us*!!\u0011\u0005B\u0012\u0003\u001d)7\r\\5qg\u0016T!A!\n\u0002\u0007=\u0014x-\u0003\u0003\u0003*\t]!AB*feZ,'\u000f\u0003\u0005\u0003\u001a\t5\u0001\u0019\u0001B\n\u0011\u001d\u0011y#\u0011C\u0005\u0003S\f!c^5qKJ\u001b\u0018P\\2ESN\\7)Y2iK\u0002")
public class Main
implements Http,
Logging {
    private final ActorSystem actorSystem;
    private final long startedAt;
    private final Ref<Seq<BgpRisDump>> bgpRisDumps;
    private final BgpAnnouncementValidator bgpAnnouncementValidator;
    private final File dataFile;
    private final PersistentData data;
    private final List<TrustAnchor> trustAnchors;
    private final ValidatedObjects roas;
    private final Ref<UserPreferences> userPreferences;
    private final BgpRisDumpDownloader bgpRisDumpDownloader;
    private final Ref<MemoryImage> memoryImage;
    private final RTRServer rtrServer;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private final KeyStore net$ripe$rpki$validator$config$Http$$customKeyStore;
    private final X509Certificate[] net$ripe$rpki$validator$config$Http$$systemTrustedCertificates;
    private final RequestConfig net$ripe$rpki$validator$config$Http$$httpRequestConfig;
    private final SSLContext net$ripe$rpki$validator$config$Http$$customSslContext;
    private final CloseableHttpClient net$ripe$rpki$validator$config$Http$$httpClient;
    private volatile boolean bitmap$0;

    public static void main(String[] stringArray) {
        Main$.MODULE$.main(stringArray);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Main main = this;
        synchronized (main) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    @Override
    public KeyStore net$ripe$rpki$validator$config$Http$$customKeyStore() {
        return this.net$ripe$rpki$validator$config$Http$$customKeyStore;
    }

    @Override
    public X509Certificate[] net$ripe$rpki$validator$config$Http$$systemTrustedCertificates() {
        return this.net$ripe$rpki$validator$config$Http$$systemTrustedCertificates;
    }

    @Override
    public RequestConfig net$ripe$rpki$validator$config$Http$$httpRequestConfig() {
        return this.net$ripe$rpki$validator$config$Http$$httpRequestConfig;
    }

    @Override
    public SSLContext net$ripe$rpki$validator$config$Http$$customSslContext() {
        return this.net$ripe$rpki$validator$config$Http$$customSslContext;
    }

    @Override
    public CloseableHttpClient net$ripe$rpki$validator$config$Http$$httpClient() {
        return this.net$ripe$rpki$validator$config$Http$$httpClient;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customKeyStore_$eq(KeyStore x$1) {
        this.net$ripe$rpki$validator$config$Http$$customKeyStore = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$systemTrustedCertificates_$eq(X509Certificate[] x$1) {
        this.net$ripe$rpki$validator$config$Http$$systemTrustedCertificates = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpRequestConfig_$eq(RequestConfig x$1) {
        this.net$ripe$rpki$validator$config$Http$$httpRequestConfig = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customSslContext_$eq(SSLContext x$1) {
        this.net$ripe$rpki$validator$config$Http$$customSslContext = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpClient_$eq(CloseableHttpClient x$1) {
        this.net$ripe$rpki$validator$config$Http$$httpClient = x$1;
    }

    @Override
    public CloseableHttpClient http() {
        return Http$class.http(this);
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public long startedAt() {
        return this.startedAt;
    }

    public Ref<Seq<BgpRisDump>> bgpRisDumps() {
        return this.bgpRisDumps;
    }

    public BgpAnnouncementValidator bgpAnnouncementValidator() {
        return this.bgpAnnouncementValidator;
    }

    public File dataFile() {
        return this.dataFile;
    }

    public PersistentData data() {
        return this.data;
    }

    public List<TrustAnchor> trustAnchors() {
        return this.trustAnchors;
    }

    public ValidatedObjects roas() {
        return this.roas;
    }

    @Override
    public File trustedCertsLocation() {
        return ApplicationOptions$.MODULE$.trustedSslCertsLocation();
    }

    public Ref<UserPreferences> userPreferences() {
        return this.userPreferences;
    }

    public BgpRisDumpDownloader bgpRisDumpDownloader() {
        return this.bgpRisDumpDownloader;
    }

    public Ref<MemoryImage> memoryImage() {
        return this.memoryImage;
    }

    public void updateMemoryImage(Function1<MemoryImage, MemoryImage> f, MaybeTxn transaction) {
        package$.MODULE$.atomic().apply((Function1)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Function1 f$1;

            public final void apply(InTxn transaction) {
                int oldVersion = ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version();
                this.$outer.memoryImage().transform(this.f$1, (Object)transaction);
                if (oldVersion != ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version()) {
                    this.$outer.bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)((Seq)((TraversableLike)this.$outer.bgpRisDumps().apply((Object)transaction)).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<BgpAnnouncement> apply(BgpRisDump x$2) {
                            return x$2.announcedRoutes();
                        }
                    }, Seq$.MODULE$.canBuildFrom())), (Seq<RtrPrefix>)((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes().toSeq());
                    this.$outer.rtrServer().notify(((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        }, transaction);
    }

    public RTRServer rtrServer() {
        return this.rtrServer;
    }

    private TrustAnchors loadTrustAnchors() {
        Collection tals = FileUtils.listFiles((File)ApplicationOptions$.MODULE$.talDirLocation(), (String[])((String[])((Object[])new String[]{"tal"})), (boolean)false);
        return TrustAnchors$.MODULE$.load((Seq<File>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tals).asScala()).toSeq());
    }

    public void net$ripe$rpki$validator$config$Main$$refreshRisDumps() {
        Future$.MODULE$.traverse((TraversableOnce)this.bgpRisDumps().single().get(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Future<BgpRisDump> apply(BgpRisDump dump) {
                return this.$outer.bgpRisDumpDownloader().download(dump, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.actorSystem().dispatcher()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply(Seq<BgpRisDump> dumps) {
                package$.MODULE$.atomic().apply((Function1)new Serializable(this, dumps){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$refreshRisDumps$2 $outer;
                    private final Seq dumps$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpRisDumps().update((Object)this.dumps$1, (Object)transaction);
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)((Seq)this.dumps$1.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<BgpAnnouncement> apply(BgpRisDump x$3) {
                                return x$3.announcedRoutes();
                            }
                        }, Seq$.MODULE$.canBuildFrom())), (Seq<RtrPrefix>)((MemoryImage)this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes().toSeq());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dumps$1 = dumps$1;
                    }
                }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator() {
        DateTime now = new DateTime();
        List needUpdating = (List)((TraversableLike)((MemoryImage)this.memoryImage().single().get()).trustAnchors().all().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrustAnchor ta) {
                return ta.status().isIdle();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TrustAnchor, Idle> apply(TrustAnchor ta) {
                ProcessingStatus processingStatus = ta.status();
                if (processingStatus instanceof Idle) {
                    Tuple2 tuple2;
                    Idle idle = (Idle)processingStatus;
                    DateTime nextUpdate = idle.nextUpdate();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)idle, (Object)nextUpdate);
                    Idle x$4 = (Idle)tuple22._1();
                    DateTime nextUpdate2 = (DateTime)tuple22._2();
                    return new Tuple2((Object)ta, (Object)x$4);
                }
                throw new MatchError((Object)processingStatus);
            }
        }, List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final DateTime now$1;

            public final boolean apply(Tuple2<TrustAnchor, Idle> x$6) {
                Idle idle;
                Tuple2<TrustAnchor, Idle> tuple2 = x$6;
                if (tuple2 != null && (idle = (Idle)tuple2._2()) != null) {
                    DateTime nextUpdate = idle.nextUpdate();
                    boolean bl = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nextUpdate, (Ordering)DateAndTime$DateTimeOrdering$.MODULE$).$less$eq((Object)this.now$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.now$1 = now$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TrustAnchor, Idle> x$7) {
                Tuple2<TrustAnchor, Idle> tuple2 = x$7;
                if (tuple2 != null) {
                    TrustAnchor ta = (TrustAnchor)tuple2._1();
                    Idle idle = (Idle)tuple2._2();
                    if (idle != null) {
                        String string = ta.name();
                        return string;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom());
        this.net$ripe$rpki$validator$config$Main$$runValidator((Seq<String>)needUpdating);
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator(Seq<String> trustAnchorNames) {
        int maxStaleDays = ((UserPreferences)this.userPreferences().single().get()).maxStaleDays();
        List<TrustAnchor> trustAnchors = ((MemoryImage)this.memoryImage().single().get()).trustAnchors().all();
        Seq taLocators = (Seq)trustAnchorNames.flatMap((Function1)new Serializable(this, trustAnchors){
            public static final long serialVersionUID = 0L;
            private final List trustAnchors$1;

            public final Iterable<TrustAnchor> apply(String name) {
                return Option$.MODULE$.option2Iterable(this.trustAnchors$1.find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(TrustAnchor x$8) {
                        String string = x$8.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }));
            }
            {
                this.trustAnchors$1 = trustAnchors$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        taLocators.foreach((Function1)new Serializable(this, maxStaleDays){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            public final int maxStaleDays$1;

            public final Future<BoxedUnit> apply(TrustAnchor trustAnchorLocator) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, trustAnchorLocator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 $outer;
                    public final TrustAnchor trustAnchorLocator$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        TrackValidationProcess process = new TrackValidationProcess(this){
                            private final Ref<MemoryImage> memoryImage;
                            private volatile ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            private ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() {
                                $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$$anon$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if (this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module != null) return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                    this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module = new ValidationProcessLogger$ObjectFetcherLogger$(this);
                                    return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                }
                            }

                            public final ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger() {
                                return this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module == null ? this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() : this.net$ripe$rpki$validator$models$ValidationProcessLogger$$ObjectFetcherLogger$module;
                            }

                            public Seq net$ripe$rpki$validator$models$ValidationProcessLogger$$super$objectFetcherListeners() {
                                return ValidationProcess$class.objectFetcherListeners(this);
                            }

                            public Map net$ripe$rpki$validator$models$ValidationProcessLogger$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return TrackValidationProcess$class.validateObjects(this, certificate);
                            }

                            public PartialFunction net$ripe$rpki$validator$models$ValidationProcessLogger$$super$exceptionHandler() {
                                return ValidationProcess$class.exceptionHandler(this);
                            }

                            public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
                                return ValidationProcessLogger$class.objectFetcherListeners(this);
                            }

                            public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return ValidationProcessLogger$class.validateObjects(this, certificate);
                            }

                            public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
                                return ValidationProcessLogger$class.exceptionHandler(this);
                            }

                            public Validation net$ripe$rpki$validator$models$TrackValidationProcess$$super$runProcess() {
                                return ValidationProcess$class.runProcess(this);
                            }

                            public Map net$ripe$rpki$validator$models$TrackValidationProcess$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate) {
                                return super.validateObjects(certificate);
                            }

                            public Validation<String, Map<URI, ValidatedObject>> runProcess() {
                                return TrackValidationProcess$class.runProcess(this);
                            }

                            public Ref<MemoryImage> memoryImage() {
                                return this.memoryImage;
                            }
                            {
                                super($outer.trustAnchorLocator$1.locator(), $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().maxStaleDays$1, ApplicationOptions$.MODULE$.workDirLocation(), ApplicationOptions$.MODULE$.rsyncDirLocation(), $outer.trustAnchorLocator$1.name(), ApplicationOptions$.MODULE$.enableLooseValidation());
                                TrackValidationProcess$class.$init$(this);
                                ValidationProcessLogger$class.$init$(this);
                                this.memoryImage = $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage();
                            }
                        };
                        try {
                            Validation<String, Map<URI, ValidatedObject>> validation;
                            block8: {
                                block7: {
                                    block6: {
                                        validation = ((TrackValidationProcess)process).runProcess();
                                        if (!(validation instanceof Success)) break block6;
                                        Success success = (Success)validation;
                                        Map validatedObjectsByUri = (Map)success.a();
                                        Seq validatedObjects = validatedObjectsByUri.values().toSeq();
                                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this, validatedObjects){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1 $outer;
                                            private final Seq validatedObjects$1;

                                            public final MemoryImage apply(MemoryImage x$9) {
                                                return x$9.updateValidatedObjects(this.$outer.trustAnchorLocator$1.locator(), (Seq<ValidatedObject>)this.validatedObjects$1);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.validatedObjects$1 = validatedObjects$1;
                                            }
                                        }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block7;
                                    }
                                    if (!(validation instanceof Failure)) break block8;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new MatchError(validation);
                        }
                        finally {
                            ((TrustAnchorValidationProcess)((Object)process)).shutdown();
                        }
                    }

                    public /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.trustAnchorLocator$1 = trustAnchorLocator$1;
                    }
                }, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.maxStaleDays$1 = maxStaleDays$1;
            }
        });
    }

    private void runWebServer() {
        Server server = this.setup(new Server(ApplicationOptions$.MODULE$.httpPort()));
        scala.sys.package$.MODULE$.addShutdownHook((Function0)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Server server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.stop();
                this.$outer.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Terminating...";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.server$1 = server$1;
            }
        });
        server.start();
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Welcome to the RIPE NCC RPKI Validator, now available on port ").append((Object)BoxesRunTime.boxToInteger((int)ApplicationOptions$.MODULE$.httpPort())).append((Object)". Hit CTRL+C to terminate.").toString();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private RTRServer runRtrServer() {
        void var1_1;
        RTRServer rtrServer = new RTRServer(ApplicationOptions$.MODULE$.rtrPort(), ApplicationOptions$.MODULE$.rtrCloseOnError(), ApplicationOptions$.MODULE$.rtrSendNotify(), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).version();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Set<RtrPrefix>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Set<RtrPrefix> apply() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return Main$.MODULE$.net$ripe$rpki$validator$config$Main$$sessionId();
            }
        }, (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors().hasEnabledAnchors();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.actorSystem());
        rtrServer.startServer();
        return var1_1;
    }

    private Server setup(Server server) {
        WebFilter webFilter = new WebFilter(this){
            private final Object dataFileLock;
            private final /* synthetic */ Main $outer;

            private Object dataFileLock() {
                return this.dataFileLock;
            }

            private void updateAndPersist(Function1<InTxn, BoxedUnit> f) {
                Object object = this.dataFileLock();
                synchronized (object) {
                    Tuple2 tuple2 = (Tuple2)package$.MODULE$.atomic().apply((Function1)new $anon$1$$anonfun$17(this, f), (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        MemoryImage image = (MemoryImage)tuple2._1();
                        UserPreferences userPreferences = (UserPreferences)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)image, (Object)userPreferences);
                        MemoryImage image2 = (MemoryImage)tuple23._1();
                        UserPreferences userPreferences2 = (UserPreferences)tuple23._2();
                        Filters x$23 = image2.filters();
                        Whitelist x$24 = image2.whitelist();
                        UserPreferences x$25 = userPreferences2;
                        Map x$26 = (Map)image2.trustAnchors().all().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, TrustAnchorData> apply(TrustAnchor ta) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ta.name()), (Object)new TrustAnchorData(ta.enabled()));
                            }
                        }, scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
                        int x$27 = PersistentData$.MODULE$.apply$default$1();
                        PersistentDataSerialiser$.MODULE$.write(new PersistentData(x$27, x$23, x$24, x$25, (Map<String, TrustAnchorData>)x$26), this.$outer.dataFile());
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }

            public void startTrustAnchorValidation(Seq<String> trustAnchors) {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator(trustAnchors);
            }

            public TrustAnchors trustAnchors() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors();
            }

            public ValidatedObjects validatedObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).validatedObjects();
            }

            public Filters filters() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).filters();
            }

            public void addFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$11) {
                                return x$11.addFilter(this.$outer.filter$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$1 = filter$1;
                    }
                });
            }

            public void removeFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$12) {
                                return x$12.removeFilter(this.$outer.filter$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$2 = filter$2;
                    }
                });
            }

            public Whitelist whitelist() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).whitelist();
            }

            public void addWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$13) {
                                return x$13.addWhitelistEntry(this.$outer.entry$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                });
            }

            public void removeWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$14) {
                                return x$14.removeWhitelistEntry(this.$outer.entry$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$2 = entry$2;
                    }
                });
            }

            public Seq<BgpRisDump> bgpRisDumps() {
                return (Seq)this.$outer.bgpRisDumps().single().get();
            }

            public IndexedSeq<BgpValidatedAnnouncement> validatedAnnouncements() {
                return this.$outer.bgpAnnouncementValidator().validatedAnnouncements();
            }

            public Set<RtrPrefix> getRtrPrefixes() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }

            public Iterable<RtrSessionData> sessionData() {
                return this.$outer.rtrServer().rtrSessions().allClientData();
            }

            public OnlineNewVersionDetailFetcher newVersionDetailFetcher() {
                return new OnlineNewVersionDetailFetcher(ReleaseInfo$.MODULE$.version(), (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final String apply() {
                        HttpGet get = new HttpGet("https://lirportal.ripe.net/certification/content/static/validator/latest-version.properties");
                        CloseableHttpResponse response = this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().http().execute((HttpUriRequest)get);
                        return Source$.MODULE$.fromInputStream(response.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public UserPreferences userPreferences() {
                return (UserPreferences)this.$outer.userPreferences().single().get();
            }

            public void updateUserPreferences(UserPreferences userPreferences) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, userPreferences){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    private final UserPreferences userPreferences$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().userPreferences().set((Object)this.userPreferences$1, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userPreferences$1 = userPreferences$1;
                    }
                });
            }

            public void updateTrustAnchorState(TrustAnchorLocator locator, boolean enabled) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, locator, enabled){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final TrustAnchorLocator locator$1;
                    public final boolean enabled$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().memoryImage().transform((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$updateTrustAnchorState$1 $outer;

                            public final MemoryImage apply(MemoryImage x$15) {
                                return x$15.updateTrustAnchorState(this.$outer.locator$1, this.$outer.enabled$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                        this.enabled$1 = enabled$1;
                    }
                });
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataFileLock = new Object();
            }
        };
        RestApi restApiServlet = new RestApi(this){
            private final /* synthetic */ Main $outer;

            public Set<RtrPrefix> getVrpObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/", 1);
        root.setResourceBase(this.getClass().getResource("/public").toString());
        ServletHolder defaultServletHolder = new ServletHolder((Servlet)new DefaultServlet());
        defaultServletHolder.setName("default");
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        root.addServlet(defaultServletHolder, "/*");
        root.addServlet(new ServletHolder((Servlet)restApiServlet), "/api/*");
        root.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks$.MODULE$.registry())), "/health");
        root.addFilter(new FilterHolder((Filter)webFilter), "/*", EnumSet.allOf(DispatcherType.class));
        RequestLogHandler handler = new RequestLogHandler();
        NCSARequestLog requestLog = new NCSARequestLog(ApplicationOptions$.MODULE$.accessLogFileName());
        requestLog.setRetainDays(90);
        requestLog.setAppend(true);
        requestLog.setExtended(false);
        requestLog.setLogLatency(true);
        handler.setRequestLog((RequestLog)requestLog);
        RequestLogHandler requestLogHandler = handler;
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)root);
        handlers.addHandler((Handler)requestLogHandler);
        server.setHandler((Handler)handlers);
        return server;
    }

    private void wipeRsyncDiskCache() {
        File diskCache = new File(ApplicationOptions$.MODULE$.rsyncDirLocation());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    public Main() {
        Http$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.actorSystem = ActorSystem$.MODULE$.apply();
        this.startedAt = System.currentTimeMillis();
        this.bgpRisDumps = Ref$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpRisDump[]{new BgpRisDump("http://www.ris.ripe.net/dumps/riswhoisdump.IPv4.gz", BgpRisDump$.MODULE$.apply$default$2(), BgpRisDump$.MODULE$.apply$default$3()), new BgpRisDump("http://www.ris.ripe.net/dumps/riswhoisdump.IPv6.gz", BgpRisDump$.MODULE$.apply$default$2(), BgpRisDump$.MODULE$.apply$default$3())})), (OptManifest)ClassManifestFactory$.MODULE$.classType(Seq.class, (OptManifest)ClassManifestFactory$.MODULE$.classType(BgpRisDump.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])));
        this.bgpAnnouncementValidator = new BgpAnnouncementValidator(this.actorSystem());
        this.dataFile = ApplicationOptions$.MODULE$.dataFileLocation();
        this.data = (PersistentData)PersistentDataSerialiser$.MODULE$.read(this.dataFile()).getOrElse((Function0)new $anonfun$7(this));
        this.trustAnchors = (List)this.loadTrustAnchors().all().map((Function1)new $anonfun$8(this), List$.MODULE$.canBuildFrom());
        this.roas = ValidatedObjects$.MODULE$.apply(new TrustAnchors((Seq<TrustAnchor>)((Seq)this.trustAnchors().filter((Function1)new $anonfun$10(this)))));
        this.userPreferences = Ref$.MODULE$.apply((Object)this.data().userPreferences(), (OptManifest)ClassManifestFactory$.MODULE$.classType(UserPreferences.class));
        this.bgpRisDumpDownloader = new BgpRisDumpDownloader((HttpClient)this.http());
        this.memoryImage = Ref$.MODULE$.apply((Object)new MemoryImage(this.data().filters(), this.data().whitelist(), new TrustAnchors((Seq<TrustAnchor>)this.trustAnchors()), this.roas(), MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class));
        this.wipeRsyncDiskCache();
        this.rtrServer = this.runRtrServer();
        this.runWebServer();
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).hours(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$refreshRisDumps();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }
}

