/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ApplicationOptions$ {
    public static final ApplicationOptions$ MODULE$;
    private Logger logger;
    private final Config net$ripe$rpki$validator$config$ApplicationOptions$$config;
    private final FiniteDuration net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval;
    private FiniteDuration validationInterval;
    private volatile byte bitmap$0;

    static {
        new ApplicationOptions$();
    }

    private Logger logger$lzycompute() {
        ApplicationOptions$ applicationOptions$ = this;
        synchronized (applicationOptions$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ApplicationOptions$.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    private FiniteDuration validationInterval$lzycompute() {
        ApplicationOptions$ applicationOptions$ = this;
        synchronized (applicationOptions$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                FiniteDuration finiteDuration;
                FiniteDuration interval = FiniteDuration$.MODULE$.apply(this.net$ripe$rpki$validator$config$ApplicationOptions$$config().getDuration("validation.interval", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                if (interval.$less((Object)this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval())) {
                    this.logger().warn((Function0)new Serializable(interval){
                        public static final long serialVersionUID = 0L;
                        private final FiniteDuration interval$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation interval ", " is too short; using ", " instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.interval$1, ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval()}));
                        }
                        {
                            this.interval$1 = interval$1;
                        }
                    });
                    finiteDuration = this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval();
                } else {
                    finiteDuration = interval;
                }
                this.validationInterval = finiteDuration;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.validationInterval;
        }
    }

    private Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public Config net$ripe$rpki$validator$config$ApplicationOptions$$config() {
        return this.net$ripe$rpki$validator$config$ApplicationOptions$$config;
    }

    public FiniteDuration net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval() {
        return this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval;
    }

    public int httpPort() {
        return BoxesRunTime.unboxToInt(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getInt(x$1);
            }
        }, "ui.http.port"));
    }

    public boolean httpKioskEnabled() {
        return BoxesRunTime.unboxToBoolean(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getBoolean(x$1);
            }
        }, "ui.kiosk.enable"));
    }

    public String httpKioskUser() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "ui.kiosk.user");
    }

    public String httpKioskPass() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "ui.kiosk.pass");
    }

    public FiniteDuration validationInterval() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.validationInterval$lzycompute() : this.validationInterval;
    }

    public int rtrPort() {
        return BoxesRunTime.unboxToInt(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getInt(x$1);
            }
        }, "rtr.port"));
    }

    public boolean rtrCloseOnError() {
        return BoxesRunTime.unboxToBoolean(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getBoolean(x$1);
            }
        }, "rtr.close-on-error"));
    }

    public boolean rtrSendNotify() {
        return BoxesRunTime.unboxToBoolean(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getBoolean(x$1);
            }
        }, "rtr.send-notify"));
    }

    public File net$ripe$rpki$validator$config$ApplicationOptions$$resolveFile(String path, String fileName) {
        return new File(new StringBuilder().append((Object)path).append((Object)File.separator).append((Object)fileName).toString());
    }

    public File dataFileLocation() {
        return (File)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String s) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$resolveFile(ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(s), "data.json");
            }
        }, "locations.datadir");
    }

    public File talDirLocation() {
        return (File)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String s) {
                return new File(ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(s));
            }
        }, "locations.taldir");
    }

    public File trustedSslCertsLocation() {
        return (File)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String s) {
                return new File(ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(s));
            }
        }, "locations.trusted.ssl.dir");
    }

    public File workDirLocation() {
        return (File)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String s) {
                return new File(ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(s));
            }
        }, "locations.workdir");
    }

    public String rsyncDirLocation() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "locations.rsyncdir");
    }

    public String applicationLogFileName() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "logging.application.file");
    }

    public String rtrLogFileName() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "logging.rtr.file");
    }

    public String accessLogFileName() {
        return (String)this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getString(x$1);
            }
        }, "logging.access.file");
    }

    public boolean enableLooseValidation() {
        return BoxesRunTime.unboxToBoolean(this.safeConf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return ApplicationOptions$.MODULE$.net$ripe$rpki$validator$config$ApplicationOptions$$config().getBoolean(x$1);
            }
        }, "validation.loose"));
    }

    private <T> T safeConf(Function1<String, T> f, String name) {
        try {
            return (T)f.apply((Object)name);
        }
        catch (Throwable throwable) {
            this.logger().error((Function0)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Couldn't extract property ").append((Object)this.name$1).toString();
                }
                {
                    this.name$1 = name$1;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw throwable;
        }
    }

    private ApplicationOptions$() {
        MODULE$ = this;
        this.net$ripe$rpki$validator$config$ApplicationOptions$$config = ConfigFactory.load();
        this.net$ripe$rpki$validator$config$ApplicationOptions$$minimumValidationInterval = new package.DurationInt(package$.MODULE$.DurationInt(10)).minutes();
    }
}

