/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.views;

import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchorValidations;
import net.ripe.rpki.validator.models.TrustAnchorValidations$;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.ValidatedObjectsTest$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.testing.TestingObjectMother$;
import net.ripe.rpki.validator.views.TrustAnchorMonitorView;
import net.ripe.rpki.validator.views.TrustAnchorMonitorView$;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001b\tQBK];ti\u0006s7\r[8s\u001b>t\u0017\u000e^8s-&,w\u000fV3ti*\u00111\u0001B\u0001\u0006m&,wo\u001d\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011aB:vaB|'\u000f^\u0005\u0003'A\u0011\u0011CV1mS\u0012\fGo\u001c:UKN$8)Y:f!\t)B$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003n_\u000e\\'BA\r\u001b\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u001c\u0003\ry'oZ\u0005\u0003;Y\u0011A\"T8dW&$xnU;hCJDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002)\t\u0001!C&\f\t\u0003K)j\u0011A\n\u0006\u0003O!\naA];o]\u0016\u0014(BA\u0015\u001b\u0003\u0015QWO\\5u\u0013\tYcEA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u00039\u0002\"aL\u0019\u000e\u0003AR!!\u000b\r\n\u0005I\u0002$a\u0003&V]&$(+\u001e8oKJ\u0004")
public class TrustAnchorMonitorViewTest
extends ValidatorTestCase
implements MockitoSugar {
    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public TrustAnchorMonitorViewTest() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.test("Should not raise alert for invalid object fraction when validated object count == 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorMonitorViewTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TrustAnchorValidations taValidations = new TrustAnchorValidations(TrustAnchorValidations$.MODULE$.apply$default$1(), TrustAnchorValidations$.MODULE$.apply$default$2());
                TrustAnchorMonitorView subject = new TrustAnchorMonitorView(TestingObjectMother$.MODULE$.TA(), taValidations, TrustAnchorMonitorView$.MODULE$.$lessinit$greater$default$3());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)subject.hasTooHighErrorFraction())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not raise alert for invalid object fraction when less then 10% errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorMonitorViewTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq validatedObjects = (IndexedSeq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom());
                TrustAnchorValidations taValidations = new TrustAnchorValidations((Seq)validatedObjects, TrustAnchorValidations$.MODULE$.apply$default$2());
                TrustAnchorMonitorView subject = new TrustAnchorMonitorView(TestingObjectMother$.MODULE$.TA(), taValidations, TrustAnchorMonitorView$.MODULE$.$lessinit$greater$default$3());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)subject.hasTooHighErrorFraction())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should raise alert for invalid object fraction when 10% or more errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorMonitorViewTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq validatedObjects = (IndexedSeq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(9).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom());
                TrustAnchorValidations taValidations = new TrustAnchorValidations((Seq)validatedObjects, TrustAnchorValidations$.MODULE$.apply$default$2());
                TrustAnchorMonitorView subject = new TrustAnchorMonitorView(TestingObjectMother$.MODULE$.TA(), taValidations, TrustAnchorMonitorView$.MODULE$.$lessinit$greater$default$3());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)subject.hasTooHighErrorFraction())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should raise alert when object drop seen", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorMonitorViewTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(new TrustAnchors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{TestingObjectMother$.MODULE$.TA()}))));
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                TrustAnchorMonitorView subject = new TrustAnchorMonitorView(TestingObjectMother$.MODULE$.TA(), (TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get(), TrustAnchorMonitorView$.MODULE$.$lessinit$greater$default$3());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)subject.hasUnexpectedDrop())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

