/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.HttpFetcherStore;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u001b\t!\u0002\n\u001e;q\r\u0016$8\r[3s'R|'/\u001a+fgRT!a\u0001\u0003\u0002\u000bM$xN]3\u000b\u0005\u00151\u0011!\u0003<bY&$\u0017\r^8s\u0015\t9\u0001\"\u0001\u0003sa.L'BA\u0005\u000b\u0003\u0011\u0011\u0018\u000e]3\u000b\u0003-\t1A\\3u\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\t\tB!A\u0004tkB\u0004xN\u001d;\n\u0005M\u0001\"!\u0005,bY&$\u0017\r^8s)\u0016\u001cHoQ1tKB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\ng\u000e\fG.\u0019;fgRT\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0017\u00059\u0011UMZ8sK\u0006sG-\u00114uKJDQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000f\r\u0001!\u0019!C\u0001EU\t1\u0005\u0005\u0002!I%\u0011QE\u0001\u0002\u0011\u0011R$\bOR3uG\",'o\u0015;pe\u0016Daa\n\u0001!\u0002\u0013\u0019\u0013AB:u_J,\u0007\u0005\u000b\u0003\u0001SE\u0012\u0004C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0019\u0011XO\u001c8fe*\u0011a\u0006G\u0001\u0006UVt\u0017\u000e^\u0005\u0003a-\u0012qAU;o/&$\b.A\u0003wC2,XmI\u00014!\t!d'D\u00016\u0015\tqc#\u0003\u00028k\tY!*\u00168jiJ+hN\\3s\u0001")
public class HttpFetcherStoreTest
extends ValidatorTestCase
implements BeforeAndAfter {
    private final HttpFetcherStore store;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public HttpFetcherStore store() {
        return this.store;
    }

    public HttpFetcherStoreTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.store = new HttpFetcherStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a serial and get it back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI url = new URI("http://bla.bla");
                String sessionId = "aec41310-67e1-429b-9d1b-df30961e9932";
                BigInt serial = package$.MODULE$.BigInt().apply(100);
                this.$outer.store().storeSerial(url, sessionId, serial);
                Option s = this.$outer.store().getSerial(url, sessionId);
                this.$outer.convertToAnyShouldWrapper(s).should(this.$outer.be().apply((Object)new Some((Object)serial)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a really big serial number and get it back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI url = new URI("http://bla.bla");
                String sessionId = "aec41310-67e1-429b-9d1b-df30961e9932";
                BigInt serial = package$.MODULE$.BigInt().apply(Long.MAX_VALUE).$times(BigInt$.MODULE$.int2bigInt(10));
                this.$outer.store().storeSerial(url, sessionId, serial);
                Option s = this.$outer.store().getSerial(url, sessionId);
                this.$outer.convertToAnyShouldWrapper(s).should(this.$outer.be().apply((Object)new Some((Object)serial)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a serial, updates it and get back the latest one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI url = new URI("http://bla.bla");
                String sessionId = "aec41310-67e1-429b-9d1b-df30961e9932";
                BigInt serial1 = package$.MODULE$.BigInt().apply(100);
                BigInt serial2 = package$.MODULE$.BigInt().apply(101);
                this.$outer.store().storeSerial(url, sessionId, serial1);
                this.$outer.convertToAnyShouldWrapper(this.$outer.store().getSerial(url, sessionId)).should(this.$outer.be().apply((Object)new Some((Object)serial1)));
                this.$outer.store().storeSerial(url, sessionId, serial2);
                this.$outer.convertToAnyShouldWrapper(this.$outer.store().getSerial(url, sessionId)).should(this.$outer.be().apply((Object)new Some((Object)serial2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

