/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CertificateObject$;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.CrlObject$;
import net.ripe.rpki.validator.models.validation.Hashing;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.ManifestObject$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.RoaObject;
import net.ripe.rpki.validator.models.validation.RoaObject$;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.CacheStoreTest$;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.apache.commons.dbcp.BasicDataSource;
import org.joda.time.Instant;
import org.junit.runner.RunWith;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Length$;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u00015\u0011abQ1dQ\u0016\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001a\u0005\u0003\u0001\u001dQa\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u001d\u0019X\u000f\u001d9peRL!a\u0005\t\u0003#Y\u000bG.\u001b3bi>\u0014H+Z:u\u0007\u0006\u001cX\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005I1oY1mCR,7\u000f\u001e\u0006\u00023\u0005\u0019qN]4\n\u0005m1\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n!B^1mS\u0012\fG/[8o\u0015\t\tC!\u0001\u0004n_\u0012,Gn]\u0005\u0003Gy\u0011q\u0001S1tQ&tw\rC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0005!9!\u0006\u0001b\u0001\n\u0013Y\u0013\u0001E7f[>\u0014\u0018\u0010R1uCN{WO]2f+\u0005a\u0003CA\u00175\u001b\u0005q#BA\u00181\u0003\u0011!'m\u00199\u000b\u0005E\u0012\u0014aB2p[6|gn\u001d\u0006\u0003ga\ta!\u00199bG\",\u0017BA\u001b/\u0005=\u0011\u0015m]5d\t\u0006$\u0018mU8ve\u000e,\u0007BB\u001c\u0001A\u0003%A&A\tnK6|'/\u001f#bi\u0006\u001cv.\u001e:dK\u0002Bqa\u0001\u0001C\u0002\u0013%\u0011(F\u0001;!\tA3(\u0003\u0002=\u0005\tQ1)Y2iKN#xN]3\t\ry\u0002\u0001\u0015!\u0003;\u0003\u0019\u0019Ho\u001c:fA!9\u0001\t\u0001b\u0001\n\u0003\t\u0015a\u0002;fgR\u001c%\u000f\\\u000b\u0002\u0005B\u00111)S\u0007\u0002\t*\u0011QIR\u0001\u0004GJd'BA$I\u0003\u0019\u0019'/\u001f9u_*\u0011\u0011GB\u0005\u0003\u0015\u0012\u0013q\u0001W\u001b1s\r\u0013H\u000e\u0003\u0004M\u0001\u0001\u0006IAQ\u0001\ti\u0016\u001cHo\u0011:mA!9a\n\u0001b\u0001\n\u0003y\u0015\u0001\u0004;fgRl\u0015M\\5gKN$X#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001C7b]&4Wm\u001d;\u000b\u0005U3\u0015aA2ng&\u0011qK\u0015\u0002\f\u001b\u0006t\u0017NZ3ti\u000ek7\u000f\u0003\u0004Z\u0001\u0001\u0006I\u0001U\u0001\u000ei\u0016\u001cH/T1oS\u001a,7\u000f\u001e\u0011\t\u000fm\u0003!\u0019!C\u00019\u00069A/Z:u%>\fW#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0016a\u0001:pC&\u0011!m\u0018\u0002\u0007%>\f7)\\:\t\r\u0011\u0004\u0001\u0015!\u0003^\u0003!!Xm\u001d;S_\u0006\u0004\u0003b\u00024\u0001\u0005\u0004%\taZ\u0001\u0010i\u0016\u001cHoQ3si&4\u0017nY1uKV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l\r\u0006A\u00010\u000e\u0019:G\u0016\u0014H/\u0003\u0002nU\n9\u0002,\u000e\u0019:%\u0016\u001cx.\u001e:dK\u000e+'\u000f^5gS\u000e\fG/\u001a\u0005\u0007_\u0002\u0001\u000b\u0011\u00025\u0002!Q,7\u000f^\"feRLg-[2bi\u0016\u0004\u0003\u0006\u0002\u0001rsj\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\rI,hN\\3s\u0015\t1\b$A\u0003kk:LG/\u0003\u0002yg\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%A>\u0011\u0005qtX\"A?\u000b\u0005Y4\u0012BA@~\u0005-QUK\\5u%Vtg.\u001a:")
public class CacheStoreTest
extends ValidatorTestCase
implements BeforeAndAfter,
Hashing {
    private final BasicDataSource memoryDataSource;
    private final CacheStore net$ripe$rpki$validator$store$CacheStoreTest$$store;
    private final X509Crl testCrl;
    private final ManifestCms testManifest;
    private final RoaCms testRoa;
    private final X509ResourceCertificate testCertificate;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public byte[] getHash(byte[] bytes) {
        return Hashing.class.getHash((Hashing)this, (byte[])bytes);
    }

    public String stringify(byte[] bytes) {
        return Hashing.class.stringify((Hashing)this, (byte[])bytes);
    }

    public Option<byte[]> parseBytes(String hex) {
        return Hashing.class.parseBytes((Hashing)this, (String)hex);
    }

    public boolean equals(byte[] hashA, byte[] hashB) {
        return Hashing.class.equals((Hashing)this, (byte[])hashA, (byte[])hashB);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    private BasicDataSource memoryDataSource() {
        return this.memoryDataSource;
    }

    public CacheStore net$ripe$rpki$validator$store$CacheStoreTest$$store() {
        return this.net$ripe$rpki$validator$store$CacheStoreTest$$store;
    }

    public X509Crl testCrl() {
        return this.testCrl;
    }

    public ManifestCms testManifest() {
        return this.testManifest;
    }

    public RoaCms testRoa() {
        return this.testRoa;
    }

    public X509ResourceCertificate testCertificate() {
        return this.testCertificate;
    }

    public CacheStoreTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        Hashing.class.$init$((Hashing)this);
        this.memoryDataSource = DataSources$.MODULE$.InMemoryDataSource();
        this.net$ripe$rpki$validator$store$CacheStoreTest$$store = new CacheStore((DataSource)this.memoryDataSource());
        this.testCrl = X509CrlTest.createCrl();
        this.testManifest = ManifestCmsTest.getRootManifestCms();
        this.testRoa = RoaCmsTest.getRoaCms();
        this.testCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a certificate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject certificate = new CertificateObject("rsync://bla", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                CertificateObject obj = (CertificateObject)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(certificate.hash())).get();
                this.$outer.convertToStringShouldWrapper(obj.url()).should(this.$outer.be().apply((Object)certificate.url()));
                this.$outer.convertToAnyShouldWrapper(obj.aki()).should(this.$outer.be().apply((Object)certificate.aki()));
                this.$outer.convertToAnyShouldWrapper(obj.ski()).should(this.$outer.be().apply((Object)certificate.ski()));
                this.$outer.convertToAnyShouldWrapper(obj.encoded()).should(this.$outer.be().apply((Object)certificate.encoded()));
                this.$outer.convertToAnyShouldWrapper(obj.hash()).should(this.$outer.be().apply((Object)certificate.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a crl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CrlObject crl = new CrlObject("rsync://bla", this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(crl);
                CrlObject obj = (CrlObject)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(crl.hash())).get();
                this.$outer.convertToStringShouldWrapper(obj.url()).should(this.$outer.be().apply((Object)crl.url()));
                this.$outer.convertToAnyShouldWrapper(obj.aki()).should(this.$outer.be().apply((Object)crl.aki()));
                this.$outer.convertToAnyShouldWrapper(obj.encoded()).should(this.$outer.be().apply((Object)crl.encoded()));
                this.$outer.convertToAnyShouldWrapper(obj.hash()).should(this.$outer.be().apply((Object)crl.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ManifestObject manifest = new ManifestObject("rsync://bla", this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(manifest);
                Seq manifests = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getManifests(manifest.aki());
                this.$outer.convertToAnyShouldWrapper(manifests).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
                ManifestObject head = (ManifestObject)manifests.head();
                this.$outer.convertToStringShouldWrapper(head.url()).should(this.$outer.be().apply((Object)manifest.url()));
                this.$outer.convertToAnyShouldWrapper(head.aki()).should(this.$outer.be().apply((Object)manifest.aki()));
                this.$outer.convertToAnyShouldWrapper(head.encoded()).should(this.$outer.be().apply((Object)manifest.encoded()));
                this.$outer.convertToAnyShouldWrapper(head.hash()).should(this.$outer.be().apply((Object)manifest.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a roa", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                RoaObject obj = (RoaObject)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(roa.hash())).get();
                this.$outer.convertToStringShouldWrapper(obj.url()).should(this.$outer.be().apply((Object)roa.url()));
                this.$outer.convertToAnyShouldWrapper(obj.aki()).should(this.$outer.be().apply((Object)roa.aki()));
                this.$outer.convertToAnyShouldWrapper(obj.encoded()).should(this.$outer.be().apply((Object)roa.encoded()));
                this.$outer.convertToAnyShouldWrapper(obj.hash()).should(this.$outer.be().apply((Object)roa.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Do not store the same object twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(roa.hash())).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Do not store the same certificate twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject certificate = new CertificateObject("rsync://bla", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(certificate.hash())).get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Update validation timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant newTime = Instant.now();
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().updateValidationTimestamp((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{roa.url(), certificate.url()})), newTime);
                RepositoryObject roaObject = (RepositoryObject)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(roa.hash())).get();
                this.$outer.convertToAnyShouldWrapper(roaObject.validationTime()).should(this.$outer.be().apply((Object)new Some((Object)newTime)));
                RepositoryObject certificateObject = (RepositoryObject)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(certificate.hash())).get();
                this.$outer.convertToAnyShouldWrapper(certificateObject.validationTime()).should(this.$outer.be().apply((Object)new Some((Object)newTime)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Delete old objects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant timeInThePast = Instant.now().minus((long)(3600000 * (this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().deletionDelay() + 1)));
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().updateValidationTimestamp((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{roa.url(), certificate.url()})), timeInThePast);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clearObjects(Instant.now());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(roa.hash())).isEmpty())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(certificate.hash())).isEmpty())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Delete objects never validated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant timeInTheFuture = Instant.now().plus((long)(3600000 * (this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().deletionDelay() + 1)));
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clearObjects(timeInTheFuture);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(roa.hash())).isEmpty())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(this.$outer.stringify(certificate.hash())).isEmpty())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return both objects and certificates matching the url", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String myUrl = "rsync://bla";
                CertificateObject certificate = new CertificateObject(myUrl, this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                RoaObject roa = new RoaObject(myUrl, this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                ManifestObject manifest = new ManifestObject(myUrl, this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                CrlObject crl = new CrlObject(myUrl, this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                CrlObject someOtherCrl = new CrlObject("rsync:bla.bla", this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(crl);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(manifest);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(someOtherCrl);
                Option objects = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject(myUrl);
                objects.foreach((Function1)new Serializable(this, certificate, roa, manifest, crl){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;
                    private final CertificateObject certificate$1;
                    private final RoaObject roa$1;
                    private final ManifestObject manifest$1;
                    private final CrlObject crl$1;

                    public final void apply(RepositoryObject<? extends CertificateRepositoryObject> x0$1) {
                        RepositoryObject<? extends CertificateRepositoryObject> repositoryObject;
                        block6: {
                            block3: {
                                block5: {
                                    block4: {
                                        block2: {
                                            repositoryObject = x0$1;
                                            if (!(repositoryObject instanceof CertificateObject)) break block2;
                                            CertificateObject certificateObject = (CertificateObject)repositoryObject;
                                            this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(certificateObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.certificate$1.decoded()));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(repositoryObject instanceof RoaObject)) break block4;
                                        RoaObject roaObject = (RoaObject)repositoryObject;
                                        this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(roaObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.roa$1.decoded()));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(repositoryObject instanceof ManifestObject)) break block5;
                                    ManifestObject manifestObject = (ManifestObject)repositoryObject;
                                    this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(manifestObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.manifest$1.decoded()));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(repositoryObject instanceof CrlObject)) break block6;
                                CrlObject crlObject = (CrlObject)repositoryObject;
                                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(crlObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.crl$1.decoded()));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(repositoryObject);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.certificate$1 = certificate$1;
                        this.roa$1 = roa$1;
                        this.manifest$1 = manifest$1;
                        this.crl$1 = crl$1;
                    }
                });
            }

            public /* synthetic */ CacheStoreTest net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return an empty Seq when nothing matches the url", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObject("rsync:bla");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

