/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Filters$;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.Idle$;
import net.ripe.rpki.validator.models.MyValidationProcess;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.Running;
import net.ripe.rpki.validator.models.TrackValidationProcess;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchor$;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.models.Whitelist$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scalaz.Failure;
import scalaz.Validation;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011!\u0004\u0016:bG.4\u0016\r\\5eCRLwN\u001c)s_\u000e,7o\u001d+fgRT!a\u0001\u0003\u0002\r5|G-\u001a7t\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\bgV\u0004\bo\u001c:u\u0013\t\u0019\u0002CA\tWC2LG-\u0019;peR+7\u000f^\"bg\u0016\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\r\u0002\u0007=\u0014x-\u0003\u0002\u001c-\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\r\u0011\u0011\u0003\u0001A\u0012\u0003G5KHK]1dWZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8\u000f\u0016:vgR\fen\u00195peN\u0019\u0011\u0005J\u0014\u0011\u0005\u0001*\u0013B\u0001\u0014\u0003\u0005Mi\u0015PV1mS\u0012\fG/[8o!J|7-Z:t!\t\u0001\u0003&\u0003\u0002*\u0005\t1BK]1dWZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8\u000f\u0003\u0005,C\t\u0005\t\u0015!\u0003-\u00031!(/^:u\u0003:\u001c\u0007n\u001c:t!\risG\u000f\b\u0003]Qr!a\f\u001a\u000e\u0003AR!!\r\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b7\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aM\u0005\u0003qe\u00121aU3r\u0015\t)d\u0007\u0005\u0002!w%\u0011AH\u0001\u0002\f)J,8\u000f^!oG\"|'\u000fC\u0003\u001eC\u0011\u0005a\b\u0006\u0002@\u0003B\u0011\u0001)I\u0007\u0002\u0001!)1&\u0010a\u0001Y!91)\tb\u0001\n\u0003\"\u0015aC7f[>\u0014\u00180S7bO\u0016,\u0012!\u0012\t\u0004\r.kU\"A$\u000b\u0005!K\u0015aA:u[*\u0011!JN\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001'H\u0005\r\u0011VM\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\taaY8oM&<\u0017B\u0001*P\u0005-iU-\\8ss&k\u0017mZ3\t\rQ\u000b\u0003\u0015!\u0003F\u00031iW-\\8ss&k\u0017mZ3!\u0011\u00151\u0016\u0005\"\u0011X\u0003)\u0011XO\u001c)s_\u000e,7o\u001d\u000b\u00021B!\u0011\f\u00180g\u001b\u0005Q&\"A.\u0002\rM\u001c\u0017\r\\1{\u0013\ti&L\u0001\u0006WC2LG-\u0019;j_:\u0004\"aX2\u000f\u0005\u0001\fW\"\u0001\u001c\n\u0005\t4\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u001c\u0011\t};\u0017\u000e]\u0005\u0003Q\u0016\u00141!T1q!\tQg.D\u0001l\u0015\tYANC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=\\'aA+S\u0013B\u0011\u0001%]\u0005\u0003e\n\u0011qBV1mS\u0012\fG/\u001a3PE*,7\r\u001e\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0003\r!\u0018\r\\\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011\u0010B\u0001\u0005kRLG.\u0003\u0002|q\n\u0011BK];ti\u0006s7\r[8s\u0019>\u001c\u0017\r^8s\u0011\u0019i\b\u0001)A\u0005m\u0006!A/\u00197!Q\u0019\u0001q0a\u0004\u0002\u0012A!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011A\u0002:v]:,'OC\u0002\u0002\na\tQA[;oSRLA!!\u0004\u0002\u0004\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\n!\u0011\t)\"!\u0007\u000e\u0005\u0005]!bAA\u0005-%!\u00111DA\f\u0005-QUK\\5u%Vtg.\u001a:")
public class TrackValidationProcessTest
extends ValidatorTestCase
implements BeforeAndAfter {
    private final TrustAnchorLocator tal;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public TrustAnchorLocator tal() {
        return this.tal;
    }

    public TrackValidationProcessTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.tal = new TrustAnchorLocator(new File(""), "caName", URI.create("rsync://rpki.ripe.net/root.cer"), "publicKeyInfo", Collections.emptyList());
        this.test("should fail with no processable trust anchor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.empty()));
                Validation<String, Map<URI, ValidatedObject>> result = subject.runProcess();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not process disabled trust anchors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{new TrustAnchor(this.$outer.tal(), (ProcessingStatus)new Idle(new DateTime(), Idle$.MODULE$.apply$default$2()), false, TrustAnchor$.MODULE$.apply$default$4(), TrustAnchor$.MODULE$.apply$default$5(), TrustAnchor$.MODULE$.apply$default$6(), TrustAnchor$.MODULE$.apply$default$7())}))));
                Validation<String, Map<URI, ValidatedObject>> result = subject.runProcess();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not process already running trust anchors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrackValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyTrackValidationProcessTrustAnchor subject = this.$outer.new MyTrackValidationProcessTrustAnchor((Seq<TrustAnchor>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{new TrustAnchor(this.$outer.tal(), (ProcessingStatus)new Running(""), true, TrustAnchor$.MODULE$.apply$default$4(), TrustAnchor$.MODULE$.apply$default$5(), TrustAnchor$.MODULE$.apply$default$6(), TrustAnchor$.MODULE$.apply$default$7())}))));
                Validation<String, Map<URI, ValidatedObject>> result = subject.runProcess();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new Failure((Object)"Trust anchor not idle or enabled")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public class MyTrackValidationProcessTrustAnchor
    extends MyValidationProcess
    implements TrackValidationProcess {
        private final Ref<MemoryImage> memoryImage;

        public Validation net$ripe$rpki$validator$models$TrackValidationProcess$$super$runProcess() {
            return ValidationProcess.class.runProcess((ValidationProcess)this);
        }

        public Map net$ripe$rpki$validator$models$TrackValidationProcess$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate) {
            return super.validateObjects(certificate);
        }

        @Override
        public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
            return TrackValidationProcess.class.validateObjects((TrackValidationProcess)this, (CertificateRepositoryObjectValidationContext)certificate);
        }

        public Ref<MemoryImage> memoryImage() {
            return this.memoryImage;
        }

        @Override
        public Validation<String, Map<URI, ValidatedObject>> runProcess() {
            return TrackValidationProcess.class.runProcess((TrackValidationProcess)this);
        }

        public /* synthetic */ TrackValidationProcessTest net$ripe$rpki$validator$models$TrackValidationProcessTest$MyTrackValidationProcessTrustAnchor$$$outer() {
            return TrackValidationProcessTest.this;
        }

        public MyTrackValidationProcessTrustAnchor(Seq<TrustAnchor> trustAnchors) {
            if (TrackValidationProcessTest.this == null) {
                throw new NullPointerException();
            }
            TrackValidationProcess.class.$init$((TrackValidationProcess)this);
            this.memoryImage = Ref$.MODULE$.apply((Object)new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist(Whitelist$.MODULE$.apply$default$1()), new TrustAnchors(trustAnchors), ValidatedObjects$.MODULE$.apply(new TrustAnchors(trustAnchors)), MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class));
        }
    }
}

