/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import javax.sql.DataSource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.PregeneratedKeyPairFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.TopDownWalker;
import net.ripe.rpki.validator.models.TopDownWalkerSpec$;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CertificateObject$;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.CrlObject$;
import net.ripe.rpki.validator.models.validation.Hashing;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.ManifestObject$;
import net.ripe.rpki.validator.models.validation.RepoFetcher;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.HttpFetcherStore$;
import net.ripe.rpki.validator.store.Storage;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.runner.RunWith;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import org.scalatest.enablers.Size$;
import org.scalatest.junit.JUnitRunner;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\r\u0015g\u0001B\u0001\u0003\u00015\u0011\u0011\u0003V8q\t><hnV1mW\u0016\u00148\u000b]3d\u0015\t\u0019A!\u0001\u0004n_\u0012,Gn\u001d\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M!\u0001A\u0004\u000b\u001d!\ty!#D\u0001\u0011\u0015\t\tB!A\u0004tkB\u0004xN\u001d;\n\u0005M\u0001\"!\u0005,bY&$\u0017\r^8s)\u0016\u001cHoQ1tKB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\ng\u000e\fG.\u0019;fgRT\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0017\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}\u0011\u0011A\u0003<bY&$\u0017\r^5p]&\u0011\u0011E\b\u0002\b\u0011\u0006\u001c\b.\u001b8h\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t!\u0001C\u0004)\u0001\t\u0007I\u0011B\u0015\u0002\u001bI+\u0005kT0M\u001f\u000e\u000bE+S(O+\u0005Q\u0003CA\u00160\u001b\u0005a#BA\u0006.\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001\r\u0017\u0003\u0007U\u0013\u0016\n\u0003\u00043\u0001\u0001\u0006IAK\u0001\u000f%\u0016\u0003vj\u0018'P\u0007\u0006#\u0016j\u0014(!\u0011\u001d!\u0004A1A\u0005\n%\n!D\u0015*E!~su\nV%G\u0013\u000e\u000bE+S(O?2{5)\u0011+J\u001f:CaA\u000e\u0001!\u0002\u0013Q\u0013a\u0007*S\tB{fj\u0014+J\r&\u001b\u0015\tV%P\u001d~cujQ!U\u0013>s\u0005\u0005C\u00049\u0001\t\u0007I\u0011B\u0015\u0002-I{u\nV0N\u0003:Ke)R*U?2{5)\u0011+J\u001f:CaA\u000f\u0001!\u0002\u0013Q\u0013a\u0006*P\u001fR{V*\u0011(J\r\u0016\u001bFk\u0018'P\u0007\u0006#\u0016j\u0014(!\u0011\u001da\u0004A1A\u0005\n%\n\u0011CU(P)~\u001b%\u000bT0M\u001f\u000e\u000bE+S(O\u0011\u0019q\u0004\u0001)A\u0005U\u0005\u0011\"kT(U?\u000e\u0013Fj\u0018'P\u0007\u0006#\u0016j\u0014(!\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000bQCU(P)~\u001bUI\u0015+J\r&\u001b\u0015\tV#`\u001d\u0006kU)F\u0001C!\t\u0019E*D\u0001E\u0015\t)e)\u0001\u0003ykA\u0002$BA$I\u0003\u0011\tW\u000f\u001e5\u000b\u0005%S\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003-\u000bQA[1wCbL!!\u0014#\u0003\u001ba+\u0004\u0007\r)sS:\u001c\u0017\u000e]1m\u0011\u0019y\u0005\u0001)A\u0005\u0005\u00061\"kT(U?\u000e+%\u000bV%G\u0013\u000e\u000bE+R0O\u00036+\u0005\u0005C\u0004R\u0001\t\u0007I\u0011B!\u0002/I{u\nV0D\u000bJ#\u0016JR%D\u0003R+uLT!N\u000b~\u0013\u0004BB*\u0001A\u0003%!)\u0001\rS\u001f>#vlQ#S)&3\u0015jQ!U\u000b~s\u0015)T#`e\u0001Bq!\u0016\u0001C\u0002\u0013%\u0011)\u0001\tD\u000bJ#\u0016JR%D\u0003R+uLT!N\u000b\"1q\u000b\u0001Q\u0001\n\t\u000b\u0011cQ#S)&3\u0015jQ!U\u000b~s\u0015)T#!\u0011\u001dI\u0006A1A\u0005\ni\u000b\u0011CU(P)~\u0013ViU(V%\u000e+ulU#U+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010\t\u0003)I\u0007O]3t_V\u00148-Z\u0005\u0003Av\u0013Q\"\u00139SKN|WO]2f'\u0016$\bB\u00022\u0001A\u0003%1,\u0001\nS\u001f>#vLU#T\u001fV\u00136)R0T\u000bR\u0003\u0003b\u00023\u0001\u0005\u0004%I!Z\u0001\u0013%>{EkX*F%&\u000bEj\u0018(V\u001b\n+%+F\u0001g!\t9'.D\u0001i\u0015\tIW&\u0001\u0003nCRD\u0017BA6i\u0005)\u0011\u0015nZ%oi\u0016<WM\u001d\u0005\u0007[\u0002\u0001\u000b\u0011\u00024\u0002'I{u\nV0T\u000bJK\u0015\tT0O+6\u0013UI\u0015\u0011\t\u000f=\u0004!\u0019!C\u0005a\u0006\u0019ajT,\u0016\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\tQLW.\u001a\u0006\u0003mb\tAA[8eC&\u0011\u0001p\u001d\u0002\t\t\u0006$X\rV5nK\"1!\u0010\u0001Q\u0001\nE\fAAT(XA!9A\u0010\u0001b\u0001\n\u0013i\u0018a\u0004,B\u0019&#\u0015\nV-`!\u0016\u0013\u0016j\u0014#\u0016\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB2ssB$xNC\u0002\u0002\b\u0019\tqaY8n[>t7/\u0003\u0003\u0002\f\u0005\u0005!A\u0004,bY&$\u0017\u000e^=QKJLw\u000e\u001a\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u007f\u0003A1\u0016\tT%E\u0013RKv\fU#S\u0013>#\u0005\u0005C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016\u0005i!kT(U?.+\u0015l\u0018)B\u0013J+\"!a\u0006\u0011\t\u0005e\u0011QD\u0007\u0003\u00037Q!!S\u0017\n\t\u0005}\u00111\u0004\u0002\b\u0017\u0016L\b+Y5s\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005]\u0011A\u0004*P\u001fR{6*R-`!\u0006K%\u000b\t\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003+\tqBU(P)~[U)W0Q\u0003&\u0013vL\r\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u0018\u0005\u0001\"kT(U?.+\u0015l\u0018)B\u0013J{&\u0007\t\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003+\tAcQ#S)&3\u0015jQ!U\u000b~[U)W0Q\u0003&\u0013\u0006\u0002CA\u001a\u0001\u0001\u0006I!a\u0006\u0002+\r+%\u000bV%G\u0013\u000e\u000bE+R0L\u000bf{\u0006+Q%SA!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011H\u0001\u001b\t\u00163\u0015)\u0016'U?Z\u000bE*\u0013#B)&{ejX(Q)&{ejU\u000b\u0003\u0003w\u0001B!!\u0010\u0002B5\u0011\u0011q\b\u0006\u0004?\u0005\u0015\u0011\u0002BA\"\u0003\u007f\u0011\u0011CV1mS\u0012\fG/[8o\u001fB$\u0018n\u001c8t\u0011!\t9\u0005\u0001Q\u0001\n\u0005m\u0012a\u0007#F\r\u0006+F\nV0W\u00032KE)\u0011+J\u001f:{v\n\u0015+J\u001f:\u001b\u0006\u0005\u0003\u0005\u0002L\u0001\u0011\r\u0011\"\u0003f\u0003]!UIR!V\u0019R{V*\u0011(J\r\u0016\u001bFk\u0018(V\u001b\n+%\u000bC\u0004\u0002P\u0001\u0001\u000b\u0011\u00024\u00021\u0011+e)Q+M)~k\u0015IT%G\u000bN#vLT+N\u0005\u0016\u0013\u0006\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V\u000591\u000f^8sC\u001e,WCAA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\t\u0005)1\u000f^8sK&!\u0011\u0011MA.\u0005)\u0019\u0015m\u00195f'R|'/\u001a\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002X\u0005A1\u000f^8sC\u001e,\u0007\u0005C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0014a\u0006:p_R\u0014Vm]8ve\u000e,7)\u001a:uS\u001aL7-\u0019;f+\t\ti\u0007\u0005\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(!\u0001\u0002\u0011a,\u0004'O2feRLA!a\u001e\u0002r\t9\u0002,\u000e\u0019:%\u0016\u001cx.\u001e:dK\u000e+'\u000f^5gS\u000e\fG/\u001a\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n\u0013\ti(A\u000es_>$(+Z:pkJ\u001cWmQ3si&4\u0017nY1uK~#S-\u001d\u000b\u0005\u0003\u007f\nY\t\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\t\t))A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0006\r%\u0001B+oSRD!\"!$\u0002z\u0005\u0005\t\u0019AA7\u0003\rAH%\r\u0005\t\u0003#\u0003\u0001\u0015)\u0003\u0002n\u0005A\"o\\8u%\u0016\u001cx.\u001e:dK\u000e+'\u000f^5gS\u000e\fG/\u001a\u0011\t\u0017\u0005U\u0005\u00011AA\u0002\u0013%\u0011qS\u0001\ni\u0006\u001cuN\u001c;fqR,\"!!'\u0011\t\u0005m\u0015\u0011U\u0007\u0003\u0003;SA!a(\u0002@\u0005\u0001rN\u00196fGR4\u0018\r\\5eCR|'o]\u0005\u0005\u0003G\u000biJ\u0001\u0017DKJ$\u0018NZ5dCR,'+\u001a9pg&$xN]=PE*,7\r\u001e,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\"Y\u0011q\u0015\u0001A\u0002\u0003\u0007I\u0011BAU\u00035!\u0018mQ8oi\u0016DHo\u0018\u0013fcR!\u0011qPAV\u0011)\ti)!*\u0002\u0002\u0003\u0007\u0011\u0011\u0014\u0005\t\u0003_\u0003\u0001\u0015)\u0003\u0002\u001a\u0006QA/Y\"p]R,\u0007\u0010\u001e\u0011\t\u0017\u0005M\u0006\u00011AA\u0002\u0013%\u0011QW\u0001\u0006i\u0006\u001c%\u000f\\\u000b\u0003\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0005\u0003{\u000b\t!A\u0002de2LA!!1\u0002<\n9\u0001,\u000e\u0019:\u0007Jd\u0007bCAc\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000f\f\u0011\u0002^1De2|F%Z9\u0015\t\u0005}\u0014\u0011\u001a\u0005\u000b\u0003\u001b\u000b\u0019-!AA\u0002\u0005]\u0006\u0002CAg\u0001\u0001\u0006K!a.\u0002\rQ\f7I\u001d7!\u0011\u001d\t\t\u000e\u0001C!\u0003'\f!BY3g_J,W)Y2i)\t\ty\bC\u0004\u0002X\u0002!I!!7\u0002-Q,7\u000f^,ji\"\u0014%o\\6f]6\u000bg.\u001b4fgR$b!a \u0002\\\u0006}\u0007bBAo\u0003+\u0004\rAZ\u0001\u000f[\u0006t\u0017NZ3ti:+XNY3s\u0011!\t\t/!6A\u0002\u0005\r\u0018aC3se>\u0014h*^7cKJ\u0004B!!!\u0002f&!\u0011q]AB\u0005\rIe\u000e\u001e\u0005\b\u0003W\u0004A\u0011AA6\u0003i9W\r\u001e*p_R\u0014Vm]8ve\u000e,7)\u001a:uS\u001aL7-\u0019;f\u0011\u001d\ty\u000f\u0001C\u0005\u0003c\fq\"\u001a=ue\u0006\u001cGOR5mK:\u000bW.\u001a\u000b\u0005\u0003g\u0014\t\u0001\u0005\u0003\u0002v\u0006mh\u0002BAA\u0003oLA!!?\u0002\u0004\u00061\u0001K]3eK\u001aLA!!@\u0002\u0000\n11\u000b\u001e:j]\u001eTA!!?\u0002\u0004\"9!1AAw\u0001\u0004Q\u0013aA;sS\"9!q\u0001\u0001\u0005\u0002\t%\u0011AD2sK\u0006$X-R7qif\u001c%\u000f\u001c\u000b\u0005\u0003o\u0013Y\u0001\u0003\u0005\u0003\u000e\t\u0015\u0001\u0019AA\f\u0003\u001dYW-\u001f)bSJDqA!\u0005\u0001\t\u0013\u0011\u0019\"\u0001\nde\u0016\fG/Z\"sY^KG\u000f[#oiJLH\u0003BA\\\u0005+A\u0001Ba\u0006\u0003\u0010\u0001\u0007\u0011QN\u0001\fG\u0016\u0014H/\u001b4jG\u0006$X\rC\u0004\u0003\u0012\u0001!IAa\u0007\u0015\u0011\u0005]&Q\u0004B\u0010\u0005GA\u0001Ba\u0006\u0003\u001a\u0001\u0007\u0011Q\u000e\u0005\b\u0005C\u0011I\u00021\u0001C\u0003!\u0019WM\u001d;OC6,\u0007\u0002\u0003B\u0013\u00053\u0001\r!a=\u0002\u0017\r\u0014H\u000eT8dCRLwN\u001c\u0005\b\u0005#\u0001A\u0011\u0002B\u0015))\t9La\u000b\u0003.\t=\"\u0011\u0007\u0005\t\u0005/\u00119\u00031\u0001\u0002n!A!Q\u0002B\u0014\u0001\u0004\t9\u0002C\u0004\u0003\"\t\u001d\u0002\u0019\u0001\"\t\u0011\t\u0015\"q\u0005a\u0001\u0003gDqA!\u000e\u0001\t\u0013\u00119$\u0001\u000ede\u0016\fG/Z'gi^KG\u000f[\"sY\u0006sG-\u00128ue&,7\u000f\u0006\u0004\u0003:\t=#q\f\t\b\u0003\u0003\u0013YD\u000bB \u0013\u0011\u0011i$a!\u0003\rQ+\b\u000f\\33!\u0011\u0011\tEa\u0013\u000e\u0005\t\r#\u0002\u0002B#\u0005\u000f\n\u0001\"\\1oS\u001a,7\u000f\u001e\u0006\u0005\u0005\u0013\n\t!A\u0002d[NLAA!\u0014\u0003D\tYQ*\u00198jM\u0016\u001cHoQ7t\u0011!\u0011\tFa\rA\u0002\tM\u0013AC2sY\u000e{g\u000e^3oiB1\u0011\u0011\u0011B+\u00053JAAa\u0016\u0002\u0004\n)\u0011I\u001d:bsB!\u0011\u0011\u0011B.\u0013\u0011\u0011i&a!\u0003\t\tKH/\u001a\u0005\t\u0005C\u0012\u0019\u00041\u0001\u0003d\u00059QM\u001c;sS\u0016\u001c\bCBAA\u0005K\u0012I'\u0003\u0003\u0003h\u0005\r%A\u0003\u001fsKB,\u0017\r^3e}A9\u0011\u0011\u0011B\u001eU\tM\u0003b\u0002B\u001b\u0001\u0011%!Q\u000e\u000b\t\u0005s\u0011yG!\u001d\u0003t!A!Q\u0002B6\u0001\u0004\t9\u0002\u0003\u0005\u0003R\t-\u0004\u0019\u0001B*\u0011!\u0011\tGa\u001bA\u0002\t\r\u0004b\u0002B<\u0001\u0011%!\u0011P\u0001 GJ,\u0017\r^3DQ&dG-\u00144u/&$\bn\u0011:m\u0003:$WI\u001c;sS\u0016\u001cHC\u0004B\u001d\u0005w\u0012iH!!\u0003\u0006\n\u001d%\u0011\u0012\u0005\t\u0005\u001b\u0011)\b1\u0001\u0002\u0018!9!q\u0010B;\u0001\u0004Q\u0013\u0001E7b]&4Wm\u001d;M_\u000e\fG/[8o\u0011\u001d\u0011\u0019I!\u001eA\u0002\t\u000ba![:tk\u0016\u0014\bb\u0002B\u0013\u0005k\u0002\rA\u000b\u0005\t\u0005#\u0012)\b1\u0001\u0003T!A!\u0011\rB;\u0001\u0004\u0011\u0019\u0007C\u0004\u0003\u000e\u0002!IAa$\u0002)\r\u0014X-\u0019;f\u001b\u001a$x+\u001b;i\u000b:$(/[3t))\u0011ID!%\u0003\u0014\nU%q\u0013\u0005\t\u0005\u001b\u0011Y\t1\u0001\u0002\u0018!9!q\u0010BF\u0001\u0004Q\u0003b\u0002BB\u0005\u0017\u0003\rA\u0011\u0005\t\u0005C\u0012Y\t1\u0001\u0003d!9!1\u0014\u0001\u0005\n\tu\u0015\u0001E2sK\u0006$X-\u00144u\u0005VLG\u000eZ3s)!\u0011yJ!*\u0003(\n%\u0006\u0003\u0002B!\u0005CKAAa)\u0003D\t\u0011R*\u00198jM\u0016\u001cHoQ7t\u0005VLG\u000eZ3s\u0011!\u0011iA!'A\u0002\u0005]\u0001b\u0002BB\u00053\u0003\rA\u0011\u0005\t\u0005C\u0012I\n1\u0001\u0003d!9!Q\u0016\u0001\u0005\n\t=\u0016aG2sK\u0006$X-T1oS\u001a,7\u000f^#F\u0007\u0016\u0014H/\u001b4jG\u0006$X\r\u0006\u0004\u0002n\tE&1\u0017\u0005\t\u0005\u001b\u0011Y\u000b1\u0001\u0002\u0018!9!Q\u0017BV\u0001\u0004\u0011\u0015\u0001C5tgV,'\u000f\u0012(\t\u000f\te\u0006\u0001\"\u0001\u0003<\u0006\u00013M]3bi\u0016,\u0005\u0010]5sK\u0012\u0014Vm]8ve\u000e,7)\u001a:uS\u001aL7-\u0019;f)\u0019\u0011iLa0\u0003BB9\u0011\u0011\u0011B\u001eU\u00055\u0004\u0002\u0003B\u0007\u0005o\u0003\r!a\u0006\t\u0011\t\r'q\u0017a\u0001\u0003g\fA\u0002\\8dCRLwN\u001c(b[\u0016DqAa2\u0001\t\u0003\u0011I-A\u0012de\u0016\fG/Z%oQ\u0016\u0014\u0018\u000e^5oOJ+7o\\;sG\u0016\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\u0011\tu&1\u001aBg\u0005\u001fD\u0001B!\u0004\u0003F\u0002\u0007\u0011q\u0003\u0005\t\u0005\u0007\u0014)\r1\u0001\u0002t\"9!q\u0010Bc\u0001\u0004Q\u0003b\u0002Bj\u0001\u0011\u0005!Q[\u0001\u001fGJ,\u0017\r^3WC2LGMU3t_V\u00148-Z\"feRLg-[2bi\u0016$\u0002B!0\u0003X\ne'1\u001c\u0005\t\u0005\u001b\u0011\t\u000e1\u0001\u0002\u0018!A!1\u0019Bi\u0001\u0004\t\u0019\u0010C\u0004\u0003\u0000\tE\u0007\u0019\u0001\u0016\t\u000f\t}\u0007\u0001\"\u0001\u0003b\u0006i2M]3bi\u0016dU-\u00194SKN|WO]2f\u0007\u0016\u0014H/\u001b4jG\u0006$X\r\u0006\u0004\u0003>\n\r(Q\u001d\u0005\t\u0005\u001b\u0011i\u000e1\u0001\u0002\u0018!A!1\u0019Bo\u0001\u0004\t\u0019\u0010C\u0004\u0003j\u0002!\tAa;\u0002=\r\u0014X-\u0019;f\u0007\"LG\u000e\u001a*fg>,(oY3DKJ$\u0018NZ5dCR,G\u0003\u0004B_\u0005[\u0014yOa=\u0003v\ne\b\u0002\u0003B\u0007\u0005O\u0004\r!a\u0006\t\u0011\tE(q\u001da\u0001\u0003/\tQ\u0002]1sK:$8*Z=QC&\u0014\b\u0002\u0003Bb\u0005O\u0004\r!a=\t\u000f\t](q\u001da\u0001\u0005\u0006y1-\u001a:uS\u001aL7-\u0019;f\u001d\u0006lW\rC\u0004\u0003|\n\u001d\b\u0019\u0001\"\u0002\u0015A\f'/\u001a8u\u001d\u0006lW\rC\u0004\u0003\u0000\u0002!\ta!\u0001\u0002K\r\u0014X-\u0019;f\u001fZ,'o\u00117bS6Lgn\u001a*fg>,(oY3DKJ$\u0018NZ5dCR,GC\u0005B_\u0007\u0007\u0019)aa\u0002\u0004\n\r-1QBB\b\u0007'A\u0001B!\u0004\u0003~\u0002\u0007\u0011q\u0003\u0005\t\u0005c\u0014i\u00101\u0001\u0002\u0018!A!1\u0019B\u007f\u0001\u0004\t\u0019\u0010C\u0004\u0003\u0000\tu\b\u0019\u0001\u0016\t\u000f\t](Q a\u0001\u0005\"9!1 B\u007f\u0001\u0004\u0011\u0005bBB\t\u0005{\u0004\rA`\u0001\u000fm\u0006d\u0017\u000eZ5usB+'/[8e\u0011!\u0019)B!@A\u0002\r]\u0011AD5t\u001f\nTWm\u0019;JgN,XM\u001d\t\u0005\u0003\u0003\u001bI\"\u0003\u0003\u0004\u001c\u0005\r%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007?\u0001A\u0011AB\u0011\u0003e\u0019'/Z1uKJ+7o\\;sG\u0016\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015)\tu61EB\u0013\u0007O\u0019Ica\u000b\u0004.\r=2\u0011GB\u001a\u0011!\u0011ia!\bA\u0002\u0005]\u0001\u0002\u0003By\u0007;\u0001\r!a\u0006\t\u0011\t\r7Q\u0004a\u0001\u0003gDqAa \u0004\u001e\u0001\u0007!\u0006C\u0004\u0003x\u000eu\u0001\u0019\u0001\"\t\u000f\tm8Q\u0004a\u0001\u0005\"91\u0011CB\u000f\u0001\u0004q\b\u0002CB\u000b\u0007;\u0001\raa\u0006\t\u0011\rU2Q\u0004a\u0001\u0007/\t\u0001#\u001b8iKJLGOU3t_V\u00148-Z:\t\u000f\re\u0002\u0001\"\u0003\u0004<\u00051q-\u001a;De2$\u0002\"a.\u0004>\r}2\u0011\t\u0005\b\u0005o\u001c9\u00041\u0001C\u0011!\u0011iaa\u000eA\u0002\u0005]\u0001\u0002CB\"\u0007o\u0001\ra!\u0012\u0002\u001dI,go\\6fIN+'/[1mgB)\u0011\u0011\u0011B3M\"91\u0011\n\u0001\u0005\u0002\r-\u0013!E2sK\u0006$XMU3q_N+'O^5dKR11QJB*\u00077\u00022AJB(\u0013\r\u0019\tF\u0001\u0002\f%\u0016\u0004xnU3sm&\u001cW\r\u0003\u0005\u0002T\r\u001d\u0003\u0019AB+!\u0011\tIfa\u0016\n\t\re\u00131\f\u0002\b'R|'/Y4f\u0011)\u0019ifa\u0012\u0011\u0002\u0003\u00071qL\u0001\u0007KJ\u0014xN]:\u0011\r\r\u00054\u0011OB<\u001d\u0011\u0019\u0019g!\u001c\u000f\t\r\u001541N\u0007\u0003\u0007OR1a!\u001b\r\u0003\u0019a$o\\8u}%\u0011\u0011QQ\u0005\u0005\u0007_\n\u0019)A\u0004qC\u000e\\\u0017mZ3\n\t\rM4Q\u000f\u0002\u0004'\u0016\f(\u0002BB8\u0003\u0007\u0003Ba!\u001f\u0004\u0006:!11PBA\u001b\t\u0019iHC\u0002\u0004\u0000\u0011\t\u0001BZ3uG\",'o]\u0005\u0005\u0007\u0007\u001bi(A\u0004GKR\u001c\u0007.\u001a:\n\t\r\u001d5\u0011\u0012\u0002\u0006\u000bJ\u0014xN\u001d\u0006\u0005\u0007\u0007\u001bi\bC\u0005\u0004\u000e\u0002\t\n\u0011\"\u0001\u0004\u0010\u0006Y2M]3bi\u0016\u0014V\r]8TKJ4\u0018nY3%I\u00164\u0017-\u001e7uII*\"a!%+\t\r}31S\u0016\u0003\u0007+\u0003Baa&\u0004\"6\u00111\u0011\u0014\u0006\u0005\u00077\u001bi*A\u0005v]\u000eDWmY6fI*!1qTAB\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007G\u001bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Ds\u0001ABT\u0007o\u001bI\f\u0005\u0003\u0004*\u000eMVBABV\u0015\u0011\u0019ika,\u0002\rI,hN\\3s\u0015\r\u0019\t\fG\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0007k\u001bYKA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\rm\u0006\u0003BB_\u0007\u0003l!aa0\u000b\u0007\rEf#\u0003\u0003\u0004D\u000e}&a\u0003&V]&$(+\u001e8oKJ\u0004")
public class TopDownWalkerSpec
extends ValidatorTestCase
implements BeforeAndAfterEach,
Hashing {
    private final URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION;
    private final URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION;
    private final URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION;
    private final URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION;
    private final X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME;
    private final X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME_2;
    private final X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME;
    private final IpResourceSet ROOT_RESOURCE_SET;
    private final BigInteger ROOT_SERIAL_NUMBER;
    private final DateTime net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW;
    private final ValidityPeriod VALIDITY_PERIOD;
    private final KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR;
    private final KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR_2;
    private final KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR;
    private final ValidationOptions net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS;
    private final BigInteger net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER;
    private final CacheStore net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage;
    private X509ResourceCertificate net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate;
    private CertificateRepositoryObjectValidationContext net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext;
    private X509Crl net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl;

    public byte[] getHash(byte[] bytes) {
        return Hashing.class.getHash((Hashing)this, (byte[])bytes);
    }

    public String stringify(byte[] bytes) {
        return Hashing.class.stringify((Hashing)this, (byte[])bytes);
    }

    public Option<byte[]> parseBytes(String hex) {
        return Hashing.class.parseBytes((Hashing)this, (String)hex);
    }

    public boolean equals(byte[] hashA, byte[] hashB) {
        return Hashing.class.equals((Hashing)this, (byte[])hashA, (byte[])hashB);
    }

    public Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION;
    }

    public URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION;
    }

    public URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION;
    }

    public URI net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION;
    }

    public X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME;
    }

    public X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME_2() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME_2;
    }

    public X500Principal net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME;
    }

    private IpResourceSet ROOT_RESOURCE_SET() {
        return this.ROOT_RESOURCE_SET;
    }

    private BigInteger ROOT_SERIAL_NUMBER() {
        return this.ROOT_SERIAL_NUMBER;
    }

    public DateTime net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW;
    }

    private ValidityPeriod VALIDITY_PERIOD() {
        return this.VALIDITY_PERIOD;
    }

    public KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR;
    }

    public KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR_2() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR_2;
    }

    public KeyPair net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR;
    }

    public ValidationOptions net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS;
    }

    public BigInteger net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER;
    }

    public CacheStore net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage;
    }

    public X509ResourceCertificate net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate;
    }

    private void net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate_$eq(X509ResourceCertificate x$1) {
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate = x$1;
    }

    public CertificateRepositoryObjectValidationContext net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext;
    }

    private void net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext_$eq(CertificateRepositoryObjectValidationContext x$1) {
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext = x$1;
    }

    public X509Crl net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl() {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl;
    }

    private void net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl_$eq(X509Crl x$1) {
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl = x$1;
    }

    public void beforeEach() {
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().clear();
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate_$eq(this.getRootResourceCertificate());
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext_$eq(new CertificateRepositoryObjectValidationContext(URI.create("rsync://host/ta"), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate()));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl_$eq(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0])));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION().toString(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl(), CrlObject$.MODULE$.apply$default$3()));
    }

    public void net$ripe$rpki$validator$models$TopDownWalkerSpec$$testWithBrokenManifest(BigInteger manifestNumber, int errorNumber) {
        Tuple2<URI, X509ResourceCertificate> tuple2 = this.createValidResourceCertificate(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
        if (tuple2 != null) {
            X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
            X509ResourceCertificate x509ResourceCertificate = certificate;
            X509ResourceCertificate certificate2 = x509ResourceCertificate;
            X509Crl crl = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
            Tuple2<URI, ManifestCms> tuple22 = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            if (tuple22 != null) {
                ManifestCms manifest;
                ManifestCms manifestCms;
                ManifestCms manifest2 = manifestCms = (manifest = (ManifestCms)tuple22._2());
                ManifestCmsBuilder badManifestBuilder = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftBuilder(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                badManifestBuilder.addFile("rsync://host.net/bad_manifest_crl.crl", (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4}), ClassTag$.MODULE$.Byte()));
                badManifestBuilder.withManifestNumber(manifestNumber);
                TopDownWalker subject = new TopDownWalker(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.createRepoService((Storage)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.createRepoService$default$2()), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                ManifestObject manifestObject = new ManifestObject("rsync://host.net/manifest.mft", manifest2, ManifestObject$.MODULE$.apply$default$3());
                ManifestObject badManifestObject = new ManifestObject("rsync://host.net/bad_manifest.mft", badManifestBuilder.build(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR().getPrivate()), ManifestObject$.MODULE$.apply$default$3());
                Option result = subject.findRecentValidMftWithCrl((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ManifestObject[]{manifestObject, badManifestObject})));
                this.convertToAnyShouldWrapper(((Tuple4)result.get())._1()).should(this.be().apply((Object)manifestObject));
                this.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.be().apply((Object)crl));
                this.convertToStringShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).url()).should(this.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                this.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.be().apply((Object)crl));
                this.convertToAnyShouldWrapper(((Tuple4)result.get())._3()).should(this.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.convertToStringShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).url()).should(this.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                this.convertToAnyShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).decoded()).should(this.be().apply((Object)crl));
                this.convertToAnyShouldWrapper(((Tuple4)result.get())._4()).should(this.have()).size((long)errorNumber, Size$.MODULE$.sizeOfGenTraversable());
                return;
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public X509ResourceCertificate getRootResourceCertificate() {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withSubjectDN(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME());
        builder.withIssuerDN(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME());
        builder.withSerial(this.ROOT_SERIAL_NUMBER());
        builder.withValidityPeriod(this.VALIDITY_PERIOD());
        builder.withPublicKey(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR().getPublic());
        builder.withCa(true);
        builder.withKeyUsage(4);
        builder.withAuthorityKeyIdentifier(true);
        builder.withSubjectKeyIdentifier(true);
        builder.withResources(this.ROOT_RESOURCE_SET());
        builder.withAuthorityKeyIdentifier(false);
        builder.withSigningKeyPair(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR());
        builder.withCrlDistributionPoints(new URI[]{this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION()});
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_NOTIFY, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION()), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION())});
        return builder.build();
    }

    public String net$ripe$rpki$validator$models$TopDownWalkerSpec$$extractFileName(URI uri) {
        return (String)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(uri.toString())).split('/')).last();
    }

    /*
     * WARNING - void declaration
     */
    public X509Crl createEmptyCrl(KeyPair keyPair) {
        void var2_2;
        X509Crl taCrl = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), keyPair, (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0]));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION().toString(), taCrl, CrlObject$.MODULE$.apply$default$3()));
        return var2_2;
    }

    public X509Crl net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(X509ResourceCertificate certificate) {
        return this.createCrlWithEntry(certificate, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION().toString());
    }

    private X509Crl createCrlWithEntry(X509ResourceCertificate certificate, X500Principal certName, String crlLocation) {
        return this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), certName, crlLocation);
    }

    public X509Crl net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(X509ResourceCertificate certificate, KeyPair keyPair, X500Principal certName, String crlLocation) {
        X509Crl taCrl = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(certName, keyPair, (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[]{certificate.getSerialNumber()}));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(crlLocation, taCrl, CrlObject$.MODULE$.apply$default$3()));
        return taCrl;
    }

    public Tuple2<URI, ManifestCms> net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(byte[] crlContent, Seq<Tuple2<URI, byte[]>> entries) {
        return this.createMftWithEntries(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), (Seq<Tuple2<URI, byte[]>>)((Seq)entries.toSeq().$colon$plus((Object)new Tuple2((Object)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION(), (Object)crlContent), Seq$.MODULE$.canBuildFrom())));
    }

    public Tuple2<URI, ManifestCms> net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(KeyPair keyPair, byte[] crlContent, Seq<Tuple2<URI, byte[]>> entries) {
        return this.createMftWithEntries(keyPair, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), (Seq<Tuple2<URI, byte[]>>)((Seq)entries.toSeq().$colon$plus((Object)new Tuple2((Object)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION(), (Object)crlContent), Seq$.MODULE$.canBuildFrom())));
    }

    public Tuple2<URI, ManifestCms> net$ripe$rpki$validator$models$TopDownWalkerSpec$$createChildMftWithCrlAndEntries(KeyPair keyPair, URI manifestLocation, X500Principal issuer, URI crlLocation, byte[] crlContent, Seq<Tuple2<URI, byte[]>> entries) {
        return this.createMftWithEntries(keyPair, manifestLocation, issuer, (Seq<Tuple2<URI, byte[]>>)((Seq)entries.toSeq().$colon$plus((Object)new Tuple2((Object)crlLocation, (Object)crlContent), Seq$.MODULE$.canBuildFrom())));
    }

    private Tuple2<URI, ManifestCms> createMftWithEntries(KeyPair keyPair, URI manifestLocation, X500Principal issuer, Seq<Tuple2<URI, byte[]>> entries) {
        ManifestCmsBuilder builder = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftBuilder(keyPair, issuer, entries);
        ManifestCms manifest = builder.build(keyPair.getPrivate());
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeManifest(new ManifestObject(manifestLocation.toString(), manifest, ManifestObject$.MODULE$.apply$default$3()));
        return new Tuple2((Object)manifestLocation, (Object)manifest);
    }

    public ManifestCmsBuilder net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftBuilder(KeyPair keyPair, X500Principal issuer, Seq<Tuple2<URI, byte[]>> entries) {
        DateTime thisUpdateTime = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusMinutes(1);
        DateTime nextUpdateTime = this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1);
        ManifestCmsBuilder builder = new ManifestCmsBuilder();
        builder.withCertificate(this.createManifestEECertificate(keyPair, issuer)).withManifestNumber(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER()).withThisUpdateTime(thisUpdateTime).withNextUpdateTime(nextUpdateTime);
        entries.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;
            private final ManifestCmsBuilder builder$1;

            public final void apply(Tuple2<URI, byte[]> e) {
                Tuple2<URI, byte[]> tuple2 = e;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI u = (URI)tuple2._1();
                    byte[] content = (byte[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)u, (Object)content);
                    URI u2 = (URI)tuple23._1();
                    byte[] content2 = (byte[])tuple23._2();
                    this.builder$1.addFile(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$extractFileName(u2), content2);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.builder$1 = builder$1;
            }
        });
        builder.withSignatureProvider("SunRsaSign");
        return builder;
    }

    private X509ResourceCertificate createManifestEECertificate(KeyPair keyPair, X500Principal issuerDN) {
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(false).withSubjectDN(new X500Principal("CN=EECert")).withIssuerDN(issuerDN).withSerial(BigInteger.ONE);
        builder.withPublicKey(keyPair.getPublic());
        builder.withSigningKeyPair(keyPair);
        builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder.withValidityPeriod(this.VALIDITY_PERIOD());
        builder.withCrlDistributionPoints(new URI[]{this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION()});
        builder.withKeyUsage(128);
        return builder.build();
    }

    public Tuple2<URI, X509ResourceCertificate> createExpiredResourceCertificate(KeyPair keyPair, String locationName) {
        return this.createResourceCertificate(keyPair, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), locationName, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(1)), true, false);
    }

    public Tuple2<URI, X509ResourceCertificate> createInheritingResourceCertificate(KeyPair keyPair, String locationName, URI manifestLocation) {
        return this.createResourceCertificate(keyPair, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), locationName, manifestLocation, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1)), true, true);
    }

    public Tuple2<URI, X509ResourceCertificate> createValidResourceCertificate(KeyPair keyPair, String locationName, URI manifestLocation) {
        return this.createResourceCertificate(keyPair, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), locationName, manifestLocation, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1)), true, false);
    }

    public Tuple2<URI, X509ResourceCertificate> createLeafResourceCertificate(KeyPair keyPair, String locationName) {
        return this.createResourceCertificate(keyPair, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), locationName, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1)), false, false);
    }

    public Tuple2<URI, X509ResourceCertificate> createChildResourceCertificate(KeyPair keyPair, KeyPair parentKeyPair, String locationName, X500Principal certificateName, X500Principal parentName) {
        return this.createResourceCertificate(keyPair, parentKeyPair, locationName, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), certificateName, parentName, new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1)), false, false);
    }

    public Tuple2<URI, X509ResourceCertificate> createOverClaimingResourceCertificate(KeyPair keyPair, KeyPair parentKeyPair, String locationName, URI manifestLocation, X500Principal certificateName, X500Principal parentName, ValidityPeriod validityPeriod, boolean isObjectIssuer) {
        X509ResourceCertificateBuilder x509ResourceCertificateBuilder;
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withValidityPeriod(validityPeriod);
        IpResourceSet overClaimingResourceSet = IpResourceSet.parse((String)"127.0.0.0/8");
        builder.withResources(overClaimingResourceSet);
        builder.withIssuerDN(parentName);
        builder.withSubjectDN(certificateName);
        builder.withSerial(this.ROOT_SERIAL_NUMBER().add(BigInteger.ONE));
        builder.withPublicKey(keyPair.getPublic());
        builder.withAuthorityKeyIdentifier(true);
        builder.withSubjectKeyIdentifier(true);
        builder.withSigningKeyPair(parentKeyPair);
        builder.withCrlDistributionPoints(new URI[]{URI.create("rsync://foo.host/bar/i_dont_care.crl")});
        if (isObjectIssuer) {
            builder.withCa(true);
            builder.withKeyUsage(134);
            x509ResourceCertificateBuilder = builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, manifestLocation)});
        } else {
            x509ResourceCertificateBuilder = builder.withKeyUsage(128);
        }
        X509ResourceCertificate certificate = builder.build();
        URI certificateLocation = new URI(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), locationName));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCertificate(new CertificateObject(certificateLocation.toString(), certificate, CertificateObject$.MODULE$.apply$default$3()));
        certificate.getManifestUri();
        return new Tuple2((Object)certificateLocation, (Object)certificate);
    }

    public Tuple2<URI, X509ResourceCertificate> createResourceCertificate(KeyPair keyPair, KeyPair parentKeyPair, String locationName, URI manifestLocation, X500Principal certificateName, X500Principal parentName, ValidityPeriod validityPeriod, boolean isObjectIssuer, boolean inheritResources) {
        X509ResourceCertificateBuilder x509ResourceCertificateBuilder;
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withValidityPeriod(validityPeriod);
        X509ResourceCertificateBuilder x509ResourceCertificateBuilder2 = inheritResources ? builder.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class)) : builder.withResources(this.ROOT_RESOURCE_SET());
        builder.withIssuerDN(parentName);
        builder.withSubjectDN(certificateName);
        builder.withSerial(this.ROOT_SERIAL_NUMBER().add(BigInteger.ONE));
        builder.withPublicKey(keyPair.getPublic());
        builder.withAuthorityKeyIdentifier(true);
        builder.withSubjectKeyIdentifier(true);
        builder.withSigningKeyPair(parentKeyPair);
        builder.withCrlDistributionPoints(new URI[]{URI.create("rsync://foo.host/bar/i_dont_care.crl")});
        if (isObjectIssuer) {
            builder.withCa(true);
            builder.withKeyUsage(134);
            x509ResourceCertificateBuilder = builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, manifestLocation)});
        } else {
            x509ResourceCertificateBuilder = builder.withKeyUsage(128);
        }
        X509ResourceCertificate certificate = builder.build();
        URI certificateLocation = new URI(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), locationName));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCertificate(new CertificateObject(certificateLocation.toString(), certificate, CertificateObject$.MODULE$.apply$default$3()));
        certificate.getManifestUri();
        return new Tuple2((Object)certificateLocation, (Object)certificate);
    }

    public X509Crl net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(X500Principal certificateName, KeyPair keyPair, Seq<BigInteger> revokedSerials) {
        X509CrlBuilder builder = new X509CrlBuilder();
        builder.withIssuerDN(certificateName);
        builder.withThisUpdateTime(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW());
        builder.withNextUpdateTime(this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusHours(8));
        builder.withNumber(BigInteger.TEN);
        builder.withAuthorityKeyIdentifier(keyPair.getPublic());
        revokedSerials.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;
            private final X509CrlBuilder builder$2;

            public final X509CrlBuilder apply(BigInteger i) {
                return this.builder$2.addEntry(i, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusDays(1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.builder$2 = builder$2;
            }
        });
        return builder.build(keyPair.getPrivate());
    }

    public RepoService createRepoService(Storage storage, Seq<Fetcher.Error> errors) {
        return new RepoService(this, storage, errors){
            private final Seq errors$1;

            public Seq<Fetcher.Error> visitRepo(URI repoUri) {
                return this.errors$1;
            }
            {
                this.errors$1 = errors$1;
                super(new RepoFetcher(storage$1, HttpFetcherStore$.MODULE$.inMemory(), new FetcherConfig("")));
            }
        };
    }

    public Seq<Fetcher.Error> createRepoService$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public TopDownWalkerSpec() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        Hashing.class.$init$((Hashing)this);
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION = URI.create("rsync://foo.host/bar/");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION = URI.create("http://foo.host/bar/notification.xml");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION = URI.create("rsync://foo.host/bar/manifest.mft");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION = URI.create("rsync://foo.host/bar/ta.crl");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME = new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME_2 = new X500Principal("CN=For Testing Only 2, CN=RIPE NCC, C=NL");
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME = new X500Principal("CN=123");
        this.ROOT_RESOURCE_SET = IpResourceSet.parse((String)"10.0.0.0/8, 192.168.0.0/16, ffce::/16, AS21212");
        this.ROOT_SERIAL_NUMBER = BigInteger.valueOf(900L);
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW = DateTime.now();
        this.VALIDITY_PERIOD = new ValidityPeriod((ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusMinutes(1), (ReadableInstant)this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1));
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR_2 = PregeneratedKeyPairFactory.getInstance().generate();
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR = PregeneratedKeyPairFactory.getInstance().generate();
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS = new ValidationOptions();
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER = BigInteger.valueOf(68L);
        this.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage = new CacheStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.test("should not give warnings when all entries are present in the manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createLeafResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), "valid.cer");
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(3L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)certificateLocation2).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                    this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION()).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                    this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION()).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not give warnings for valid certificate with child objects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI childManifestLocation = URI.create("rsync://foo.host/bar/childManifest.mft");
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", childManifestLocation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    KeyPair childKeyPair = PregeneratedKeyPairFactory.getInstance().generate();
                    URI childCrlLocation = URI.create("rsync://foo.host/bar/child.crl");
                    X509Crl childCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0]));
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(URI.create("rsync://foo.host/bar/child.crl").toString(), childCrl, CrlObject$.MODULE$.apply$default$3()));
                    Tuple2<URI, X509ResourceCertificate> tuple24 = this.$outer.createChildResourceCertificate(childKeyPair, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "validChild.cer", new X500Principal("CN=124"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME());
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        URI childCertificateLocation = (URI)tuple24._1();
                        X509ResourceCertificate childCertificate = (X509ResourceCertificate)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)childCertificateLocation, (Object)childCertificate);
                        URI childCertificateLocation2 = (URI)tuple26._1();
                        X509ResourceCertificate childCertificate2 = (X509ResourceCertificate)tuple26._2();
                        this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createChildMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), childManifestLocation, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), childCrlLocation, childCrl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)childCertificateLocation2, (Object)childCertificate2.getEncoded())}));
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        Map result = subject.execute();
                        this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(6L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)certificateLocation2).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CRL_LOCATION()).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION()).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)childCertificateLocation2).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)childManifestLocation).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)childCrlLocation).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        return;
                    }
                    throw new MatchError(tuple24);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give warning when no mft refers to a certificate that is an object issuer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(3L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)certificateLocation2).get()).checks()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("empty"), Predef$.MODULE$.conforms());
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give error when a cycle between a manifest and a certificate is found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI childManifestLocation = URI.create("rsync://foo.host/bar/childManifest.mft");
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", childManifestLocation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    URI childCrlLocation = URI.create("rsync://foo.host/bar/child.crl");
                    X509Crl childCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0]));
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(URI.create("rsync://foo.host/bar/child.crl").toString(), childCrl, CrlObject$.MODULE$.apply$default$3()));
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createChildMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), childManifestLocation, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), childCrlLocation, childCrl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate().getRepositoryUri(), (Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$rootResourceCertificate().getEncoded())}));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)childManifestLocation).get()).checks()).should(this.$outer.not()).be(Symbol$.MODULE$.apply("empty"), Predef$.MODULE$.conforms());
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)childManifestLocation).get()).isValid())).should(this.$outer.be().apply(false));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give error when object referenced in manifest is not found by its hash", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                byte[] missingHash = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3, 4}), ClassTag$.MODULE$.Byte());
                Tuple2<URI, ManifestCms> tuple2 = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new URI(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), "missing.cer")), (Object)missingHash)}));
                if (tuple2 != null) {
                    URI manifestLocation;
                    URI uRI;
                    URI manifestLocation2 = uRI = (manifestLocation = (URI)tuple2._1());
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.get((Object)manifestLocation2).exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ValidatedObject o) {
                            return o.hasCheckKey("validator.repository.object.not.in.cache");
                        }
                    }))).should(this.$outer.be().apply(true));
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)manifestLocation2).get()).isValid())).should(this.$outer.be().apply(false));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give error when object is found by hash but location doesnt match with location in manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createLeafResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer");
                if (tuple2 != null) {
                    X509ResourceCertificate certificate;
                    X509ResourceCertificate x509ResourceCertificate;
                    X509ResourceCertificate certificate2 = x509ResourceCertificate = (certificate = (X509ResourceCertificate)tuple2._2());
                    Tuple2<URI, ManifestCms> tuple22 = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new URI(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$REPO_LOCATION()), "missing.cer")), (Object)certificate2.getEncoded())}));
                    if (tuple22 != null) {
                        URI manifestLocation;
                        URI uRI;
                        URI manifestLocation2 = uRI = (manifestLocation = (URI)tuple22._1());
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        Map result = subject.execute();
                        this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(3L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.get((Object)manifestLocation2).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(ValidatedObject o) {
                                return o.hasCheckKey("validator.manifest.uri.mismatch");
                            }
                        }))).should(this.$outer.be().apply(true));
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)manifestLocation2).get()).isValid())).should(this.$outer.be().apply(false));
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn about expired certificates that are on the manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createExpiredResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "expired.cer");
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI expiredCertificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate cert = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)expiredCertificateLocation, (Object)cert);
                    URI expiredCertificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate cert2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)expiredCertificateLocation2, (Object)cert2.getEncoded())}));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.get((Object)expiredCertificateLocation2).exists((Function1)new Serializable(this, expiredCertificateLocation2){
                        public static final long serialVersionUID = 0L;
                        private final URI expiredCertificateLocation$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(ValidatedObject o) {
                            if (!o.hasCheckKey("cert.not.valid.after")) return false;
                            URI uRI = o.uri();
                            URI uRI2 = this.expiredCertificateLocation$1;
                            if (uRI != null) {
                                if (!((Object)uRI).equals(uRI2)) return false;
                                return true;
                            }
                            if (uRI2 == null) return true;
                            return false;
                        }
                        {
                            this.expiredCertificateLocation$1 = expiredCertificateLocation$1;
                        }
                    }))).should(this.$outer.be().apply(true));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should ignore alert messages for revoked certificates that are not on the manifest and not in repository", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    X509Crl crl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(result.get((Object)certificateLocation2)).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not warn about revoked certificates not on the manifest and not in repository", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "expired.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    X509ResourceCertificate certificate;
                    X509ResourceCertificate x509ResourceCertificate;
                    X509ResourceCertificate certificate2 = x509ResourceCertificate = (certificate = (X509ResourceCertificate)tuple2._2());
                    X509Crl crl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    this.$outer.convertToAnyShouldWrapper(result.get((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION()).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ValidatedObject x$8) {
                            return x$8.hasCheckKey("validator.manifest.does.not.contain.file");
                        }
                    })).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should prefer rpkiNotify URI over caRepository URI", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(subject.preferredFetchLocation().get()).should(this.$outer.be().apply((Object)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$RRDP_NOTIFICATION_LOCATION()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should update validation time for validated objects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    CertificateObject cert = new CertificateObject("", certificate2, CertificateObject$.MODULE$.apply$default$3());
                    CrlObject crl = new CrlObject("", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2), CrlObject$.MODULE$.apply$default$3());
                    ManifestObject mft = new ManifestObject("", (ManifestCms)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.encoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}))._2(), ManifestObject$.MODULE$.apply$default$3());
                    Instant validationTime = new DateTime().minusDays(1).toInstant();
                    Instant now = Instant.now();
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), validationTime, (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    subject.execute();
                    RepositoryObject certObj = (RepositoryObject)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().getObject(this.$outer.stringify(cert.hash())).get();
                    RepositoryObject crlObj = (RepositoryObject)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().getObject(this.$outer.stringify(crl.hash())).get();
                    RepositoryObject mftObj = (RepositoryObject)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().getObject(this.$outer.stringify(mft.hash())).get();
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)certObj.validationTime().exists((Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final Instant now$1;

                        public final boolean apply(Instant x$10) {
                            return !this.now$1.isAfter((ReadableInstant)x$10);
                        }
                        {
                            this.now$1 = now$1;
                        }
                    }))).should(this.$outer.be().apply(true));
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)crlObj.validationTime().exists((Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final Instant now$1;

                        public final boolean apply(Instant x$11) {
                            return !this.now$1.isAfter((ReadableInstant)x$11);
                        }
                        {
                            this.now$1 = now$1;
                        }
                    }))).should(this.$outer.be().apply(true));
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)mftObj.validationTime().exists((Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final Instant now$1;

                        public final boolean apply(Instant x$12) {
                            return !this.now$1.isAfter((ReadableInstant)x$12);
                        }
                        {
                            this.now$1 = now$1;
                        }
                    }))).should(this.$outer.be().apply(true));
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give error when fetch fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    X509ResourceCertificate certificate;
                    X509ResourceCertificate x509ResourceCertificate;
                    X509ResourceCertificate certificate2 = x509ResourceCertificate = (certificate = (X509ResourceCertificate)tuple2._2());
                    X509Crl crl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    URI uri = new URI("http://some.uri");
                    String message = "Some message";
                    Seq errors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Fetcher.Error[]{new Fetcher.Error(uri, message)}));
                    TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), (Seq<Fetcher.Error>)errors), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                    Map result = subject.execute();
                    Iterable invalidObjects = (Iterable)result.collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Tuple2<URI, ValidatedObject>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            ValidatedObject validatedObject;
                            A1 A1 = x1;
                            if (A1 != null && (validatedObject = (ValidatedObject)A1._2()) instanceof InvalidObject) {
                                InvalidObject invalidObject = (InvalidObject)validatedObject;
                                object = invalidObject;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<URI, ValidatedObject> x1) {
                            ValidatedObject validatedObject;
                            Tuple2<URI, ValidatedObject> tuple2 = x1;
                            boolean bl = tuple2 != null && (validatedObject = (ValidatedObject)tuple2._2()) instanceof InvalidObject;
                            return bl;
                        }
                    }, Iterable$.MODULE$.canBuildFrom());
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)invalidObjects.size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                    this.$outer.convertToAnyShouldWrapper(((InvalidObject)invalidObjects.head()).uri()).should(this.$outer.be().apply((Object)uri));
                    ((InvalidObject)invalidObjects.head()).checks().foreach((Function1)new Serializable(this, message){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$12 $outer;
                        private final String message$1;

                        public final void apply(ValidationCheck invalidObject) {
                            this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().convertToAnyShouldWrapper(invalidObject.getStatus()).should(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().be().apply((Object)ValidationStatus.FETCH_ERROR));
                            this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().convertToStringShouldWrapper(invalidObject.getKey()).should(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().be().apply((Object)"validator.repo.execution"));
                            this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.refArrayOps((Object[])invalidObject.getParams()).contains((Object)this.message$1))).should(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer().be().apply(true));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.message$1 = message$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TopDownWalkerSpec net$ripe$rpki$validator$models$TopDownWalkerSpec$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find recent valid manifest with valid CRL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    X509ResourceCertificate x509ResourceCertificate = certificate;
                    X509ResourceCertificate certificate2 = x509ResourceCertificate;
                    X509Crl crl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
                    Tuple2<URI, ManifestCms> tuple22 = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(crl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    if (tuple22 != null) {
                        ManifestCms manifest;
                        ManifestCms manifestCms;
                        ManifestCms manifest2 = manifestCms = (manifest = (ManifestCms)tuple22._2());
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        ManifestObject manifestObject = new ManifestObject("rsync://host.net/manifest.mft", manifest2, ManifestObject$.MODULE$.apply$default$3());
                        Option result = subject.findRecentValidMftWithCrl((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ManifestObject[]{manifestObject})));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._1()).should(this.$outer.be().apply((Object)manifestObject));
                        this.$outer.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.$outer.be().apply((Object)crl));
                        this.$outer.convertToStringShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).url()).should(this.$outer.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                        this.$outer.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.$outer.be().apply((Object)crl));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._3()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToStringShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).url()).should(this.$outer.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                        this.$outer.convertToAnyShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).decoded()).should(this.$outer.be().apply((Object)crl));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._4()).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find recent valid manifest with valid CRL in case there is second invalid more recent manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$testWithBrokenManifest(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER().add(BigInteger.valueOf(1L)), 2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find recent valid manifest with valid CRL in case there is second invalid older manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$testWithBrokenManifest(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER().subtract(BigInteger.valueOf(1L)), 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find recent valid manifest in case there is second manifest with invalid CRL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION());
                if (tuple2 != null) {
                    X509ResourceCertificate certificate;
                    X509ResourceCertificate x509ResourceCertificate;
                    X509ResourceCertificate certificate2 = x509ResourceCertificate = (certificate = (X509ResourceCertificate)tuple2._2());
                    X509Crl goodCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2);
                    X509Crl bogusMftCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createCrlWithEntry(certificate2, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR_2(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME_2(), "bad_manifest_crl.crl");
                    Tuple2<URI, ManifestCms> tuple22 = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(goodCrl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    if (tuple22 != null) {
                        ManifestCms manifest1;
                        ManifestCms manifestCms;
                        ManifestCms manifest12 = manifestCms = (manifest1 = (ManifestCms)tuple22._2());
                        ManifestCmsBuilder bogusManifestBuilder = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftBuilder(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_CERTIFICATE_NAME(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                        bogusManifestBuilder.addFile("rsync://host.net/bad_manifest_crl.crl", bogusMftCrl.getEncoded());
                        bogusManifestBuilder.withManifestNumber(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_MANIFEST_NUMBER().add(BigInteger.valueOf(1L)));
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        ManifestObject manifestObject = new ManifestObject("rsync://host.net/manifest.mft", manifest12, ManifestObject$.MODULE$.apply$default$3());
                        ManifestObject badManifestObject = new ManifestObject("rsync://host.net/bad_manifest.mft", bogusManifestBuilder.build(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR().getPrivate()), ManifestObject$.MODULE$.apply$default$3());
                        Option result = subject.findRecentValidMftWithCrl((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ManifestObject[]{manifestObject, badManifestObject})));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._1()).should(this.$outer.be().apply((Object)manifestObject));
                        this.$outer.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.$outer.be().apply((Object)goodCrl));
                        this.$outer.convertToStringShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).url()).should(this.$outer.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                        this.$outer.convertToAnyShouldWrapper(((CrlObject)((Tuple4)result.get())._2()).decoded()).should(this.$outer.be().apply((Object)goodCrl));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._3()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToStringShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).url()).should(this.$outer.be().apply((Object)"rsync://foo.host/bar/ta.crl"));
                        this.$outer.convertToAnyShouldWrapper(((RepositoryObject)((IterableLike)((Tuple4)result.get())._3()).head()).decoded()).should(this.$outer.be().apply((Object)goodCrl));
                        this.$outer.convertToAnyShouldWrapper(((Tuple4)result.get())._4()).should(this.$outer.have()).size(3L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((IterableLike)((Tuple4)result.get())._4()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TopDownWalker.Check ch) {
                                String string = ch.impl().getKey();
                                String string2 = "crl.aki.mismatch";
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }))).should(this.$outer.be().apply(true));
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((IterableLike)((Tuple4)result.get())._4()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TopDownWalker.Check ch) {
                                String string = ch.impl().getKey();
                                String string2 = "cert.crl.signature";
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }))).should(this.$outer.be().apply(true));
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((IterableLike)((Tuple4)result.get())._4()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(TopDownWalker.Check ch) {
                                String string = ch.impl().getKey();
                                String string2 = "validator.manifest.uri.mismatch";
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }))).should(this.$outer.be().apply(true));
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give overclaim warning if a child certificate claims more resources than its parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI childManifestLocation = URI.create("rsync://foo.host/bar/childManifest.mft");
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createValidResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", childManifestLocation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    KeyPair childKeyPair = PregeneratedKeyPairFactory.getInstance().generate();
                    URI childCrlLocation = URI.create("rsync://foo.host/bar/child.crl");
                    X509Crl childCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0]));
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(URI.create("rsync://foo.host/bar/child.crl").toString(), childCrl, CrlObject$.MODULE$.apply$default$3()));
                    Tuple2<URI, X509ResourceCertificate> tuple24 = this.$outer.createOverClaimingResourceCertificate(childKeyPair, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "validChild.cer", this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_MANIFEST_LOCATION(), new X500Principal("CN=124"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), new ValidityPeriod((ReadableInstant)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().minusYears(2), (ReadableInstant)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$NOW().plusYears(1)), false);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        URI childCertificateLocation = (URI)tuple24._1();
                        X509ResourceCertificate childCertificate = (X509ResourceCertificate)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)childCertificateLocation, (Object)childCertificate);
                        URI childCertificateLocation2 = (URI)tuple26._1();
                        X509ResourceCertificate childCertificate2 = (X509ResourceCertificate)tuple26._2();
                        this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createChildMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), childManifestLocation, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), childCrlLocation, childCrl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)childCertificateLocation2, (Object)childCertificate2.getEncoded())}));
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        Map result = subject.execute();
                        this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(6L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)childCertificateLocation2).get()).isValid())).should(this.$outer.be().apply(false));
                        return;
                    }
                    throw new MatchError(tuple24);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not give invalid overclaim warning if a certificate inherits its parents resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopDownWalkerSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI childManifestLocation = URI.create("rsync://foo.host/bar/childManifest.mft");
                Tuple2<URI, X509ResourceCertificate> tuple2 = this.$outer.createInheritingResourceCertificate(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "valid.cer", childManifestLocation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    URI certificateLocation = (URI)tuple2._1();
                    X509ResourceCertificate certificate = (X509ResourceCertificate)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)certificateLocation, (Object)certificate);
                    URI certificateLocation2 = (URI)tuple23._1();
                    X509ResourceCertificate certificate2 = (X509ResourceCertificate)tuple23._2();
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$ROOT_KEY_PAIR(), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taCrl().getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)certificateLocation2, (Object)certificate2.getEncoded())}));
                    KeyPair childKeyPair = PregeneratedKeyPairFactory.getInstance().generate();
                    URI childCrlLocation = URI.create("rsync://foo.host/bar/child.crl");
                    X509Crl childCrl = this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$getCrl(new X500Principal("CN=For Testing Only, CN=RIPE NCC, C=NL"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), (Seq<BigInteger>)Predef$.MODULE$.wrapRefArray((Object[])new BigInteger[0]));
                    this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage().storeCrl(new CrlObject(URI.create("rsync://foo.host/bar/child.crl").toString(), childCrl, CrlObject$.MODULE$.apply$default$3()));
                    Tuple2<URI, X509ResourceCertificate> tuple24 = this.$outer.createChildResourceCertificate(childKeyPair, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), "validChild.cer", new X500Principal("CN=124"), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME());
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        URI childCertificateLocation = (URI)tuple24._1();
                        X509ResourceCertificate childCertificate = (X509ResourceCertificate)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)childCertificateLocation, (Object)childCertificate);
                        URI childCertificateLocation2 = (URI)tuple26._1();
                        X509ResourceCertificate childCertificate2 = (X509ResourceCertificate)tuple26._2();
                        this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$createChildMftWithCrlAndEntries(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_KEY_PAIR(), childManifestLocation, this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$CERTIFICATE_NAME(), childCrlLocation, childCrl.getEncoded(), (Seq<Tuple2<URI, byte[]>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)childCertificateLocation2, (Object)childCertificate2.getEncoded())}));
                        TopDownWalker subject = new TopDownWalker(this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$taContext(), (Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService((Storage)this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$storage(), this.$outer.createRepoService$default$2()), this.$outer.net$ripe$rpki$validator$models$TopDownWalkerSpec$$DEFAULT_VALIDATION_OPTIONS(), Instant.now(), (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                        Map result = subject.execute();
                        this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(6L, Size$.MODULE$.sizeOfGenTraversable());
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)certificateLocation2).get()).isValid())).should(this.$outer.be().apply(true));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)certificateLocation2).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((ValidatedObject)result.get((Object)childCertificateLocation2).get()).isValid())).should(this.$outer.be().apply(true));
                        this.$outer.convertToAnyShouldWrapper(((ValidatedObject)result.get((Object)childCertificateLocation2).get()).checks()).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
                        return;
                    }
                    throw new MatchError(tuple24);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

