/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.validation.RepoFetcher;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\ty!+\u001a9p'\u0016\u0014h/[2f'B,7M\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0005\u00019!B\u0004\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u000591/\u001e9q_J$\u0018BA\n\u0011\u0005E1\u0016\r\\5eCR|'\u000fV3ti\u000e\u000b7/\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003e\t1a\u001c:h\u0013\tYbC\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0012\u0001B7pG.L!!\t\u0010\u0003\u00195{7m[5u_N+x-\u0019:\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001b\u0002\u0015\u0001\u0005\u0004%\t!K\u0001\tM\u0016$8\r[3scU\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.\u0005\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\u0005=b#a\u0003*fa>4U\r^2iKJDa!\r\u0001!\u0002\u0013Q\u0013!\u00034fi\u000eDWM]\u0019!\u0011\u001d\u0019\u0004A1A\u0005\u0002%\n\u0001BZ3uG\",'O\r\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0013\u0019,Go\u00195feJ\u0002\u0003bB\u001c\u0001\u0005\u0004%\t\u0001O\u0001\re\u0016\u0004xnU3sm&\u001cW-M\u000b\u0002sA\u0011aEO\u0005\u0003w\t\u00111BU3q_N+'O^5dK\"1Q\b\u0001Q\u0001\ne\nQB]3q_N+'O^5dKF\u0002\u0003bB \u0001\u0005\u0004%\t\u0001O\u0001\re\u0016\u0004xnU3sm&\u001cWM\r\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\u0002\u001bI,\u0007o\\*feZL7-\u001a\u001a!Q\u0011\u00011i\u0013'\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015A\u0002:v]:,'O\u0003\u0002I1\u0005)!.\u001e8ji&\u0011!*\u0012\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005i\u0005C\u0001(Q\u001b\u0005y%B\u0001%\u0017\u0013\t\tvJA\u0006K+:LGOU;o]\u0016\u0014\b")
public class RepoServiceSpec
extends ValidatorTestCase
implements BeforeAndAfter,
MockitoSugar {
    private final RepoFetcher fetcher1;
    private final RepoFetcher fetcher2;
    private final RepoService repoService1;
    private final RepoService repoService2;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public RepoFetcher fetcher1() {
        return this.fetcher1;
    }

    public RepoFetcher fetcher2() {
        return this.fetcher2;
    }

    public RepoService repoService1() {
        return this.repoService1;
    }

    public RepoService repoService2() {
        return this.repoService2;
    }

    public RepoServiceSpec() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.fetcher1 = (RepoFetcher)this.mock(ManifestFactory$.MODULE$.classType(RepoFetcher.class));
        this.fetcher2 = (RepoFetcher)this.mock(ManifestFactory$.MODULE$.classType(RepoFetcher.class));
        this.repoService1 = new RepoService(this.fetcher1());
        this.repoService2 = new RepoService(this.fetcher2());
        this.test("should fetch if URI was never visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                this.$outer.repoService1().visitRepo(uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher1())).fetchRepo(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should NOT fetch if URI was just visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla");
                this.$outer.repoService1().visitRepo(uri);
                this.$outer.repoService1().visitRepo(uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher1())).fetchRepo(uri);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.$outer.fetcher1()});
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fetch object if URI was never visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla.cer");
                this.$outer.repoService1().visitObject(uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher1())).fetchObject(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch object if URI was already visited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                URI uri = new URI("http://foo.bar/bla.cer");
                this.$outer.repoService1().visitObject(uri);
                this.$outer.repoService1().visitObject(uri);
                ((RepoFetcher)Mockito.verify((Object)this.$outer.fetcher1(), (VerificationMode)Mockito.times((int)1))).fetchObject(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fetch time should be recent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Instant minuteAgo = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)1L));
                Duration twoMinutes = Duration.standardMinutes((long)2L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.repoService1().timeIsRecent(minuteAgo, twoMinutes))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fetch time should NOT be recent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoServiceSpec $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Instant twoMinutesAgo = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)2L));
                Duration minute = Duration.standardMinutes((long)1L);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.repoService1().timeIsRecent(twoMinutesAgo, minute))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

