/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.lib;

import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.lib.NumberResources;
import net.ripe.rpki.validator.lib.NumberResourcesTest$;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.RtrPrefix$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Containing$;
import org.scalatest.enablers.Size$;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scalaz.Reducer;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]s!B\u0001\u0003\u0011\u0003i\u0011a\u0005(v[\n,'OU3t_V\u00148-Z:UKN$(BA\u0002\u0005\u0003\ra\u0017N\u0019\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\t\u0019b*^7cKJ\u0014Vm]8ve\u000e,7\u000fV3tiN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0012$\u0003\u0002\u001b)\ta1+\u001a:jC2L'0\u00192mK\")Ad\u0004C\u0001;\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u0006?=!\u0019\u0001I\u0001\n\u0019>tw\rV8Bg:$\"!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011B\u0011AC5qe\u0016\u001cx.\u001e:dK&\u0011ae\t\u0002\u0004\u0003Nt\u0007\"\u0002\u0015\u001f\u0001\u0004I\u0013aA1t]B\u00111CK\u0005\u0003WQ\u0011A\u0001T8oO\")Qf\u0004C\u0002]\u0005Y1\u000b\u001e:j]\u001e$v.Q:o)\t\ts\u0006C\u0003)Y\u0001\u0007\u0001\u0007\u0005\u00022i9\u00111CM\u0005\u0003gQ\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111\u0007\u0006\u0005\u0006q=!\u0019!O\u0001\u000f'R\u0014\u0018N\\4U_B\u0013XMZ5y)\tQT\b\u0005\u0002#w%\u0011Ah\t\u0002\b\u0013B\u0014\u0016M\\4f\u0011\u0015qt\u00071\u00011\u0003\u0005\u0019\b\"\u0002!\u0010\t\u0007\t\u0015!E%q%\u0006tw-\u001a+p\u0013:$XM\u001d<bYR\u0011!I\u0016\t\u0003\u0007Ns!\u0001R)\u000f\u0005\u0015\u0003fB\u0001$P\u001d\t9eJ\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002S\u0005\u0005ya*^7cKJ\u0014Vm]8ve\u000e,7/\u0003\u0002U+\n1b*^7cKJ\u0014Vm]8ve\u000e,\u0017J\u001c;feZ\fGN\u0003\u0002S\u0005!)qk\u0010a\u0001u\u0005)!/\u00198hK\")\u0011l\u0004C\u00025\u0006\u00012\u000b\u001e:j]\u001e$v.\u00138uKJ4\u0018\r\u001c\u000b\u0003\u0005nCQA\u0010-A\u0002ABq!X\b\u0002\u0002\u0013%a,A\u0006sK\u0006$'+Z:pYZ,G#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n1qJ\u00196fGR4A\u0001\u0005\u0002\u0001QN\u0011q-\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0012\tqa];qa>\u0014H/\u0003\u0002oW\n\tb+\u00197jI\u0006$xN\u001d+fgR\u001c\u0015m]3\t\u000bq9G\u0011\u00019\u0015\u0003E\u0004\"AD4\t\u000fM<'\u0019!C\u0001i\u0006Y\u0001K]3gSb|\u0016\u0007M09+\u0005Q\u0004B\u0002<hA\u0003%!(\u0001\u0007Qe\u00164\u0017\u000e_02a}C\u0004\u0005C\u0004yO\n\u0007I\u0011\u0001;\u0002\u0017A\u0013XMZ5y?F\u0002t,\u000f\u0005\u0007u\u001e\u0004\u000b\u0011\u0002\u001e\u0002\u0019A\u0013XMZ5y?F\u0002t,\u000f\u0011\t\u000fq<'\u0019!C\u0001{\u0006Q!+\u00198hK~\u000b\u0004g\u0018\u001d\u0016\u0003\tCaa`4!\u0002\u0013\u0011\u0015a\u0003*b]\u001e,w,\r\u0019`q\u0001B\u0001\"a\u0001h\u0005\u0004%\t!`\u0001\u000b%\u0006tw-Z02a}K\u0004bBA\u0004O\u0002\u0006IAQ\u0001\f%\u0006tw-Z02a}K\u0004\u0005\u0003\u0005\u0002\f\u001d\u0014\r\u0011\"\u0001~\u0003-\u0011\u0016M\\4f?F\u0012tg\u0018\u001d\t\u000f\u0005=q\r)A\u0005\u0005\u0006a!+\u00198hK~\u000b$gN09A!I\u00111C4C\u0002\u0013\u0005\u0011QC\u0001\u000f%R\u0014\bK]3gSb|\u0016\u0007M09+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\u0002B\u0001\u0007[>$W\r\\:\n\t\u0005\u0005\u00121\u0004\u0002\n%R\u0014\bK]3gSbD\u0001\"!\nhA\u0003%\u0011qC\u0001\u0010%R\u0014\bK]3gSb|\u0016\u0007M09A!I\u0011\u0011F4C\u0002\u0013\u0005\u0011QC\u0001\u000f%R\u0014\bK]3gSb|\u0016\u0007M0:\u0011!\tic\u001aQ\u0001\n\u0005]\u0011a\u0004*ueB\u0013XMZ5y?F\u0002t,\u000f\u0011)\u000f\u001d\f\t$!\u0012\u0002HA!\u00111GA!\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012A\u0002:v]:,'O\u0003\u0003\u0002<\u0005u\u0012!\u00026v]&$(BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n)DA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005%\u0003\u0003BA&\u0003'j!!!\u0014\u000b\t\u0005m\u0012q\n\u0006\u0005\u0003#\ni$A\u0005tG\u0006d\u0017\r^3ti&!\u0011QKA'\u0005-QUK\\5u%Vtg.\u001a:")
public class NumberResourcesTest
extends ValidatorTestCase {
    private final IpRange Prefix_10_8 = IpRange.parse((String)"10/8");
    private final IpRange Prefix_10_9 = IpRange.parse((String)"10/9");
    private final NumberResources.NumberResourceInterval Range_10_8 = new NumberResources.NumberResourceInterval(this.Prefix_10_8().getStart(), this.Prefix_10_8().getEnd());
    private final NumberResources.NumberResourceInterval Range_10_9 = new NumberResources.NumberResourceInterval(this.Prefix_10_9().getStart(), this.Prefix_10_9().getEnd());
    private final NumberResources.NumberResourceInterval Range_127_8 = new NumberResources.NumberResourceInterval(IpRange.parse((String)"127/8").getStart(), IpRange.parse((String)"127/8").getEnd());
    private final RtrPrefix RtrPrefix_10_8 = new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(65535L), this.Prefix_10_8(), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4());
    private final RtrPrefix RtrPrefix_10_9 = new RtrPrefix(Asn.parse((String)"AS65530"), this.Prefix_10_9(), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4());

    public static NumberResources.NumberResourceInterval StringToInterval(String string) {
        return NumberResourcesTest$.MODULE$.StringToInterval(string);
    }

    public static NumberResources.NumberResourceInterval IpRangeToInterval(IpRange ipRange) {
        return NumberResourcesTest$.MODULE$.IpRangeToInterval(ipRange);
    }

    public static IpRange StringToPrefix(String string) {
        return NumberResourcesTest$.MODULE$.StringToPrefix(string);
    }

    public static Asn StringToAsn(String string) {
        return NumberResourcesTest$.MODULE$.StringToAsn(string);
    }

    public static Asn LongToAsn(long l) {
        return NumberResourcesTest$.MODULE$.LongToAsn(l);
    }

    public IpRange Prefix_10_8() {
        return this.Prefix_10_8;
    }

    public IpRange Prefix_10_9() {
        return this.Prefix_10_9;
    }

    public NumberResources.NumberResourceInterval Range_10_8() {
        return this.Range_10_8;
    }

    public NumberResources.NumberResourceInterval Range_10_9() {
        return this.Range_10_9;
    }

    public NumberResources.NumberResourceInterval Range_127_8() {
        return this.Range_127_8;
    }

    public RtrPrefix RtrPrefix_10_8() {
        return this.RtrPrefix_10_8;
    }

    public RtrPrefix RtrPrefix_10_9() {
        return this.RtrPrefix_10_9;
    }

    public NumberResourcesTest() {
        this.test("NumberResourceInterval 10/8 should contain 10/9", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.Range_10_8().contains(this.$outer.Range_10_9()))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NumberResourceInterval 10/8 should not contain 127/8", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.Range_10_8().contains(this.$outer.Range_127_8()))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Empty NumberResourceIntervalTree should be empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.empty((Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Empty NumberResourceIntervalTree should not find any match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.empty((Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_10_8())).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Singleton NumberResourceIntervalTree should not be empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject).should(this.$outer.not()).be(Symbol$.MODULE$.apply("empty"), Predef$.MODULE$.conforms());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Singleton NumberResourceIntervalTree should find exact match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_10_8())).should(this.$outer.contain().apply((Object)this.$outer.RtrPrefix_10_8()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Singleton NumberResourceIntervalTree should find containing match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_10_9())).should(this.$outer.contain().apply((Object)this.$outer.RtrPrefix_10_8()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Singleton NumberResourceIntervalTree should not find range outside", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_127_8())).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi-entry NumberResourceIntervalTree should not be empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8(), this.$outer.RtrPrefix_10_9()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject).should(this.$outer.not()).be(Symbol$.MODULE$.apply("empty"), Predef$.MODULE$.conforms());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi-entry NumberResourceIntervalTree should find exact match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8(), this.$outer.RtrPrefix_10_9()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_10_8())).should(this.$outer.contain().apply((Object)this.$outer.RtrPrefix_10_8()), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi-entry NumberResourceIntervalTree should find containing matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8(), this.$outer.RtrPrefix_10_9()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_10_9())).should(this.$outer.contain().apply((Object)this.$outer.RtrPrefix_10_8()).and(this.$outer.contain().apply((Object)this.$outer.RtrPrefix_10_9())), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi-entry NumberResourceIntervalTree should not find range outside", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RtrPrefix[]{this.$outer.RtrPrefix_10_8(), this.$outer.RtrPrefix_10_9()}), (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(this.$outer.Range_127_8())).should(this.$outer.be().apply(Symbol$.MODULE$.apply("empty")));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Many distinct entry NumberResourceIntervalTree should find exact matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq prefixes = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RtrPrefix apply(int i) {
                        return new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(i), IpRange.parse((String)new StringBuilder().append(i).append((Object)"/8").toString()), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)prefixes, (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                prefixes.foreach((Function1)new Serializable(this, subject){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final NumberResources.NumberResourceIntervalTree subject$1;

                    public final void apply(RtrPrefix prefix) {
                        this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.subject$1.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.IpRangeToInterval(prefix.prefix()))).should(this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().have().size(1L).and(this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().contain().apply((Object)prefix)), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.subject$1 = subject$1;
                    }
                });
            }

            public /* synthetic */ NumberResourcesTest net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Many distinct entry NumberResourceIntervalTree should find containing match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq prefixes = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RtrPrefix apply(int i) {
                        return new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(i), IpRange.parse((String)new StringBuilder().append(i).append((Object)"/8").toString()), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)prefixes, (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.StringToInterval("1/9"))).should(this.$outer.have().size(1L).and(this.$outer.contain().apply((Object)new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(1L), NumberResourcesTest$.MODULE$.StringToPrefix("1/8"), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4()))), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.StringToInterval("33/9"))).should(this.$outer.have().size(1L).and(this.$outer.contain().apply((Object)new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(33L), NumberResourcesTest$.MODULE$.StringToPrefix("33/8"), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4()))), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.StringToInterval("99/9"))).should(this.$outer.have().size(1L).and(this.$outer.contain().apply((Object)new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(99L), NumberResourcesTest$.MODULE$.StringToPrefix("99/8"), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4()))), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.StringToInterval("100/9"))).should(this.$outer.have().size(1L).and(this.$outer.contain().apply((Object)new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(100L), NumberResourcesTest$.MODULE$.StringToPrefix("100/8"), (Option)None$.MODULE$, RtrPrefix$.MODULE$.apply$default$4()))), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find exact matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq prefixes = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 30).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RtrPrefix apply(int i) {
                        return new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(i), NumberResourcesTest$.MODULE$.StringToPrefix(new StringBuilder().append((Object)"0/").append((Object)BoxesRunTime.boxToInteger((int)i)).toString()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)i)), RtrPrefix$.MODULE$.apply$default$4());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)prefixes, (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                prefixes.foreach((Function1)new Serializable(this, subject){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final NumberResources.NumberResourceIntervalTree subject$2;

                    public final void apply(RtrPrefix prefix) {
                        this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.subject$2.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.IpRangeToInterval(prefix.prefix()))).should(this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().have().size((long)(BoxesRunTime.unboxToInt((Object)prefix.maxPrefixLength().get()) + 1)).and(this.$outer.net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer().contain().apply((Object)prefix)), (Object)Size$.MODULE$.sizeOfGenTraversable(), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.subject$2 = subject$2;
                    }
                });
            }

            public /* synthetic */ NumberResourcesTest net$ripe$rpki$validator$lib$NumberResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find containing match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NumberResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq prefixes = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 30).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RtrPrefix apply(int i) {
                        return new RtrPrefix(NumberResourcesTest$.MODULE$.LongToAsn(i), NumberResourcesTest$.MODULE$.StringToPrefix(new StringBuilder().append((Object)"0/").append((Object)BoxesRunTime.boxToInteger((int)i)).toString()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)i)), RtrPrefix$.MODULE$.apply$default$4());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                NumberResources.NumberResourceIntervalTree subject = NumberResources.NumberResourceIntervalTree$.MODULE$.apply((Seq)prefixes, (Reducer)RtrPrefix.RtrPrefixReducer$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(subject.findExactAndAllLessSpecific(NumberResourcesTest$.MODULE$.StringToInterval("0/31"))).should(this.$outer.equal(prefixes), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

