/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherListener;
import net.ripe.rpki.validator.fetchers.HttpFetcher;
import net.ripe.rpki.validator.fetchers.HttpFetcherTest$;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.HttpFetcherStore;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Size$;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u00015\u0011q\u0002\u0013;ua\u001a+Go\u00195feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001BZ3uG\",'o\u001d\u0006\u0003\u000b\u0019\t\u0011B^1mS\u0012\fGo\u001c:\u000b\u0005\u001dA\u0011\u0001\u0002:qW&T!!\u0003\u0006\u0002\tIL\u0007/\u001a\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0004\u0001M!\u0001A\u0004\u000b\u001d!\ty!#D\u0001\u0011\u0015\t\tB!A\u0004tkB\u0004xN\u001d;\n\u0005M\u0001\"!\u0005,bY&$\u0017\r^8s)\u0016\u001cHoQ1tKB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\ng\u000e\fG.\u0019;fgRT\u0011!G\u0001\u0004_J<\u0017BA\u000e\u0017\u00059\u0011UMZ8sK\u0006sG-\u00114uKJ\u0004\"!\b\u0011\u000e\u0003yQ!a\b\f\u0002\t5|7m[\u0005\u0003Cy\u0011A\"T8dW&$xnU;hCJDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000f!\u0002!\u0019!C\u0001S\u0005)1\u000f^8sKV\t!\u0006\u0005\u0002,[5\tAF\u0003\u0002)\t%\u0011a\u0006\f\u0002\u0011\u0011R$\bOR3uG\",'o\u0015;pe\u0016Da\u0001\r\u0001!\u0002\u0013Q\u0013AB:u_J,\u0007%\u0002\u00033\u0001\u0001\u0019$!\u0005$fi\u000eDWM\u001d*fiV\u0014h\u000eV=qKB!AGP!J\u001d\t)4H\u0004\u00027s5\tqG\u0003\u00029\u0019\u00051AH]8pizJ\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003yu\nq\u0001]1dW\u0006<WMC\u0001;\u0013\ty\u0004I\u0001\u0004FSRDWM\u001d\u0006\u0003yu\u0002\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002G\t\u00051Qn\u001c3fYNL!\u0001S\"\u0003\u0019\t\u0013xn[3o\u001f\nTWm\u0019;\u0011\u0005)keB\u0001\"L\u0013\ta5)\u0001\tSKB|7/\u001b;pef|%M[3di&\u0011aj\u0014\u0002\u0007%>#\u0016\u0010]3\u000b\u00051\u001b\u0005\"B)\u0001\t\u0013\u0011\u0016\u0001\u0003:fC\u00124\u0015\u000e\\3\u0015\u0005M[\u0006C\u0001+Y\u001d\t)f+D\u0001>\u0013\t9V(\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,>\u0011\u0015a\u0006\u000b1\u0001T\u0003\u0011\u0001\u0018\r\u001e5\t\u000by\u0003A\u0011A0\u0002'\r\u0014X-\u0019;f\u001b>\u001c7.\u001a3GKR\u001c\u0007.\u001a:\u0015\u0005\u0001d'cA1dM\u001a!!-\u0018\u0001a\u00051a$/\u001a4j]\u0016lWM\u001c;?!\t1C-\u0003\u0002f\u0005\tY\u0001\n\u001e;q\r\u0016$8\r[3s!\t9'.D\u0001i\u0015\tIG!\u0001\u0004d_:4\u0017nZ\u0005\u0003W\"\u0014A\u0001\u0013;ua\")Q.\u0018a\u0001]\u0006!QO\u001d7t!\u0011)vnU*\n\u0005Al$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015\u0011\b\u0001\"\u0001t\u0003%1W\r^2i%\u0016\u0004x\u000eF\u0003u\u0003S\ti\u0003\u0005\u0004Vk^|\u0018QC\u0005\u0003mv\u0012a\u0001V;qY\u0016\u001c\u0004c\u0001=~\u00136\t\u0011P\u0003\u0002{w\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003yv\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0018P\u0001\u0003MSN$\b\u0003\u0002=~\u0003\u0003\u0001b!VA\u0002\u0003\u000f\u0019\u0016bAA\u0003{\t1A+\u001e9mKJ\u0002B!!\u0003\u0002\u00125\u0011\u00111\u0002\u0006\u0004\u0017\u00055!BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u00111\u0002\u0002\u0004+JK\u0005#\u0002\u001b\u0002\u0018\u0005m\u0011bAA\r\u0001\n\u00191+Z9\u0011\t\u0005u\u00111\u0005\b\u0004M\u0005}\u0011bAA\u0011\u0005\u00059a)\u001a;dQ\u0016\u0014\u0018\u0002BA\u0013\u0003O\u0011Q!\u0012:s_JT1!!\t\u0003\u0011\u0019\tY#\u001da\u0001G\u00069a-\u001a;dQ\u0016\u0014\bBBA\u0018c\u0002\u00071+A\u0004s_>$XK\u001d7)\u000f\u0001\t\u0019$a\u0011\u0002FA!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012A\u0002:v]:,'OC\u0002\u0002>a\tQA[;oSRLA!!\u0011\u00028\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA$!\u0011\tI%!\u0014\u000e\u0005\u0005-#bAA\u001f-%!\u0011qJA&\u0005-QUK\\5u%Vtg.\u001a:")
public class HttpFetcherTest
extends ValidatorTestCase
implements BeforeAndAfter,
MockitoSugar {
    private final HttpFetcherStore store;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public HttpFetcherStore store() {
        return this.store;
    }

    public String net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile(String path) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public HttpFetcher createMockedFetcher(Function1<String, String> urls) {
        return new HttpFetcher(this, urls){
            private final /* synthetic */ HttpFetcherTest $outer;
            public final Function1 urls$1;

            /*
             * WARNING - void declaration
             */
            public CloseableHttpClient http() {
                void var1_1;
                CloseableHttpClient httpMock = (CloseableHttpClient)this.$outer.mock(ManifestFactory$.MODULE$.classType(CloseableHttpClient.class));
                Mockito.when((Object)httpMock.execute((HttpUriRequest)Matchers.any())).thenAnswer((Answer)new Answer<CloseableHttpResponse>(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public CloseableHttpResponse answer(InvocationOnMock invocation) {
                        HttpGet argument = (HttpGet)invocation.getArguments()[0];
                        String xml = (String)this.$outer.urls$1.apply((Object)argument.getURI().toString());
                        CloseableHttpResponse response = (CloseableHttpResponse)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anon$$$outer().mock(ManifestFactory$.MODULE$.classType(CloseableHttpResponse.class));
                        HttpEntity entity = (HttpEntity)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anon$$$outer().mock(ManifestFactory$.MODULE$.classType(HttpEntity.class));
                        Mockito.when((Object)entity.getContent()).thenReturn((Object)new ByteArrayInputStream(xml.getBytes()));
                        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
                        return response;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ HttpFetcherTest net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.urls$1 = urls$1;
                super($outer.store());
            }
        };
    }

    public Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> fetchRepo(HttpFetcher fetcher, String rootUrl) {
        ObjectRef objects = new ObjectRef((Object)Nil$.MODULE$);
        ObjectRef withdraws = new ObjectRef((Object)Nil$.MODULE$);
        Seq errors = fetcher.fetch(new URI(rootUrl), new FetcherListener(this, objects, withdraws){
            private final ObjectRef objects$1;
            private final ObjectRef withdraws$1;

            public void processObject(RepositoryObject<? extends CertificateRepositoryObject> repoObj) {
                RepositoryObject<? extends CertificateRepositoryObject> repositoryObject = repoObj;
                this.objects$1.elem = ((List)this.objects$1.elem).$colon$colon(repositoryObject);
            }

            public void withdraw(URI url, String hash) {
                Tuple2 tuple2 = new Tuple2((Object)url, (Object)hash);
                this.withdraws$1.elem = ((List)this.withdraws$1.elem).$colon$colon((Object)tuple2);
            }
            {
                this.objects$1 = objects$1;
                this.withdraws$1 = withdraws$1;
            }
        });
        return new Tuple3((Object)((List)objects.elem).reverse(), (Object)((List)withdraws.elem).reverse(), (Object)errors);
    }

    public HttpFetcherTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.store = new HttpFetcherStore((DataSource)DataSources$.MODULE$.InMemoryDataSource());
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should download repository when we only have snapshot and no local state", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/notification1.xml")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/snapshot.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/snapshot1.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    CertificateObject c = (CertificateObject)objects2.head();
                    this.$outer.convertToStringShouldWrapper(c.url()).should(this.$outer.be().apply((Object)"rsync://bandito.ripe.net/repo/671570f06499fbd2d6ab76c4f22566fe49d5de60.cer"));
                    this.$outer.convertToAnyShouldWrapper(c.decoded().getResources()).should(this.$outer.be().apply((Object)IpResourceSet.parse((String)"192.168.0.0/16")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(1))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not download repository where local serial number matches the remote one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/notification1.xml")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/snapshot.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/snapshot1.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(1))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not download repository where local serial number is larger than the remote one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(2));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/notification1.xml")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/snapshot.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test1/snapshot1.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2.head()).should(this.$outer.be().apply((Object)new Fetcher.Error(URI.create("http://repo.net/repo/notification.xml"), "Local serial 2 is larger then repository serial 1")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(2))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not download snapshot and download and apply one delta", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test2/notification2.xml")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/delta2_1.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test2/delta2_1.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    ManifestObject mft = (ManifestObject)objects2.head();
                    this.$outer.convertToStringShouldWrapper(mft.url()).should(this.$outer.be().apply((Object)"rsync://bandito.ripe.net/repo/3a87a4b1-6e22-4a63-ad0f-06f83ad3ca16/default/671570f06499fbd2d6ab76c4f22566fe49d5de60.mft"));
                    this.$outer.convertToStringShouldWrapper((String)mft.decoded().getHashes().keySet().iterator().next()).should(this.$outer.be().apply((Object)"671570f06499fbd2d6ab76c4f22566fe49d5de60.crl"));
                    CrlObject crl = (CrlObject)((IterableLike)objects2.tail()).head();
                    this.$outer.convertToStringShouldWrapper(crl.url()).should(this.$outer.be().apply((Object)"rsync://bandito.ripe.net/repo/3a87a4b1-6e22-4a63-ad0f-06f83ad3ca16/default/671570f06499fbd2d6ab76c4f22566fe49d5de60.crl"));
                    this.$outer.convertToStringShouldWrapper(((Object)crl.decoded().getCrl().getIssuerDN()).toString()).should(this.$outer.be().apply((Object)"CN=671570f06499fbd2d6ab76c4f22566fe49d5de60"));
                    this.$outer.convertToAnyShouldWrapper(withdraws2.head()).should(this.$outer.be().apply((Object)new Tuple2((Object)URI.create("rsync://bandito.ripe.net/repo/3a87a4b1-6e22-4a63-ad0f-06f83ad3ca16/default/example.roa"), (Object)"2B551A6C10CCA04C174B0CEB3B64652A5534D1385BEAA40A55A68CB06055E6BB")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(2))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should download snapshot when there are not enough deltas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test3/notification3.xml")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/snapshot3.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test3/snapshot3.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    CertificateObject c = (CertificateObject)objects2.head();
                    this.$outer.convertToStringShouldWrapper(c.url()).should(this.$outer.be().apply((Object)"rsync://bandito.ripe.net/repo/671570f06499fbd2d6ab76c4f22566fe49d5de60.cer"));
                    this.$outer.convertToAnyShouldWrapper(c.decoded().getResources()).should(this.$outer.be().apply((Object)IpResourceSet.parse((String)"192.168.0.0/16")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(3))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not change local serial number in case of errors (invalid XML in notification file)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)((Function1)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"http://repo.net/repo/notification.xml"), (Object)this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test4/broken_notification1.xml"))}))));
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2.head()).should(this.$outer.be().apply((Object)new Fetcher.Error(URI.create("http://repo.net/repo/notification.xml"), "The element type \"notification\" must be terminated by the matching end-tag \"</notification>\".")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(1))));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not change local serial number in case of errors (could not download snapshot)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final String apply(String x0$1) {
                        String string;
                        String string2 = string = x0$1;
                        if (!("http://repo.net/repo/notification.xml" != null ? !"http://repo.net/repo/notification.xml".equals(string2) : string2 != null)) {
                            String string3 = this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anonfun$$$outer().net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test4/notification1.xml");
                            return string3;
                        }
                        String string4 = string;
                        if (!("http://repo.net/repo/snapshot.xml" != null ? !"http://repo.net/repo/snapshot.xml".equals(string4) : string4 != null)) {
                            throw new Exception("Couldn't download snapshot");
                        }
                        throw new MatchError((Object)string);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2.head()).should(this.$outer.be().apply((Object)new Fetcher.Error(URI.create("http://repo.net/repo/snapshot.xml"), "Couldn't download snapshot")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(1))));
                    return;
                }
                throw new MatchError(tuple3);
            }

            public /* synthetic */ HttpFetcherTest net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should not change local serial number in case of errors (could not download one delta of two)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpFetcherTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.store().storeSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28", package$.MODULE$.BigInt().apply(1));
                HttpFetcher fetcher = this.$outer.createMockedFetcher((Function1<String, String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final String apply(String x0$2) {
                        String string;
                        block6: {
                            String string2;
                            block5: {
                                block4: {
                                    String string3 = string = x0$2;
                                    if ("http://repo.net/repo/notification.xml" != null ? !"http://repo.net/repo/notification.xml".equals(string3) : string3 != null) break block4;
                                    string2 = this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anonfun$$$outer().net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test5/notification1.xml");
                                    break block5;
                                }
                                String string4 = string;
                                if ("http://repo.net/repo/delta1.xml" != null ? !"http://repo.net/repo/delta1.xml".equals(string4) : string4 != null) break block6;
                                string2 = this.$outer.net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anonfun$$$outer().net$ripe$rpki$validator$fetchers$HttpFetcherTest$$readFile("mock-http-responses/test5/delta1.xml");
                            }
                            return string2;
                        }
                        String string5 = string;
                        if (!("http://repo.net/repo/delta2.xml" != null ? !"http://repo.net/repo/delta2.xml".equals(string5) : string5 != null)) {
                            throw new Exception("Couldn't download delta2");
                        }
                        throw new MatchError((Object)string);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Tuple3<List<RepositoryObject<? extends CertificateRepositoryObject>>, List<Tuple2<URI, String>>, Seq<Fetcher.Error>> tuple3 = this.$outer.fetchRepo(fetcher, "http://repo.net/repo/notification.xml");
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    List objects = (List)tuple3._1();
                    List withdraws = (List)tuple3._2();
                    Seq errors = (Seq)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)objects, (Object)withdraws, (Object)errors);
                    List objects2 = (List)tuple33._1();
                    List withdraws2 = (List)tuple33._2();
                    Seq errors2 = (Seq)tuple33._3();
                    this.$outer.convertToAnyShouldWrapper(objects2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(withdraws2).should(this.$outer.have()).size(0L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                    this.$outer.convertToAnyShouldWrapper(errors2.head()).should(this.$outer.be().apply((Object)new Fetcher.Error(URI.create("http://repo.net/repo/delta2.xml"), "Couldn't download delta2")));
                    Option serial = this.$outer.store().getSerial(URI.create("http://repo.net/repo/notification.xml"), "9df4b597-af9e-4dca-bdda-719cce2c4e28");
                    this.$outer.convertToAnyShouldWrapper(serial).should(this.$outer.be().apply((Object)new Some((Object)package$.MODULE$.BigInt().apply(1))));
                    return;
                }
                throw new MatchError(tuple3);
            }

            public /* synthetic */ HttpFetcherTest net$ripe$rpki$validator$fetchers$HttpFetcherTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

