/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.validator.lib.Locker;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CertificateObject$;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.GhostbustersObject;
import net.ripe.rpki.validator.models.validation.Hashing;
import net.ripe.rpki.validator.models.validation.Hashing$class;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.ManifestObject$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.RoaObject;
import net.ripe.rpki.validator.store.CacheStore$;
import net.ripe.rpki.validator.store.Storage;
import net.ripe.rpki.validator.store.Storage$class;
import org.joda.time.Instant;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0001\u0003\u00015\u0011!bQ1dQ\u0016\u001cFo\u001c:f\u0015\t\u0019A!A\u0003ti>\u0014XM\u0003\u0002\u0006\r\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u000f!\tAA\u001d9lS*\u0011\u0011BC\u0001\u0005e&\u0004XMC\u0001\f\u0003\rqW\r^\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u000fM#xN]1hKB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0010\u0005\u0003\u0019iw\u000eZ3mg&\u0011\u0011\u0005\b\u0002\b\u0011\u0006\u001c\b.\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013A\u00033bi\u0006\u001cv.\u001e:dKB\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0004gFd'\"A\u0015\u0002\u000b)\fg/\u0019=\n\u0005-2#A\u0003#bi\u0006\u001cv.\u001e:dK\")Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"\"a\f\u0019\u0011\u0005]\u0001\u0001\"B\u0012-\u0001\u0004!\u0003b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\ti\u0016l\u0007\u000f\\1uKV\tA\u0007\u0005\u00026\u00016\taG\u0003\u00028q\u0005Qa.Y7fIB\f'/Y7\u000b\u0005eR\u0014\u0001B2pe\u0016T!a\u000f\u001f\u0002\t)$'m\u0019\u0006\u0003{y\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u00053$A\u0007(b[\u0016$\u0007+\u0019:b[\u0016$XM\u001d&eE\u000e$V-\u001c9mCR,\u0007BB\"\u0001A\u0003%A'A\u0005uK6\u0004H.\u0019;fA!9Q\t\u0001b\u0001\n\u00131\u0015A\u0001;y+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&;\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0003\u0019&\u0013A\u0004R1uCN{WO]2f)J\fgn]1di&|g.T1oC\u001e,'\u000f\u0003\u0004O\u0001\u0001\u0006IaR\u0001\u0004ib\u0004\u0003\"\u0002)\u0001\t\u0003\n\u0016AB1u_6L7-\u0006\u0002S+R\u00111+\u0019\t\u0003)Vc\u0001\u0001B\u0003W\u001f\n\u0007qKA\u0001U#\tAf\f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&LA\u0004O_RD\u0017N\\4\u0011\u0005e{\u0016B\u00011[\u0005\r\te.\u001f\u0005\u0007E>#\t\u0019A2\u0002\u0003\u0019\u00042!\u00173T\u0013\t)'L\u0001\u0005=Eft\u0017-\\3?\u0011\u001d9\u0007A1A\u0005\n!\fQB]8b\u001f\nTWm\u0019;UsB,W#A5\u0011\u0005=Q\u0017BA6\u0011\u0005\u0019\u0019FO]5oO\"1Q\u000e\u0001Q\u0001\n%\faB]8b\u001f\nTWm\u0019;UsB,\u0007\u0005C\u0004p\u0001\t\u0007I\u0011\u00025\u0002%5\fg.\u001b4fgR|%M[3diRK\b/\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B5\u0002'5\fg.\u001b4fgR|%M[3diRK\b/\u001a\u0011\t\u000fM\u0004!\u0019!C\u0005Q\u0006i1M\u001d7PE*,7\r\u001e+za\u0016Da!\u001e\u0001!\u0002\u0013I\u0017AD2sY>\u0013'.Z2u)f\u0004X\r\t\u0005\bo\u0002\u0011\r\u0011\"\u0003i\u0003U\u0019WM\u001d;jM&\u001c\u0017\r^3PE*,7\r\u001e+za\u0016Da!\u001f\u0001!\u0002\u0013I\u0017AF2feRLg-[2bi\u0016|%M[3diRK\b/\u001a\u0011\t\u000fm\u0004!\u0019!C\u0005Q\u00061r\r[8ti\n,8\u000f^3sg>\u0013'.Z2u)f\u0004X\r\u0003\u0004~\u0001\u0001\u0006I![\u0001\u0018O\"|7\u000f\u001e2vgR,'o](cU\u0016\u001cG\u000fV=qK\u0002B\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011A\u0001\u000eI\u0016dW\r^5p]\u0012+G.Y=\u0016\u0005\u0005\r\u0001cA-\u0002\u0006%\u0019\u0011q\u0001.\u0003\u0007%sG\u000f\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0002\u00039!W\r\\3uS>tG)\u001a7bs\u0002B\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\u0002\r1|7m[3s+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\u0002B\u0001\u0004Y&\u0014\u0017\u0002BA\u000f\u0003/\u0011a\u0001T8dW\u0016\u0014\b\u0002CA\u0011\u0001\u0001\u0006I!a\u0005\u0002\u000f1|7m[3sA!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012\u0001E:u_J,7)\u001a:uS\u001aL7-\u0019;f)\u0011\tI#a\f\u0011\u0007e\u000bY#C\u0002\u0002.i\u0013A!\u00168ji\"A\u0011\u0011GA\u0012\u0001\u0004\t\u0019$A\u0006dKJ$\u0018NZ5dCR,\u0007cA\u000e\u00026%\u0019\u0011q\u0007\u000f\u0003#\r+'\u000f^5gS\u000e\fG/Z(cU\u0016\u001cG\u000fC\u0004\u0002<\u0001!\t%!\u0010\u0002\u0011M$xN]3S_\u0006$B!!\u000b\u0002@!A\u0011\u0011IA\u001d\u0001\u0004\t\u0019%A\u0002s_\u0006\u00042aGA#\u0013\r\t9\u0005\b\u0002\n%>\fwJ\u00196fGRDq!a\u0013\u0001\t\u0003\ni%A\tti>\u0014Xm\u00125pgR\u0014Wo\u001d;feN$B!!\u000b\u0002P!A\u0011\u0011KA%\u0001\u0004\t\u0019&\u0001\u0007hQ>\u001cHOY;ti\u0016\u00148\u000fE\u0002\u001c\u0003+J1!a\u0016\u001d\u0005I9\u0005n\\:uEV\u001cH/\u001a:t\u001f\nTWm\u0019;\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u0005i1\u000f^8sK6\u000bg.\u001b4fgR$B!!\u000b\u0002`!A\u0011\u0011MA-\u0001\u0004\t\u0019'\u0001\u0005nC:Lg-Z:u!\rY\u0012QM\u0005\u0004\u0003Ob\"AD'b]&4Wm\u001d;PE*,7\r\u001e\u0005\b\u0003W\u0002A\u0011IA7\u0003!\u0019Ho\u001c:f\u0007JdG\u0003BA\u0015\u0003_B\u0001\"!\u001d\u0002j\u0001\u0007\u00111O\u0001\u0004GJd\u0007cA\u000e\u0002v%\u0019\u0011q\u000f\u000f\u0003\u0013\r\u0013Hn\u00142kK\u000e$\bbBA>\u0001\u0011%\u0011QP\u0001\u0010gR|'/\u001a*fa>|%M[3diV!\u0011qPAJ)\u0019\t\t)a\"\u0002(B\u0019\u0011,a!\n\u0007\u0005\u0015%L\u0001\u0004B]f4\u0016\r\u001c\u0005\t\u0003\u0013\u000bI\b1\u0001\u0002\f\u0006\u0019qN\u00196\u0011\u000bm\ti)!%\n\u0007\u0005=ED\u0001\tSKB|7/\u001b;pef|%M[3diB\u0019A+a%\u0005\u000fY\u000bIH1\u0001\u0002\u0016F\u0019\u0001,a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u000611M]=qi>T1!!)\u0007\u0003\u001d\u0019w.\\7p]NLA!!*\u0002\u001c\nY2)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGRD\u0001\"!+\u0002z\u0001\u0007\u00111V\u0001\b_\nTG+\u001f9f!\u0011\ti+a-\u000f\u0007e\u000by+C\u0002\u00022j\u000ba\u0001\u0015:fI\u00164\u0017bA6\u00026*\u0019\u0011\u0011\u0017.\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\u0006qq-\u001a;DKJ$\u0018NZ5dCR,G\u0003BA_\u0003\u0007\u0004R!WA`\u0003gI1!!1[\u0005\u0019y\u0005\u000f^5p]\"A\u0011QYA\\\u0001\u0004\tY+A\u0002ve2Dq!!3\u0001\t\u0003\tY-\u0001\u0007hKRl\u0015M\\5gKN$8\u000f\u0006\u0003\u0002N\u0006e\u0007CBAh\u0003+\f\u0019'\u0004\u0002\u0002R*\u0019\u00111\u001b.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0006E'aA*fc\"A\u00111\\Ad\u0001\u0004\ti.A\u0002bW&\u0004R!WAp\u0003GL1!!9[\u0005\u0015\t%O]1z!\rI\u0016Q]\u0005\u0004\u0003OT&\u0001\u0002\"zi\u0016Dq!a;\u0001\t\u0013\ti/A\u0007hKR\u0014V\r]8PE*,7\r^\u000b\u0005\u0003_\f9\u0010\u0006\u0004\u0002r\nU!q\u0003\u000b\u0005\u0003g\fI\u0010\u0005\u0004\u0002P\u0006U\u0017Q\u001f\t\u0004)\u0006]HA\u0002,\u0002j\n\u0007q\u000b\u0003\u0005\u0002|\u0006%\b\u0019AA\u007f\u0003\u0019i\u0017\r\u001d9feBY\u0011,a@\u0002,\u0006u'1AA{\u0013\r\u0011\tA\u0017\u0002\n\rVt7\r^5p]N\u0002R!WA`\u0005\u000b\u0001BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!\u0001\u0003uS6,'b\u0001B\b}\u0005!!n\u001c3b\u0013\u0011\u0011\u0019B!\u0003\u0003\u000f%s7\u000f^1oi\"A\u00111\\Au\u0001\u0004\ti\u000e\u0003\u0005\u0002*\u0006%\b\u0019AAV\u0011\u001d\u0011Y\u0002\u0001C!\u0005;\t\u0011bZ3u\u001f\nTWm\u0019;\u0015\t\t}!q\u0006\t\u00063\u0006}&\u0011\u0005\t\u0005\u0005G\u0011ICD\u0002\u001c\u0005KI1Aa\n\u001d\u0003A\u0011V\r]8tSR|'/_(cU\u0016\u001cG/\u0003\u0003\u0003,\t5\"A\u0002*P)f\u0004XMC\u0002\u0003(qA\u0001B!\r\u0003\u001a\u0001\u0007\u00111V\u0001\u0005Q\u0006\u001c\b\u000eC\u0004\u00036\u0001!\tAa\u000e\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005%\u0002b\u0002B\u001e\u0001\u0011\u0005!QH\u0001\rG2,\u0017M](cU\u0016\u001cGo\u001d\u000b\u0005\u0003S\u0011y\u0004\u0003\u0005\u0003B\te\u0002\u0019\u0001B\u0003\u0003%yG\u000eZ3s)\"\fg\u000eC\u0004\u0003F\u0001!\tEa\u0012\u0002\r\u0011,G.\u001a;f)\u0019\tIC!\u0013\u0003L!A\u0011Q\u0019B\"\u0001\u0004\tY\u000b\u0003\u0005\u00032\t\r\u0003\u0019AAV\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#\n\u0011$\u001e9eCR,g+\u00197jI\u0006$\u0018n\u001c8US6,7\u000f^1naR1\u0011\u0011\u0006B*\u0005_B\u0001B!\u0016\u0003N\u0001\u0007!qK\u0001\u0005kJd7\u000f\u0005\u0004\u0003Z\t%\u00141\u0016\b\u0005\u00057\u0012)G\u0004\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\t\u0007D\u0001\u0007yI|w\u000e\u001e \n\u0003mK1Aa\u001a[\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u001b\u0003n\tA\u0011\n^3sC\ndWMC\u0002\u0003hiC!B!\u001d\u0003NA\u0005\t\u0019\u0001B\u0003\u0003\u0005!\bb\u0002B;\u0001\u0011%!qO\u0001\ni&lWm\u001d;b[B$BA!\u001f\u0003\u0004B!!1\u0010B@\u001b\t\u0011iH\u0003\u0002(%%!!\u0011\u0011B?\u0005%!\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0003v\tM\u0004\u0019\u0001B\u0003\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013\u000bq!\u001b8ti\u0006tG\u000f\u0006\u0003\u0003\u0004\t-\u0005\u0002\u0003BG\u0005\u000b\u0003\rAa$\u0002\u0003\u0011\u0004BA!%\u0003\u00186\u0011!1\u0013\u0006\u0004\u0005+\u0013\u0012\u0001B;uS2LAA!'\u0003\u0014\n!A)\u0019;f\u0001")
public class CacheStore
implements Storage,
Hashing {
    public final DataSource net$ripe$rpki$validator$store$CacheStore$$dataSource;
    private final NamedParameterJdbcTemplate net$ripe$rpki$validator$store$CacheStore$$template;
    private final DataSourceTransactionManager tx;
    private final String roaObjectType;
    private final String manifestObjectType;
    private final String crlObjectType;
    private final String net$ripe$rpki$validator$store$CacheStore$$certificateObjectType;
    private final String ghostbustersObjectType;
    private final int deletionDelay;
    private final Locker locker;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public byte[] getHash(byte[] bytes) {
        return Hashing$class.getHash(this, bytes);
    }

    @Override
    public String stringify(byte[] bytes) {
        return Hashing$class.stringify(this, bytes);
    }

    @Override
    public Option<byte[]> parseBytes(String hex) {
        return Hashing$class.parseBytes(this, hex);
    }

    @Override
    public boolean equals(byte[] hashA, byte[] hashB) {
        return Hashing$class.equals(this, hashA, hashB);
    }

    @Override
    public Instant updateValidationTimestamp$default$2() {
        return Storage$class.updateValidationTimestamp$default$2(this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CacheStore cacheStore = this;
        synchronized (cacheStore) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public NamedParameterJdbcTemplate net$ripe$rpki$validator$store$CacheStore$$template() {
        return this.net$ripe$rpki$validator$store$CacheStore$$template;
    }

    private DataSourceTransactionManager tx() {
        return this.tx;
    }

    @Override
    public <T> T atomic(Function0<T> f) {
        return (T)new TransactionTemplate((PlatformTransactionManager)this.tx()).execute(new TransactionCallback<T>(this, f){
            private final Function0 f$1;

            public T doInTransaction(TransactionStatus transactionStatus) {
                return (T)this.f$1.apply();
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    private String roaObjectType() {
        return this.roaObjectType;
    }

    private String manifestObjectType() {
        return this.manifestObjectType;
    }

    private String crlObjectType() {
        return this.crlObjectType;
    }

    public String net$ripe$rpki$validator$store$CacheStore$$certificateObjectType() {
        return this.net$ripe$rpki$validator$store$CacheStore$$certificateObjectType;
    }

    private String ghostbustersObjectType() {
        return this.ghostbustersObjectType;
    }

    public int deletionDelay() {
        return this.deletionDelay;
    }

    private Locker locker() {
        return this.locker;
    }

    @Override
    public void storeCertificate(CertificateObject certificate) {
        this.storeRepoObject(certificate, this.net$ripe$rpki$validator$store$CacheStore$$certificateObjectType());
    }

    @Override
    public void storeRoa(RoaObject roa) {
        this.storeRepoObject(roa, this.roaObjectType());
    }

    @Override
    public void storeGhostbusters(GhostbustersObject ghostbusters) {
        this.storeRepoObject(ghostbusters, this.ghostbustersObjectType());
    }

    @Override
    public void storeManifest(ManifestObject manifest) {
        this.storeRepoObject(manifest, this.manifestObjectType());
    }

    @Override
    public void storeCrl(CrlObject crl) {
        this.storeRepoObject(crl, this.crlObjectType());
    }

    private <T extends CertificateRepositoryObject> Object storeRepoObject(RepositoryObject<T> obj, String objType) {
        return this.locker().locked(obj.hash(), new Serializable(this, obj, objType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStore $outer;
            public final RepositoryObject obj$1;
            private final String objType$1;

            public final Object apply() {
                try {
                    scala.collection.immutable.Map params = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"aki"), (Object)this.$outer.stringify(this.obj$1.aki())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"hash"), (Object)this.$outer.stringify(this.obj$1.hash())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)this.obj$1.url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"encoded"), (Object)this.obj$1.encoded()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"object_type"), (Object)this.objType$1)}));
                    int updated = this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().update("UPDATE repo_objects SET url = :url WHERE hash = :hash", JavaConversions$.MODULE$.mapAsJavaMap((Map)params));
                    return updated == 0 ? BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().update("INSERT INTO repo_objects(aki, hash, url, encoded, object_type)\n               VALUES(:aki, :hash, :url, :encoded, :object_type)", JavaConversions$.MODULE$.mapAsJavaMap((Map)params))) : BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    this.$outer.logger().error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$storeRepoObject$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An error occurred while inserting an object: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"url = ", ", hash = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.obj$1.url(), this.$outer.net$ripe$rpki$validator$store$CacheStore$$anonfun$$$outer().stringify(this.$outer.obj$1.hash())}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    throw exception;
                }
            }

            public /* synthetic */ CacheStore net$ripe$rpki$validator$store$CacheStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.obj$1 = obj$1;
                this.objType$1 = objType$1;
            }
        });
    }

    @Override
    public Option<CertificateObject> getCertificate(String url) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, url){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStore $outer;
            private final String url$1;

            public final CertificateObject apply() {
                return (CertificateObject)this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().queryForObject("SELECT url, encoded FROM repo_objects WHERE url = :url AND object_type = :object_type", JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)this.url$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"object_type"), (Object)this.$outer.net$ripe$rpki$validator$store$CacheStore$$certificateObjectType())}))), (RowMapper)new RowMapper<CertificateObject>(this){

                    public CertificateObject mapRow(ResultSet rs, int i) {
                        return CertificateObject$.MODULE$.parse(rs.getString(1), rs.getBytes(2));
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.url$1 = url$1;
            }
        }).toOption();
    }

    @Override
    public Seq<ManifestObject> getManifests(byte[] aki) {
        return this.getRepoObject(aki, this.manifestObjectType(), (Function3)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ManifestObject apply(String url, byte[] bytes, Option<Instant> validationTime) {
                ManifestObject qual$1 = ManifestObject$.MODULE$.parse(url, bytes);
                Option<Instant> x$3 = validationTime;
                String x$4 = qual$1.copy$default$1();
                ManifestCms x$5 = qual$1.copy$default$2();
                return qual$1.copy(x$4, x$5, x$3);
            }
        });
    }

    private <T> Seq<T> getRepoObject(byte[] aki, String objType, Function3<String, byte[], Option<Instant>, T> mapper) {
        return JavaConversions$.MODULE$.asScalaBuffer(this.net$ripe$rpki$validator$store$CacheStore$$template().query("SELECT url, encoded, validation_time\n        FROM repo_objects\n        WHERE aki = :aki AND object_type = :object_type", JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"aki"), (Object)this.stringify(aki)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"object_type"), (Object)objType)}))), new RowMapper<T>(this, mapper){
            private final /* synthetic */ CacheStore $outer;
            private final Function3 mapper$1;

            public T mapRow(ResultSet rs, int i) {
                return (T)this.mapper$1.apply((Object)rs.getString(1), (Object)rs.getBytes(2), this.$outer.net$ripe$rpki$validator$store$CacheStore$$instant(rs.getTimestamp(3)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.mapper$1 = mapper$1;
            }
        })).toSeq();
    }

    @Override
    public Option<RepositoryObject<? extends CertificateRepositoryObject>> getObject(String hash) {
        Try try_;
        block4: {
            Some some;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new $anonfun$1(this, hash));
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    RepositoryObject obj = (RepositoryObject)success.value();
                    some = new Some((Object)obj);
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                this.logger().error((Function0)new Serializable(this, err){
                    public static final long serialVersionUID = 0L;
                    private final Throwable err$1;

                    public final String apply() {
                        return this.err$1.toString();
                    }
                    {
                        this.err$1 = err$1;
                    }
                });
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public void clear() {
        this.net$ripe$rpki$validator$store$CacheStore$$template().update(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE repo_objects"})).s((Seq)Nil$.MODULE$), JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().empty()));
    }

    public void clearObjects(Instant olderThan) {
        Timestamp tt = this.timestamp(olderThan.toDateTime().minusHours(this.deletionDelay()).toInstant());
        this.atomic((Function0)new Serializable(this, olderThan, tt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStore $outer;
            public final Instant olderThan$1;
            private final Timestamp tt$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int i = this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().update(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM repo_objects WHERE validation_time < '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tt$1})), JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().empty()));
                this.$outer.info((Function0<Object>)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clearObjects$1 $outer;
                    private final int i$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clear Old Objects -> ", " object(s) older than ", " deleted from repo_objects"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1), this.$outer.olderThan$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                int j = this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().update(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM repo_objects WHERE validation_time IS NULL AND download_time < '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tt$1})), JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().empty()));
                this.$outer.info((Function0<Object>)new Serializable(this, j){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clearObjects$1 $outer;
                    private final int j$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clear Old Objects -> ", " object(s) downloaded 2 hours before ", " deleted from repo_objects"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.j$1), this.$outer.olderThan$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.j$1 = j$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.olderThan$1 = olderThan$1;
                this.tt$1 = tt$1;
            }
        });
    }

    @Override
    public void delete(String url, String hash) {
        this.locker().locked(url, new Serializable(this, url, hash){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStore $outer;
            private final String url$2;
            private final String hash$2;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.net$ripe$rpki$validator$store$CacheStore$$template().update(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE FROM repo_objects WHERE url = :url AND hash = :hash"})).s((Seq)Nil$.MODULE$), JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"hash"), (Object)this.hash$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)this.url$2)}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.url$2 = url$2;
                this.hash$2 = hash$2;
            }
        });
    }

    @Override
    public void updateValidationTimestamp(Iterable<String> urls, Instant t) {
        Timestamp tt = this.timestamp(t);
        Iterator sqls = urls.grouped(99).map((Function1)new Serializable(this, tt){
            public static final long serialVersionUID = 0L;
            private final Timestamp tt$2;

            public final String apply(Iterable<String> group) {
                String inClause = ((TraversableOnce)group.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2) {
                        return new StringBuilder().append((Object)"'").append((Object)x$2).append((Object)"'").toString();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("(", ",", ")");
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UPDATE repo_objects SET validation_time = '", "' WHERE url IN ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tt$2, inClause}));
            }
            {
                this.tt$2 = tt$2;
            }
        });
        if (sqls.nonEmpty()) {
            this.atomic((Function0)new Serializable(this, sqls){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CacheStore $outer;
                private final Iterator sqls$1;

                public final int[] apply() {
                    return new JdbcTemplate(this.$outer.net$ripe$rpki$validator$store$CacheStore$$dataSource).batchUpdate((String[])this.sqls$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.sqls$1 = sqls$1;
                }
            });
        }
    }

    private Timestamp timestamp(Instant timestamp) {
        return new Timestamp(timestamp.getMillis());
    }

    public Option<Instant> net$ripe$rpki$validator$store$CacheStore$$instant(Date d) {
        return Option$.MODULE$.apply((Object)d).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Instant apply(Date d) {
                return new Instant(d.getTime());
            }
        });
    }

    public CacheStore(DataSource dataSource) {
        this.net$ripe$rpki$validator$store$CacheStore$$dataSource = dataSource;
        Logging.class.$init$((Logging)this);
        Storage$class.$init$(this);
        Hashing$class.$init$(this);
        this.net$ripe$rpki$validator$store$CacheStore$$template = new NamedParameterJdbcTemplate(dataSource);
        this.tx = new DataSourceTransactionManager(dataSource);
        this.roaObjectType = "roa";
        this.manifestObjectType = "mft";
        this.crlObjectType = "crl";
        this.net$ripe$rpki$validator$store$CacheStore$$certificateObjectType = "cer";
        this.ghostbustersObjectType = "gbr";
        this.deletionDelay = 168;
        this.locker = new Locker();
    }
}

