/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import java.io.File;
import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.fetchers.FetcherListener;
import net.ripe.rpki.validator.fetchers.HttpFetcher;
import net.ripe.rpki.validator.fetchers.RsyncFetcher;
import net.ripe.rpki.validator.fetchers.SingleObjectHttpFetcher;
import net.ripe.rpki.validator.fetchers.SingleObjectRsyncFetcher;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.GhostbustersObject;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.RepoFetcher$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.RoaObject;
import net.ripe.rpki.validator.store.HttpFetcherStore;
import net.ripe.rpki.validator.store.Storage;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001=\u00111BU3q_\u001a+Go\u00195fe*\u00111\u0001B\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0003\u0007\u0003\u0019iw\u000eZ3mg*\u0011q\u0001C\u0001\nm\u0006d\u0017\u000eZ1u_JT!!\u0003\u0006\u0002\tI\u00048.\u001b\u0006\u0003\u00171\tAA]5qK*\tQ\"A\u0002oKR\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bgR|'/Y4f!\tIB$D\u0001\u001b\u0015\tYb!A\u0003ti>\u0014X-\u0003\u0002\u001e5\t91\u000b^8sC\u001e,\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0013!$H\u000f]*u_J,\u0007CA\r\"\u0013\t\u0011#D\u0001\tIiR\u0004h)\u001a;dQ\u0016\u00148\u000b^8sK\"AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0004d_:4\u0017n\u001a\t\u0003M%j\u0011a\n\u0006\u0003Q\u0019\t\u0001BZ3uG\",'o]\u0005\u0003U\u001d\u0012QBR3uG\",'oQ8oM&<\u0007\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\b\u0006\u0003/aE\u0012\u0004CA\u0018\u0001\u001b\u0005\u0011\u0001\"B\f,\u0001\u0004A\u0002\"B\u0010,\u0001\u0004\u0001\u0003\"\u0002\u0013,\u0001\u0004)\u0003b\u0002\u001b\u0001\u0005\u0004%\t!N\u0001\reNLhnY+sYB{w\u000e\\\u000b\u0002mA\u0019q\u0007\u0010 \u000e\u0003aR!!\u000f\u001e\u0002\u000f5,H/\u00192mK*\u00111HE\u0001\u000bG>dG.Z2uS>t\u0017BA\u001f9\u0005\r\u0019V\r\u001e\t\u0003\u007f\ts!!\u0005!\n\u0005\u0005\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011\n\t\r\u0019\u0003\u0001\u0015!\u00037\u00035\u00118/\u001f8d+Jd\u0007k\\8mA!9\u0001\n\u0001b\u0001\n\u0003)\u0014a\u00035uiB,&\u000f\u001c)p_2DaA\u0013\u0001!\u0002\u00131\u0014\u0001\u00045uiB,&\u000f\u001c)p_2\u0004\u0003\"\u0002'\u0001\t\u0013i\u0015aB2ik:\\W\r\u001a\u000b\u0003\u001dJ\u00032a\u0014)?\u001b\u0005Q\u0014BA);\u0005\r\u0019V-\u001d\u0005\u0006'.\u0003\rAP\u0001\u0004kJL\u0007\"B+\u0001\t\u00031\u0016a\u00034fi\u000eDwJ\u00196fGR$\"aV5\u0011\u0007a\u0003'M\u0004\u0002Z=:\u0011!,X\u0007\u00027*\u0011ALD\u0001\u0007yI|w\u000e\u001e \n\u0003MI!a\u0018\n\u0002\u000fA\f7m[1hK&\u0011\u0011+\u0019\u0006\u0003?J\u0001\"a\u00194\u000f\u0005\u0019\"\u0017BA3(\u0003\u001d1U\r^2iKJL!a\u001a5\u0003\u000b\u0015\u0013(o\u001c:\u000b\u0005\u0015<\u0003\"\u00026U\u0001\u0004Y\u0017!C8cU\u0016\u001cG/\u0016:j!\ta\u0007/D\u0001n\u0015\tiaNC\u0001p\u0003\u0011Q\u0017M^1\n\u0005El'aA+S\u0013\")1\u000f\u0001C\u0001i\u0006Ia-\u001a;dQJ+\u0007o\u001c\u000b\u0003/VDQA\u001e:A\u0002-\fqA]3q_V\u0013\u0018\u000eC\u0003y\u0001\u0011%\u00110A\u0003gKR\u001c\u0007\u000eF\u0002XunDQA^<A\u0002-DQ\u0001`<A\u0002u\fqAZ3uG\",'\u000f\u0005\u0002'}&\u0011qp\n\u0002\b\r\u0016$8\r[3s\u000f\u001d\t\u0019A\u0001E\u0001\u0003\u000b\t1BU3q_\u001a+Go\u00195feB\u0019q&a\u0002\u0007\r\u0005\u0011\u0001\u0012AA\u0005'\r\t9\u0001\u0005\u0005\bY\u0005\u001dA\u0011AA\u0007)\t\t)\u0001\u0003\u0005\u0002\u0012\u0005\u001dA\u0011AA\n\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q\u0013QCA\u0013\u0011!\t9\"a\u0004A\u0002\u0005e\u0011\u0001E:u_J\fw-\u001a#je\u0016\u001cGo\u001c:z!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010]\u0006\u0011\u0011n\\\u0005\u0005\u0003G\tiB\u0001\u0003GS2,\u0007B\u0002\u0013\u0002\u0010\u0001\u0007Q\u0005\u0003\u0005\u0002*\u0005\u001dA\u0011AA\u0016\u0003!Ig.T3n_JLHc\u0001\u0018\u0002.!1A%a\nA\u0002\u0015\u0002")
public class RepoFetcher {
    public final Storage net$ripe$rpki$validator$models$validation$RepoFetcher$$storage;
    private final HttpFetcherStore httpStore;
    private final FetcherConfig config;
    private final Set<String> rsyncUrlPool;
    private final Set<String> httpUrlPool;

    public static RepoFetcher inMemory(FetcherConfig fetcherConfig) {
        return RepoFetcher$.MODULE$.inMemory(fetcherConfig);
    }

    public static RepoFetcher apply(File file, FetcherConfig fetcherConfig) {
        return RepoFetcher$.MODULE$.apply(file, fetcherConfig);
    }

    public Set<String> rsyncUrlPool() {
        return this.rsyncUrlPool;
    }

    public Set<String> httpUrlPool() {
        return this.httpUrlPool;
    }

    private Seq<String> chunked(String uri) {
        return (Seq)((TraversableLike)((Tuple2)Predef$.MODULE$.refArrayOps((Object[])uri.split("/")).toSeq().foldLeft((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<Seq<String>>, Seq<String>> apply(Tuple2<Seq<Seq<String>>, Seq<String>> accum, String ch) {
                Seq newLatest = (Seq)((SeqLike)accum._2()).$colon$plus((Object)ch, Seq$.MODULE$.canBuildFrom());
                return new Tuple2(((SeqLike)accum._1()).$colon$plus((Object)newLatest, Seq$.MODULE$.canBuildFrom()), (Object)newLatest);
            }
        }))._1()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$3) {
                return x$3.mkString("", "/", "/");
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Fetcher.Error> fetchObject(URI objectUri) {
        block7: {
            Fetcher fetcher;
            block6: {
                boolean bl;
                String string;
                block5: {
                    String string2 = string = objectUri.getScheme();
                    if ("rsync" != null ? !"rsync".equals(string2) : string2 != null) break block5;
                    fetcher = new SingleObjectRsyncFetcher(this.config);
                    break block6;
                }
                String string3 = string;
                if (!("http" != null ? !"http".equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = string;
                    bl = !("https" != null ? !"https".equals(string4) : string4 != null);
                }
                if (!bl) break block7;
                fetcher = new SingleObjectHttpFetcher(this.httpStore);
            }
            SingleObjectRsyncFetcher fetcher2 = fetcher;
            return this.fetch(objectUri, fetcher2);
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No fetcher for the object ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{objectUri})));
    }

    public Seq<Fetcher.Error> fetchRepo(URI repoUri) {
        block7: {
            Fetcher fetcher;
            block6: {
                boolean bl;
                String string;
                block5: {
                    String string2 = string = repoUri.getScheme();
                    if ("rsync" != null ? !"rsync".equals(string2) : string2 != null) break block5;
                    fetcher = new RsyncFetcher(this.config);
                    break block6;
                }
                String string3 = string;
                if (!("http" != null ? !"http".equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = string;
                    bl = !("https" != null ? !"https".equals(string4) : string4 != null);
                }
                if (!bl) break block7;
                fetcher = new HttpFetcher(this.httpStore);
            }
            RsyncFetcher fetcher2 = fetcher;
            return this.fetch(repoUri, fetcher2);
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No fetcher for the uri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repoUri})));
    }

    private Seq<Fetcher.Error> fetch(URI repoUri, Fetcher fetcher) {
        return (Seq)this.net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.atomic(new Serializable(this, repoUri, fetcher){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepoFetcher $outer;
            private final URI repoUri$1;
            private final Fetcher fetcher$1;

            public final Seq<Fetcher.Error> apply() {
                return this.fetcher$1.fetch(this.repoUri$1, new FetcherListener(this){
                    private final /* synthetic */ $anonfun$fetch$1 $outer;

                    public void processObject(RepositoryObject<? extends CertificateRepositoryObject> repoObj) {
                        RepositoryObject<? extends CertificateRepositoryObject> repositoryObject;
                        block7: {
                            block3: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                repositoryObject = repoObj;
                                                if (!(repositoryObject instanceof CertificateObject)) break block2;
                                                CertificateObject certificateObject = (CertificateObject)repositoryObject;
                                                this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.storeCertificate(certificateObject);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(repositoryObject instanceof CrlObject)) break block4;
                                            CrlObject crlObject = (CrlObject)repositoryObject;
                                            this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.storeCrl(crlObject);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(repositoryObject instanceof ManifestObject)) break block5;
                                        ManifestObject manifestObject = (ManifestObject)repositoryObject;
                                        this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.storeManifest(manifestObject);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(repositoryObject instanceof RoaObject)) break block6;
                                    RoaObject roaObject = (RoaObject)repositoryObject;
                                    this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.storeRoa(roaObject);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(repositoryObject instanceof GhostbustersObject)) break block7;
                                GhostbustersObject ghostbustersObject = (GhostbustersObject)repositoryObject;
                                this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.storeGhostbusters(ghostbustersObject);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(repositoryObject);
                    }

                    public void withdraw(URI url, String hash) {
                        this.$outer.net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer().net$ripe$rpki$validator$models$validation$RepoFetcher$$storage.delete(url.toString(), hash);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RepoFetcher net$ripe$rpki$validator$models$validation$RepoFetcher$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.repoUri$1 = repoUri$1;
                this.fetcher$1 = fetcher$1;
            }
        });
    }

    public RepoFetcher(Storage storage, HttpFetcherStore httpStore, FetcherConfig config) {
        this.net$ripe$rpki$validator$models$validation$RepoFetcher$$storage = storage;
        this.httpStore = httpStore;
        this.config = config;
        this.rsyncUrlPool = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.httpUrlPool = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

