/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import grizzled.slf4j.Logger;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.TopDownWalker;
import net.ripe.rpki.validator.models.TrustAnchorValidationProcess$;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.RepoFetcher$;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.DurableCaches$;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.Instant;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u00015\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\tb+\u00197jI\u0006$\u0018n\u001c8Qe>\u001cWm]:\t\u0011e\u0001!Q1A\u0005Bi\t!\u0003\u001e:vgR\fen\u00195pe2{7-\u0019;peV\t1\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\t\u0005!Q\u000f^5m\u0013\t\u0001SD\u0001\nUeV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002'Q\u0014Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nA\"\\1y'R\fG.\u001a#bsN\u0004\"a\u0004\u0014\n\u0005\u001d\u0002\"aA%oi\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\tti>\u0014\u0018mZ3ESJ,7\r^8ssB\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0003S>T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t!a)\u001b7f\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014\u0001\u0003:ts:\u001cG)\u001b:\u0011\u0005UBdBA\b7\u0013\t9\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\u0011\u0011!a\u0004A!A!\u0002\u0013!\u0014A\u0002;b\u001d\u0006lW\r\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003U)g.\u00192mK2{wn]3WC2LG-\u0019;j_:\u0004\"a\u0004!\n\u0005\u0005\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u00153u\tS%K\u0017B\u0011Q\u0003\u0001\u0005\u00063\t\u0003\ra\u0007\u0005\u0006I\t\u0003\r!\n\u0005\u0006S\t\u0003\rA\u000b\u0005\u0006g\t\u0003\r\u0001\u000e\u0005\u0006y\t\u0003\r\u0001\u000e\u0005\b}\t\u0003\n\u00111\u0001@\u0011\u001di\u0005A1A\u0005\n9\u000b\u0011C^1mS\u0012\fG/[8o\u001fB$\u0018n\u001c8t+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003)\u001a\tqaY8n[>t7/\u0003\u0002W#\n\tb+\u00197jI\u0006$\u0018n\u001c8PaRLwN\\:\t\ra\u0003\u0001\u0015!\u0003P\u0003I1\u0018\r\\5eCRLwN\\(qi&|gn\u001d\u0011\t\u000fi\u0003!\u0019!C\u00017\u0006)1\u000f^8sKV\tA\f\u0005\u0002^?6\taL\u0003\u0002[\t%\u0011\u0001M\u0018\u0002\u000b\u0007\u0006\u001c\u0007.Z*u_J,\u0007B\u00022\u0001A\u0003%A,\u0001\u0004ti>\u0014X\r\t\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0003-\u0011X\r]8TKJ4\u0018nY3\u0016\u0003\u0019\u0004\"!F4\n\u0005!\u0014!a\u0003*fa>\u001cVM\u001d<jG\u0016DaA\u001b\u0001!\u0002\u00131\u0017\u0001\u0004:fa>\u001cVM\u001d<jG\u0016\u0004\u0003\"\u00027\u0001\t\u0003j\u0017!G3yiJ\f7\r\u001e+skN$\u0018I\\2i_JdunY1u_J$\u0012A\u001c\t\u0003+=L!\u0001\u001d\u0002\u0003\u001fY\u000bG.\u001b3bi\u0016$wJ\u00196fGRDQA\u001d\u0001\u0005BM\fqB^1mS\u0012\fG/Z(cU\u0016\u001cGo\u001d\u000b\u0003ir\u0004B!N;x]&\u0011aO\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001={\u001b\u0005I(BA\u0006/\u0013\tY\u0018PA\u0002V%&CQ!`9A\u0002y\f1bY3si&4\u0017nY1uKB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002#\u0006\u0001rN\u00196fGR4\u0018\r\\5eCR|'o]\u0005\u0005\u0003\u000f\t\tA\u0001\u0017DKJ$\u0018NZ5dCR,'+\u001a9pg&$xN]=PE*,7\r\u001e,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\"9\u00111\u0002\u0001\u0005\n\u00055\u0011AD6fs&sgm\\'bi\u000eDWm\u001d\u000b\u0004\u007f\u0005=\u0001bB?\u0002\n\u0001\u0007\u0011\u0011\u0003\t\u0005\u0003'\t9\"\u0004\u0002\u0002\u0016)\u0011!KA\u0005\u0005\u00033\t)BA\tDKJ$\u0018NZ5dCR,wJ\u00196fGR<\u0011\"!\b\u0003\u0003\u0003E\t!a\b\u00029Q\u0013Xo\u001d;B]\u000eDwN\u001d,bY&$\u0017\r^5p]B\u0013xnY3tgB\u0019Q#!\t\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u00192!!\t\u000f\u0011\u001d\u0019\u0015\u0011\u0005C\u0001\u0003O!\"!a\b\t\u0015\u0005-\u0012\u0011EI\u0001\n\u0003\ti#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003_Q3aPA\u0019W\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001f!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0013q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    private final ValidationOptions validationOptions;
    private final CacheStore store;
    private final RepoService repoService;
    private final Logger logger;

    public static boolean $lessinit$greater$default$6() {
        return TrustAnchorValidationProcess$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$ValidationProcess$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Validation<String, Map<URI, ValidatedObject>> runProcess() {
        return ValidationProcess$class.runProcess(this);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions validationOptions() {
        return this.validationOptions;
    }

    public CacheStore store() {
        return this.store;
    }

    public RepoService repoService() {
        return this.repoService;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator() {
        URI uri = this.trustAnchorLocator().getCertificateLocation();
        ValidationResult validationResult = ValidationResult.withLocation((URI)uri);
        Seq<Fetcher.Error> errors = this.repoService().visitObject(uri);
        errors.foreach((Function1)new Serializable(this, validationResult){
            public static final long serialVersionUID = 0L;
            private final ValidationResult validationResult$1;

            public final ValidationResult apply(Fetcher.Error e) {
                return this.validationResult$1.warn("validator.repository.object.not.found", new String[]{e.toString()});
            }
            {
                this.validationResult$1 = validationResult$1;
            }
        });
        Option<CertificateObject> certificate = this.store().getCertificate(uri.toString());
        Boolean bl = certificate.isDefined() ? BoxesRunTime.boxToBoolean((boolean)validationResult.rejectIfFalse(this.keyInfoMatches((CertificateObject)certificate.get()), "trust.anchor.public.key.match", new String[0])) : validationResult.rejectForLocation(new ValidationLocation(uri), "validator.repository.object.not.in.cache", new String[]{"Trust Anchor Certificate"});
        return validationResult.hasFailureForCurrentLocation() ? new InvalidObject(uri, (scala.collection.immutable.Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForCurrentLocation()).asScala()).toSet()) : new ValidObject(uri, (scala.collection.immutable.Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForCurrentLocation()).asScala()).toSet(), (CertificateRepositoryObject)((CertificateObject)certificate.get()).decoded());
    }

    @Override
    public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
        Instant startTime = Instant.now();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcess $outer;

            public final Seq<Fetcher.Error> apply(URI uri) {
                return this.$outer.repoService().visitRepo(uri);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        TopDownWalker walker = new TopDownWalker(certificate, this.store(), this.repoService(), this.validationOptions(), startTime, (Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Map<URI, ValidatedObject> result = walker.execute();
        this.store().clearObjects(startTime);
        return result;
    }

    private boolean keyInfoMatches(CertificateObject certificate) {
        String string = this.trustAnchorLocator().getPublicKeyInfo();
        String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.decoded().getCertificate());
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, int maxStaleDays, File storageDirectory, String rsyncDir, String taName, boolean enableLooseValidation2) {
        this.trustAnchorLocator = trustAnchorLocator;
        ValidationProcess$class.$init$(this);
        this.validationOptions = new ValidationOptions();
        this.validationOptions().setMaxStaleDays(maxStaleDays);
        this.validationOptions().setLooseValidationEnabled(enableLooseValidation2);
        this.store = DurableCaches$.MODULE$.apply(storageDirectory);
        this.repoService = new RepoService(RepoFetcher$.MODULE$.apply(storageDirectory, new FetcherConfig(rsyncDir)));
    }
}

