/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisEntry;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.matching.Regex;

public final class BgpRisDump$
implements Logging,
Serializable {
    public static final BgpRisDump$ MODULE$;
    private final Regex BgpEntryRegex;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    static {
        new BgpRisDump$();
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BgpRisDump$ bgpRisDump$ = this;
        synchronized (bgpRisDump$) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public Either<Exception, IndexedSeq<BgpRisEntry>> parse(InputStream is) {
        Left left;
        BgpRisDump.ObjectIdentityMap identityMap = new BgpRisDump.ObjectIdentityMap();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            left = package$.MODULE$.Right().apply((Object)package$.MODULE$.Iterator().continually((Function0)new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final BufferedReader reader$1;

                public final String apply() {
                    return this.reader$1.readLine();
                }
                {
                    this.reader$1 = reader$1;
                }
            }).takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1 != null;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<BgpRisEntry> apply(String content) {
                    return Option$.MODULE$.option2Iterable(BgpRisDump$.MODULE$.parseLine(content));
                }
            }).map((Function1)new Serializable(identityMap){
                public static final long serialVersionUID = 0L;
                private final BgpRisDump.ObjectIdentityMap identityMap$1;

                public final BgpRisEntry apply(BgpRisEntry x$2) {
                    return BgpRisDump$.MODULE$.net$ripe$rpki$validator$bgp$preview$BgpRisDump$$makeResourcesUnique(this.identityMap$1, x$2);
                }
                {
                    this.identityMap$1 = identityMap$1;
                }
            }).toIndexedSeq());
        }
        catch (Exception exception) {
            left = package$.MODULE$.Left().apply((Object)exception);
        }
        return left;
    }

    public BgpRisEntry net$ripe$rpki$validator$bgp$preview$BgpRisDump$$makeResourcesUnique(BgpRisDump.ObjectIdentityMap identityMap, BgpRisEntry entry) {
        Asn asn = identityMap.makeUnique(entry.origin());
        IpRange prefix = (IpRange)identityMap.makeUnique(entry.prefix().getStart()).upTo(identityMap.makeUnique(entry.prefix().getEnd()));
        return entry.copy(asn, prefix, entry.copy$default$3());
    }

    private Regex BgpEntryRegex() {
        return this.BgpEntryRegex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<BgpRisEntry> parseLine(String content) {
        Some some;
        String string = content;
        Option option = this.BgpEntryRegex().unapplySeq((Object)string);
        if (option.isEmpty()) return None$.MODULE$;
        if (option.get() == null) return None$.MODULE$;
        if (((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) return None$.MODULE$;
        String asn = (String)((LinearSeqOptimized)option.get()).apply(0);
        String ipprefix = (String)((LinearSeqOptimized)option.get()).apply(1);
        String visibility = (String)((LinearSeqOptimized)option.get()).apply(2);
        try {
            some = new Some((Object)new BgpRisEntry(Asn.parse((String)asn), IpRange.parse((String)ipprefix), Integer.parseInt(visibility)));
            return some;
        }
        catch (Throwable throwable) {
            this.error((Function0<Object>)new Serializable(content){
                public static final long serialVersionUID = 0L;
                private final String content$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Skipping unparseble line: ").append((Object)this.content$1).toString();
                }
                {
                    this.content$1 = content$1;
                }
            });
            this.debug((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Detailed error: ";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            some = None$.MODULE$;
        }
        return some;
    }

    public BgpRisDump apply(String url, Option<DateTime> lastModified2, Seq<BgpRisEntry> entries) {
        return new BgpRisDump(url, lastModified2, entries);
    }

    public Option<Tuple3<String, Option<DateTime>, Seq<BgpRisEntry>>> unapply(BgpRisDump x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.url(), x$0.lastModified(), x$0.entries()));
    }

    public Option<DateTime> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public Seq<BgpRisEntry> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<DateTime> apply$default$2() {
        return None$.MODULE$;
    }

    public Seq<BgpRisEntry> apply$default$3() {
        return Nil$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BgpRisDump$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.BgpEntryRegex = new StringOps(Predef$.MODULE$.augmentString("^\\s*([0-9]+)\\s+([0-9a-fA-F.:/]+)\\s+([0-9]+)\\s*$")).r();
    }
}

