/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.util;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.ripe.rpki.validator.util.TrustAnchorExtractorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class TrustAnchorLocator {
    private final File file;
    private final String caName;
    private final URI certificateLocation;
    private final String publicKeyInfo;
    private final List<URI> prefetchUris;

    public static TrustAnchorLocator fromFile(File file) throws TrustAnchorExtractorException {
        try {
            String contents = Files.toString((File)file, (Charset)Charsets.UTF_8);
            if (contents.trim().startsWith("rsync://")) {
                return TrustAnchorLocator.readStandardTrustAnchorLocator(file, contents);
            }
            return TrustAnchorLocator.readExtendedTrustAnchorLocator(file, contents);
        }
        catch (IllegalArgumentException e) {
            throw new TrustAnchorExtractorException("failed to load trust anchor locator " + file + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TrustAnchorExtractorException("failed to open trust anchor locator " + file + ": " + e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new TrustAnchorExtractorException("failed to load trust anchor locator " + file + ": " + e.getMessage(), e);
        }
    }

    private static TrustAnchorLocator readStandardTrustAnchorLocator(File file, String contents) throws URISyntaxException {
        String caName = Files.getNameWithoutExtension((String)file.getName());
        String[] lines = contents.trim().split("\\s*(\r\n|\n\r|\n|\r)\\s*");
        URI location = new URI(lines[0]);
        int i = 1;
        while (lines[i].startsWith("rsync://")) {
            ++i;
        }
        String publicKeyInfo = StringUtils.join((Object[])Arrays.copyOfRange(lines, i, lines.length));
        return new TrustAnchorLocator(file, caName, location, publicKeyInfo, new ArrayList<URI>());
    }

    private static TrustAnchorLocator readExtendedTrustAnchorLocator(File file, String contents) throws IOException, URISyntaxException {
        Properties p = new Properties();
        p.load(new StringReader(contents));
        String caName = p.getProperty("ca.name");
        String loc = p.getProperty("certificate.location");
        Validate.notEmpty((String)loc, (String)"'certificate.location' must be provided");
        URI location = new URI(loc);
        String publicKeyInfo = p.getProperty("public.key.info", "").replaceAll("\\s+", "");
        String[] uris = p.getProperty("prefetch.uris", "").split(",");
        ArrayList<URI> prefetchUris = new ArrayList<URI>(uris.length);
        for (String uri : uris) {
            if (!StringUtils.isNotBlank((String)(uri = uri.trim()))) continue;
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            prefetchUris.add(new URI(uri));
        }
        return new TrustAnchorLocator(file, caName, location, publicKeyInfo, prefetchUris);
    }

    public TrustAnchorLocator(File file, String caName, URI location, String publicKeyInfo, List<URI> prefetchUris) {
        Validate.notEmpty((String)caName, (String)"'ca.name' must be provided");
        Validate.notNull((Object)location, (String)"'certificate.location' must be provided");
        Validate.notEmpty((String)publicKeyInfo, (String)"'public.key.info' must be provided");
        this.file = file;
        this.caName = caName;
        this.certificateLocation = location;
        this.publicKeyInfo = publicKeyInfo;
        this.prefetchUris = prefetchUris;
    }

    public File getFile() {
        return this.file;
    }

    public String getCaName() {
        return this.caName;
    }

    public URI getCertificateLocation() {
        return this.certificateLocation;
    }

    public String getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public List<URI> getPrefetchUris() {
        return this.prefetchUris;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("caName", (Object)this.getCaName()).add("certificationLocation", (Object)this.getCertificateLocation()).toString();
    }
}

