/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import akka.util.ByteString$;
import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.Timestamp;
import javax.sql.DataSource;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u00015\u0011QCU3q_NLGo\u001c:z\u001f\nTWm\u0019;Ti>\u0014XM\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u000bI\u0006$\u0018m]8ve\u000e,\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00027\u0005)!.\u0019<bq&\u0011Q\u0004\u0007\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0005!)QC\ba\u0001-!9Q\u0005\u0001b\u0001\n\u00031\u0013\u0001\u0003;f[Bd\u0017\r^3\u0016\u0003\u001d\u0002\"\u0001K\u0019\u000e\u0003%R!AK\u0016\u0002\t\r|'/\u001a\u0006\u0003Y5\nAA\u001b3cG*\u0011afL\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001'A\u0002pe\u001eL!AM\u0015\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\t\rQ\u0002\u0001\u0015!\u0003(\u0003%!X-\u001c9mCR,\u0007\u0005C\u00047\u0001\t\u0007I\u0011A\u001c\u0002\r\t\f7/\u001a\u001c5+\u0005A\u0004CA\u001dC\u001b\u0005Q$BA\u001e=\u0003\tIwN\u0003\u0002>}\u000511m\\7n_:T!a\u0010!\u0002\r\u001d|wn\u001a7f\u0015\u0005\t\u0015aA2p[&\u00111I\u000f\u0002\r\u0005\u0006\u001cX-\u00128d_\u0012Lgn\u001a\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u000f\t\f7/\u001a\u001c5A!)q\t\u0001C\u0001\u0011\u0006\u0019\u0001/\u001e;\u0015\u0005%c\u0005CA\bK\u0013\tY\u0005C\u0001\u0003V]&$\b\"B'G\u0001\u0004q\u0015a\u0004:fiJLWM^3e\u001f\nTWm\u0019;\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E#\u0011AB7pI\u0016d7/\u0003\u0002T!\n12\u000b^8sK\u0012\u0014V\r]8tSR|'/_(cU\u0016\u001cG\u000fC\u0003H\u0001\u0011\u0005Q\u000b\u0006\u0002J-\")q\u000b\u0016a\u00011\u0006\u0001\"/\u001a;sS\u00164X\rZ(cU\u0016\u001cGo\u001d\t\u00043\u0006teB\u0001.`\u001d\tYf,D\u0001]\u0015\tiF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011\u0001\rE\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0002TKFT!\u0001\u0019\t\t\u000b\u0015\u0004A\u0011\u00014\u0002\u0019A,(oZ3FqBL'/\u001a3\u0015\u0005%;\u0007b\u00025e!\u0003\u0005\r![\u0001\r[\u0006D8\u000b^1mK\u0012\u000b\u0017p\u001d\t\u0003\u001f)L!a\u001b\t\u0003\u0007%sG\u000fC\u0003n\u0001\u0011\u0005a.A\u0003dY\u0016\f'\u000fF\u0001J\u0011\u0015\u0001\b\u0001\"\u0001r\u000399W\r\u001e'bi\u0016\u001cHOQ=Ve2$\"A];\u0011\u0007=\u0019h*\u0003\u0002u!\t1q\n\u001d;j_:DQA^8A\u0002]\f1!\u001e:m!\tAH0D\u0001z\u0015\tY!PC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uL(aA+S\u0013\"1q\u0010\u0001C\u0001\u0003\u0003\t\u0011bZ3u\u0005fD\u0015m\u001d5\u0015\u0007I\f\u0019\u0001C\u0004\u0002\u0006y\u0004\r!a\u0002\u0002\t!\f7\u000f\u001b\t\u0006\u001f\u0005%\u0011QB\u0005\u0004\u0003\u0017\u0001\"!B!se\u0006L\bcA\b\u0002\u0010%\u0019\u0011\u0011\u0003\t\u0003\t\tKH/\u001a\u0005\b\u0003+\u0001A\u0011BA\f\u0003E9W\r^(qi&|g.\u00197SKN,H\u000e\u001e\u000b\u0006e\u0006e\u00111\u0006\u0005\t\u00037\t\u0019\u00021\u0001\u0002\u001e\u0005a1/\u001a7fGR\u001cFO]5oOB!\u0011qDA\u0013\u001d\ry\u0011\u0011E\u0005\u0004\u0003G\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twMC\u0002\u0002$AA\u0001\"!\f\u0002\u0014\u0001\u0007\u0011qF\u0001\u000bg\u0016dWm\u0019;Be\u001e\u001c\b#B\b\u0002\n\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\"0\u0001\u0003mC:<\u0017\u0002BA\u001e\u0003k\u0011aa\u00142kK\u000e$hABA \u0001\u0011\t\tE\u0001\nTi>\u0014X\rZ(cU\u0016\u001cG/T1qa\u0016\u00148CBA\u001f\u0003c\t\u0019\u0005\u0005\u0003)\u0003\u000br\u0015bAA$S\tI!k\\<NCB\u0004XM\u001d\u0005\b?\u0005uB\u0011AA&)\t\ti\u0005\u0005\u0003\u0002P\u0005uR\"\u0001\u0001\t\u0011\u0005M\u0013Q\bC!\u0003+\na!\\1q%><H#\u0002(\u0002X\u0005\u0015\u0004\u0002CA-\u0003#\u0002\r!a\u0017\u0002\u0005I\u001c\b\u0003BA/\u0003Cj!!a\u0018\u000b\u0005eQ\u0018\u0002BA2\u0003?\u0012\u0011BU3tk2$8+\u001a;\t\u000f\u0005\u001d\u0014\u0011\u000ba\u0001S\u00061!o\\<Ok6D\u0011\"a\u001b\u0001#\u0003%\t!!\u001c\u0002-A,(oZ3FqBL'/\u001a3%I\u00164\u0017-\u001e7uIE*\"!a\u001c+\u0007%\f\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\ti\bE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RepositoryObjectStore {
    private final JdbcTemplate template;
    private final BaseEncoding base64;

    public JdbcTemplate template() {
        return this.template;
    }

    public BaseEncoding base64() {
        return this.base64;
    }

    public void put(StoredRepositoryObject retrievedObject) {
        Long updateOrder = Predef$.MODULE$.long2Long(this.template().queryForLong("SELECT NEXTVAL('update_order_seq')"));
        try {
            this.template().update("insert into retrieved_objects (hash, uri, encoded_object, expires, update_order) values (?, ?, ?, ?, ?)", new Object[]{this.base64().encode((byte[])retrievedObject.hash().toArray(ClassTag$.MODULE$.Byte())), retrievedObject.uri().toString(), this.base64().encode((byte[])retrievedObject.binaryObject().toArray(ClassTag$.MODULE$.Byte())), new Timestamp(retrievedObject.expires().getMillis()), updateOrder});
        }
        catch (DuplicateKeyException duplicateKeyException) {
            this.template().update("update retrieved_objects set update_order = ? where hash = ?", new Object[]{updateOrder, this.base64().encode((byte[])retrievedObject.hash().toArray(ClassTag$.MODULE$.Byte()))});
        }
    }

    public void put(Seq<StoredRepositoryObject> retrievedObjects) {
        retrievedObjects.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepositoryObjectStore $outer;

            public final void apply(StoredRepositoryObject retrievedObject) {
                this.$outer.put(retrievedObject);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void purgeExpired(int maxStaleDays) {
        DateTime mustBeValidAfter = new DateTime().minusDays(maxStaleDays);
        this.template().update("delete from retrieved_objects where expires < ?", new Object[]{new Timestamp(mustBeValidAfter.getMillis())});
    }

    public int purgeExpired$default$1() {
        return 0;
    }

    public void clear() {
        this.template().update("truncate table retrieved_objects");
    }

    public Option<StoredRepositoryObject> getLatestByUrl(URI url) {
        String selectString = "select * from retrieved_objects where uri = ? order by update_order desc limit 1";
        Object[] selectArgs = new Object[]{url.toString()};
        return this.getOptionalResult(selectString, selectArgs);
    }

    public Option<StoredRepositoryObject> getByHash(byte[] hash) {
        String encodedHash = this.base64().encode(hash);
        String selectString = "select * from retrieved_objects where hash = ?";
        Object[] selectArgs = new Object[]{encodedHash};
        return this.getOptionalResult(selectString, selectArgs);
    }

    private Option<StoredRepositoryObject> getOptionalResult(String selectString, Object[] selectArgs) {
        Some some;
        try {
            some = new Some(this.template().queryForObject(selectString, selectArgs, (RowMapper)new StoredObjectMapper()));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public RepositoryObjectStore(DataSource datasource) {
        this.template = new JdbcTemplate(datasource);
        this.base64 = BaseEncoding.base64();
    }

    public class StoredObjectMapper
    implements RowMapper<StoredRepositoryObject> {
        public StoredRepositoryObject mapRow(ResultSet rs, int rowNum) {
            return new StoredRepositoryObject(ByteString$.MODULE$.apply(this.net$ripe$rpki$validator$store$RepositoryObjectStore$StoredObjectMapper$$$outer().base64().decode((CharSequence)rs.getString("hash"))), URI.create(rs.getString("uri")), ByteString$.MODULE$.apply(this.net$ripe$rpki$validator$store$RepositoryObjectStore$StoredObjectMapper$$$outer().base64().decode((CharSequence)rs.getString("encoded_object"))), new DateTime((Object)rs.getTimestamp("expires")).withZone(DateTimeZone.UTC));
        }

        public /* synthetic */ RepositoryObjectStore net$ripe$rpki$validator$store$RepositoryObjectStore$StoredObjectMapper$$$outer() {
            return RepositoryObjectStore.this;
        }

        public StoredObjectMapper() {
            if (RepositoryObjectStore.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

