/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ObjectCountDrop;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchorValidations;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.ValidatedObjectsTest$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.testing.TestingObjectMother$;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E<Q!\u0001\u0002\t\u00025\tACV1mS\u0012\fG/\u001a3PE*,7\r^:UKN$(BA\u0002\u0005\u0003\u0019iw\u000eZ3mg*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\u000bWC2LG-\u0019;fI>\u0013'.Z2ugR+7\u000f^\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQaH\b\u0005\u0002\u0001\na#\\1lK2K7\u000f^(g-\u0006d\u0017\u000eZ(cU\u0016\u001cGo\u001d\u000b\u0003C1\u00022AI\u0014*\u001b\u0005\u0019#B\u0001\u0013&\u0003%IW.\\;uC\ndWM\u0003\u0002')\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001a#AC%oI\u0016DX\rZ*fcB\u0011aBK\u0005\u0003W\t\u00111BV1mS\u0012|%M[3di\")QF\ba\u0001]\u00051a.^7cKJ\u0004\"aE\u0018\n\u0005A\"\"aA%oi\")!g\u0004C\u0001g\u0005AR.Y6f\u0019&\u001cHo\u00144J]Z\fG.\u001b3PE*,7\r^:\u0015\u0005QB\u0004c\u0001\u0012(kA\u0011aBN\u0005\u0003o\t\u0011Q\"\u00138wC2LGm\u00142kK\u000e$\b\"B\u00172\u0001\u0004q\u0003b\u0002\u001e\u0010\u0003\u0003%IaO\u0001\fe\u0016\fGMU3t_24X\rF\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u00142kK\u000e$h\u0001\u0002\t\u0003\u0001\u0015\u001b2\u0001\u0012$M!\t9%*D\u0001I\u0015\tIE!A\u0004tkB\u0004xN\u001d;\n\u0005-C%!\u0005,bY&$\u0017\r^8s)\u0016\u001cHoQ1tKB\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\u0005[>\u001c7N\u0003\u0002R%\u0006I1oY1mCR,7\u000f\u001e\u0006\u0002'\u0006\u0019qN]4\n\u0005Us%\u0001D'pG.LGo\\*vO\u0006\u0014\b\"\u0002\u000fE\t\u00039F#\u0001-\u0011\u00059!\u0005b\u0002.E\u0005\u0004%\taW\u0001\r)J,8\u000f^!oG\"|'o]\u000b\u00029B\u0011a\"X\u0005\u0003=\n\u0011A\u0002\u0016:vgR\fen\u00195peNDa\u0001\u0019#!\u0002\u0013a\u0016!\u0004+skN$\u0018I\\2i_J\u001c\b\u0005\u000b\u0003EE*\\\u0007CA2i\u001b\u0005!'BA3g\u0003\u0019\u0011XO\u001c8fe*\u0011qMU\u0001\u0006UVt\u0017\u000e^\u0005\u0003S\u0012\u0014qAU;o/&$\b.A\u0003wC2,XmI\u0001m!\tiw.D\u0001o\u0015\t9\u0007+\u0003\u0002q]\nY!*\u00168jiJ+hN\\3s\u0001")
public class ValidatedObjectsTest
extends ValidatorTestCase
implements MockitoSugar {
    private final TrustAnchors TrustAnchors;

    public static IndexedSeq<InvalidObject> makeListOfInvalidObjects(int n) {
        return ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(n);
    }

    public static IndexedSeq<ValidObject> makeListOfValidObjects(int n) {
        return ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(n);
    }

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public TrustAnchors TrustAnchors() {
        return this.TrustAnchors;
    }

    public ValidatedObjectsTest() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.TrustAnchors = new TrustAnchors((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrustAnchor[]{TestingObjectMother$.MODULE$.TA()})));
        this.test("Should add repository error when at least one error was found and there is a 10% or more drop in valid object count", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToIntShouldWrapper(((ObjectCountDrop)((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved().get()).previousNumber()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT add repository error when at least one error was found and there is a less than 10% drop in valid object count", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(9).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT add repository error there is a drop in object count, but no errors were found", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(5));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should carry over object drop error if drop seen last run and object count not recovered this run", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                ValidatedObjects validatedObjectsAfterThirdRun = validatedObjectsAfterSecondRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToIntShouldWrapper(((ObjectCountDrop)((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved().get()).previousNumber()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToIntShouldWrapper(((ObjectCountDrop)((TrustAnchorValidations)validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved().get()).previousNumber()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT carry over object drop error if drop seen last run, and no errors seen this run", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                ValidatedObjects validatedObjectsAfterThirdRun = validatedObjectsAfterSecondRun.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToIntShouldWrapper(((ObjectCountDrop)((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved().get()).previousNumber()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should NOT carry over object drop error if drop seen last run, and object count recovered this run (errors may still exist)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValidatedObjectsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ValidatedObjects initialValidatedObjects = ValidatedObjects$.MODULE$.apply(this.$outer.TrustAnchors());
                ValidatedObjects validatedObjectsAfterFirstRun = initialValidatedObjects.update(TestingObjectMother$.MODULE$.TAL(), ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(10));
                ValidatedObjects validatedObjectsAfterSecondRun = validatedObjectsAfterFirstRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(8).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                ValidatedObjects validatedObjectsAfterThirdRun = validatedObjectsAfterSecondRun.update(TestingObjectMother$.MODULE$.TAL(), (Seq)ValidatedObjectsTest$.MODULE$.makeListOfValidObjects(9).$plus$plus(ValidatedObjectsTest$.MODULE$.makeListOfInvalidObjects(1), IndexedSeq$.MODULE$.canBuildFrom()));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterFirstRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToIntShouldWrapper(((ObjectCountDrop)((TrustAnchorValidations)validatedObjectsAfterSecondRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved().get()).previousNumber()).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.convertToAnyRefShouldWrapper(validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL())).should(this.$outer.not()).be((Object)None$.MODULE$);
                this.$outer.convertToAnyRefShouldWrapper(((TrustAnchorValidations)validatedObjectsAfterThirdRun.all().get((Object)TestingObjectMother$.MODULE$.TAL()).get()).objectCountDropObserved()).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

