/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Filters$;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.models.Whitelist$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.testing.TestingObjectMother$;
import org.junit.runner.RunWith;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\tyQ*Z7pefLU.Y4f)\u0016\u001cHO\u0003\u0002\u0004\t\u000511m\u001c8gS\u001eT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0005\u00019!B\u0004\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u000591/\u001e9q_J$\u0018BA\n\u0011\u0005E1\u0016\r\\5eCR|'\u000fV3ti\u000e\u000b7/\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003e\t1a\u001c:h\u0013\tYbCA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"!F\u000f\n\u0005y1\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\tAq!\n\u0001A\u0002\u0013\u0005a%A\u0004tk\nTWm\u0019;\u0016\u0003\u001d\u0002\"a\t\u0015\n\u0005%\u0012!aC'f[>\u0014\u00180S7bO\u0016Dqa\u000b\u0001A\u0002\u0013\u0005A&A\u0006tk\nTWm\u0019;`I\u0015\fHCA\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0011)f.\u001b;\t\u000fQR\u0013\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\t\rY\u0002\u0001\u0015)\u0003(\u0003!\u0019XO\u00196fGR\u0004\u0003b\u0002\u001d\u0001\u0001\u0004%\t!O\u0001\riJ,8\u000f^!oG\"|'o]\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011Q\bB\u0001\u0007[>$W\r\\:\n\u0005}b$\u0001\u0004+skN$\u0018I\\2i_J\u001c\bbB!\u0001\u0001\u0004%\tAQ\u0001\u0011iJ,8\u000f^!oG\"|'o]0%KF$\"!L\"\t\u000fQ\u0002\u0015\u0011!a\u0001u!1Q\t\u0001Q!\ni\nQ\u0002\u001e:vgR\fen\u00195peN\u0004\u0003\"B$\u0001\t\u0003B\u0015!\u00032fM>\u0014X-\u00117m)\u0005i\u0003\u0006\u0002\u0001K%N\u0003\"a\u0013)\u000e\u00031S!!\u0014(\u0002\rI,hN\\3s\u0015\ty\u0005$A\u0003kk:LG/\u0003\u0002R\u0019\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%\u0001+\u0011\u0005U;V\"\u0001,\u000b\u0005=3\u0012B\u0001-W\u0005-QUK\\5u%Vtg.\u001a:")
public class MemoryImageTest
extends ValidatorTestCase
implements BeforeAndAfterAll,
BeforeAndAfter {
    private MemoryImage subject;
    private TrustAnchors trustAnchors;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuite.class.runTest((FunSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    @Override
    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void beforeAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, configMap);
    }

    public MemoryImage subject() {
        return this.subject;
    }

    public void subject_$eq(MemoryImage x$1) {
        this.subject = x$1;
    }

    public TrustAnchors trustAnchors() {
        return this.trustAnchors;
    }

    public void trustAnchors_$eq(TrustAnchors x$1) {
        this.trustAnchors = x$1;
    }

    public void beforeAll() {
        this.trustAnchors_$eq(new TrustAnchors((Seq)Seq$.MODULE$.empty()));
    }

    public MemoryImageTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.subject = null;
        this.trustAnchors = null;
        this.test("Should find distinct ROA prefixes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.subject_$eq(new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), new Whitelist(Whitelist$.MODULE$.apply$default$1()), this.$outer.trustAnchors(), TestingObjectMother$.MODULE$.ROAS(), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V6_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN2_TO_ROA_PREFIX_V4_1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should list whitelist entries when no roas", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.subject_$eq(new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), TestingObjectMother$.MODULE$.WHITELIST(), this.$outer.trustAnchors(), ValidatedObjects$.MODULE$.apply(this.$outer.trustAnchors()), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN3_TO_WHITELIST1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should mix whitelist entries with roas for same prefix", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Whitelist whitelist = TestingObjectMother$.MODULE$.WHITELIST().addEntry(TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2());
                this.$outer.subject_$eq(new MemoryImage(new Filters(Filters$.MODULE$.apply$default$1()), whitelist, this.$outer.trustAnchors(), TestingObjectMother$.MODULE$.ROAS(), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)5)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V6_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN2_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN3_TO_WHITELIST1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should mix whitelist entries with roas for same prefix and a filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Whitelist whitelist = TestingObjectMother$.MODULE$.WHITELIST().addEntry(TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2());
                this.$outer.subject_$eq(new MemoryImage(TestingObjectMother$.MODULE$.FILTERS(), whitelist, this.$outer.trustAnchors(), TestingObjectMother$.MODULE$.ROAS(), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN2_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN3_TO_WHITELIST1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should mix whitelist entries with roas for same prefix and more than one filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Whitelist whitelist = TestingObjectMother$.MODULE$.WHITELIST().addEntry(TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2());
                Filters filters = TestingObjectMother$.MODULE$.FILTERS().addFilter(new IgnoreFilter(TestingObjectMother$.MODULE$.UNUSED_PREFIX_FOR_FILTER()));
                this.$outer.subject_$eq(new MemoryImage(filters, whitelist, this.$outer.trustAnchors(), TestingObjectMother$.MODULE$.ROAS(), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN2_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN3_TO_WHITELIST1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should prevail whitelist entry over roa prefix filtered out by filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryImageTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Whitelist whitelist = TestingObjectMother$.MODULE$.WHITELIST().addEntry(TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V6_1());
                this.$outer.subject_$eq(new MemoryImage(TestingObjectMother$.MODULE$.FILTERS(), whitelist, this.$outer.trustAnchors(), TestingObjectMother$.MODULE$.ROAS(), MemoryImage$.MODULE$.$lessinit$greater$default$5()));
                Set distinctRoaPrefixes = this.$outer.subject().getDistinctRtrPrefixes();
                this.$outer.convertToIntShouldWrapper(distinctRoaPrefixes.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)5)));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V4_2()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN1_TO_ROA_PREFIX_V6_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN2_TO_ROA_PREFIX_V4_1()));
                this.$outer.convertToTraversableShouldWrapper(distinctRoaPrefixes).should(this.$outer.contain().apply((Object)TestingObjectMother$.MODULE$.ASN3_TO_WHITELIST1()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

