/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import java.io.InputStream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump$;
import net.ripe.rpki.validator.bgp.preview.BgpRisEntry;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.junit.runner.RunWith;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u001f\tq!i\u001a9SSN$U/\u001c9UKN$(BA\u0002\u0005\u0003\u001d\u0001(/\u001a<jK^T!!\u0002\u0004\u0002\u0007\t<\u0007O\u0003\u0002\b\u0011\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u0013)\tAA\u001d9lS*\u00111\u0002D\u0001\u0005e&\u0004XMC\u0001\u000e\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\r\u000591/\u001e9q_J$\u0018BA\u000b\u0013\u0005E1\u0016\r\\5eCR|'\u000fV3ti\u000e\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAC\u0001\u0001\u000f'OA\u0011Q\u0004J\u0007\u0002=)\u0011q\u0004I\u0001\u0007eVtg.\u001a:\u000b\u0005\u0005\u0012\u0013!\u00026v]&$(\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&=\t9!+\u001e8XSRD\u0017!\u0002<bYV,7%\u0001\u0015\u0011\u0005%jS\"\u0001\u0016\u000b\u0005\u0005Z#B\u0001\u0017#\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002/U\tY!*\u00168jiJ+hN\\3s\u0001")
public class BgpRisDumpTest
extends ValidatorTestCase {
    public BgpRisDumpTest() {
        this.test("should parse empty line", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyRefShouldWrapper(BgpRisDump$.MODULE$.parseLine("")).should(this.$outer.equal(None$.MODULE$));
                this.$outer.convertToAnyRefShouldWrapper(BgpRisDump$.MODULE$.parseLine("\n")).should(this.$outer.equal(None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse comment line", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyRefShouldWrapper(BgpRisDump$.MODULE$.parseLine("% this is some comment")).should(this.$outer.equal(None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse IPv4 announcement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option entry = BgpRisDump$.MODULE$.parseLine("3333\t127.0.0.0/8\t201\n");
                this.$outer.convertToAnyRefShouldWrapper(entry).should(this.$outer.equal(new Some((Object)new BgpRisEntry(new Asn(3333L), IpRange.parse((String)"127.0.0.0/8"), 201))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse IPv6 announcement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option entry = BgpRisDump$.MODULE$.parseLine("24490\t2001:254:8000::/33\t62\n");
                this.$outer.convertToAnyRefShouldWrapper(entry).should(this.$outer.equal(new Some((Object)new BgpRisEntry(new Asn(24490L), IpRange.parse((String)"2001:254:8000::/33"), 62))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse IPv4-Embedded Ipv6 announcement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option entry = BgpRisDump$.MODULE$.parseLine("24490\t::1.2.3.4/128\t62\n");
                this.$outer.convertToAnyRefShouldWrapper(entry).should(this.$outer.equal(new Some((Object)new BgpRisEntry(new Asn(24490L), IpRange.parse((String)"::1.2.3.4/128"), 62))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should skip malformed line", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option entry = BgpRisDump$.MODULE$.parseLine("24490\t::::/128\t62\n");
                this.$outer.convertToAnyRefShouldWrapper(entry).should(this.$outer.equal(None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse file", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ris/riswhoisdump-example.IPv4");
                IndexedSeq entries = (IndexedSeq)BgpRisDump$.MODULE$.parse(inputStream).right().get();
                this.$outer.convertToIntShouldWrapper(entries.size()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)84)));
                this.$outer.convertToSeqShouldWrapper(entries).should(this.$outer.contain().apply((Object)new BgpRisEntry(new Asn(45528L), IpRange.parse((String)"1.22.120.0/24"), 105)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

