/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import java.util.Date;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump$;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.joda.time.DateTime;
import org.junit.runner.RunWith;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import org.scalatest.junit.JUnitRunner;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001f\tA\"i\u001a9SSN$U/\u001c9E_^tGn\\1eKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00029sKZLWm\u001e\u0006\u0003\u000b\u0019\t1AY4q\u0015\t9\u0001\"A\u0005wC2LG-\u0019;pe*\u0011\u0011BC\u0001\u0005eB\\\u0017N\u0003\u0002\f\u0019\u0005!!/\u001b9f\u0015\u0005i\u0011a\u00018fi\u000e\u00011\u0003\u0002\u0001\u0011-y\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\u000fM,\b\u000f]8si&\u0011QC\u0005\u0002\u0012-\u0006d\u0017\u000eZ1u_J$Vm\u001d;DCN,\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u001c\u0003\ry'oZ\u0005\u0003;a\u0011\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m!\ty\"%D\u0001!\u0015\t\t\u0003$\u0001\u0003n_\u000e\\\u0017BA\u0012!\u00051iunY6ji>\u001cVoZ1s\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t!\u0001C\u0004+\u0001\t\u0007I\u0011A\u0016\u0002\u001d5|7m\u001b%uiB\u001cE.[3oiV\tA\u0006\u0005\u0002.i5\taF\u0003\u00020a\u000511\r\\5f]RT!!\r\u001a\u0002\t!$H\u000f\u001d\u0006\u0003gi\ta!\u00199bG\",\u0017BA\u001b/\u0005)AE\u000f\u001e9DY&,g\u000e\u001e\u0005\u0007o\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u001f5|7m\u001b%uiB\u001cE.[3oi\u0002Bq!\u000f\u0001C\u0002\u0013\u0005!(\u0001\biiR\u0004\u0018'\r)s_R|7m\u001c7\u0016\u0003m\u0002\"\u0001P\u001f\u000e\u0003AJ!A\u0010\u0019\u0003\u001fA\u0013x\u000e^8d_24VM]:j_:Da\u0001\u0011\u0001!\u0002\u0013Y\u0014a\u00045uiB\f\u0014\u0007\u0015:pi>\u001cw\u000e\u001c\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006!A-^7q+\u0005!\u0005C\u0001\u0015F\u0013\t1%A\u0001\u0006COB\u0014\u0016n\u001d#v[BDa\u0001\u0013\u0001!\u0002\u0013!\u0015!\u00023v[B\u0004\u0003b\u0002&\u0001\u0005\u0004%\taS\u0001\u0015\u0005\u001e\u0004(+[:Ek6\u0004Hi\\<oY>\fG-\u001a:\u0016\u00031\u0003\"\u0001K'\n\u00059\u0013!\u0001\u0006\"haJK7\u000fR;na\u0012{wO\u001c7pC\u0012,'\u000f\u0003\u0004Q\u0001\u0001\u0006I\u0001T\u0001\u0016\u0005\u001e\u0004(+[:Ek6\u0004Hi\\<oY>\fG-\u001a:!Q\u0011\u0001!KW.\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016A\u0002:v]:,'O\u0003\u0002X5\u0005)!.\u001e8ji&\u0011\u0011\f\u0016\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005a\u0006CA/`\u001b\u0005q&BA,\u0019\u0013\t\u0001gLA\u0006K+:LGOU;o]\u0016\u0014\b")
public class BgpRisDumpDownloaderTest
extends ValidatorTestCase
implements BeforeAndAfterAll,
MockitoSugar {
    private final HttpClient mockHttpClient;
    private final ProtocolVersion http11Protocol;
    private final BgpRisDump dump;
    private final BgpRisDumpDownloader BgpRisDumpDownloader;

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public void org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuite.class.run((FunSuite)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public void beforeAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(Map<String, Object> configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, configMap);
    }

    @Override
    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public HttpClient mockHttpClient() {
        return this.mockHttpClient;
    }

    public ProtocolVersion http11Protocol() {
        return this.http11Protocol;
    }

    public BgpRisDump dump() {
        return this.dump;
    }

    public BgpRisDumpDownloader BgpRisDumpDownloader() {
        return this.BgpRisDumpDownloader;
    }

    public BgpRisDumpDownloaderTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MockitoSugar.class.$init$((MockitoSugar)this);
        this.mockHttpClient = (HttpClient)this.mock(ManifestFactory$.MODULE$.classType(HttpClient.class));
        this.http11Protocol = new ProtocolVersion("http", 1, 1);
        this.dump = new BgpRisDump("http://no.where/dump.4.gz", BgpRisDump$.MODULE$.apply$default$2(), BgpRisDump$.MODULE$.apply$default$3());
        this.BgpRisDumpDownloader = new BgpRisDumpDownloader(this.mockHttpClient());
        this.test("should stick to old dump, if new dump cannot be retrieved", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 500, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpRisDump dumpFromResponse = (BgpRisDump)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyRefShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should stick to old dump if it's not modified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 304, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpRisDump dumpFromResponse = (BgpRisDump)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyRefShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should stick to old dump if new dump can't be parsed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 304, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                BgpRisDump dumpFromResponse = (BgpRisDump)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyRefShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should download and unzip new dump", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BgpRisDumpDownloaderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ResponseHandler responseHandler = this.$outer.BgpRisDumpDownloader().makeResponseHandler(this.$outer.dump());
                BasicStatusLine statusLine = new BasicStatusLine(this.$outer.http11Protocol(), 200, null);
                BasicHttpResponse response = new BasicHttpResponse((StatusLine)statusLine);
                StringEntity entity = new StringEntity("not gzip format");
                entity.setContentType("application/x-gzip");
                Date lastMidnight = new Date(new DateTime().toDateMidnight().getMillis());
                response.setEntity((HttpEntity)entity);
                response.setHeader("Last-Modified", DateUtils.formatDate((Date)lastMidnight));
                BgpRisDump dumpFromResponse = (BgpRisDump)responseHandler.handleResponse((HttpResponse)response);
                this.$outer.convertToAnyRefShouldWrapper(dumpFromResponse).should(this.$outer.equal(this.$outer.dump()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

