/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;

public class CachingCertificateRepositoryObjectFetcher
implements CertificateRepositoryObjectFetcher {
    private final Map<URI, CertificateRepositoryObject> objectCache = new HashMap<URI, CertificateRepositoryObject>();
    private final Map<URI, ManifestCms> manifestCache = new HashMap<URI, ManifestCms>();
    private final Map<URI, X509Crl> crlCache = new HashMap<URI, X509Crl>();
    private final CertificateRepositoryObjectFetcher fetcher;

    public CachingCertificateRepositoryObjectFetcher(CertificateRepositoryObjectFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public X509Crl getCrl(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        if (this.crlCache.containsKey(uri)) {
            return this.crlCache.get(uri);
        }
        X509Crl crl = this.fetcher.getCrl(uri, context, result);
        this.updateCache(uri, (CertificateRepositoryObject)crl);
        return crl;
    }

    @Override
    public ManifestCms getManifest(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        if (this.manifestCache.containsKey(uri)) {
            return this.manifestCache.get(uri);
        }
        ManifestCms manifest = this.fetcher.getManifest(uri, context, result);
        this.updateCache(uri, (CertificateRepositoryObject)manifest);
        return manifest;
    }

    @Override
    public CertificateRepositoryObject getObject(URI uri, CertificateRepositoryObjectValidationContext context, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        if (this.objectCache.containsKey(uri)) {
            return this.objectCache.get(uri);
        }
        CertificateRepositoryObject object = this.fetcher.getObject(uri, context, fileContentSpecification, result);
        this.updateCache(uri, object);
        return object;
    }

    @Override
    public void prefetch(URI uri, ValidationResult result) {
        this.fetcher.prefetch(uri, result);
    }

    public void updateCache(URI uri, CertificateRepositoryObject object) {
        this.objectCache.put(uri, object);
        if (object instanceof X509Crl) {
            this.crlCache.put(uri, (X509Crl)object);
            this.manifestCache.put(uri, null);
        } else if (object instanceof ManifestCms) {
            this.manifestCache.put(uri, (ManifestCms)object);
            this.crlCache.put(uri, null);
        } else {
            this.manifestCache.put(uri, null);
            this.crlCache.put(uri, null);
        }
    }
}

